/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.os.AsyncTask;
import android.util.Log;
import com.mopub.mobileads.DiskLruCache;
import com.mopub.mobileads.factories.HttpClientFactory;
import com.mopub.mobileads.util.HttpClients;
import com.mopub.mobileads.util.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class VastVideoDownloadTask
extends AsyncTask<String, Void, Boolean> {
    private static final int HTTP_CLIENT_TIMEOUT = 10000;
    private static final long MAX_TEMP_FILE_LENGTH = 25000000L;
    private static final String TEMP_FILE_PREFIX = "mopub-vast";
    private final DiskLruCache mDiskLruCache;
    private final DefaultHttpClient mHttpClient;
    private final OnDownloadCompleteListener mOnDownloadCompleteListener;

    public VastVideoDownloadTask(OnDownloadCompleteListener onDownloadCompleteListener, DiskLruCache diskLruCache) {
        this.mOnDownloadCompleteListener = onDownloadCompleteListener;
        this.mDiskLruCache = diskLruCache;
        this.mHttpClient = HttpClientFactory.create(10000);
    }

    InputStream connectToUrl(String string2) throws IOException {
        if (string2 == null) {
            throw new IOException("Unable to connect to null url.");
        }
        HttpGet httpGet = new HttpGet(string2);
        HttpResponse httpResponse = this.mHttpClient.execute((HttpUriRequest)httpGet);
        if (httpResponse == null || httpResponse.getEntity() == null) {
            throw new IOException("Obtained null response from video url: " + string2);
        }
        return httpResponse.getEntity().getContent();
    }

    File copyInputStreamToTempFile(InputStream inputStream) throws IOException {
        File file = File.createTempFile(TEMP_FILE_PREFIX, null, this.mDiskLruCache.getCacheDirectory());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            Streams.copyContent(inputStream, bufferedOutputStream, 25000000L);
            return file;
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
        finally {
            Streams.closeStream(inputStream);
            Streams.closeStream(bufferedOutputStream);
        }
    }

    boolean copyTempFileIntoCache(String string2, File file) throws FileNotFoundException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        boolean bl2 = this.mDiskLruCache.putStream(string2, bufferedInputStream);
        Streams.closeStream(bufferedInputStream);
        return bl2;
    }

    protected Boolean doInBackground(String ... stringArray) {
        if (stringArray == null || stringArray[0] == null) {
            return false;
        }
        return this.downloadToCache(stringArray[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Boolean downloadToCache(String string2) {
        boolean bl2 = false;
        try {
            File file = this.copyInputStreamToTempFile(this.connectToUrl(string2));
            bl2 = this.copyTempFileIntoCache(string2, file);
            file.delete();
        }
        catch (Exception exception) {
            Log.d((String)"MoPub", (String)"Failed to download video.");
            return bl2;
        }
        finally {
            HttpClients.safeShutdown((HttpClient)this.mHttpClient);
            return bl2;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPostExecute(Boolean bl2) {
        if (bl2.booleanValue()) {
            if (this.mOnDownloadCompleteListener == null) return;
            this.mOnDownloadCompleteListener.onDownloadSuccess();
            return;
        }
        if (this.mOnDownloadCompleteListener == null) return;
        this.mOnDownloadCompleteListener.onDownloadFailed();
    }

    public static interface OnDownloadCompleteListener {
        public void onDownloadFailed();

        public void onDownloadSuccess();
    }
}

