/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.mopub.mobileads.MraidAbstractController;
import com.mopub.mobileads.MraidCommandFactory;
import com.mopub.mobileads.MraidProperty;
import com.mopub.mobileads.MraidScreenSizeProperty;
import com.mopub.mobileads.MraidStateProperty;
import com.mopub.mobileads.MraidSupportsProperty;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.MraidView;
import com.mopub.mobileads.MraidViewableProperty;
import com.mopub.mobileads.factories.HttpClientFactory;
import com.mopub.mobileads.resource.Drawables;
import com.mopub.mobileads.util.HttpResponses;
import com.mopub.mobileads.util.Mraids;
import com.mopub.mobileads.util.ResponseHeader;
import com.mopub.mobileads.util.Streams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

class MraidDisplayController
extends MraidAbstractController {
    private static final int CLOSE_BUTTON_SIZE_DP = 50;
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZZZZZ", "yyyy-MM-dd'T'HH:mmZZZZZ"};
    private static final String LOGTAG = "MraidDisplayController";
    private static final int MAX_NUMBER_DAYS_IN_MONTH = 31;
    private static final long VIEWABILITY_TIMER_MILLIS = 3000L;
    private FrameLayout mAdContainerLayout;
    private boolean mAdWantsCustomCloseButton;
    private ImageView mCloseButton;
    protected float mDensity;
    private RelativeLayout mExpansionLayout;
    private final MraidView.ExpansionStyle mExpansionStyle;
    private Handler mHandler;
    private final MraidView.NativeCloseButtonStyle mNativeCloseButtonStyle;
    private OrientationBroadcastReceiver mOrientationBroadcastReceiver;
    private final int mOriginalRequestedOrientation;
    private FrameLayout mPlaceholderView;
    private FrameLayout mRootView;
    protected int mScreenHeight;
    protected int mScreenWidth;
    private MraidView mTwoPartExpansionView;
    private int mViewIndexInParent;
    private MraidView.ViewState mViewState;

    MraidDisplayController(MraidView mraidView, MraidView.ExpansionStyle expansionStyle, MraidView.NativeCloseButtonStyle nativeCloseButtonStyle) {
        int n2 = -1;
        super(mraidView);
        this.mViewState = MraidView.ViewState.HIDDEN;
        this.mHandler = new Handler();
        this.mOrientationBroadcastReceiver = new OrientationBroadcastReceiver();
        this.mScreenWidth = n2;
        this.mScreenHeight = n2;
        this.mExpansionStyle = expansionStyle;
        this.mNativeCloseButtonStyle = nativeCloseButtonStyle;
        Context context = this.getContext();
        if (context instanceof Activity) {
            n2 = ((Activity)context).getRequestedOrientation();
        }
        this.mOriginalRequestedOrientation = n2;
        this.mAdContainerLayout = this.createAdContainerLayout();
        this.mExpansionLayout = this.createExpansionLayout();
        this.mPlaceholderView = this.createPlaceholderView();
        this.initialize();
    }

    private String dayNumberToDayOfMonthString(int n2) throws IllegalArgumentException {
        if (n2 != 0 && n2 >= -31 && n2 <= 31) {
            return "" + n2;
        }
        throw new IllegalArgumentException("invalid day of month " + n2);
    }

    private String dayNumberToDayOfWeekString(int n2) throws IllegalArgumentException {
        switch (n2) {
            default: {
                throw new IllegalArgumentException("invalid day of week " + n2);
            }
            case 0: {
                return "SU";
            }
            case 1: {
                return "MO";
            }
            case 2: {
                return "TU";
            }
            case 3: {
                return "WE";
            }
            case 4: {
                return "TH";
            }
            case 5: {
                return "FR";
            }
            case 6: 
        }
        return "SA";
    }

    private void downloadImage(final String string2) {
        final File file = this.getPictureStoragePath();
        file.mkdirs();
        new Thread(new Runnable(){
            private MediaScannerConnection mediaScannerConnection;
            private InputStream pictureInputStream;
            private OutputStream pictureOutputStream;
            private URI uri;

            private void loadPictureIntoGalleryApp(String string22) {
                MoPubMediaScannerConnectionClient moPubMediaScannerConnectionClient = new MoPubMediaScannerConnectionClient(string22, null);
                this.mediaScannerConnection = new MediaScannerConnection(MraidDisplayController.this.getContext().getApplicationContext(), (MediaScannerConnection.MediaScannerConnectionClient)moPubMediaScannerConnectionClient);
                moPubMediaScannerConnectionClient.setMediaScannerConnection(this.mediaScannerConnection);
                this.mediaScannerConnection.connect();
            }

            @Override
            public void run() {
                try {
                    this.uri = URI.create(string2);
                    HttpResponse httpResponse = HttpClientFactory.create().execute((HttpUriRequest)new HttpGet(this.uri));
                    this.pictureInputStream = httpResponse.getEntity().getContent();
                    String string22 = HttpResponses.extractHeader(httpResponse, ResponseHeader.LOCATION);
                    if (string22 != null) {
                        this.uri = URI.create(string22);
                    }
                    String string3 = MraidDisplayController.this.getFileNameForUriAndHttpResponse(this.uri, httpResponse);
                    File file2 = new File(file, string3);
                    String string4 = file2.toString();
                    this.pictureOutputStream = new FileOutputStream(file2);
                    Streams.copyContent(this.pictureInputStream, this.pictureOutputStream);
                    this.loadPictureIntoGalleryApp(string4);
                    return;
                }
                catch (Exception exception) {
                    MraidDisplayController.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            MraidDisplayController.this.showUserToast("Image failed to download.");
                            MraidDisplayController.this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.STORE_PICTURE, "Error downloading and saving image file.");
                            Log.d((String)"MoPub", (String)"Error downloading and saving image file.");
                        }
                    });
                    return;
                }
                finally {
                    Streams.closeStream(this.pictureInputStream);
                    Streams.closeStream(this.pictureOutputStream);
                }
            }
        }).start();
    }

    private void expandLayouts(View view, int n2, int n3) {
        int n4 = (int)(0.5f + 50.0f * this.mDensity);
        if (n2 < n4) {
            n2 = n4;
        }
        if (n3 < n4) {
            n3 = n4;
        }
        View view2 = new View(this.getContext());
        view2.setBackgroundColor(0);
        view2.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        this.mExpansionLayout.addView(view2, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mAdContainerLayout.addView(view, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n2, n3);
        layoutParams.addRule(13);
        this.mExpansionLayout.addView((View)this.mAdContainerLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    private Context getContext() {
        return this.getMraidView().getContext();
    }

    private int getDisplayRotation() {
        return ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getOrientation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFileNameForUriAndHttpResponse(URI uRI, HttpResponse httpResponse) {
        String string2 = uRI.getPath();
        if (string2 == null) {
            return null;
        }
        String string3 = new File(string2).getName();
        Header header = httpResponse.getFirstHeader("Content-Type");
        if (header == null) return string3;
        String[] stringArray = header.getValue().split(";");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4 = stringArray[n3];
            if (string4.contains("image/")) {
                String string5 = "." + string4.split("/")[1];
                if (string3.endsWith(string5)) return string3;
                return string3 + string5;
            }
            ++n3;
        }
        return string3;
    }

    private File getPictureStoragePath() {
        return new File(Environment.getExternalStorageDirectory(), "Pictures");
    }

    private void initialize() {
        this.mViewState = MraidView.ViewState.LOADING;
        this.initializeScreenMetrics();
        this.mOrientationBroadcastReceiver.register(this.getContext());
    }

    private void initializeScreenMetrics() {
        Context context = this.getContext();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.mDensity = displayMetrics.density;
        boolean bl2 = context instanceof Activity;
        int n2 = 0;
        int n3 = 0;
        if (bl2) {
            Window window = ((Activity)context).getWindow();
            Rect rect = new Rect();
            window.getDecorView().getWindowVisibleDisplayFrame(rect);
            n2 = rect.top;
            n3 = window.findViewById(0x1020002).getTop() - n2;
        }
        int n4 = displayMetrics.widthPixels;
        int n5 = displayMetrics.heightPixels - n2 - n3;
        this.mScreenWidth = (int)((double)n4 * (160.0 / (double)displayMetrics.densityDpi));
        this.mScreenHeight = (int)((double)n5 * (160.0 / (double)displayMetrics.densityDpi));
    }

    private void onOrientationChanged(int n2) {
        this.initializeScreenMetrics();
        this.getMraidView().fireChangeEventForProperty(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date parseDate(String string2) {
        Date date = null;
        for (int n2 = 0; n2 < DATE_FORMATS.length; ++n2) {
            try {
                Date date2;
                date = date2 = new SimpleDateFormat(DATE_FORMATS[n2]).parse(string2);
                if (date == null) continue;
                return date;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseRecurrenceRule(Map<String, String> map) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        if (!map.containsKey("frequency")) return stringBuilder.toString();
        String string2 = map.get("frequency");
        int n2 = -1;
        if (map.containsKey("interval")) {
            n2 = Integer.parseInt(map.get("interval"));
        }
        if ("daily".equals(string2)) {
            stringBuilder.append("FREQ=DAILY;");
            if (n2 == -1) return stringBuilder.toString();
            stringBuilder.append("INTERVAL=" + n2 + ";");
            return stringBuilder.toString();
        }
        if ("weekly".equals(string2)) {
            stringBuilder.append("FREQ=WEEKLY;");
            if (n2 != -1) {
                stringBuilder.append("INTERVAL=" + n2 + ";");
            }
            if (!map.containsKey("daysInWeek")) return stringBuilder.toString();
            String string3 = this.translateWeekIntegersToDays(map.get("daysInWeek"));
            if (string3 == null) {
                throw new IllegalArgumentException("invalid ");
            }
            stringBuilder.append("BYDAY=" + string3 + ";");
            return stringBuilder.toString();
        }
        if (!"monthly".equals(string2)) throw new IllegalArgumentException("frequency is only supported for daily, weekly, and monthly.");
        stringBuilder.append("FREQ=MONTHLY;");
        if (n2 != -1) {
            stringBuilder.append("INTERVAL=" + n2 + ";");
        }
        if (!map.containsKey("daysInMonth")) return stringBuilder.toString();
        String string4 = this.translateMonthIntegersToDays(map.get("daysInMonth"));
        if (string4 == null) {
            throw new IllegalArgumentException();
        }
        stringBuilder.append("BYMONTHDAY=" + string4 + ";");
        return stringBuilder.toString();
    }

    private void resetViewToDefaultState() {
        this.setNativeCloseButtonEnabled(false);
        this.mAdContainerLayout.removeAllViewsInLayout();
        this.mExpansionLayout.removeAllViewsInLayout();
        this.mRootView.removeView((View)this.mExpansionLayout);
        this.getMraidView().requestLayout();
        ViewGroup viewGroup = (ViewGroup)this.mPlaceholderView.getParent();
        viewGroup.addView((View)this.getMraidView(), this.mViewIndexInParent);
        viewGroup.removeView((View)this.mPlaceholderView);
        viewGroup.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setOrientationLockEnabled(boolean bl2) {
        Context context = this.getContext();
        try {
            Activity activity = (Activity)context;
            int n2 = bl2 ? activity.getResources().getConfiguration().orientation : this.mOriginalRequestedOrientation;
            activity.setRequestedOrientation(n2);
            return;
        }
        catch (ClassCastException classCastException) {
            Log.d((String)LOGTAG, (String)"Unable to modify device orientation.");
            return;
        }
    }

    private void showUserDialog(final String string2) {
        new AlertDialog.Builder(this.getContext()).setTitle((CharSequence)"Save Image").setMessage((CharSequence)"Download image to Picture gallery?").setNegativeButton((CharSequence)"Cancel", null).setPositiveButton((CharSequence)"Okay", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                MraidDisplayController.this.downloadImage(string2);
            }
        }).setCancelable(true).show();
    }

    private void showUserToast(final String string2) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)MraidDisplayController.this.getContext(), (CharSequence)string2, (int)0).show();
            }
        });
    }

    private void swapViewWithPlaceholderView() {
        ViewGroup viewGroup = (ViewGroup)this.getMraidView().getParent();
        if (viewGroup == null) {
            return;
        }
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (true) {
            if (n3 >= n2 || viewGroup.getChildAt(n3) == this.getMraidView()) {
                this.mViewIndexInParent = n3;
                viewGroup.addView((View)this.mPlaceholderView, n3, new ViewGroup.LayoutParams(this.getMraidView().getWidth(), this.getMraidView().getHeight()));
                viewGroup.removeView((View)this.getMraidView());
                return;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<String, Object> translateJSParamsToAndroidCalendarEventMapping(Map<String, String> map) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!map.containsKey("description") || !map.containsKey("start")) {
            throw new IllegalArgumentException("Missing start and description fields");
        }
        hashMap.put("title", map.get("description"));
        if (map.containsKey("start") && map.get("start") != null) {
            Date date = this.parseDate(map.get("start"));
            if (date == null) {
                throw new IllegalArgumentException("Invalid calendar event: start time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
            }
            hashMap.put("beginTime", date.getTime());
            if (map.containsKey("end") && map.get("end") != null) {
                Date date2 = this.parseDate(map.get("end"));
                if (date2 == null) {
                    throw new IllegalArgumentException("Invalid calendar event: end time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
                }
                hashMap.put("endTime", date2.getTime());
            }
            if (map.containsKey("location")) {
                hashMap.put("eventLocation", map.get("location"));
            }
            if (map.containsKey("summary")) {
                hashMap.put("description", map.get("summary"));
            }
            if (map.containsKey("transparency")) {
                int n2 = map.get("transparency").equals("transparent") ? 1 : 0;
                hashMap.put("availability", n2);
            }
            hashMap.put("rrule", this.parseRecurrenceRule(map));
            return hashMap;
        }
        throw new IllegalArgumentException("Invalid calendar event: start is null.");
    }

    private String translateMonthIntegersToDays(String string2) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean[] blArray = new boolean[63];
        String[] stringArray = string2.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n2 = Integer.parseInt(stringArray[i2]);
            if (blArray[n2 + 31]) continue;
            stringBuilder.append(this.dayNumberToDayOfMonthString(n2) + ",");
            blArray[n2 + 31] = true;
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("must have at least 1 day of the month if specifying repeating weekly");
        }
        stringBuilder.deleteCharAt(-1 + stringBuilder.length());
        return stringBuilder.toString();
    }

    private String translateWeekIntegersToDays(String string2) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean[] blArray = new boolean[7];
        String[] stringArray = string2.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n2 = Integer.parseInt(stringArray[i2]);
            if (n2 == 7) {
                n2 = 0;
            }
            if (blArray[n2]) continue;
            stringBuilder.append(this.dayNumberToDayOfWeekString(n2) + ",");
            blArray[n2] = true;
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("must have at least 1 day of the week if specifying repeating weekly");
        }
        stringBuilder.deleteCharAt(-1 + stringBuilder.length());
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void close() {
        if (this.mViewState == MraidView.ViewState.EXPANDED) {
            this.resetViewToDefaultState();
            this.setOrientationLockEnabled(false);
            this.mViewState = MraidView.ViewState.DEFAULT;
            this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        } else if (this.mViewState == MraidView.ViewState.DEFAULT) {
            this.getMraidView().setVisibility(4);
            this.mViewState = MraidView.ViewState.HIDDEN;
            this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        }
        if (this.getMraidView().getMraidListener() != null) {
            this.getMraidView().getMraidListener().onClose(this.getMraidView(), this.mViewState);
        }
    }

    FrameLayout createAdContainerLayout() {
        return new FrameLayout(this.getContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createCalendarEvent(Map<String, String> map) {
        Context context = this.getMraidView().getContext();
        if (!Mraids.isCalendarAvailable(context)) {
            Log.d((String)LOGTAG, (String)"unsupported action createCalendarEvent for devices pre-ICS");
            this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.CREATE_CALENDAR_EVENT, "Action is unsupported on this device (need Android version Ice Cream Sandwich or above)");
            return;
        }
        Map<String, Object> map2 = this.translateJSParamsToAndroidCalendarEventMapping(map);
        Intent intent = new Intent("android.intent.action.INSERT").setType("vnd.android.cursor.item/event");
        for (String string2 : map2.keySet()) {
            Object object = map2.get(string2);
            if (object instanceof Long) {
                intent.putExtra(string2, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Integer) {
                intent.putExtra(string2, ((Integer)object).intValue());
                continue;
            }
            intent.putExtra(string2, (String)object);
        }
        try {
            intent.setFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.d((String)LOGTAG, (String)"no calendar app installed");
            this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.CREATE_CALENDAR_EVENT, "Action is unsupported on this device - no calendar app installed");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.d((String)LOGTAG, (String)("create calendar: invalid parameters " + illegalArgumentException.getMessage()));
            this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.CREATE_CALENDAR_EVENT, illegalArgumentException.getMessage());
            return;
        }
        catch (Exception exception) {
            Log.d((String)LOGTAG, (String)"could not create calendar event");
            this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.CREATE_CALENDAR_EVENT, "could not create calendar event");
            return;
        }
    }

    RelativeLayout createExpansionLayout() {
        return new RelativeLayout(this.getContext());
    }

    FrameLayout createPlaceholderView() {
        return new FrameLayout(this.getContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        try {
            this.mOrientationBroadcastReceiver.unregister();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().contains("Receiver not registered")) return;
            throw illegalArgumentException;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void expand(String string2, int n2, int n3, boolean bl2, boolean bl3) {
        block7: {
            block6: {
                if (this.mExpansionStyle == MraidView.ExpansionStyle.DISABLED) break block6;
                if (string2 != null && !URLUtil.isValidUrl((String)string2)) {
                    this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.EXPAND, "URL passed to expand() was invalid.");
                    return;
                }
                this.mRootView = (FrameLayout)this.getMraidView().getRootView().findViewById(0x1020002);
                this.useCustomClose(bl2);
                this.setOrientationLockEnabled(bl3);
                this.swapViewWithPlaceholderView();
                MraidView mraidView = this.getMraidView();
                if (string2 != null) {
                    this.mTwoPartExpansionView = new MraidView(this.getContext(), this.getMraidView().getAdConfiguration(), MraidView.ExpansionStyle.DISABLED, MraidView.NativeCloseButtonStyle.AD_CONTROLLED, MraidView.PlacementType.INLINE);
                    this.mTwoPartExpansionView.setMraidListener(new MraidView.BaseMraidListener(){

                        @Override
                        public void onClose(MraidView mraidView, MraidView.ViewState viewState) {
                            MraidDisplayController.this.close();
                        }
                    });
                    this.mTwoPartExpansionView.loadUrl(string2);
                    mraidView = this.mTwoPartExpansionView;
                }
                this.expandLayouts((View)mraidView, (int)((float)n2 * this.mDensity), (int)((float)n3 * this.mDensity));
                this.mRootView.addView((View)this.mExpansionLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                if (this.mNativeCloseButtonStyle == MraidView.NativeCloseButtonStyle.ALWAYS_VISIBLE || !this.mAdWantsCustomCloseButton && this.mNativeCloseButtonStyle != MraidView.NativeCloseButtonStyle.ALWAYS_HIDDEN) {
                    this.setNativeCloseButtonEnabled(true);
                }
                this.mViewState = MraidView.ViewState.EXPANDED;
                this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
                if (this.getMraidView().getMraidListener() != null) break block7;
            }
            return;
        }
        this.getMraidView().getMraidListener().onExpand(this.getMraidView());
    }

    protected void getCurrentPosition() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.GET_CURRENT_POSITION, "Unsupported action getCurrentPosition");
    }

    protected void getDefaultPosition() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.GET_DEFAULT_POSITION, "Unsupported action getDefaultPosition");
    }

    protected void getMaxSize() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.GET_MAX_SIZE, "Unsupported action getMaxSize");
    }

    protected void getScreenSize() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.GET_SCREEN_SIZE, "Unsupported action getScreenSize");
    }

    protected void initializeJavaScriptState() {
        ArrayList<MraidProperty> arrayList = new ArrayList<MraidProperty>();
        arrayList.add(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
        arrayList.add(MraidViewableProperty.createWithViewable(this.getMraidView().getIsVisible()));
        this.getMraidView().fireChangeEventForProperties(arrayList);
        this.mViewState = MraidView.ViewState.DEFAULT;
        this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        this.initializeSupportedFunctionsProperty();
    }

    protected void initializeSupportedFunctionsProperty() {
        Context context = this.getContext();
        this.getMraidView().fireChangeEventForProperty(new MraidSupportsProperty().withTel(Mraids.isTelAvailable(context)).withSms(Mraids.isSmsAvailable(context)).withCalendar(Mraids.isCalendarAvailable(context)).withInlineVideo(Mraids.isInlineVideoAvailable(context)).withStorePicture(Mraids.isStorePictureSupported(context)));
    }

    protected boolean isExpanded() {
        return this.mViewState == MraidView.ViewState.EXPANDED;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setNativeCloseButtonEnabled(boolean bl2) {
        MraidView mraidView;
        block7: {
            block6: {
                if (this.mRootView == null) break block6;
                if (bl2) {
                    if (this.mCloseButton == null) {
                        StateListDrawable stateListDrawable = new StateListDrawable();
                        stateListDrawable.addState(new int[]{-16842919}, (Drawable)Drawables.INTERSTITIAL_CLOSE_BUTTON_NORMAL.decodeImage(this.mRootView.getContext()));
                        stateListDrawable.addState(new int[]{16842919}, (Drawable)Drawables.INTERSTITIAL_CLOSE_BUTTON_PRESSED.decodeImage(this.mRootView.getContext()));
                        this.mCloseButton = new ImageButton(this.getContext());
                        this.mCloseButton.setImageDrawable((Drawable)stateListDrawable);
                        this.mCloseButton.setBackgroundDrawable(null);
                        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                MraidDisplayController.this.close();
                            }
                        });
                    }
                    int n2 = (int)(0.5f + 50.0f * this.mDensity);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n2, n2, 5);
                    this.mAdContainerLayout.addView((View)this.mCloseButton, (ViewGroup.LayoutParams)layoutParams);
                } else {
                    this.mAdContainerLayout.removeView((View)this.mCloseButton);
                }
                if ((mraidView = this.getMraidView()).getOnCloseButtonStateChangeListener() != null) break block7;
            }
            return;
        }
        mraidView.getOnCloseButtonStateChangeListener().onCloseButtonStateChange(mraidView, bl2);
    }

    protected void showUserDownloadImageAlert(String string2) {
        Context context = this.getContext();
        if (!Mraids.isStorePictureSupported(context)) {
            this.getMraidView().fireErrorEvent(MraidCommandFactory.MraidJavascriptCommand.STORE_PICTURE, "Error downloading file - the device does not have an SD card mounted, or the Android permission is not granted.");
            Log.d((String)"MoPub", (String)"Error downloading file - the device does not have an SD card mounted, or the Android permission is not granted.");
            return;
        }
        if (context instanceof Activity) {
            this.showUserDialog(string2);
            return;
        }
        this.showUserToast("Downloading image to Picture gallery...");
        this.downloadImage(string2);
    }

    protected void showVideo(String string2) {
        MraidVideoPlayerActivity.startMraid(this.getContext(), string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void useCustomClose(boolean bl2) {
        this.mAdWantsCustomCloseButton = bl2;
        MraidView mraidView = this.getMraidView();
        boolean bl3 = !bl2;
        if (mraidView.getOnCloseButtonStateChangeListener() != null) {
            mraidView.getOnCloseButtonStateChangeListener().onCloseButtonStateChange(mraidView, bl3);
        }
    }

    private class MoPubMediaScannerConnectionClient
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private final String mFilename;
        private MediaScannerConnection mMediaScannerConnection;
        private final String mMimeType;

        private MoPubMediaScannerConnectionClient(String string2, String string3) {
            this.mFilename = string2;
            this.mMimeType = string3;
        }

        private void setMediaScannerConnection(MediaScannerConnection mediaScannerConnection) {
            this.mMediaScannerConnection = mediaScannerConnection;
        }

        public void onMediaScannerConnected() {
            if (this.mMediaScannerConnection != null) {
                this.mMediaScannerConnection.scanFile(this.mFilename, this.mMimeType);
            }
        }

        public void onScanCompleted(String string2, Uri uri) {
            if (this.mMediaScannerConnection != null) {
                this.mMediaScannerConnection.disconnect();
            }
        }
    }

    class OrientationBroadcastReceiver
    extends BroadcastReceiver {
        private Context mContext;
        private int mLastRotation;

        OrientationBroadcastReceiver() {
        }

        private boolean isRegistered() {
            return this.mContext != null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onReceive(Context context, Intent intent) {
            int n2;
            if (!this.isRegistered() || !intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED") || (n2 = MraidDisplayController.this.getDisplayRotation()) == this.mLastRotation) {
                return;
            }
            this.mLastRotation = n2;
            MraidDisplayController.this.onOrientationChanged(this.mLastRotation);
        }

        public void register(Context context) {
            this.mContext = context;
            context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
        }

        public void unregister() {
            this.mContext.unregisterReceiver((BroadcastReceiver)this);
            this.mContext = null;
        }
    }
}

