/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.mopub.mobileads.MraidAbstractController;
import com.mopub.mobileads.MraidBrowser;
import com.mopub.mobileads.MraidView;
import com.mopub.mobileads.Utils;

class MraidBrowserController
extends MraidAbstractController {
    private static final String LOGTAG = "MraidBrowserController";
    private Context mContext;

    MraidBrowserController(MraidView mraidView) {
        super(mraidView);
        this.mContext = mraidView.getContext();
    }

    private boolean canHandleApplicationUrl(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        if (!Utils.deviceCanHandleIntent(this.mContext, intent)) {
            Log.w((String)"MoPub", (String)("Could not handle application specific action: " + string2 + ". " + "You may be running in the emulator or another device which does not " + "have the required application."));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeIntent(Context context, Intent intent, String string2) {
        try {
            context.startActivity(intent);
            return true;
        }
        catch (Exception exception) {
            if (string2 == null) {
                string2 = "Unable to start intent.";
            }
            Log.d((String)"MoPub", (String)string2);
            return false;
        }
    }

    private boolean isWebSiteUrl(String string2) {
        return string2.startsWith("http://") || string2.startsWith("https://");
    }

    private boolean launchApplicationUrl(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        intent.addFlags(0x10000000);
        return this.executeIntent(this.getMraidView().getContext(), intent, "Unable to open intent.");
    }

    protected void open(String string2) {
        Log.d((String)LOGTAG, (String)("Opening url: " + string2));
        MraidView mraidView = this.getMraidView();
        if (mraidView.getOnOpenListener() != null) {
            mraidView.getOnOpenListener().onOpen(mraidView);
        }
        if (!this.isWebSiteUrl(string2) && this.canHandleApplicationUrl(string2)) {
            this.launchApplicationUrl(string2);
            return;
        }
        Intent intent = new Intent(this.mContext, MraidBrowser.class);
        intent.putExtra("extra_url", string2);
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
    }
}

