/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.mopub.mobileads.resource.Drawables;

public class MraidBrowser
extends Activity {
    public static final int INNER_LAYOUT_ID = 1;
    public static final String URL_EXTRA = "extra_url";
    private ImageButton mBackButton;
    private ImageButton mCloseButton;
    private ImageButton mForwardButton;
    private ImageButton mRefreshButton;
    private WebView mWebView;

    private void enableCookies() {
        CookieSyncManager.createInstance((Context)this);
        CookieSyncManager.getInstance().startSync();
    }

    private ImageButton getButton(Drawable drawable2) {
        ImageButton imageButton = new ImageButton((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        layoutParams.gravity = 16;
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageButton.setImageDrawable(drawable2);
        return imageButton;
    }

    private View getMraidBrowserView() {
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        linearLayout.setOrientation(1);
        RelativeLayout relativeLayout = new RelativeLayout((Context)this);
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.addView((View)relativeLayout);
        LinearLayout linearLayout2 = new LinearLayout((Context)this);
        linearLayout2.setId(1);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(12);
        linearLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout2.setBackgroundDrawable((Drawable)Drawables.BACKGROUND.decodeImage((Context)this));
        relativeLayout.addView((View)linearLayout2);
        this.mBackButton = this.getButton((Drawable)Drawables.LEFT_ARROW.decodeImage((Context)this));
        this.mForwardButton = this.getButton((Drawable)Drawables.RIGHT_ARROW.decodeImage((Context)this));
        this.mRefreshButton = this.getButton((Drawable)Drawables.REFRESH.decodeImage((Context)this));
        this.mCloseButton = this.getButton((Drawable)Drawables.CLOSE.decodeImage((Context)this));
        linearLayout2.addView((View)this.mBackButton);
        linearLayout2.addView((View)this.mForwardButton);
        linearLayout2.addView((View)this.mRefreshButton);
        linearLayout2.addView((View)this.mCloseButton);
        this.mWebView = new WebView((Context)this);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams2.addRule(2, 1);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        relativeLayout.addView((View)this.mWebView);
        return linearLayout;
    }

    private void initializeButtons() {
        this.mBackButton.setBackgroundColor(0);
        this.mBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MraidBrowser.this.mWebView.canGoBack()) {
                    MraidBrowser.this.mWebView.goBack();
                }
            }
        });
        this.mForwardButton.setBackgroundColor(0);
        this.mForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MraidBrowser.this.mWebView.canGoForward()) {
                    MraidBrowser.this.mWebView.goForward();
                }
            }
        });
        this.mRefreshButton.setBackgroundColor(0);
        this.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MraidBrowser.this.mWebView.reload();
            }
        });
        this.mCloseButton.setBackgroundColor(0);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MraidBrowser.this.finish();
            }
        });
    }

    private void initializeWebView(Intent intent) {
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        this.mWebView.loadUrl(intent.getStringExtra(URL_EXTRA));
        this.mWebView.setWebViewClient(new WebViewClient(){

            /*
             * Enabled aggressive block sorting
             */
            public void onPageFinished(WebView webView, String string2) {
                super.onPageFinished(webView, string2);
                BitmapDrawable bitmapDrawable = webView.canGoBack() ? Drawables.LEFT_ARROW.decodeImage((Context)MraidBrowser.this) : Drawables.UNLEFT_ARROW.decodeImage((Context)MraidBrowser.this);
                MraidBrowser.this.mBackButton.setImageDrawable((Drawable)bitmapDrawable);
                BitmapDrawable bitmapDrawable2 = webView.canGoForward() ? Drawables.RIGHT_ARROW.decodeImage((Context)MraidBrowser.this) : Drawables.UNRIGHT_ARROW.decodeImage((Context)MraidBrowser.this);
                MraidBrowser.this.mForwardButton.setImageDrawable((Drawable)bitmapDrawable2);
            }

            public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
                super.onPageStarted(webView, string2, bitmap);
                MraidBrowser.this.mForwardButton.setImageDrawable((Drawable)Drawables.UNRIGHT_ARROW.decodeImage((Context)MraidBrowser.this));
            }

            public void onReceivedError(WebView webView, int n2, String string2, String string3) {
                Toast.makeText((Context)((Activity)webView.getContext()), (CharSequence)("MRAID error: " + string2), (int)0).show();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
                block5: {
                    block4: {
                        if (string2 == null) break block4;
                        String string3 = Uri.parse((String)string2).getHost();
                        if (!string2.startsWith("http:") && !string2.startsWith("https:") || "play.google.com".equals(string3) || "market.android.com".equals(string3)) break block5;
                    }
                    return false;
                }
                try {
                    MraidBrowser.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)string2)));
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    Log.w((String)"MoPub", (String)("Unable to start activity for " + string2 + ". " + "Ensure that your phone can handle this intent."));
                }
                MraidBrowser.this.finish();
                return true;
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView webView, int n2) {
                Activity activity = (Activity)webView.getContext();
                activity.setTitle((CharSequence)"Loading...");
                activity.setProgress(n2 * 100);
                if (n2 == 100) {
                    activity.setTitle((CharSequence)webView.getUrl());
                }
            }
        });
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getWindow().requestFeature(2);
        this.getWindow().setFeatureInt(2, -1);
        this.setContentView(this.getMraidBrowserView());
        this.initializeWebView(this.getIntent());
        this.initializeButtons();
        this.enableCookies();
    }

    protected void onPause() {
        super.onPause();
        CookieSyncManager.getInstance().stopSync();
    }

    protected void onResume() {
        super.onResume();
        CookieSyncManager.getInstance().startSync();
    }
}

