/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import com.mopub.mobileads.AdConfiguration;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MraidView;
import com.mopub.mobileads.factories.MraidViewFactory;
import java.util.Map;

class MraidBanner
extends CustomEventBanner {
    private CustomEventBanner.CustomEventBannerListener mBannerListener;
    private MraidView mMraidView;

    MraidBanner() {
    }

    private boolean extrasAreValid(Map<String, String> map) {
        return map.containsKey("Html-Response-Body");
    }

    private void initMraidListener() {
        this.mMraidView.setMraidListener(new MraidView.MraidListener(){

            @Override
            public void onClose(MraidView mraidView, MraidView.ViewState viewState) {
                MraidBanner.this.onClose();
            }

            @Override
            public void onExpand(MraidView mraidView) {
                MraidBanner.this.onExpand();
            }

            @Override
            public void onFailure(MraidView mraidView) {
                MraidBanner.this.onFail();
            }

            @Override
            public void onReady(MraidView mraidView) {
                MraidBanner.this.onReady();
            }
        });
    }

    private void onClose() {
        this.mBannerListener.onBannerCollapsed();
    }

    private void onExpand() {
        this.mBannerListener.onBannerExpanded();
        this.mBannerListener.onBannerClicked();
    }

    private void onFail() {
        this.mBannerListener.onBannerFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
    }

    private void onReady() {
        this.mBannerListener.onBannerLoaded((View)this.mMraidView);
    }

    private void resetMraidListener() {
        this.mMraidView.setMraidListener(null);
    }

    @Override
    protected void loadBanner(Context context, CustomEventBanner.CustomEventBannerListener customEventBannerListener, Map<String, Object> map, Map<String, String> map2) {
        this.mBannerListener = customEventBannerListener;
        if (this.extrasAreValid(map2)) {
            String string2 = Uri.decode((String)map2.get("Html-Response-Body"));
            this.mMraidView = MraidViewFactory.create(context, AdConfiguration.extractFromMap(map));
            this.mMraidView.loadHtmlData(string2);
            this.initMraidListener();
            return;
        }
        this.mBannerListener.onBannerFailed(MoPubErrorCode.MRAID_LOAD_ERROR);
    }

    @Override
    protected void onInvalidate() {
        if (this.mMraidView != null) {
            this.resetMraidListener();
            this.mMraidView.destroy();
        }
    }
}

