/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.webkit.WebViewDatabase;
import android.widget.FrameLayout;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.CustomEventBannerAdapter;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.factories.AdViewControllerFactory;
import com.mopub.mobileads.factories.CustomEventBannerAdapterFactory;
import com.mopub.mobileads.util.ResponseHeader;
import java.util.Collections;
import java.util.Map;

public class MoPubView
extends FrameLayout {
    public static final String AD_HANDLER = "/m/ad";
    public static final int DEFAULT_LOCATION_PRECISION = 6;
    public static final String HOST = "ads.mopub.com";
    public static final String HOST_FOR_TESTING = "testing.ads.mopub.com";
    protected AdViewController mAdViewController;
    private BannerAdListener mBannerAdListener;
    private Context mContext;
    protected CustomEventBannerAdapter mCustomEventBannerAdapter;
    private boolean mIsInForeground;
    private LocationAwareness mLocationAwareness;
    private OnAdClickedListener mOnAdClickedListener;
    private OnAdClosedListener mOnAdClosedListener;
    private OnAdFailedListener mOnAdFailedListener;
    private OnAdLoadedListener mOnAdLoadedListener;
    private OnAdPresentedOverlayListener mOnAdPresentedOverlayListener;
    private OnAdWillLoadListener mOnAdWillLoadListener;
    private boolean mPreviousAutorefreshSetting = false;
    private BroadcastReceiver mScreenStateReceiver;

    public MoPubView(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public MoPubView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        boolean bl2 = this.getVisibility() == 0;
        this.mIsInForeground = bl2;
        this.mLocationAwareness = LocationAwareness.LOCATION_AWARENESS_NORMAL;
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        if (WebViewDatabase.getInstance((Context)context) == null) {
            Log.e((String)"MoPub", (String)"Disabling MoPub. Local cache file is inaccessible so MoPub will fail if we try to create a WebView. Details of this Android bug found at:http://code.google.com/p/android/issues/detail?id=10789");
            return;
        }
        this.mAdViewController = AdViewControllerFactory.create(context, this);
        this.registerScreenStateBroadcastReceiver();
    }

    static /* synthetic */ boolean access$102(MoPubView moPubView, boolean bl2) {
        moPubView.mPreviousAutorefreshSetting = bl2;
        return bl2;
    }

    private void registerScreenStateBroadcastReceiver() {
        if (this.mAdViewController == null) {
            return;
        }
        this.mScreenStateReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                    if (!MoPubView.this.mIsInForeground) {
                        Log.d((String)"MoPub", (String)"Screen sleep but ad in background; refresh should already be disabled");
                        return;
                    }
                    Log.d((String)"MoPub", (String)"Screen sleep with ad in foreground, disable refresh");
                    if (MoPubView.this.mAdViewController == null) return;
                    MoPubView.access$102(MoPubView.this, MoPubView.this.mAdViewController.getAutorefreshEnabled());
                    MoPubView.this.mAdViewController.setAutorefreshEnabled(false);
                    return;
                }
                if (!intent.getAction().equals("android.intent.action.USER_PRESENT")) return;
                if (!MoPubView.this.mIsInForeground) {
                    Log.d((String)"MoPub", (String)"Screen wake but ad in background; don't enable refresh");
                    return;
                }
                Log.d((String)"MoPub", (String)"Screen wake / ad in foreground, reset refresh");
                if (MoPubView.this.mAdViewController == null) return;
                MoPubView.this.mAdViewController.setAutorefreshEnabled(MoPubView.this.mPreviousAutorefreshSetting);
            }
        };
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiver(this.mScreenStateReceiver, intentFilter);
    }

    private void unregisterScreenStateBroadcastReceiver() {
        try {
            this.mContext.unregisterReceiver(this.mScreenStateReceiver);
            return;
        }
        catch (Exception exception) {
            Log.d((String)"MoPub", (String)"Failed to unregister screen state broadcast receiver (never registered).");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void adClicked() {
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerClicked(this);
            return;
        } else {
            if (this.mOnAdClickedListener == null) return;
            this.mOnAdClickedListener.OnAdClicked(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void adClosed() {
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerCollapsed(this);
            return;
        } else {
            if (this.mOnAdClosedListener == null) return;
            this.mOnAdClosedListener.OnAdClosed(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void adFailed(MoPubErrorCode moPubErrorCode) {
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerFailed(this, moPubErrorCode);
            return;
        } else {
            if (this.mOnAdFailedListener == null) return;
            this.mOnAdFailedListener.OnAdFailed(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void adLoaded() {
        Log.d((String)"MoPub", (String)"adLoaded");
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerLoaded(this);
            return;
        } else {
            if (this.mOnAdLoadedListener == null) return;
            this.mOnAdLoadedListener.OnAdLoaded(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void adPresentedOverlay() {
        if (this.mBannerAdListener != null) {
            this.mBannerAdListener.onBannerExpanded(this);
            return;
        } else {
            if (this.mOnAdPresentedOverlayListener == null) return;
            this.mOnAdPresentedOverlayListener.OnAdPresentedOverlay(this);
            return;
        }
    }

    @Deprecated
    protected void adWillLoad(String string2) {
        Log.d((String)"MoPub", (String)("adWillLoad: " + string2));
        if (this.mOnAdWillLoadListener != null) {
            this.mOnAdWillLoadListener.OnAdWillLoad(this, string2);
        }
    }

    @Deprecated
    public void customEventActionWillBegin() {
        if (this.mAdViewController != null) {
            this.mAdViewController.customEventActionWillBegin();
        }
    }

    @Deprecated
    public void customEventDidFailToLoadAd() {
        if (this.mAdViewController != null) {
            this.mAdViewController.customEventDidFailToLoadAd();
        }
    }

    @Deprecated
    public void customEventDidLoadAd() {
        if (this.mAdViewController != null) {
            this.mAdViewController.customEventDidLoadAd();
        }
    }

    public void destroy() {
        this.unregisterScreenStateBroadcastReceiver();
        this.removeAllViews();
        if (this.mAdViewController != null) {
            this.mAdViewController.cleanup();
            this.mAdViewController = null;
        }
        if (this.mCustomEventBannerAdapter != null) {
            this.mCustomEventBannerAdapter.invalidate();
            this.mCustomEventBannerAdapter = null;
        }
    }

    public void forceRefresh() {
        if (this.mCustomEventBannerAdapter != null) {
            this.mCustomEventBannerAdapter.invalidate();
            this.mCustomEventBannerAdapter = null;
        }
        if (this.mAdViewController != null) {
            this.mAdViewController.forceRefresh();
        }
    }

    public Activity getActivity() {
        return (Activity)this.mContext;
    }

    public int getAdHeight() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getAdHeight();
        }
        return 0;
    }

    Integer getAdTimeoutDelay() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getAdTimeoutDelay();
        }
        return null;
    }

    public String getAdUnitId() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getAdUnitId();
        }
        return null;
    }

    AdViewController getAdViewController() {
        return this.mAdViewController;
    }

    public int getAdWidth() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getAdWidth();
        }
        return 0;
    }

    public boolean getAutorefreshEnabled() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getAutorefreshEnabled();
        }
        Log.d((String)"MoPub", (String)"Can't get autorefresh status for destroyed MoPubView. Returning false.");
        return false;
    }

    public BannerAdListener getBannerAdListener() {
        return this.mBannerAdListener;
    }

    public String getClickthroughUrl() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getClickthroughUrl();
        }
        return null;
    }

    public String getKeywords() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getKeywords();
        }
        return null;
    }

    public Map<String, Object> getLocalExtras() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getLocalExtras();
        }
        return Collections.emptyMap();
    }

    public Location getLocation() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getLocation();
        }
        return null;
    }

    public LocationAwareness getLocationAwareness() {
        return this.mLocationAwareness;
    }

    public int getLocationPrecision() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getLocationPrecision();
        }
        return 0;
    }

    public String getResponseString() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getResponseString();
        }
        return null;
    }

    public boolean getTesting() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getTesting();
        }
        Log.d((String)"MoPub", (String)"Can't get testing status for destroyed MoPubView. Returning false.");
        return false;
    }

    public boolean isFacebookSupported() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.isFacebookSupported();
        }
        return false;
    }

    public void loadAd() {
        if (this.mAdViewController != null) {
            this.mAdViewController.loadAd();
        }
    }

    protected void loadCustomEvent(Map<String, String> map) {
        if (map == null) {
            Log.d((String)"MoPub", (String)"Couldn't invoke custom event because the server did not specify one.");
            this.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
            return;
        }
        if (this.mCustomEventBannerAdapter != null) {
            this.mCustomEventBannerAdapter.invalidate();
        }
        Log.d((String)"MoPub", (String)"Loading custom event adapter.");
        this.mCustomEventBannerAdapter = CustomEventBannerAdapterFactory.create(this, map.get(ResponseHeader.CUSTOM_EVENT_NAME.getKey()), map.get(ResponseHeader.CUSTOM_EVENT_DATA.getKey()));
        this.mCustomEventBannerAdapter.loadAd();
    }

    protected void loadFailUrl(MoPubErrorCode moPubErrorCode) {
        if (this.mAdViewController != null) {
            this.mAdViewController.loadFailUrl(moPubErrorCode);
        }
    }

    protected void nativeAdLoaded() {
        if (this.mAdViewController != null) {
            this.mAdViewController.scheduleRefreshTimerIfEnabled();
        }
        this.adLoaded();
    }

    protected void onWindowVisibilityChanged(int n2) {
        if (this.mAdViewController == null) {
            return;
        }
        if (n2 == 0) {
            Log.d((String)"MoPub", (String)("Ad Unit (" + this.mAdViewController.getAdUnitId() + ") going visible: enabling refresh"));
            this.mIsInForeground = true;
            this.mAdViewController.setAutorefreshEnabled(true);
            return;
        }
        Log.d((String)"MoPub", (String)("Ad Unit (" + this.mAdViewController.getAdUnitId() + ") going invisible: disabling refresh"));
        this.mIsInForeground = false;
        this.mAdViewController.setAutorefreshEnabled(false);
    }

    protected void registerClick() {
        if (this.mAdViewController != null) {
            this.mAdViewController.registerClick();
            this.adClicked();
        }
    }

    public void setAdContentView(View view) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setAdContentView(view);
        }
    }

    public void setAdUnitId(String string2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setAdUnitId(string2);
        }
    }

    public void setAutorefreshEnabled(boolean bl2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setAutorefreshEnabled(bl2);
        }
    }

    public void setBannerAdListener(BannerAdListener bannerAdListener) {
        this.mBannerAdListener = bannerAdListener;
    }

    public void setClickthroughUrl(String string2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setClickthroughUrl(string2);
        }
    }

    public void setFacebookSupported(boolean bl2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setFacebookSupported(bl2);
        }
    }

    public void setKeywords(String string2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setKeywords(string2);
        }
    }

    public void setLocalExtras(Map<String, Object> map) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setLocalExtras(map);
        }
    }

    public void setLocation(Location location) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setLocation(location);
        }
    }

    public void setLocationAwareness(LocationAwareness locationAwareness) {
        this.mLocationAwareness = locationAwareness;
    }

    public void setLocationPrecision(int n2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setLocationPrecision(n2);
        }
    }

    @Deprecated
    public void setOnAdClickedListener(OnAdClickedListener onAdClickedListener) {
        this.mOnAdClickedListener = onAdClickedListener;
    }

    @Deprecated
    public void setOnAdClosedListener(OnAdClosedListener onAdClosedListener) {
        this.mOnAdClosedListener = onAdClosedListener;
    }

    @Deprecated
    public void setOnAdFailedListener(OnAdFailedListener onAdFailedListener) {
        this.mOnAdFailedListener = onAdFailedListener;
    }

    @Deprecated
    public void setOnAdLoadedListener(OnAdLoadedListener onAdLoadedListener) {
        this.mOnAdLoadedListener = onAdLoadedListener;
    }

    @Deprecated
    public void setOnAdPresentedOverlayListener(OnAdPresentedOverlayListener onAdPresentedOverlayListener) {
        this.mOnAdPresentedOverlayListener = onAdPresentedOverlayListener;
    }

    @Deprecated
    public void setOnAdWillLoadListener(OnAdWillLoadListener onAdWillLoadListener) {
        this.mOnAdWillLoadListener = onAdWillLoadListener;
    }

    public void setTesting(boolean bl2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setTesting(bl2);
        }
    }

    public void setTimeout(int n2) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setTimeout(n2);
        }
    }

    protected void trackNativeImpression() {
        Log.d((String)"MoPub", (String)"Tracking impression for native adapter.");
        if (this.mAdViewController != null) {
            this.mAdViewController.trackImpression();
        }
    }

    public static interface BannerAdListener {
        public void onBannerClicked(MoPubView var1);

        public void onBannerCollapsed(MoPubView var1);

        public void onBannerExpanded(MoPubView var1);

        public void onBannerFailed(MoPubView var1, MoPubErrorCode var2);

        public void onBannerLoaded(MoPubView var1);
    }

    public static final class LocationAwareness
    extends Enum<LocationAwareness> {
        private static final /* synthetic */ LocationAwareness[] $VALUES;
        public static final /* enum */ LocationAwareness LOCATION_AWARENESS_DISABLED;
        public static final /* enum */ LocationAwareness LOCATION_AWARENESS_NORMAL;
        public static final /* enum */ LocationAwareness LOCATION_AWARENESS_TRUNCATED;

        static {
            LOCATION_AWARENESS_NORMAL = new LocationAwareness();
            LOCATION_AWARENESS_TRUNCATED = new LocationAwareness();
            LOCATION_AWARENESS_DISABLED = new LocationAwareness();
            LocationAwareness[] locationAwarenessArray = new LocationAwareness[]{LOCATION_AWARENESS_NORMAL, LOCATION_AWARENESS_TRUNCATED, LOCATION_AWARENESS_DISABLED};
            $VALUES = locationAwarenessArray;
        }

        public static LocationAwareness valueOf(String string2) {
            return Enum.valueOf(LocationAwareness.class, string2);
        }

        public static LocationAwareness[] values() {
            return (LocationAwareness[])$VALUES.clone();
        }
    }

    @Deprecated
    public static interface OnAdClickedListener {
        public void OnAdClicked(MoPubView var1);
    }

    @Deprecated
    public static interface OnAdClosedListener {
        public void OnAdClosed(MoPubView var1);
    }

    @Deprecated
    public static interface OnAdFailedListener {
        public void OnAdFailed(MoPubView var1);
    }

    @Deprecated
    public static interface OnAdLoadedListener {
        public void OnAdLoaded(MoPubView var1);
    }

    @Deprecated
    public static interface OnAdPresentedOverlayListener {
        public void OnAdPresentedOverlay(MoPubView var1);
    }

    @Deprecated
    public static interface OnAdWillLoadListener {
        public void OnAdWillLoad(MoPubView var1, String var2);
    }
}

