/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.util.Log;
import com.mopub.mobileads.CustomEventInterstitialAdapter;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.factories.CustomEventInterstitialAdapterFactory;
import com.mopub.mobileads.util.ResponseHeader;
import java.util.Map;

public class MoPubInterstitial
implements CustomEventInterstitialAdapter.CustomEventInterstitialAdapterListener {
    private Activity mActivity;
    private String mAdUnitId;
    private InterstitialState mCurrentInterstitialState;
    private CustomEventInterstitialAdapter mCustomEventInterstitialAdapter;
    private InterstitialAdListener mInterstitialAdListener;
    private MoPubInterstitialView mInterstitialView;
    private boolean mIsDestroyed;
    private MoPubInterstitialListener mListener;

    public MoPubInterstitial(Activity activity, String string2) {
        this.mActivity = activity;
        this.mAdUnitId = string2;
        this.mInterstitialView = new MoPubInterstitialView((Context)this.mActivity);
        this.mInterstitialView.setAdUnitId(this.mAdUnitId);
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
    }

    static /* synthetic */ CustomEventInterstitialAdapter access$002(MoPubInterstitial moPubInterstitial, CustomEventInterstitialAdapter customEventInterstitialAdapter) {
        moPubInterstitial.mCustomEventInterstitialAdapter = customEventInterstitialAdapter;
        return customEventInterstitialAdapter;
    }

    private void resetCurrentInterstitial() {
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.invalidate();
            this.mCustomEventInterstitialAdapter = null;
        }
        this.mIsDestroyed = false;
    }

    private void showCustomEventInterstitial() {
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.showInterstitial();
        }
    }

    @Deprecated
    public void customEventActionWillBegin() {
        if (this.mInterstitialView != null) {
            this.mInterstitialView.registerClick();
        }
    }

    @Deprecated
    public void customEventDidFailToLoadAd() {
        if (this.mInterstitialView != null) {
            this.mInterstitialView.loadFailUrl(MoPubErrorCode.UNSPECIFIED);
        }
    }

    @Deprecated
    public void customEventDidLoadAd() {
        if (this.mInterstitialView != null) {
            this.mInterstitialView.trackImpression();
        }
    }

    public void destroy() {
        this.mIsDestroyed = true;
        if (this.mCustomEventInterstitialAdapter != null) {
            this.mCustomEventInterstitialAdapter.invalidate();
            this.mCustomEventInterstitialAdapter = null;
        }
        this.mInterstitialView.setBannerAdListener(null);
        this.mInterstitialView.destroy();
    }

    public void forceRefresh() {
        this.resetCurrentInterstitial();
        this.mInterstitialView.forceRefresh();
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    Integer getAdTimeoutDelay() {
        return this.mInterstitialView.getAdTimeoutDelay();
    }

    public InterstitialAdListener getInterstitialAdListener() {
        return this.mInterstitialAdListener;
    }

    public String getKeywords() {
        return this.mInterstitialView.getKeywords();
    }

    @Deprecated
    public MoPubInterstitialListener getListener() {
        return this.mListener;
    }

    public Map<String, Object> getLocalExtras() {
        return this.mInterstitialView.getLocalExtras();
    }

    public Location getLocation() {
        return this.mInterstitialView.getLocation();
    }

    public MoPubView.LocationAwareness getLocationAwareness() {
        return this.mInterstitialView.getLocationAwareness();
    }

    public int getLocationPrecision() {
        return this.mInterstitialView.getLocationPrecision();
    }

    MoPubInterstitialView getMoPubInterstitialView() {
        return this.mInterstitialView;
    }

    public boolean getTesting() {
        return this.mInterstitialView.getTesting();
    }

    boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    public boolean isFacebookSupported() {
        return this.mInterstitialView.isFacebookSupported();
    }

    public boolean isReady() {
        return this.mCurrentInterstitialState.isReady();
    }

    public void load() {
        this.resetCurrentInterstitial();
        this.mInterstitialView.loadAd();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCustomEventInterstitialClicked() {
        block3: {
            block2: {
                if (this.isDestroyed()) break block2;
                this.mInterstitialView.registerClick();
                if (this.mInterstitialAdListener != null) break block3;
            }
            return;
        }
        this.mInterstitialAdListener.onInterstitialClicked(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCustomEventInterstitialDismissed() {
        block3: {
            block2: {
                if (this.isDestroyed()) break block2;
                this.mCurrentInterstitialState = InterstitialState.NOT_READY;
                if (this.mInterstitialAdListener != null) break block3;
            }
            return;
        }
        this.mInterstitialAdListener.onInterstitialDismissed(this);
    }

    @Override
    public void onCustomEventInterstitialFailed(MoPubErrorCode moPubErrorCode) {
        if (this.isDestroyed()) {
            return;
        }
        this.mCurrentInterstitialState = InterstitialState.NOT_READY;
        this.mInterstitialView.loadFailUrl(moPubErrorCode);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCustomEventInterstitialLoaded() {
        block5: {
            block4: {
                if (this.mIsDestroyed) break block4;
                this.mCurrentInterstitialState = InterstitialState.CUSTOM_EVENT_AD_READY;
                if (this.mInterstitialAdListener != null) {
                    this.mInterstitialAdListener.onInterstitialLoaded(this);
                    return;
                }
                if (this.mListener != null) break block5;
            }
            return;
        }
        this.mListener.OnInterstitialLoaded();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCustomEventInterstitialShown() {
        block3: {
            block2: {
                if (this.isDestroyed()) break block2;
                this.mInterstitialView.trackImpression();
                if (this.mInterstitialAdListener != null) break block3;
            }
            return;
        }
        this.mInterstitialAdListener.onInterstitialShown(this);
    }

    public void setFacebookSupported(boolean bl2) {
        this.mInterstitialView.setFacebookSupported(bl2);
    }

    public void setInterstitialAdListener(InterstitialAdListener interstitialAdListener) {
        this.mInterstitialAdListener = interstitialAdListener;
    }

    @Deprecated
    void setInterstitialView(MoPubInterstitialView moPubInterstitialView) {
        this.mInterstitialView = moPubInterstitialView;
    }

    public void setKeywords(String string2) {
        this.mInterstitialView.setKeywords(string2);
    }

    @Deprecated
    public void setListener(MoPubInterstitialListener moPubInterstitialListener) {
        this.mListener = moPubInterstitialListener;
    }

    public void setLocalExtras(Map<String, Object> map) {
        this.mInterstitialView.setLocalExtras(map);
    }

    public void setLocationAwareness(MoPubView.LocationAwareness locationAwareness) {
        this.mInterstitialView.setLocationAwareness(locationAwareness);
    }

    public void setLocationPrecision(int n2) {
        this.mInterstitialView.setLocationPrecision(n2);
    }

    public void setTesting(boolean bl2) {
        this.mInterstitialView.setTesting(bl2);
    }

    public boolean show() {
        switch (this.mCurrentInterstitialState) {
            default: {
                return false;
            }
            case CUSTOM_EVENT_AD_READY: 
        }
        this.showCustomEventInterstitial();
        return true;
    }

    public static interface InterstitialAdListener {
        public void onInterstitialClicked(MoPubInterstitial var1);

        public void onInterstitialDismissed(MoPubInterstitial var1);

        public void onInterstitialFailed(MoPubInterstitial var1, MoPubErrorCode var2);

        public void onInterstitialLoaded(MoPubInterstitial var1);

        public void onInterstitialShown(MoPubInterstitial var1);
    }

    private static final class InterstitialState
    extends Enum<InterstitialState> {
        private static final /* synthetic */ InterstitialState[] $VALUES;
        public static final /* enum */ InterstitialState CUSTOM_EVENT_AD_READY = new InterstitialState();
        public static final /* enum */ InterstitialState NOT_READY = new InterstitialState();

        static {
            InterstitialState[] interstitialStateArray = new InterstitialState[]{CUSTOM_EVENT_AD_READY, NOT_READY};
            $VALUES = interstitialStateArray;
        }

        public static InterstitialState valueOf(String string2) {
            return Enum.valueOf(InterstitialState.class, string2);
        }

        public static InterstitialState[] values() {
            return (InterstitialState[])$VALUES.clone();
        }

        boolean isReady() {
            return this != NOT_READY;
        }
    }

    @Deprecated
    public static interface MoPubInterstitialListener {
        public void OnInterstitialFailed();

        public void OnInterstitialLoaded();
    }

    public class MoPubInterstitialView
    extends MoPubView {
        public MoPubInterstitialView(Context context) {
            super(context);
            this.setAutorefreshEnabled(false);
        }

        @Override
        protected void adFailed(MoPubErrorCode moPubErrorCode) {
            if (MoPubInterstitial.this.mInterstitialAdListener != null) {
                MoPubInterstitial.this.mInterstitialAdListener.onInterstitialFailed(MoPubInterstitial.this, moPubErrorCode);
            }
        }

        @Override
        protected void loadCustomEvent(Map<String, String> map) {
            if (map == null) {
                Log.d((String)"MoPub", (String)"Couldn't invoke custom event because the server did not specify one.");
                this.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
                return;
            }
            if (MoPubInterstitial.this.mCustomEventInterstitialAdapter != null) {
                MoPubInterstitial.this.mCustomEventInterstitialAdapter.invalidate();
            }
            Log.d((String)"MoPub", (String)"Loading custom event interstitial adapter.");
            MoPubInterstitial.access$002(MoPubInterstitial.this, CustomEventInterstitialAdapterFactory.create(MoPubInterstitial.this, map.get(ResponseHeader.CUSTOM_EVENT_NAME.getKey()), map.get(ResponseHeader.CUSTOM_EVENT_DATA.getKey())));
            MoPubInterstitial.this.mCustomEventInterstitialAdapter.setAdapterListener(MoPubInterstitial.this);
            MoPubInterstitial.this.mCustomEventInterstitialAdapter.loadInterstitial();
        }

        protected void trackImpression() {
            Log.d((String)"MoPub", (String)"Tracking impression for interstitial.");
            if (this.mAdViewController != null) {
                this.mAdViewController.trackImpression();
            }
        }
    }
}

