/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.mopub.mobileads.BaseUrlGenerator;
import com.mopub.mobileads.factories.HttpClientFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class MoPubConversionTracker {
    private static final String PREFERENCE_NAME = "mopubSettings";
    private static final String TRACK_HANDLER = "/m/open";
    private static final String TRACK_HOST = "ads.mopub.com";
    private Context mContext;
    private String mIsTrackedKey;
    private String mPackageName;
    private SharedPreferences mSharedPreferences;

    private boolean isAlreadyTracked() {
        return this.mSharedPreferences.getBoolean(this.mIsTrackedKey, false);
    }

    public void reportAppOpen(Context context) {
        if (context == null) {
            return;
        }
        this.mContext = context;
        this.mPackageName = this.mContext.getPackageName();
        this.mIsTrackedKey = this.mPackageName + " tracked";
        this.mSharedPreferences = this.mContext.getSharedPreferences(PREFERENCE_NAME, 0);
        if (!this.isAlreadyTracked()) {
            new Thread(new TrackOpen()).start();
            return;
        }
        Log.d((String)"MoPub", (String)"Conversion already tracked");
    }

    private class ConversionUrlGenerator
    extends BaseUrlGenerator {
        private ConversionUrlGenerator() {
        }

        private void setPackageId(String string2) {
            this.addParam("id", string2);
        }

        @Override
        public String generateUrlString(String string2) {
            this.initUrlString(string2, MoPubConversionTracker.TRACK_HANDLER);
            this.setApiVersion("6");
            this.setPackageId(MoPubConversionTracker.this.mPackageName);
            this.setUdid(this.getUdidFromContext(MoPubConversionTracker.this.mContext));
            this.setAppVersion(this.getAppVersionFromContext(MoPubConversionTracker.this.mContext));
            return this.getFinalUrlString();
        }
    }

    private class TrackOpen
    implements Runnable {
        private TrackOpen() {
        }

        @Override
        public void run() {
            HttpResponse httpResponse;
            String string2 = new ConversionUrlGenerator().generateUrlString(MoPubConversionTracker.TRACK_HOST);
            Log.d((String)"MoPub", (String)("Conversion track: " + string2));
            DefaultHttpClient defaultHttpClient = HttpClientFactory.create();
            try {
                httpResponse = defaultHttpClient.execute((HttpUriRequest)new HttpGet(string2));
            }
            catch (Exception exception) {
                Log.d((String)"MoPub", (String)("Conversion track failed [" + exception.getClass().getSimpleName() + "]: " + string2));
                return;
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                Log.d((String)"MoPub", (String)"Conversion track failed: Status code != 200.");
                return;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null || httpEntity.getContentLength() == 0L) {
                Log.d((String)"MoPub", (String)"Conversion track failed: Response was empty.");
                return;
            }
            Log.d((String)"MoPub", (String)"Conversion track successful.");
            MoPubConversionTracker.this.mSharedPreferences.edit().putBoolean(MoPubConversionTracker.this.mIsTrackedKey, true).commit();
        }
    }
}

