/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.location.Location;
import android.util.Log;
import android.view.View;
import com.millennialmedia.android.MMAd;
import com.millennialmedia.android.MMAdView;
import com.millennialmedia.android.MMBroadcastReceiver;
import com.millennialmedia.android.MMRequest;
import com.millennialmedia.android.MMSDK;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.Map;

class MillennialBanner
extends CustomEventBanner {
    public static final String AD_HEIGHT_KEY = "adHeight";
    public static final String AD_WIDTH_KEY = "adWidth";
    public static final String APID_KEY = "adUnitID";
    private CustomEventBanner.CustomEventBannerListener mBannerListener;
    private MillennialBroadcastReceiver mBroadcastReceiver;
    private MMAdView mMillennialAdView;

    MillennialBanner() {
    }

    private boolean extrasAreValid(Map<String, String> map) {
        try {
            Integer.parseInt(map.get(AD_WIDTH_KEY));
            Integer.parseInt(map.get(AD_HEIGHT_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return map.containsKey(APID_KEY);
    }

    @Deprecated
    MMAdView getMMAdView() {
        return this.mMillennialAdView;
    }

    @Override
    protected void loadBanner(Context context, CustomEventBanner.CustomEventBannerListener customEventBannerListener, Map<String, Object> map, Map<String, String> map2) {
        this.mBannerListener = customEventBannerListener;
        if (this.extrasAreValid(map2)) {
            String string2 = map2.get(APID_KEY);
            int n2 = Integer.parseInt(map2.get(AD_WIDTH_KEY));
            int n3 = Integer.parseInt(map2.get(AD_HEIGHT_KEY));
            MMSDK.initialize(context);
            MMSDK.setBroadcastEvents(true);
            this.mBroadcastReceiver = new MillennialBroadcastReceiver();
            this.mBroadcastReceiver.register(context);
            this.mMillennialAdView = new MMAdView(context);
            this.mMillennialAdView.setApid(string2);
            this.mMillennialAdView.setWidth(n2);
            this.mMillennialAdView.setHeight(n3);
            Location location = (Location)map.get("location");
            if (location != null) {
                MMRequest.setUserLocation(location);
            }
            this.mMillennialAdView.setMMRequest(new MMRequest());
            this.mMillennialAdView.setId(MMSDK.getDefaultAdId());
            AdViewController.setShouldHonorServerDimensions((View)this.mMillennialAdView);
            this.mMillennialAdView.getAd();
            return;
        }
        this.mBannerListener.onBannerFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
    }

    @Override
    protected void onInvalidate() {
        this.mMillennialAdView.setListener(null);
        this.mBroadcastReceiver.unregister();
    }

    class MillennialBroadcastReceiver
    extends MMBroadcastReceiver {
        private Context mContext;

        MillennialBroadcastReceiver() {
        }

        @Override
        public void getAdFailure(MMAd mMAd) {
            super.getAdFailure(mMAd);
            Log.d((String)"MoPub", (String)"Millennial banner ad failed to load.");
            MillennialBanner.this.mBannerListener.onBannerFailed(MoPubErrorCode.NETWORK_NO_FILL);
        }

        @Override
        public void getAdSuccess(MMAd mMAd) {
            super.getAdSuccess(mMAd);
            Log.d((String)"MoPub", (String)"Millennial banner ad loaded successfully. Showing ad...");
            MillennialBanner.this.mBannerListener.onBannerLoaded((View)MillennialBanner.this.mMillennialAdView);
        }

        @Override
        public void intentStarted(MMAd mMAd, String string2) {
            super.intentStarted(mMAd, string2);
            Log.d((String)"MoPub", (String)"Millennial banner ad clicked.");
            MillennialBanner.this.mBannerListener.onBannerClicked();
        }

        void register(Context context) {
            this.mContext = context;
            context.registerReceiver((BroadcastReceiver)this, MMBroadcastReceiver.createIntentFilter());
        }

        void unregister() {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
                return;
            }
            catch (Exception exception) {
                Log.d((String)"MoPub", (String)"Unable to unregister MMBroadcastReceiver", (Throwable)exception);
                return;
            }
            finally {
                this.mContext = null;
            }
        }
    }
}

