/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.mobileads.BaseHtmlWebView;
import com.mopub.mobileads.HtmlWebViewListener;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MraidBrowser;
import com.mopub.mobileads.Utils;

class HtmlWebViewClient
extends WebViewClient {
    static final String MOPUB_FAIL_LOAD = "mopub://failLoad";
    static final String MOPUB_FINISH_LOAD = "mopub://finishLoad";
    private final String mClickthroughUrl;
    private final Context mContext;
    private BaseHtmlWebView mHtmlWebView;
    private HtmlWebViewListener mHtmlWebViewListener;
    private final String mRedirectUrl;

    HtmlWebViewClient(HtmlWebViewListener htmlWebViewListener, BaseHtmlWebView baseHtmlWebView, String string2, String string3) {
        this.mHtmlWebViewListener = htmlWebViewListener;
        this.mHtmlWebView = baseHtmlWebView;
        this.mClickthroughUrl = string2;
        this.mRedirectUrl = string3;
        this.mContext = baseHtmlWebView.getContext();
    }

    private boolean canHandleApplicationUrl(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        if (!Utils.deviceCanHandleIntent(this.mContext, intent)) {
            Log.w((String)"MoPub", (String)("Could not handle application specific action: " + string2 + ". " + "You may be running in the emulator or another device which does not " + "have the required application."));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeIntent(Context context, Intent intent, String string2) {
        try {
            context.startActivity(intent);
            return true;
        }
        catch (Exception exception) {
            if (string2 == null) {
                string2 = "Unable to start intent.";
            }
            Log.d((String)"MoPub", (String)string2);
            return false;
        }
    }

    private void handleCustomIntentFromUri(Uri uri) {
        String string2;
        String string3;
        try {
            string3 = uri.getQueryParameter("fnc");
            string2 = uri.getQueryParameter("data");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.w((String)"MoPub", (String)("Could not handle custom intent with uri: " + uri));
            return;
        }
        Intent intent = new Intent(string3);
        intent.addFlags(0x10000000);
        intent.putExtra("com.mopub.intent.extra.AD_CLICK_DATA", string2);
        String string4 = "Could not handle custom intent: " + string3 + ". Is your intent spelled correctly?";
        this.launchIntentForUserClick(this.mContext, intent, string4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleNativeBrowserScheme(String string2) {
        String string3;
        block5: {
            block4: {
                if (!this.isNativeBrowserScheme(string2)) break block4;
                Uri uri = Uri.parse((String)string2);
                try {
                    string3 = uri.getQueryParameter("url");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Log.w((String)"MoPub", (String)("Could not handle url: " + string2));
                    return false;
                }
                if ("navigate".equals(uri.getHost()) && string3 != null) break block5;
            }
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string3));
        intent.setFlags(0x10000000);
        String string4 = "Could not handle intent with URI: " + string2 + ". Is this intent supported on your phone?";
        this.launchIntentForUserClick(this.mContext, intent, string4);
        return true;
    }

    private boolean handlePhoneScheme(String string2) {
        if (!this.isPhoneScheme(string2)) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        intent.addFlags(0x10000000);
        String string3 = "Could not handle intent with URI: " + string2 + ". Is this intent supported on your phone?";
        this.launchIntentForUserClick(this.mContext, intent, string3);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleSpecialMoPubScheme(String string2) {
        if (!this.isSpecialMoPubScheme(string2)) {
            return false;
        }
        Uri uri = Uri.parse((String)string2);
        String string3 = uri.getHost();
        if ("finishLoad".equals(string3)) {
            this.mHtmlWebViewListener.onLoaded(this.mHtmlWebView);
            return true;
        }
        if ("close".equals(string3)) {
            this.mHtmlWebViewListener.onCollapsed();
            return true;
        }
        if ("failLoad".equals(string3)) {
            this.mHtmlWebViewListener.onFailed(MoPubErrorCode.UNSPECIFIED);
            return true;
        }
        if (!"custom".equals(string3)) return true;
        this.handleCustomIntentFromUri(uri);
        return true;
    }

    private boolean isNativeBrowserScheme(String string2) {
        return string2.startsWith("mopubnativebrowser://");
    }

    private boolean isPhoneScheme(String string2) {
        return string2.startsWith("tel:") || string2.startsWith("voicemail:") || string2.startsWith("sms:") || string2.startsWith("mailto:") || string2.startsWith("geo:") || string2.startsWith("google.streetview:");
    }

    private boolean isSpecialMoPubScheme(String string2) {
        return string2.startsWith("mopub://");
    }

    private boolean isWebSiteUrl(String string2) {
        return string2.startsWith("http://") || string2.startsWith("https://");
    }

    private boolean launchApplicationUrl(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        intent.addFlags(0x10000000);
        return this.launchIntentForUserClick(this.mContext, intent, "Unable to open intent.");
    }

    private void showMraidBrowserForUrl(String string2) {
        if (string2 == null || string2.equals("")) {
            string2 = "about:blank";
        }
        Log.d((String)"MoPub", (String)("Final URI to show in browser: " + string2));
        Intent intent = new Intent(this.mContext, MraidBrowser.class);
        intent.putExtra("extra_url", string2);
        intent.addFlags(0x10000000);
        if (!this.launchIntentForUserClick(this.mContext, intent, "Could not handle intent action. . Perhaps you forgot to declare com.mopub.mobileads.MraidBrowser in your Android manifest file.")) {
            Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)"about:blank"));
            intent2.setFlags(0x10000000);
            this.launchIntentForUserClick(this.mContext, intent2, null);
        }
    }

    private String urlWithClickTrackingRedirect(String string2) {
        if (this.mClickthroughUrl == null) {
            return string2;
        }
        String string3 = Uri.encode((String)string2);
        return this.mClickthroughUrl + "&r=" + string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean launchIntentForUserClick(Context context, Intent intent, String string2) {
        if (!this.mHtmlWebView.wasClicked()) {
            return false;
        }
        boolean bl2 = this.executeIntent(context, intent, string2);
        if (!bl2) return bl2;
        this.mHtmlWebViewListener.onClicked();
        this.mHtmlWebView.onResetUserClick();
        return bl2;
    }

    public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        if (this.mRedirectUrl != null && string2.startsWith(this.mRedirectUrl)) {
            String string3 = this.urlWithClickTrackingRedirect(string2);
            webView.stopLoading();
            this.showMraidBrowserForUrl(string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        String string3;
        block3: {
            block2: {
                if (this.handleSpecialMoPubScheme(string2) || this.handlePhoneScheme(string2) || this.handleNativeBrowserScheme(string2)) break block2;
                string3 = this.urlWithClickTrackingRedirect(string2);
                Log.d((String)"MoPub", (String)("Ad clicked. Click URL: " + string3));
                if (this.isWebSiteUrl(string3) || !this.canHandleApplicationUrl(string3) || !this.launchApplicationUrl(string3)) break block3;
            }
            return true;
        }
        this.showMraidBrowserForUrl(string3);
        return true;
    }
}

