/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.util.Views;
import java.util.Map;

class GooglePlayServicesBanner
extends CustomEventBanner {
    private static final String AD_HEIGHT_KEY = "adHeight";
    private static final String AD_UNIT_ID_KEY = "adUnitID";
    private static final String AD_WIDTH_KEY = "adWidth";
    private static final String LOCATION_KEY = "location";
    private CustomEventBanner.CustomEventBannerListener mBannerListener;
    private AdView mGoogleAdView;

    GooglePlayServicesBanner() {
    }

    private AdSize calculateAdSize(int n2, int n3) {
        if (n2 <= AdSize.BANNER.getWidth() && n3 <= AdSize.BANNER.getHeight()) {
            return AdSize.BANNER;
        }
        if (n2 <= AdSize.MEDIUM_RECTANGLE.getWidth() && n3 <= AdSize.MEDIUM_RECTANGLE.getHeight()) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        if (n2 <= AdSize.FULL_BANNER.getWidth() && n3 <= AdSize.FULL_BANNER.getHeight()) {
            return AdSize.FULL_BANNER;
        }
        if (n2 <= AdSize.LEADERBOARD.getWidth() && n3 <= AdSize.LEADERBOARD.getHeight()) {
            return AdSize.LEADERBOARD;
        }
        return null;
    }

    private boolean extrasAreValid(Map<String, String> map) {
        try {
            Integer.parseInt(map.get(AD_WIDTH_KEY));
            Integer.parseInt(map.get(AD_HEIGHT_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return map.containsKey(AD_UNIT_ID_KEY);
    }

    @Deprecated
    AdView getGoogleAdView() {
        return this.mGoogleAdView;
    }

    @Override
    protected void loadBanner(Context context, CustomEventBanner.CustomEventBannerListener customEventBannerListener, Map<String, Object> map, Map<String, String> map2) {
        AdSize adSize;
        this.mBannerListener = customEventBannerListener;
        if (this.extrasAreValid(map2)) {
            String string2 = map2.get(AD_UNIT_ID_KEY);
            int n2 = Integer.parseInt(map2.get(AD_WIDTH_KEY));
            int n3 = Integer.parseInt(map2.get(AD_HEIGHT_KEY));
            this.mGoogleAdView = new AdView(context);
            this.mGoogleAdView.setAdListener(new AdViewListener());
            this.mGoogleAdView.setAdUnitId(string2);
            adSize = this.calculateAdSize(n2, n3);
            if (adSize == null) {
                this.mBannerListener.onBannerFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
                return;
            }
        } else {
            this.mBannerListener.onBannerFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        this.mGoogleAdView.setAdSize(adSize);
        AdRequest adRequest = new AdRequest.Builder().build();
        this.mGoogleAdView.loadAd(adRequest);
    }

    @Override
    protected void onInvalidate() {
        Views.removeFromParent((View)this.mGoogleAdView);
        if (this.mGoogleAdView != null) {
            this.mGoogleAdView.setAdListener(null);
            this.mGoogleAdView.destroy();
        }
    }

    private class AdViewListener
    extends AdListener {
        private AdViewListener() {
        }

        @Override
        public void onAdClosed() {
        }

        @Override
        public void onAdFailedToLoad(int n2) {
            Log.d((String)"MoPub", (String)"Google Play Services banner ad failed to load.");
            if (GooglePlayServicesBanner.this.mBannerListener != null) {
                GooglePlayServicesBanner.this.mBannerListener.onBannerFailed(MoPubErrorCode.NETWORK_NO_FILL);
            }
        }

        @Override
        public void onAdLeftApplication() {
        }

        @Override
        public void onAdLoaded() {
            Log.d((String)"MoPub", (String)"Google Play Services banner ad loaded successfully. Showing ad...");
            if (GooglePlayServicesBanner.this.mBannerListener != null) {
                GooglePlayServicesBanner.this.mBannerListener.onBannerLoaded((View)GooglePlayServicesBanner.this.mGoogleAdView);
            }
        }

        @Override
        public void onAdOpened() {
            Log.d((String)"MoPub", (String)"Google Play Services banner ad clicked.");
            if (GooglePlayServicesBanner.this.mBannerListener != null) {
                GooglePlayServicesBanner.this.mBannerListener.onBannerClicked();
            }
        }
    }
}

