/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.net.Uri;
import android.support.v4.util.LruCache;
import android.util.Log;
import com.mopub.mobileads.Utils;
import com.mopub.mobileads.util.Files;
import com.mopub.mobileads.util.Streams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DiskLruCache
extends LruCache<String, File> {
    private final File mCacheDirectory;
    private final String mCacheDirectoryName;
    private final Context mContext;

    public DiskLruCache(Context context, String string2, int n2) throws IllegalArgumentException, IOException {
        super(n2);
        if (context == null) {
            throw new IllegalArgumentException("context may not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("cacheDirectoryName may not be null.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("maxSizeBytes must be positive.");
        }
        this.mContext = context;
        this.mCacheDirectoryName = string2;
        this.mCacheDirectory = Files.createDirectory(context.getFilesDir() + File.separator + this.mCacheDirectoryName);
        if (this.mCacheDirectory == null) {
            throw new IOException("Unable to obtain access to directory " + this.mCacheDirectoryName);
        }
        this.loadFilesFromDisk();
    }

    private File createFile(String string2, InputStream inputStream) {
        FileOutputStream fileOutputStream;
        File file = new File(this.mContext.getFilesDir() + File.separator + this.mCacheDirectoryName + File.separator + string2);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            Streams.copyContent(inputStream, fileOutputStream);
            return file;
        }
        catch (IOException iOException) {
            file.delete();
            return null;
        }
        finally {
            Streams.closeStream(fileOutputStream);
        }
    }

    private void loadFilesFromDisk() {
        File[] fileArray = this.mCacheDirectory.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                this.put(file.getName(), file);
            }
        }
    }

    @Override
    protected void entryRemoved(boolean bl2, String string2, File file, File file2) {
        super.entryRemoved(bl2, string2, file, file2);
        if (file != null && !file.delete()) {
            Log.d((String)"MoPub", (String)("Unable to delete file from cache: " + file.getName()));
        }
    }

    File getCacheDirectory() {
        return this.mCacheDirectory;
    }

    Uri getUri(String string2) {
        File file = (File)this.get(Utils.sha1(string2));
        if (file == null) {
            return null;
        }
        return Uri.parse((String)file.getAbsolutePath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean putStream(String string2, InputStream inputStream) {
        synchronized (this) {
            boolean bl2 = false;
            if (string2 == null) return bl2;
            bl2 = false;
            if (inputStream == null) {
                return bl2;
            }
            Uri uri = this.getUri(string2);
            bl2 = false;
            if (uri != null) return bl2;
            String string3 = Utils.sha1(string2);
            File file = this.createFile(string3, inputStream);
            bl2 = false;
            if (file == null) return bl2;
            boolean bl3 = file.exists();
            bl2 = false;
            if (!bl3) return bl2;
            this.put(string3, file);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    File removeStream(String string2) {
        synchronized (this) {
            if (string2 == null) {
                return null;
            }
            File file = (File)this.remove(Utils.sha1(string2));
            return file;
        }
    }

    @Override
    protected int sizeOf(String string2, File file) {
        if (file != null && file.exists() && file.length() > 0L) {
            return Files.intLength(file);
        }
        return super.sizeOf(string2, file);
    }
}

