/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubInterstitial;
import com.mopub.mobileads.factories.CustomEventInterstitialFactory;
import com.mopub.mobileads.util.Json;
import java.util.HashMap;
import java.util.Map;

public class CustomEventInterstitialAdapter
implements CustomEventInterstitial.CustomEventInterstitialListener {
    public static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 30000;
    private Context mContext;
    private CustomEventInterstitial mCustomEventInterstitial;
    private CustomEventInterstitialAdapterListener mCustomEventInterstitialAdapterListener;
    private final Handler mHandler;
    private boolean mInvalidated;
    private Map<String, Object> mLocalExtras;
    private final MoPubInterstitial mMoPubInterstitial;
    private Map<String, String> mServerExtras;
    private final Runnable mTimeout;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CustomEventInterstitialAdapter(MoPubInterstitial moPubInterstitial, String string2, String string3) {
        AdViewController adViewController;
        block6: {
            this.mHandler = new Handler();
            this.mMoPubInterstitial = moPubInterstitial;
            this.mServerExtras = new HashMap<String, String>();
            this.mLocalExtras = new HashMap<String, Object>();
            this.mContext = moPubInterstitial.getActivity();
            this.mTimeout = new Runnable(){

                @Override
                public void run() {
                    Log.d((String)"MoPub", (String)"Third-party network timed out.");
                    CustomEventInterstitialAdapter.this.onInterstitialFailed(MoPubErrorCode.NETWORK_TIMEOUT);
                    CustomEventInterstitialAdapter.this.invalidate();
                }
            };
            Log.d((String)"MoPub", (String)("Attempting to invoke custom event: " + string2));
            try {
                this.mCustomEventInterstitial = CustomEventInterstitialFactory.create(string2);
            }
            catch (Exception exception) {
                Log.d((String)"MoPub", (String)("Couldn't locate or instantiate custom event: " + string2 + "."));
                if (this.mCustomEventInterstitialAdapterListener == null) break block6;
                this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialFailed(MoPubErrorCode.ADAPTER_NOT_FOUND);
            }
        }
        try {
            this.mServerExtras = Json.jsonStringToMap(string3);
        }
        catch (Exception exception) {
            Log.d((String)"MoPub", (String)("Failed to create Map from JSON: " + string3));
        }
        this.mLocalExtras = moPubInterstitial.getLocalExtras();
        if (moPubInterstitial.getLocation() != null) {
            this.mLocalExtras.put("location", moPubInterstitial.getLocation());
        }
        if ((adViewController = moPubInterstitial.getMoPubInterstitialView().getAdViewController()) != null) {
            this.mLocalExtras.put("Ad-Configuration", adViewController.getAdConfiguration());
        }
    }

    private void cancelTimeout() {
        this.mHandler.removeCallbacks(this.mTimeout);
    }

    private int getTimeoutDelayMilliseconds() {
        if (this.mMoPubInterstitial == null || this.mMoPubInterstitial.getAdTimeoutDelay() == null || this.mMoPubInterstitial.getAdTimeoutDelay() < 0) {
            return 30000;
        }
        return 1000 * this.mMoPubInterstitial.getAdTimeoutDelay();
    }

    void invalidate() {
        if (this.mCustomEventInterstitial != null) {
            this.mCustomEventInterstitial.onInvalidate();
        }
        this.mCustomEventInterstitial = null;
        this.mContext = null;
        this.mServerExtras = null;
        this.mLocalExtras = null;
        this.mCustomEventInterstitialAdapterListener = null;
        this.mInvalidated = true;
    }

    boolean isInvalidated() {
        return this.mInvalidated;
    }

    void loadInterstitial() {
        if (this.isInvalidated() || this.mCustomEventInterstitial == null) {
            return;
        }
        if (this.getTimeoutDelayMilliseconds() > 0) {
            this.mHandler.postDelayed(this.mTimeout, (long)this.getTimeoutDelayMilliseconds());
        }
        this.mCustomEventInterstitial.loadInterstitial(this.mContext, this, this.mLocalExtras, this.mServerExtras);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInterstitialClicked() {
        if (this.isInvalidated() || this.mCustomEventInterstitialAdapterListener == null) {
            return;
        }
        this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialClicked();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInterstitialDismissed() {
        if (this.isInvalidated() || this.mCustomEventInterstitialAdapterListener == null) {
            return;
        }
        this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialDismissed();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInterstitialFailed(MoPubErrorCode moPubErrorCode) {
        if (this.isInvalidated() || this.mCustomEventInterstitialAdapterListener == null) {
            return;
        }
        if (moPubErrorCode == null) {
            moPubErrorCode = MoPubErrorCode.UNSPECIFIED;
        }
        this.cancelTimeout();
        this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialFailed(moPubErrorCode);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInterstitialLoaded() {
        block3: {
            block2: {
                if (this.isInvalidated()) break block2;
                this.cancelTimeout();
                if (this.mCustomEventInterstitialAdapterListener != null) break block3;
            }
            return;
        }
        this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialLoaded();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInterstitialShown() {
        if (this.isInvalidated() || this.mCustomEventInterstitialAdapterListener == null) {
            return;
        }
        this.mCustomEventInterstitialAdapterListener.onCustomEventInterstitialShown();
    }

    @Override
    public void onLeaveApplication() {
        this.onInterstitialClicked();
    }

    void setAdapterListener(CustomEventInterstitialAdapterListener customEventInterstitialAdapterListener) {
        this.mCustomEventInterstitialAdapterListener = customEventInterstitialAdapterListener;
    }

    @Deprecated
    void setCustomEventInterstitial(CustomEventInterstitial customEventInterstitial) {
        this.mCustomEventInterstitial = customEventInterstitial;
    }

    void showInterstitial() {
        if (this.isInvalidated() || this.mCustomEventInterstitial == null) {
            return;
        }
        this.mCustomEventInterstitial.showInterstitial();
    }

    static interface CustomEventInterstitialAdapterListener {
        public void onCustomEventInterstitialClicked();

        public void onCustomEventInterstitialDismissed();

        public void onCustomEventInterstitialFailed(MoPubErrorCode var1);

        public void onCustomEventInterstitialLoaded();

        public void onCustomEventInterstitialShown();
    }
}

