/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.HtmlBannerWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.factories.CustomEventBannerFactory;
import com.mopub.mobileads.util.Json;
import java.util.HashMap;
import java.util.Map;

public class CustomEventBannerAdapter
implements CustomEventBanner.CustomEventBannerListener {
    public static final int DEFAULT_BANNER_TIMEOUT_DELAY = 10000;
    private Context mContext;
    private CustomEventBanner mCustomEventBanner;
    private final Handler mHandler = new Handler();
    private boolean mInvalidated;
    private Map<String, Object> mLocalExtras;
    private MoPubView mMoPubView;
    private Map<String, String> mServerExtras;
    private boolean mStoredAutorefresh;
    private final Runnable mTimeout;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CustomEventBannerAdapter(MoPubView moPubView, String string2, String string3) {
        this.mMoPubView = moPubView;
        this.mContext = moPubView.getContext();
        this.mLocalExtras = new HashMap<String, Object>();
        this.mServerExtras = new HashMap<String, String>();
        this.mTimeout = new Runnable(){

            @Override
            public void run() {
                Log.d((String)"MoPub", (String)"Third-party network timed out.");
                CustomEventBannerAdapter.this.onBannerFailed(MoPubErrorCode.NETWORK_TIMEOUT);
                CustomEventBannerAdapter.this.invalidate();
            }
        };
        Log.d((String)"MoPub", (String)("Attempting to invoke custom event: " + string2));
        try {
            this.mCustomEventBanner = CustomEventBannerFactory.create(string2);
        }
        catch (Exception exception) {
            Log.d((String)"MoPub", (String)("Couldn't locate or instantiate custom event: " + string2 + "."));
            this.mMoPubView.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
            return;
        }
        try {
            this.mServerExtras = Json.jsonStringToMap(string3);
        }
        catch (Exception exception) {
            Log.d((String)"MoPub", (String)("Failed to create Map from JSON: " + string3 + exception.toString()));
        }
        this.mLocalExtras = this.mMoPubView.getLocalExtras();
        if (this.mMoPubView.getLocation() != null) {
            this.mLocalExtras.put("location", this.mMoPubView.getLocation());
        }
        if (this.mMoPubView.getAdViewController() != null) {
            this.mLocalExtras.put("Ad-Configuration", this.mMoPubView.getAdViewController().getAdConfiguration());
        }
    }

    private void cancelTimeout() {
        this.mHandler.removeCallbacks(this.mTimeout);
    }

    private int getTimeoutDelayMilliseconds() {
        if (this.mMoPubView == null || this.mMoPubView.getAdTimeoutDelay() == null || this.mMoPubView.getAdTimeoutDelay() < 0) {
            return 10000;
        }
        return 1000 * this.mMoPubView.getAdTimeoutDelay();
    }

    void invalidate() {
        if (this.mCustomEventBanner != null) {
            this.mCustomEventBanner.onInvalidate();
        }
        this.mContext = null;
        this.mCustomEventBanner = null;
        this.mLocalExtras = null;
        this.mServerExtras = null;
        this.mInvalidated = true;
    }

    boolean isInvalidated() {
        return this.mInvalidated;
    }

    void loadAd() {
        if (this.isInvalidated() || this.mCustomEventBanner == null) {
            return;
        }
        if (this.getTimeoutDelayMilliseconds() > 0) {
            this.mHandler.postDelayed(this.mTimeout, (long)this.getTimeoutDelayMilliseconds());
        }
        this.mCustomEventBanner.loadBanner(this.mContext, this, this.mLocalExtras, this.mServerExtras);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onBannerClicked() {
        if (this.isInvalidated() || this.mMoPubView == null) {
            return;
        }
        this.mMoPubView.registerClick();
    }

    @Override
    public void onBannerCollapsed() {
        if (this.isInvalidated()) {
            return;
        }
        this.mMoPubView.setAutorefreshEnabled(this.mStoredAutorefresh);
        this.mMoPubView.adClosed();
    }

    @Override
    public void onBannerExpanded() {
        if (this.isInvalidated()) {
            return;
        }
        this.mStoredAutorefresh = this.mMoPubView.getAutorefreshEnabled();
        this.mMoPubView.setAutorefreshEnabled(false);
        this.mMoPubView.adPresentedOverlay();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onBannerFailed(MoPubErrorCode moPubErrorCode) {
        if (this.isInvalidated() || this.mMoPubView == null) {
            return;
        }
        if (moPubErrorCode == null) {
            moPubErrorCode = MoPubErrorCode.UNSPECIFIED;
        }
        this.cancelTimeout();
        this.mMoPubView.loadFailUrl(moPubErrorCode);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onBannerLoaded(View view) {
        block3: {
            block2: {
                if (this.isInvalidated()) break block2;
                this.cancelTimeout();
                if (this.mMoPubView == null) break block2;
                this.mMoPubView.nativeAdLoaded();
                this.mMoPubView.setAdContentView(view);
                if (!(view instanceof HtmlBannerWebView)) break block3;
            }
            return;
        }
        this.mMoPubView.trackNativeImpression();
    }

    @Override
    public void onLeaveApplication() {
        this.onBannerClicked();
    }
}

