/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.provider.Settings;
import com.mopub.mobileads.Utils;
import com.mopub.mobileads.util.Strings;

public abstract class BaseUrlGenerator {
    private boolean mFirstParam;
    private StringBuilder mStringBuilder;

    private String getParamDelimiter() {
        if (this.mFirstParam) {
            this.mFirstParam = false;
            return "?";
        }
        return "&";
    }

    protected void addParam(String string2, String string3) {
        if (string3 == null || Strings.isEmpty(string3)) {
            return;
        }
        this.mStringBuilder.append(this.getParamDelimiter());
        this.mStringBuilder.append(string2);
        this.mStringBuilder.append("=");
        this.mStringBuilder.append(Uri.encode((String)string3));
    }

    public abstract String generateUrlString(String var1);

    protected String getAppVersionFromContext(Context context) {
        try {
            String string2 = context.getPackageName();
            String string3 = context.getPackageManager().getPackageInfo((String)string2, (int)0).versionName;
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getFinalUrlString() {
        return this.mStringBuilder.toString();
    }

    protected String getUdidFromContext(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    protected void initUrlString(String string2, String string3) {
        this.mStringBuilder = new StringBuilder("http://" + string2 + string3);
        this.mFirstParam = true;
    }

    protected void setApiVersion(String string2) {
        this.addParam("v", string2);
    }

    protected void setAppVersion(String string2) {
        this.addParam("av", string2);
    }

    protected void setDeviceInfo(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        for (int i2 = 0; i2 < -1 + stringArray.length; ++i2) {
            stringBuilder.append(stringArray[i2]).append(",");
        }
        stringBuilder.append(stringArray[-1 + stringArray.length]);
        this.addParam("dn", stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setExternalStoragePermission(boolean bl2) {
        String string2 = bl2 ? "1" : "0";
        this.addParam("android_perms_ext_storage", string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setUdid(String string2) {
        String string3 = string2 == null ? "" : Utils.sha1(string2);
        this.addParam("udid", "sha:" + string3);
    }
}

