/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.mopub.mobileads.AdConfiguration;
import com.mopub.mobileads.resource.Drawables;
import com.mopub.mobileads.util.Dips;

abstract class BaseInterstitialActivity
extends Activity {
    public static final String ACTION_INTERSTITIAL_CLICK = "com.mopub.action.interstitial.click";
    public static final String ACTION_INTERSTITIAL_DISMISS = "com.mopub.action.interstitial.dismiss";
    public static final String ACTION_INTERSTITIAL_FAIL = "com.mopub.action.interstitial.fail";
    public static final String ACTION_INTERSTITIAL_SHOW = "com.mopub.action.interstitial.show";
    private static final float CLOSE_BUTTON_PADDING = 8.0f;
    private static final float CLOSE_BUTTON_SIZE = 50.0f;
    public static final IntentFilter HTML_INTERSTITIAL_INTENT_FILTER = BaseInterstitialActivity.createHtmlInterstitialIntentFilter();
    private int mButtonPadding;
    private int mButtonSize;
    private ImageView mCloseButton;
    private RelativeLayout mLayout;

    BaseInterstitialActivity() {
    }

    private static IntentFilter createHtmlInterstitialIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_INTERSTITIAL_FAIL);
        intentFilter.addAction(ACTION_INTERSTITIAL_SHOW);
        intentFilter.addAction(ACTION_INTERSTITIAL_DISMISS);
        intentFilter.addAction(ACTION_INTERSTITIAL_CLICK);
        return intentFilter;
    }

    private void createInterstitialCloseButton() {
        this.mCloseButton = new ImageButton((Context)this);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842919}, (Drawable)Drawables.INTERSTITIAL_CLOSE_BUTTON_NORMAL.decodeImage((Context)this));
        stateListDrawable.addState(new int[]{16842919}, (Drawable)Drawables.INTERSTITIAL_CLOSE_BUTTON_PRESSED.decodeImage((Context)this));
        this.mCloseButton.setImageDrawable((Drawable)stateListDrawable);
        this.mCloseButton.setBackgroundDrawable(null);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BaseInterstitialActivity.this.finish();
            }
        });
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.mButtonSize, this.mButtonSize);
        layoutParams.addRule(11);
        layoutParams.setMargins(this.mButtonPadding, 0, this.mButtonPadding, 0);
        this.mLayout.addView((View)this.mCloseButton, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void broadcastInterstitialAction(String string2) {
        Intent intent = new Intent(string2);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    protected AdConfiguration getAdConfiguration() {
        try {
            AdConfiguration adConfiguration = (AdConfiguration)this.getIntent().getSerializableExtra("Ad-Configuration");
            return adConfiguration;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public abstract View getAdView();

    protected void hideInterstitialCloseButton() {
        this.mCloseButton.setVisibility(4);
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.requestWindowFeature(1);
        this.getWindow().addFlags(1024);
        this.mButtonSize = Dips.asIntPixels(50.0f, (Context)this);
        this.mButtonPadding = Dips.asIntPixels(8.0f, (Context)this);
        this.mLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(13);
        this.mLayout.addView(this.getAdView(), (ViewGroup.LayoutParams)layoutParams);
        this.setContentView((View)this.mLayout);
        this.createInterstitialCloseButton();
    }

    protected void onDestroy() {
        this.mLayout.removeAllViews();
        super.onDestroy();
    }

    protected void showInterstitialCloseButton() {
        this.mCloseButton.setVisibility(0);
    }

    static final class JavaScriptWebViewCallbacks
    extends Enum<JavaScriptWebViewCallbacks> {
        private static final /* synthetic */ JavaScriptWebViewCallbacks[] $VALUES;
        public static final /* enum */ JavaScriptWebViewCallbacks WEB_VIEW_DID_APPEAR = new JavaScriptWebViewCallbacks("javascript:webviewDidAppear();");
        public static final /* enum */ JavaScriptWebViewCallbacks WEB_VIEW_DID_CLOSE = new JavaScriptWebViewCallbacks("javascript:webviewDidClose();");
        private String mUrl;

        static {
            JavaScriptWebViewCallbacks[] javaScriptWebViewCallbacksArray = new JavaScriptWebViewCallbacks[]{WEB_VIEW_DID_APPEAR, WEB_VIEW_DID_CLOSE};
            $VALUES = javaScriptWebViewCallbacksArray;
        }

        private JavaScriptWebViewCallbacks(String string3) {
            this.mUrl = string3;
        }

        public static JavaScriptWebViewCallbacks valueOf(String string2) {
            return Enum.valueOf(JavaScriptWebViewCallbacks.class, string2);
        }

        public static JavaScriptWebViewCallbacks[] values() {
            return (JavaScriptWebViewCallbacks[])$VALUES.clone();
        }

        protected String getUrl() {
            return this.mUrl;
        }
    }
}

