/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.mopub.mobileads.AdConfiguration;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.ViewGestureDetector;
import com.mopub.mobileads.util.VersionCode;

public class BaseHtmlWebView
extends BaseWebView
implements ViewGestureDetector.UserClickListener {
    private boolean mClicked;
    private final ViewGestureDetector mViewGestureDetector;

    public BaseHtmlWebView(Context context, AdConfiguration adConfiguration) {
        super(context);
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.mViewGestureDetector = new ViewGestureDetector(context, (View)this, adConfiguration);
        this.mViewGestureDetector.setUserClickListener(this);
        if (VersionCode.currentApiLevel().isAtLeast(VersionCode.ICE_CREAM_SANDWICH)) {
            this.enablePlugins(true);
        }
        this.setBackgroundColor(0);
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
    }

    public void init(boolean bl2) {
        this.initializeOnTouchListener(bl2);
    }

    void initializeOnTouchListener(final boolean bl2) {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                BaseHtmlWebView.this.mViewGestureDetector.sendTouchEvent(motionEvent);
                return motionEvent.getAction() == 2 && !bl2;
            }
        });
    }

    void loadHtmlResponse(String string2) {
        this.loadDataWithBaseURL("http://ads.mopub.com/", string2, "text/html", "utf-8", null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadUrl(String string2) {
        block3: {
            block2: {
                if (string2 == null) break block2;
                Log.d((String)"MoPub", (String)("Loading url: " + string2));
                if (string2.startsWith("javascript:")) break block3;
            }
            return;
        }
        super.loadUrl(string2);
    }

    @Override
    public void onResetUserClick() {
        this.mClicked = false;
    }

    @Override
    public void onUserClick() {
        this.mClicked = true;
    }

    @Override
    public boolean wasClicked() {
        return this.mClicked;
    }
}

