/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.mopub.mobileads.AdConfiguration;
import com.mopub.mobileads.AdFetcher;
import com.mopub.mobileads.AdUrlGenerator;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.factories.AdFetcherFactory;
import com.mopub.mobileads.factories.HttpClientFactory;
import com.mopub.mobileads.util.Dips;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class AdViewController {
    static final int DEFAULT_REFRESH_TIME_MILLISECONDS = 60000;
    static final int MINIMUM_REFRESH_TIME_MILLISECONDS = 10000;
    private static final FrameLayout.LayoutParams WRAP_AND_CENTER_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-2, -2, 17);
    private static WeakHashMap<View, Boolean> sViewShouldHonorServerDimensions = new WeakHashMap();
    private AdConfiguration mAdConfiguration;
    private AdFetcher mAdFetcher;
    private boolean mAutoRefreshEnabled = true;
    private final Context mContext;
    private Handler mHandler;
    private boolean mIsDestroyed;
    private boolean mIsFacebookSupported = true;
    private boolean mIsLoading;
    private boolean mIsTesting;
    private String mKeywords;
    private Map<String, Object> mLocalExtras = new HashMap<String, Object>();
    private Location mLocation;
    private MoPubView.LocationAwareness mLocationAwareness = MoPubView.LocationAwareness.LOCATION_AWARENESS_NORMAL;
    private int mLocationPrecision = 6;
    private MoPubView mMoPubView;
    private final Runnable mRefreshRunnable;
    private String mUrl;
    private final AdUrlGenerator mUrlGenerator;

    public AdViewController(Context context, MoPubView moPubView) {
        this.mContext = context;
        this.mMoPubView = moPubView;
        this.mUrlGenerator = new AdUrlGenerator(context);
        this.mAdConfiguration = new AdConfiguration(this.mContext);
        this.mAdFetcher = AdFetcherFactory.create(this, this.mAdConfiguration.getUserAgent());
        this.mRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                AdViewController.this.loadAd();
            }
        };
        this.mHandler = new Handler();
    }

    private void cancelRefreshTimer() {
        this.mHandler.removeCallbacks(this.mRefreshRunnable);
    }

    private FrameLayout.LayoutParams getAdLayoutParams(View view) {
        int n2 = this.mAdConfiguration.getWidth();
        int n3 = this.mAdConfiguration.getHeight();
        if (AdViewController.getShouldHonorServerDimensions(view) && n2 > 0 && n3 > 0) {
            return new FrameLayout.LayoutParams(Dips.asIntPixels(n2, this.mContext), Dips.asIntPixels(n3, this.mContext), 17);
        }
        return WRAP_AND_CENTER_LAYOUT_PARAMS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Location getLastKnownLocation() {
        Location location;
        Location location2;
        if (this.mLocationAwareness == MoPubView.LocationAwareness.LOCATION_AWARENESS_DISABLED) {
            return null;
        }
        LocationManager locationManager = (LocationManager)this.mContext.getSystemService("location");
        try {
            Location location3;
            location2 = location3 = locationManager.getLastKnownLocation("gps");
        }
        catch (SecurityException securityException) {
            Log.d((String)"MoPub", (String)"Failed to retrieve GPS location: access appears to be disabled.");
            location2 = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.d((String)"MoPub", (String)"Failed to retrieve GPS location: device has no GPS provider.");
            location2 = null;
        }
        try {
            Location location4;
            location = location4 = locationManager.getLastKnownLocation("network");
        }
        catch (SecurityException securityException) {
            Log.d((String)"MoPub", (String)"Failed to retrieve network location: access appears to be disabled.");
            location = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.d((String)"MoPub", (String)"Failed to retrieve network location: device has no network provider.");
            location = null;
        }
        if (location2 == null && location == null) {
            return null;
        }
        Location location5 = location2 != null && location != null ? (location2.getTime() > location.getTime() ? location2 : location) : (location2 != null ? location2 : location);
        if (this.mLocationAwareness != MoPubView.LocationAwareness.LOCATION_AWARENESS_TRUNCATED) return location5;
        location5.setLatitude(BigDecimal.valueOf(location5.getLatitude()).setScale(this.mLocationPrecision, 5).doubleValue());
        location5.setLongitude(BigDecimal.valueOf(location5.getLongitude()).setScale(this.mLocationPrecision, 5).doubleValue());
        return location5;
    }

    private String getServerHostname() {
        if (this.mIsTesting) {
            return "testing.ads.mopub.com";
        }
        return "ads.mopub.com";
    }

    private static boolean getShouldHonorServerDimensions(View view) {
        return sViewShouldHonorServerDimensions.get(view) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isNetworkAvailable() {
        NetworkInfo networkInfo;
        return this.mContext.checkCallingPermission("android.permission.ACCESS_NETWORK_STATE") == -1 || (networkInfo = ((ConnectivityManager)this.mContext.getSystemService("connectivity")).getActiveNetworkInfo()) != null && networkInfo.isConnected();
    }

    protected static void setShouldHonorServerDimensions(View view) {
        sViewShouldHonorServerDimensions.put(view, true);
    }

    void adDidFail(MoPubErrorCode moPubErrorCode) {
        Log.i((String)"MoPub", (String)"Ad failed to load.");
        this.setNotLoading();
        this.scheduleRefreshTimerIfEnabled();
        this.getMoPubView().adFailed(moPubErrorCode);
    }

    void cleanup() {
        if (this.mIsDestroyed) {
            return;
        }
        this.setAutorefreshEnabled(false);
        this.cancelRefreshTimer();
        this.mAdFetcher.cleanup();
        this.mAdFetcher = null;
        this.mAdConfiguration.cleanup();
        this.mMoPubView = null;
        this.mIsDestroyed = true;
    }

    void configureUsingHttpResponse(HttpResponse httpResponse) {
        this.mAdConfiguration.addHttpResponse(httpResponse);
    }

    @Deprecated
    public void customEventActionWillBegin() {
        this.registerClick();
    }

    @Deprecated
    public void customEventDidFailToLoadAd() {
        this.loadFailUrl(MoPubErrorCode.UNSPECIFIED);
    }

    @Deprecated
    public void customEventDidLoadAd() {
        this.setNotLoading();
        this.trackImpression();
        this.scheduleRefreshTimerIfEnabled();
    }

    void fetchAd(String string2) {
        if (this.mAdFetcher != null) {
            this.mAdFetcher.fetchAdForUrl(string2);
        }
    }

    void forceRefresh() {
        this.setNotLoading();
        this.loadAd();
    }

    String generateAdUrl() {
        return this.mUrlGenerator.withAdUnitId(this.mAdConfiguration.getAdUnitId()).withKeywords(this.mKeywords).withFacebookSupported(this.mIsFacebookSupported).withLocation(this.mLocation).generateUrlString(this.getServerHostname());
    }

    AdConfiguration getAdConfiguration() {
        return this.mAdConfiguration;
    }

    public int getAdHeight() {
        return this.mAdConfiguration.getHeight();
    }

    Integer getAdTimeoutDelay() {
        return this.mAdConfiguration.getAdTimeoutDelay();
    }

    public String getAdUnitId() {
        return this.mAdConfiguration.getAdUnitId();
    }

    public int getAdWidth() {
        return this.mAdConfiguration.getWidth();
    }

    public boolean getAutorefreshEnabled() {
        return this.mAutoRefreshEnabled;
    }

    public String getClickthroughUrl() {
        return this.mAdConfiguration.getClickthroughUrl();
    }

    public String getKeywords() {
        return this.mKeywords;
    }

    Map<String, Object> getLocalExtras() {
        if (this.mLocalExtras != null) {
            return new HashMap<String, Object>(this.mLocalExtras);
        }
        return new HashMap<String, Object>();
    }

    public Location getLocation() {
        return this.mLocation;
    }

    int getLocationPrecision() {
        return this.mLocationPrecision;
    }

    public MoPubView getMoPubView() {
        return this.mMoPubView;
    }

    public String getRedirectUrl() {
        return this.mAdConfiguration.getRedirectUrl();
    }

    int getRefreshTimeMilliseconds() {
        return this.mAdConfiguration.getRefreshTimeMilliseconds();
    }

    public String getResponseString() {
        return this.mAdConfiguration.getResponseString();
    }

    public boolean getTesting() {
        return this.mIsTesting;
    }

    boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    public boolean isFacebookSupported() {
        return this.mIsFacebookSupported;
    }

    public void loadAd() {
        if (this.mAdConfiguration.getAdUnitId() == null) {
            Log.d((String)"MoPub", (String)"Can't load an ad in this ad view because the ad unit ID is null. Did you forget to call setAdUnitId()?");
            return;
        }
        if (!this.isNetworkAvailable()) {
            Log.d((String)"MoPub", (String)"Can't load an ad because there is no network connectivity.");
            this.scheduleRefreshTimerIfEnabled();
            return;
        }
        if (this.mLocation == null) {
            this.mLocation = this.getLastKnownLocation();
        }
        this.loadNonJavascript(this.generateAdUrl());
    }

    /*
     * Enabled aggressive block sorting
     */
    void loadFailUrl(MoPubErrorCode moPubErrorCode) {
        this.mIsLoading = false;
        StringBuilder stringBuilder = new StringBuilder().append("MoPubErrorCode: ");
        String string2 = moPubErrorCode == null ? "" : moPubErrorCode.toString();
        Log.v((String)"MoPub", (String)stringBuilder.append(string2).toString());
        if (this.mAdConfiguration.getFailUrl() != null) {
            Log.d((String)"MoPub", (String)("Loading failover url: " + this.mAdConfiguration.getFailUrl()));
            this.loadNonJavascript(this.mAdConfiguration.getFailUrl());
            return;
        }
        this.adDidFail(MoPubErrorCode.NO_FILL);
    }

    /*
     * Enabled aggressive block sorting
     */
    void loadNonJavascript(String string2) {
        block5: {
            block4: {
                if (string2 == null) break block4;
                Log.d((String)"MoPub", (String)("Loading url: " + string2));
                if (!this.mIsLoading) {
                    this.mUrl = string2;
                    this.mAdConfiguration.setFailUrl(null);
                    this.mIsLoading = true;
                    this.fetchAd(this.mUrl);
                    return;
                }
                if (this.mAdConfiguration.getAdUnitId() != null) break block5;
            }
            return;
        }
        Log.i((String)"MoPub", (String)("Already loading an ad for " + this.mAdConfiguration.getAdUnitId() + ", wait to finish."));
    }

    void registerClick() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (AdViewController.this.mAdConfiguration.getClickthroughUrl() == null) {
                    return;
                }
                DefaultHttpClient defaultHttpClient = HttpClientFactory.create();
                try {
                    Log.d((String)"MoPub", (String)("Tracking click for: " + AdViewController.this.mAdConfiguration.getClickthroughUrl()));
                    HttpGet httpGet = new HttpGet(AdViewController.this.mAdConfiguration.getClickthroughUrl());
                    httpGet.addHeader("User-Agent", AdViewController.this.mAdConfiguration.getUserAgent());
                    defaultHttpClient.execute((HttpUriRequest)httpGet);
                    return;
                }
                catch (Exception exception) {
                    Log.d((String)"MoPub", (String)("Click tracking failed: " + AdViewController.this.mAdConfiguration.getClickthroughUrl()), (Throwable)exception);
                    return;
                }
                finally {
                    defaultHttpClient.getConnectionManager().shutdown();
                }
            }
        }).start();
    }

    public void reload() {
        Log.d((String)"MoPub", (String)("Reload ad: " + this.mUrl));
        this.loadNonJavascript(this.mUrl);
    }

    void scheduleRefreshTimerIfEnabled() {
        this.cancelRefreshTimer();
        if (this.mAutoRefreshEnabled && this.mAdConfiguration.getRefreshTimeMilliseconds() > 0) {
            this.mHandler.postDelayed(this.mRefreshRunnable, (long)this.mAdConfiguration.getRefreshTimeMilliseconds());
        }
    }

    void setAdContentView(final View view) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MoPubView moPubView = AdViewController.this.getMoPubView();
                if (moPubView == null) {
                    return;
                }
                moPubView.removeAllViews();
                moPubView.addView(view, (ViewGroup.LayoutParams)AdViewController.this.getAdLayoutParams(view));
            }
        });
    }

    public void setAdUnitId(String string2) {
        this.mAdConfiguration.setAdUnitId(string2);
    }

    public void setAutorefreshEnabled(boolean bl2) {
        this.mAutoRefreshEnabled = bl2;
        if (this.mAdConfiguration.getAdUnitId() != null) {
            Log.d((String)"MoPub", (String)("Automatic refresh for " + this.mAdConfiguration + " set to: " + bl2 + "."));
        }
        if (this.mAutoRefreshEnabled) {
            this.scheduleRefreshTimerIfEnabled();
            return;
        }
        this.cancelRefreshTimer();
    }

    @Deprecated
    public void setClickthroughUrl(String string2) {
        this.mAdConfiguration.setClickthroughUrl(string2);
    }

    public void setFacebookSupported(boolean bl2) {
        this.mIsFacebookSupported = bl2;
    }

    void setFailUrl(String string2) {
        this.mAdConfiguration.setFailUrl(string2);
    }

    public void setKeywords(String string2) {
        this.mKeywords = string2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    void setLocalExtras(Map<String, Object> map) {
        void var2_3;
        if (map != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        } else {
            HashMap hashMap = new HashMap();
        }
        this.mLocalExtras = var2_3;
    }

    public void setLocation(Location location) {
        this.mLocation = location;
    }

    void setLocationPrecision(int n2) {
        this.mLocationPrecision = Math.max(0, n2);
    }

    void setNotLoading() {
        this.mIsLoading = false;
    }

    @Deprecated
    void setRefreshTimeMilliseconds(int n2) {
        this.mAdConfiguration.setRefreshTimeMilliseconds(n2);
    }

    public void setTesting(boolean bl2) {
        this.mIsTesting = bl2;
    }

    public void setTimeout(int n2) {
        if (this.mAdFetcher != null) {
            this.mAdFetcher.setTimeout(n2);
        }
    }

    void trackImpression() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (AdViewController.this.mAdConfiguration.getImpressionUrl() == null) {
                    return;
                }
                DefaultHttpClient defaultHttpClient = HttpClientFactory.create();
                try {
                    HttpGet httpGet = new HttpGet(AdViewController.this.mAdConfiguration.getImpressionUrl());
                    httpGet.addHeader("User-Agent", AdViewController.this.mAdConfiguration.getUserAgent());
                    defaultHttpClient.execute((HttpUriRequest)httpGet);
                    return;
                }
                catch (Exception exception) {
                    Log.d((String)"MoPub", (String)("Impression tracking failed : " + AdViewController.this.mAdConfiguration.getImpressionUrl()), (Throwable)exception);
                    return;
                }
                finally {
                    defaultHttpClient.getConnectionManager().shutdown();
                }
            }
        }).start();
    }
}

