/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.mopub.mobileads.BaseUrlGenerator;
import com.mopub.mobileads.util.DateAndTime;
import com.mopub.mobileads.util.Mraids;
import java.text.SimpleDateFormat;

public class AdUrlGenerator
extends BaseUrlGenerator {
    public static final String DEVICE_ORIENTATION_LANDSCAPE = "l";
    public static final String DEVICE_ORIENTATION_PORTRAIT = "p";
    public static final String DEVICE_ORIENTATION_SQUARE = "s";
    public static final String DEVICE_ORIENTATION_UNKNOWN = "u";
    public static final int UNKNOWN_NETWORK_TYPE = 8;
    private String mAdUnitId;
    private ConnectivityManager mConnectivityManager;
    private Context mContext;
    private boolean mFacebookSupportEnabled;
    private String mKeywords;
    private Location mLocation;
    private TelephonyManager mTelephonyManager;

    public AdUrlGenerator(Context context) {
        this.mContext = context;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String addKeyword(String string2, String string3) {
        if (string3 == null) return string2;
        if (string3.length() == 0) {
            return string2;
        }
        if (string2 == null) return string3;
        if (string2.length() == 0) return string3;
        return string2 + "," + string3;
    }

    private void addParam(String string2, MoPubNetworkType moPubNetworkType) {
        this.addParam(string2, moPubNetworkType.toString());
    }

    private boolean detectIsMraidSupported() {
        try {
            Class.forName("com.mopub.mobileads.MraidView");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private int getActiveNetworkType() {
        NetworkInfo networkInfo;
        int n2 = 8;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0 && (networkInfo = this.mConnectivityManager.getActiveNetworkInfo()) != null) {
            n2 = networkInfo.getType();
        }
        return n2;
    }

    private static String getFacebookKeyword(Context context, boolean bl2) {
        if (!bl2) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("com.mopub.mobileads.FacebookKeywordProvider");
            String string2 = (String)clazz.getMethod("getKeyword", Context.class).invoke(clazz, context);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getNetworkOperator() {
        String string2 = this.mTelephonyManager.getNetworkOperator();
        if (this.mTelephonyManager.getPhoneType() == 2 && this.mTelephonyManager.getSimState() == 5) {
            string2 = this.mTelephonyManager.getSimOperator();
        }
        return string2;
    }

    private static String getTimeZoneOffsetString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("Z");
        simpleDateFormat.setTimeZone(DateAndTime.localTimeZone());
        return simpleDateFormat.format(DateAndTime.now());
    }

    private int mncPortionLength(String string2) {
        return Math.min(3, string2.length());
    }

    private void setAdUnitId(String string2) {
        this.addParam("id", string2);
    }

    private void setCarrierName(String string2) {
        this.addParam("cn", string2);
    }

    private void setDensity(float f2) {
        this.addParam("sc_a", "" + f2);
    }

    private void setIsoCountryCode(String string2) {
        this.addParam("iso", string2);
    }

    private void setKeywords(String string2) {
        this.addParam("q", string2);
    }

    private void setLocation(Location location) {
        if (location != null) {
            this.addParam("ll", location.getLatitude() + "," + location.getLongitude());
            this.addParam("lla", "" + (int)location.getAccuracy());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setMccCode(String string2) {
        String string3 = string2 == null ? "" : string2.substring(0, this.mncPortionLength(string2));
        this.addParam("mcc", string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setMncCode(String string2) {
        String string3 = string2 == null ? "" : string2.substring(this.mncPortionLength(string2));
        this.addParam("mnc", string3);
    }

    private void setMraidFlag(boolean bl2) {
        if (bl2) {
            this.addParam("mr", "1");
        }
    }

    private void setNetworkType(int n2) {
        switch (n2) {
            default: {
                this.addParam("ct", MoPubNetworkType.UNKNOWN);
                return;
            }
            case 9: {
                this.addParam("ct", MoPubNetworkType.ETHERNET);
                return;
            }
            case 1: {
                this.addParam("ct", MoPubNetworkType.WIFI);
                return;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
        }
        this.addParam("ct", MoPubNetworkType.MOBILE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setOrientation(int n2) {
        String string2 = DEVICE_ORIENTATION_UNKNOWN;
        if (n2 == 1) {
            string2 = DEVICE_ORIENTATION_PORTRAIT;
        } else if (n2 == 2) {
            string2 = DEVICE_ORIENTATION_LANDSCAPE;
        } else if (n2 == 3) {
            string2 = DEVICE_ORIENTATION_SQUARE;
        }
        this.addParam("o", string2);
    }

    private void setSdkVersion(String string2) {
        this.addParam("nv", string2);
    }

    private void setTimezone(String string2) {
        this.addParam("z", string2);
    }

    @Override
    public String generateUrlString(String string2) {
        this.initUrlString(string2, "/m/ad");
        this.setApiVersion("6");
        this.setAdUnitId(this.mAdUnitId);
        this.setSdkVersion("1.17.2.0");
        String[] stringArray = new String[]{Build.MANUFACTURER, Build.MODEL, Build.PRODUCT};
        this.setDeviceInfo(stringArray);
        this.setUdid(this.getUdidFromContext(this.mContext));
        this.setKeywords(AdUrlGenerator.addKeyword(this.mKeywords, AdUrlGenerator.getFacebookKeyword(this.mContext, this.mFacebookSupportEnabled)));
        this.setLocation(this.mLocation);
        this.setTimezone(AdUrlGenerator.getTimeZoneOffsetString());
        this.setOrientation(this.mContext.getResources().getConfiguration().orientation);
        this.setDensity(this.mContext.getResources().getDisplayMetrics().density);
        this.setMraidFlag(this.detectIsMraidSupported());
        String string3 = this.getNetworkOperator();
        this.setMccCode(string3);
        this.setMncCode(string3);
        this.setIsoCountryCode(this.mTelephonyManager.getNetworkCountryIso());
        this.setCarrierName(this.mTelephonyManager.getNetworkOperatorName());
        this.setNetworkType(this.getActiveNetworkType());
        this.setAppVersion(this.getAppVersionFromContext(this.mContext));
        this.setExternalStoragePermission(Mraids.isStorePictureSupported(this.mContext));
        return this.getFinalUrlString();
    }

    public AdUrlGenerator withAdUnitId(String string2) {
        this.mAdUnitId = string2;
        return this;
    }

    public AdUrlGenerator withFacebookSupported(boolean bl2) {
        this.mFacebookSupportEnabled = bl2;
        return this;
    }

    public AdUrlGenerator withKeywords(String string2) {
        this.mKeywords = string2;
        return this;
    }

    public AdUrlGenerator withLocation(Location location) {
        this.mLocation = location;
        return this;
    }

    public static final class MoPubNetworkType
    extends Enum<MoPubNetworkType> {
        private static final /* synthetic */ MoPubNetworkType[] $VALUES;
        public static final /* enum */ MoPubNetworkType ETHERNET;
        public static final /* enum */ MoPubNetworkType MOBILE;
        public static final /* enum */ MoPubNetworkType UNKNOWN;
        public static final /* enum */ MoPubNetworkType WIFI;

        static {
            UNKNOWN = new MoPubNetworkType();
            ETHERNET = new MoPubNetworkType();
            WIFI = new MoPubNetworkType();
            MOBILE = new MoPubNetworkType();
            MoPubNetworkType[] moPubNetworkTypeArray = new MoPubNetworkType[]{UNKNOWN, ETHERNET, WIFI, MOBILE};
            $VALUES = moPubNetworkTypeArray;
        }

        public static MoPubNetworkType valueOf(String string2) {
            return Enum.valueOf(MoPubNetworkType.class, string2);
        }

        public static MoPubNetworkType[] values() {
            return (MoPubNetworkType[])$VALUES.clone();
        }

        public String toString() {
            return Integer.toString(this.ordinal());
        }
    }
}

