/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import com.mopub.mobileads.MoPubInterstitial;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.util.Reflection;

public class AdTypeTranslator {
    private static final int GOOGLE_PLAY_SUCCESS_CODE;

    private static boolean classFound(CustomEventType customEventType) {
        try {
            Class.forName(customEventType.toString());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CustomEventType convertAdMobToGooglePlay(Context context, CustomEventType customEventType) {
        if (customEventType == CustomEventType.ADMOB_BANNER && AdTypeTranslator.classFound(CustomEventType.GOOGLE_PLAY_BANNER) && AdTypeTranslator.isGooglePlayServicesAvailable(context)) {
            return CustomEventType.GOOGLE_PLAY_BANNER;
        }
        if (customEventType != CustomEventType.ADMOB_INTERSTITIAL) return customEventType;
        if (!AdTypeTranslator.classFound(CustomEventType.GOOGLE_PLAY_INTERSTITIAL)) return customEventType;
        if (!AdTypeTranslator.isGooglePlayServicesAvailable(context)) return customEventType;
        return CustomEventType.GOOGLE_PLAY_INTERSTITIAL;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getAdNetworkType(String string2, String string3) {
        String string4 = "interstitial".equals(string2) ? string3 : string2;
        if (string4 != null) {
            return string4;
        }
        return "unknown";
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getCustomEventNameForAdType(MoPubView moPubView, String string2, String string3) {
        CustomEventType customEventType;
        if ("html".equals(string2) || "mraid".equals(string2)) {
            if (AdTypeTranslator.isInterstitial(moPubView)) {
                customEventType = CustomEventType.fromString(string2 + "_interstitial");
                return customEventType.toString();
            }
            customEventType = CustomEventType.fromString(string2 + "_banner");
            return customEventType.toString();
        }
        customEventType = "interstitial".equals(string2) ? CustomEventType.fromString(string3 + "_interstitial") : CustomEventType.fromString(string2 + "_banner");
        if (moPubView == null) return customEventType.toString();
        customEventType = AdTypeTranslator.convertAdMobToGooglePlay(moPubView.getContext(), customEventType);
        return customEventType.toString();
    }

    private static boolean isGooglePlayServicesAvailable(Context context) {
        boolean bl2;
        block3: {
            Object object;
            try {
                object = new Reflection.MethodBuilder(null, "isGooglePlayServicesAvailable").setStatic(Class.forName("com.google.android.gms.common.GooglePlayServicesUtil")).addParam(Context.class, context).execute();
                bl2 = false;
                if (object == null) break block3;
            }
            catch (Exception exception) {
                return false;
            }
            int n2 = (Integer)object;
            bl2 = false;
            if (n2 != 0) break block3;
            bl2 = true;
        }
        return bl2;
    }

    private static boolean isInterstitial(MoPubView moPubView) {
        return moPubView instanceof MoPubInterstitial.MoPubInterstitialView;
    }

    public static final class CustomEventType
    extends Enum<CustomEventType> {
        private static final /* synthetic */ CustomEventType[] $VALUES;
        public static final /* enum */ CustomEventType ADMOB_BANNER = new CustomEventType("admob_native_banner", "com.mopub.mobileads.GoogleAdMobBanner");
        public static final /* enum */ CustomEventType ADMOB_INTERSTITIAL = new CustomEventType("admob_full_interstitial", "com.mopub.mobileads.GoogleAdMobInterstitial");
        public static final /* enum */ CustomEventType GOOGLE_PLAY_BANNER = new CustomEventType("google_play_banner", "com.mopub.mobileads.GooglePlayServicesBanner");
        public static final /* enum */ CustomEventType GOOGLE_PLAY_INTERSTITIAL = new CustomEventType("google_play_interstitial", "com.mopub.mobileads.GooglePlayServicesInterstitial");
        public static final /* enum */ CustomEventType HTML_BANNER;
        public static final /* enum */ CustomEventType HTML_INTERSTITIAL;
        public static final /* enum */ CustomEventType MILLENNIAL_BANNER;
        public static final /* enum */ CustomEventType MILLENNIAL_INTERSTITIAL;
        public static final /* enum */ CustomEventType MRAID_BANNER;
        public static final /* enum */ CustomEventType MRAID_INTERSTITIAL;
        public static final /* enum */ CustomEventType UNSPECIFIED;
        public static final /* enum */ CustomEventType VAST_VIDEO_INTERSTITIAL;
        private final String mClassName;
        private final String mKey;

        static {
            MILLENNIAL_BANNER = new CustomEventType("millennial_native_banner", "com.mopub.mobileads.MillennialBanner");
            MILLENNIAL_INTERSTITIAL = new CustomEventType("millennial_full_interstitial", "com.mopub.mobileads.MillennialInterstitial");
            MRAID_BANNER = new CustomEventType("mraid_banner", "com.mopub.mobileads.MraidBanner");
            MRAID_INTERSTITIAL = new CustomEventType("mraid_interstitial", "com.mopub.mobileads.MraidInterstitial");
            HTML_BANNER = new CustomEventType("html_banner", "com.mopub.mobileads.HtmlBanner");
            HTML_INTERSTITIAL = new CustomEventType("html_interstitial", "com.mopub.mobileads.HtmlInterstitial");
            VAST_VIDEO_INTERSTITIAL = new CustomEventType("vast_interstitial", "com.mopub.mobileads.VastVideoInterstitial");
            UNSPECIFIED = new CustomEventType("", null);
            CustomEventType[] customEventTypeArray = new CustomEventType[]{ADMOB_BANNER, ADMOB_INTERSTITIAL, GOOGLE_PLAY_BANNER, GOOGLE_PLAY_INTERSTITIAL, MILLENNIAL_BANNER, MILLENNIAL_INTERSTITIAL, MRAID_BANNER, MRAID_INTERSTITIAL, HTML_BANNER, HTML_INTERSTITIAL, VAST_VIDEO_INTERSTITIAL, UNSPECIFIED};
            $VALUES = customEventTypeArray;
        }

        private CustomEventType(String string3, String string4) {
            this.mKey = string3;
            this.mClassName = string4;
        }

        private static CustomEventType fromString(String string2) {
            for (CustomEventType customEventType : CustomEventType.values()) {
                if (!customEventType.mKey.equals(string2)) continue;
                return customEventType;
            }
            return UNSPECIFIED;
        }

        public static CustomEventType valueOf(String string2) {
            return Enum.valueOf(CustomEventType.class, string2);
        }

        public static CustomEventType[] values() {
            return (CustomEventType[])$VALUES.clone();
        }

        public String toString() {
            return this.mClassName;
        }
    }
}

