/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.net.Uri;
import android.util.Log;
import com.mopub.mobileads.AdTypeTranslator;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.util.HttpResponses;
import com.mopub.mobileads.util.Json;
import com.mopub.mobileads.util.ResponseHeader;
import com.mopub.mobileads.util.Strings;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

abstract class AdLoadTask {
    WeakReference<AdViewController> mWeakAdViewController;

    AdLoadTask(AdViewController adViewController) {
        this.mWeakAdViewController = new WeakReference<AdViewController>(adViewController);
    }

    static AdLoadTask fromHttpResponse(HttpResponse httpResponse, AdViewController adViewController) throws IOException {
        return new TaskExtractor(httpResponse, adViewController).extract();
    }

    abstract void cleanup();

    abstract void execute();

    static class CustomEventAdLoadTask
    extends AdLoadTask {
        private Map<String, String> mParamsMap;

        public CustomEventAdLoadTask(AdViewController adViewController, Map<String, String> map) {
            super(adViewController);
            this.mParamsMap = map;
        }

        @Override
        void cleanup() {
            this.mParamsMap = null;
        }

        @Override
        void execute() {
            AdViewController adViewController = (AdViewController)this.mWeakAdViewController.get();
            if (adViewController == null || adViewController.isDestroyed()) {
                return;
            }
            adViewController.setNotLoading();
            adViewController.getMoPubView().loadCustomEvent(this.mParamsMap);
        }

        @Deprecated
        Map<String, String> getParamsMap() {
            return this.mParamsMap;
        }
    }

    @Deprecated
    static class LegacyCustomEventAdLoadTask
    extends AdLoadTask {
        private Header mHeader;

        public LegacyCustomEventAdLoadTask(AdViewController adViewController, Header header) {
            super(adViewController);
            this.mHeader = header;
        }

        @Override
        void cleanup() {
            this.mHeader = null;
        }

        @Override
        void execute() {
            AdViewController adViewController = (AdViewController)this.mWeakAdViewController.get();
            if (adViewController == null || adViewController.isDestroyed()) {
                return;
            }
            adViewController.setNotLoading();
            MoPubView moPubView = adViewController.getMoPubView();
            if (this.mHeader == null) {
                Log.i((String)"MoPub", (String)"Couldn't call custom method because the server did not specify one.");
                moPubView.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
                return;
            }
            String string2 = this.mHeader.getValue();
            Log.i((String)"MoPub", (String)("Trying to call method named " + string2));
            Activity activity = moPubView.getActivity();
            try {
                activity.getClass().getMethod(string2, MoPubView.class).invoke((Object)activity, new Object[]{moPubView});
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.d((String)"MoPub", (String)("Couldn't perform custom method named " + string2 + "(MoPubView view) because your activity class has no such method"));
                moPubView.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
                return;
            }
            catch (Exception exception) {
                Log.d((String)"MoPub", (String)("Couldn't perform custom method named " + string2));
                moPubView.loadFailUrl(MoPubErrorCode.ADAPTER_NOT_FOUND);
                return;
            }
        }

        @Deprecated
        Header getHeader() {
            return this.mHeader;
        }
    }

    private static class TaskExtractor {
        private String adType;
        private String adTypeCustomEventName;
        private final AdViewController adViewController;
        private String fullAdType;
        private final HttpResponse response;

        TaskExtractor(HttpResponse httpResponse, AdViewController adViewController) {
            this.response = httpResponse;
            this.adViewController = adViewController;
        }

        private AdLoadTask createCustomEventAdLoadTask(String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(ResponseHeader.CUSTOM_EVENT_NAME.getKey(), this.adTypeCustomEventName);
            if (string2 != null) {
                hashMap.put(ResponseHeader.CUSTOM_EVENT_DATA.getKey(), string2);
            }
            return new CustomEventAdLoadTask(this.adViewController, hashMap);
        }

        private boolean eventDataIsInResponseBody(String string2) {
            return "mraid".equals(string2) || "html".equals(string2) || "interstitial".equals(string2) && "vast".equals(this.fullAdType);
        }

        private AdLoadTask extractCustomEventAdLoadTask() {
            Log.i((String)"MoPub", (String)"Performing custom event.");
            this.adTypeCustomEventName = HttpResponses.extractHeader(this.response, ResponseHeader.CUSTOM_EVENT_NAME);
            if (this.adTypeCustomEventName != null) {
                return this.createCustomEventAdLoadTask(HttpResponses.extractHeader(this.response, ResponseHeader.CUSTOM_EVENT_DATA));
            }
            Header header = this.response.getFirstHeader(ResponseHeader.CUSTOM_SELECTOR.getKey());
            return new LegacyCustomEventAdLoadTask(this.adViewController, header);
        }

        private AdLoadTask extractCustomEventAdLoadTaskFromNativeParams() throws IOException {
            return this.createCustomEventAdLoadTask(HttpResponses.extractHeader(this.response, ResponseHeader.NATIVE_PARAMS));
        }

        /*
         * Enabled aggressive block sorting
         */
        private AdLoadTask extractCustomEventAdLoadTaskFromResponseBody() throws IOException {
            HttpEntity httpEntity = this.response.getEntity();
            String string2 = httpEntity != null ? Strings.fromStream(httpEntity.getContent()) : "";
            this.adViewController.getAdConfiguration().setResponseString(string2);
            String string3 = HttpResponses.extractHeader(this.response, ResponseHeader.REDIRECT_URL);
            String string4 = HttpResponses.extractHeader(this.response, ResponseHeader.CLICKTHROUGH_URL);
            boolean bl2 = HttpResponses.extractBooleanHeader(this.response, ResponseHeader.SCROLLABLE, false);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Html-Response-Body", Uri.encode((String)string2));
            hashMap.put("Scrollable", Boolean.toString(bl2));
            if (string3 != null) {
                hashMap.put("Redirect-Url", string3);
            }
            if (string4 != null) {
                hashMap.put("Clickthrough-Url", string4);
            }
            return this.createCustomEventAdLoadTask(Json.mapToJsonString(hashMap));
        }

        AdLoadTask extract() throws IOException {
            this.adType = HttpResponses.extractHeader(this.response, ResponseHeader.AD_TYPE);
            this.fullAdType = HttpResponses.extractHeader(this.response, ResponseHeader.FULL_AD_TYPE);
            Log.d((String)"MoPub", (String)("Loading ad type: " + AdTypeTranslator.getAdNetworkType(this.adType, this.fullAdType)));
            this.adTypeCustomEventName = AdTypeTranslator.getCustomEventNameForAdType(this.adViewController.getMoPubView(), this.adType, this.fullAdType);
            if ("custom".equals(this.adType)) {
                return this.extractCustomEventAdLoadTask();
            }
            if (this.eventDataIsInResponseBody(this.adType)) {
                return this.extractCustomEventAdLoadTaskFromResponseBody();
            }
            return this.extractCustomEventAdLoadTaskFromNativeParams();
        }
    }
}

