/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.util.Log;
import com.mopub.mobileads.AdFetchTask;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.TaskTracker;
import com.mopub.mobileads.factories.AdFetchTaskFactory;
import com.mopub.mobileads.util.AsyncTasks;

public class AdFetcher {
    public static final String AD_CONFIGURATION_KEY = "Ad-Configuration";
    public static final String CLICKTHROUGH_URL_KEY = "Clickthrough-Url";
    public static final String HTML_RESPONSE_BODY_KEY = "Html-Response-Body";
    public static final String REDIRECT_URL_KEY = "Redirect-Url";
    public static final String SCROLLABLE_KEY = "Scrollable";
    private AdViewController mAdViewController;
    private AdFetchTask mCurrentTask;
    private final TaskTracker mTaskTracker;
    private int mTimeoutMilliseconds = 10000;
    private String mUserAgent;

    public AdFetcher(AdViewController adViewController, String string2) {
        this.mAdViewController = adViewController;
        this.mUserAgent = string2;
        this.mTaskTracker = new TaskTracker();
    }

    private long getCurrentTaskId() {
        return this.mTaskTracker.getCurrentTaskId();
    }

    public void cancelFetch() {
        if (this.mCurrentTask != null) {
            Log.i((String)"MoPub", (String)("Canceling fetch ad for task #" + this.getCurrentTaskId()));
            this.mCurrentTask.cancel(true);
        }
    }

    void cleanup() {
        this.cancelFetch();
        this.mAdViewController = null;
        this.mUserAgent = "";
    }

    public void fetchAdForUrl(String string2) {
        this.mTaskTracker.newTaskStarted();
        Log.i((String)"MoPub", (String)("Fetching ad for task #" + this.getCurrentTaskId()));
        if (this.mCurrentTask != null) {
            this.mCurrentTask.cancel(true);
        }
        this.mCurrentTask = AdFetchTaskFactory.create(this.mTaskTracker, this.mAdViewController, this.mUserAgent, this.mTimeoutMilliseconds);
        try {
            AsyncTasks.safeExecuteOnExecutor(this.mCurrentTask, string2);
            return;
        }
        catch (Exception exception) {
            Log.d((String)"MoPub", (String)"Error executing AdFetchTask", (Throwable)exception);
            return;
        }
    }

    protected void setTimeout(int n2) {
        this.mTimeoutMilliseconds = n2;
    }

    static final class FetchStatus
    extends Enum<FetchStatus> {
        private static final /* synthetic */ FetchStatus[] $VALUES;
        public static final /* enum */ FetchStatus AD_WARMING_UP;
        public static final /* enum */ FetchStatus CLEAR_AD_TYPE;
        public static final /* enum */ FetchStatus FETCH_CANCELLED;
        public static final /* enum */ FetchStatus INVALID_SERVER_RESPONSE_BACKOFF;
        public static final /* enum */ FetchStatus INVALID_SERVER_RESPONSE_NOBACKOFF;
        public static final /* enum */ FetchStatus NOT_SET;

        static {
            NOT_SET = new FetchStatus();
            FETCH_CANCELLED = new FetchStatus();
            INVALID_SERVER_RESPONSE_BACKOFF = new FetchStatus();
            INVALID_SERVER_RESPONSE_NOBACKOFF = new FetchStatus();
            CLEAR_AD_TYPE = new FetchStatus();
            AD_WARMING_UP = new FetchStatus();
            FetchStatus[] fetchStatusArray = new FetchStatus[]{NOT_SET, FETCH_CANCELLED, INVALID_SERVER_RESPONSE_BACKOFF, INVALID_SERVER_RESPONSE_NOBACKOFF, CLEAR_AD_TYPE, AD_WARMING_UP};
            $VALUES = fetchStatusArray;
        }

        public static FetchStatus valueOf(String string2) {
            return Enum.valueOf(FetchStatus.class, string2);
        }

        public static FetchStatus[] values() {
            return (FetchStatus[])$VALUES.clone();
        }
    }
}

