/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.os.AsyncTask;
import android.util.Log;
import com.mopub.mobileads.AdFetcher;
import com.mopub.mobileads.AdLoadTask;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.TaskTracker;
import com.mopub.mobileads.factories.HttpClientFactory;
import com.mopub.mobileads.util.HttpResponses;
import com.mopub.mobileads.util.ResponseHeader;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;

public class AdFetchTask
extends AsyncTask<String, Void, AdLoadTask> {
    private static final double EXPONENTIAL_BACKOFF_FACTOR = 1.5;
    private static final int MAXIMUM_REFRESH_TIME_MILLISECONDS = 600000;
    private AdViewController mAdViewController;
    private Exception mException;
    private AdFetcher.FetchStatus mFetchStatus = AdFetcher.FetchStatus.NOT_SET;
    private HttpClient mHttpClient;
    private long mTaskId;
    private TaskTracker mTaskTracker;
    private String mUserAgent;

    public AdFetchTask(TaskTracker taskTracker, AdViewController adViewController, String string2, int n2) {
        this.mTaskTracker = taskTracker;
        this.mAdViewController = adViewController;
        this.mHttpClient = HttpClientFactory.create(n2);
        this.mTaskId = this.mTaskTracker.getCurrentTaskId();
        this.mUserAgent = string2;
    }

    private void cleanup() {
        this.mTaskTracker = null;
        this.mException = null;
        this.mFetchStatus = AdFetcher.FetchStatus.NOT_SET;
    }

    private void exponentialBackoff() {
        if (this.mAdViewController == null) {
            return;
        }
        int n2 = (int)(1.5 * (double)this.mAdViewController.getRefreshTimeMilliseconds());
        if (n2 > 600000) {
            n2 = 600000;
        }
        this.mAdViewController.setRefreshTimeMilliseconds(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private AdLoadTask fetch(String string2) throws Exception {
        HttpResponse httpResponse;
        block3: {
            block2: {
                HttpGet httpGet = new HttpGet(string2);
                httpGet.addHeader(ResponseHeader.USER_AGENT.getKey(), this.mUserAgent);
                if (!this.isStateValid() || !this.isResponseValid(httpResponse = this.mHttpClient.execute((HttpUriRequest)httpGet))) break block2;
                this.mAdViewController.configureUsingHttpResponse(httpResponse);
                if (this.responseContainsContent(httpResponse)) break block3;
            }
            return null;
        }
        return AdLoadTask.fromHttpResponse(httpResponse, this.mAdViewController);
    }

    private boolean isMostCurrentTask() {
        if (this.mTaskTracker == null) {
            return false;
        }
        return this.mTaskTracker.isMostCurrentTask(this.mTaskId);
    }

    private boolean isResponseValid(HttpResponse httpResponse) {
        if (httpResponse == null || httpResponse.getEntity() == null) {
            Log.d((String)"MoPub", (String)"MoPub server returned null response.");
            this.mFetchStatus = AdFetcher.FetchStatus.INVALID_SERVER_RESPONSE_NOBACKOFF;
            return false;
        }
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 >= 400) {
            Log.d((String)"MoPub", (String)("Server error: returned HTTP status code " + Integer.toString(n2) + ". Please try again."));
            this.mFetchStatus = AdFetcher.FetchStatus.INVALID_SERVER_RESPONSE_BACKOFF;
            return false;
        }
        if (n2 != 200) {
            Log.d((String)"MoPub", (String)("MoPub server returned invalid response: HTTP status code " + Integer.toString(n2) + "."));
            this.mFetchStatus = AdFetcher.FetchStatus.INVALID_SERVER_RESPONSE_NOBACKOFF;
            return false;
        }
        return true;
    }

    private boolean isStateValid() {
        if (this.isCancelled()) {
            this.mFetchStatus = AdFetcher.FetchStatus.FETCH_CANCELLED;
            return false;
        }
        if (this.mAdViewController == null || this.mAdViewController.isDestroyed()) {
            Log.d((String)"MoPub", (String)"Error loading ad: AdViewController has already been GCed or destroyed.");
            return false;
        }
        return true;
    }

    private boolean responseContainsContent(HttpResponse httpResponse) {
        if ("1".equals(HttpResponses.extractHeader(httpResponse, ResponseHeader.WARMUP))) {
            Log.d((String)"MoPub", (String)("Ad Unit (" + this.mAdViewController.getAdUnitId() + ") is still warming up. " + "Please try again in a few minutes."));
            this.mFetchStatus = AdFetcher.FetchStatus.AD_WARMING_UP;
            return false;
        }
        if ("clear".equals(HttpResponses.extractHeader(httpResponse, ResponseHeader.AD_TYPE))) {
            Log.d((String)"MoPub", (String)("No inventory found for adunit (" + this.mAdViewController.getAdUnitId() + ")."));
            this.mFetchStatus = AdFetcher.FetchStatus.CLEAR_AD_TYPE;
            return false;
        }
        return true;
    }

    private void shutdownHttpClient() {
        if (this.mHttpClient != null) {
            ClientConnectionManager clientConnectionManager = this.mHttpClient.getConnectionManager();
            if (clientConnectionManager != null) {
                clientConnectionManager.shutdown();
            }
            this.mHttpClient = null;
        }
    }

    protected AdLoadTask doInBackground(String ... stringArray) {
        try {
            AdLoadTask adLoadTask = this.fetch(stringArray[0]);
            return adLoadTask;
        }
        catch (Exception exception) {
            this.mException = exception;
            return null;
        }
        finally {
            this.shutdownHttpClient();
        }
    }

    protected void onCancelled() {
        if (!this.isMostCurrentTask()) {
            Log.d((String)"MoPub", (String)"Ad response is stale.");
            this.cleanup();
            return;
        }
        Log.d((String)"MoPub", (String)"Ad loading was cancelled.");
        if (this.mException != null) {
            Log.d((String)"MoPub", (String)("Exception caught while loading ad: " + this.mException));
        }
        this.mTaskTracker.markTaskCompleted(this.mTaskId);
        this.cleanup();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPostExecute(AdLoadTask adLoadTask) {
        if (!this.isMostCurrentTask()) {
            Log.d((String)"MoPub", (String)"Ad response is stale.");
            this.cleanup();
            return;
        }
        if (this.mAdViewController == null || this.mAdViewController.isDestroyed()) {
            if (adLoadTask != null) {
                adLoadTask.cleanup();
            }
            this.mTaskTracker.markTaskCompleted(this.mTaskId);
            this.cleanup();
            return;
        }
        if (adLoadTask == null) {
            MoPubErrorCode moPubErrorCode;
            if (this.mException != null) {
                Log.d((String)"MoPub", (String)("Exception caught while loading ad: " + this.mException));
            }
            switch (1.$SwitchMap$com$mopub$mobileads$AdFetcher$FetchStatus[this.mFetchStatus.ordinal()]) {
                default: {
                    moPubErrorCode = MoPubErrorCode.UNSPECIFIED;
                    break;
                }
                case 1: {
                    moPubErrorCode = MoPubErrorCode.UNSPECIFIED;
                    break;
                }
                case 2: {
                    moPubErrorCode = MoPubErrorCode.CANCELLED;
                    break;
                }
                case 3: 
                case 4: {
                    moPubErrorCode = MoPubErrorCode.SERVER_ERROR;
                    break;
                }
                case 5: 
                case 6: {
                    moPubErrorCode = MoPubErrorCode.NO_FILL;
                }
            }
            this.mAdViewController.adDidFail(moPubErrorCode);
            if (this.mFetchStatus == AdFetcher.FetchStatus.INVALID_SERVER_RESPONSE_BACKOFF) {
                this.exponentialBackoff();
                this.mFetchStatus = AdFetcher.FetchStatus.NOT_SET;
            }
        } else {
            adLoadTask.execute();
            adLoadTask.cleanup();
        }
        this.mTaskTracker.markTaskCompleted(this.mTaskId);
        this.cleanup();
    }
}

