/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.webkit.WebView;
import com.mopub.mobileads.Utils;
import com.mopub.mobileads.util.DateAndTime;
import com.mopub.mobileads.util.HttpResponses;
import com.mopub.mobileads.util.ResponseHeader;
import com.mopub.mobileads.util.VersionCode;
import java.io.Serializable;
import java.util.Map;
import org.apache.http.HttpResponse;

public class AdConfiguration
implements Serializable {
    private static final int DEFAULT_REFRESH_TIME_MILLISECONDS = 60000;
    private static final int MINIMUM_REFRESH_TIME_MILLISECONDS = 10000;
    private static final String mPlatform = "Android";
    private Integer mAdTimeoutDelay;
    private String mAdType;
    private String mAdUnitId;
    private String mClickthroughUrl;
    private final String mDeviceLocale;
    private final String mDeviceModel;
    private String mDspCreativeId;
    private String mFailUrl;
    private final String mHashedUdid;
    private int mHeight;
    private String mImpressionUrl;
    private String mNetworkType;
    private final int mPlatformVersion;
    private String mRedirectUrl;
    private int mRefreshTimeMilliseconds;
    private String mResponseString;
    private final String mSdkVersion;
    private long mTimeStamp;
    private final String mUserAgent;
    private int mWidth;

    /*
     * Enabled aggressive block sorting
     */
    AdConfiguration(Context context) {
        this.setDefaults();
        if (context != null) {
            String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (string2 == null) {
                string2 = "";
            }
            this.mHashedUdid = Utils.sha1(string2);
            this.mUserAgent = new WebView(context).getSettings().getUserAgentString();
            this.mDeviceLocale = context.getResources().getConfiguration().locale.toString();
        } else {
            this.mHashedUdid = null;
            this.mUserAgent = null;
            this.mDeviceLocale = null;
        }
        this.mDeviceModel = Build.MANUFACTURER + " " + Build.MODEL;
        this.mPlatformVersion = VersionCode.currentApiLevel().getApiLevel();
        this.mSdkVersion = "1.17.2.0";
    }

    static AdConfiguration extractFromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Object object = map.get("Ad-Configuration");
        if (object instanceof AdConfiguration) {
            return (AdConfiguration)object;
        }
        return null;
    }

    private void setDefaults() {
        this.mAdUnitId = null;
        this.mResponseString = null;
        this.mAdType = null;
        this.mNetworkType = null;
        this.mRedirectUrl = null;
        this.mClickthroughUrl = null;
        this.mImpressionUrl = null;
        this.mTimeStamp = DateAndTime.now().getTime();
        this.mWidth = 0;
        this.mHeight = 0;
        this.mAdTimeoutDelay = null;
        this.mRefreshTimeMilliseconds = 60000;
        this.mFailUrl = null;
        this.mDspCreativeId = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void addHttpResponse(HttpResponse httpResponse) {
        this.mAdType = HttpResponses.extractHeader(httpResponse, ResponseHeader.AD_TYPE);
        this.mNetworkType = HttpResponses.extractHeader(httpResponse, ResponseHeader.NETWORK_TYPE);
        this.mRedirectUrl = HttpResponses.extractHeader(httpResponse, ResponseHeader.REDIRECT_URL);
        this.mClickthroughUrl = HttpResponses.extractHeader(httpResponse, ResponseHeader.CLICKTHROUGH_URL);
        this.mFailUrl = HttpResponses.extractHeader(httpResponse, ResponseHeader.FAIL_URL);
        this.mImpressionUrl = HttpResponses.extractHeader(httpResponse, ResponseHeader.IMPRESSION_URL);
        this.mTimeStamp = DateAndTime.now().getTime();
        this.mWidth = HttpResponses.extractIntHeader(httpResponse, ResponseHeader.WIDTH, 0);
        this.mHeight = HttpResponses.extractIntHeader(httpResponse, ResponseHeader.HEIGHT, 0);
        this.mAdTimeoutDelay = HttpResponses.extractIntegerHeader(httpResponse, ResponseHeader.AD_TIMEOUT);
        if (!httpResponse.containsHeader(ResponseHeader.REFRESH_TIME.getKey())) {
            this.mRefreshTimeMilliseconds = 0;
        } else {
            this.mRefreshTimeMilliseconds = 1000 * HttpResponses.extractIntHeader(httpResponse, ResponseHeader.REFRESH_TIME, 0);
            this.mRefreshTimeMilliseconds = Math.max(this.mRefreshTimeMilliseconds, 10000);
        }
        this.mDspCreativeId = HttpResponses.extractHeader(httpResponse, ResponseHeader.DSP_CREATIVE_ID);
    }

    void cleanup() {
        this.setDefaults();
    }

    Integer getAdTimeoutDelay() {
        return this.mAdTimeoutDelay;
    }

    String getAdType() {
        return this.mAdType;
    }

    String getAdUnitId() {
        return this.mAdUnitId;
    }

    String getClickthroughUrl() {
        return this.mClickthroughUrl;
    }

    String getDeviceLocale() {
        return this.mDeviceLocale;
    }

    String getDeviceModel() {
        return this.mDeviceModel;
    }

    String getDspCreativeId() {
        return this.mDspCreativeId;
    }

    String getFailUrl() {
        return this.mFailUrl;
    }

    String getHashedUdid() {
        return this.mHashedUdid;
    }

    int getHeight() {
        return this.mHeight;
    }

    String getImpressionUrl() {
        return this.mImpressionUrl;
    }

    String getNetworkType() {
        return this.mNetworkType;
    }

    String getPlatform() {
        return mPlatform;
    }

    int getPlatformVersion() {
        return this.mPlatformVersion;
    }

    String getRedirectUrl() {
        return this.mRedirectUrl;
    }

    int getRefreshTimeMilliseconds() {
        return this.mRefreshTimeMilliseconds;
    }

    String getResponseString() {
        return this.mResponseString;
    }

    String getSdkVersion() {
        return this.mSdkVersion;
    }

    long getTimeStamp() {
        return this.mTimeStamp;
    }

    String getUserAgent() {
        return this.mUserAgent;
    }

    int getWidth() {
        return this.mWidth;
    }

    void setAdUnitId(String string2) {
        this.mAdUnitId = string2;
    }

    @Deprecated
    void setClickthroughUrl(String string2) {
        this.mClickthroughUrl = string2;
    }

    void setFailUrl(String string2) {
        this.mFailUrl = string2;
    }

    @Deprecated
    void setRefreshTimeMilliseconds(int n2) {
        this.mRefreshTimeMilliseconds = n2;
    }

    void setResponseString(String string2) {
        this.mResponseString = string2;
    }
}

