/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import com.mopub.mobileads.AdConfiguration;
import com.mopub.mobileads.util.Base64;
import com.mopub.mobileads.util.DateAndTime;
import com.mopub.mobileads.util.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class AdAlertReporter {
    private static final String BODY_SEPARATOR = "\n=================\n";
    private static final String DATE_FORMAT_PATTERN = "M/d/yy hh:mm:ss a z";
    private static final String EMAIL_RECIPIENT = "creative-review@mopub.com";
    private static final String EMAIL_SCHEME = "mailto:";
    private static final int IMAGE_QUALITY = 25;
    private static final String MARKUP_FILENAME = "mp_adalert_markup.html";
    private static final String PARAMETERS_FILENAME = "mp_adalert_parameters.txt";
    private static final String SCREEN_SHOT_FILENAME = "mp_adalert_screenshot.png";
    private final AdConfiguration mAdConfiguration;
    private final Context mContext;
    private final String mDateString;
    private ArrayList<Uri> mEmailAttachments;
    private Intent mEmailIntent;
    private String mParameters;
    private String mResponse;
    private final View mView;

    public AdAlertReporter(Context context, View view, AdConfiguration adConfiguration) {
        this.mView = view;
        this.mContext = context;
        this.mAdConfiguration = adConfiguration;
        this.mEmailAttachments = new ArrayList();
        this.mDateString = new SimpleDateFormat(DATE_FORMAT_PATTERN).format(DateAndTime.now());
        this.initEmailIntent();
        Bitmap bitmap = this.takeScreenShot();
        String string2 = this.convertBitmapInWEBPToBase64EncodedString(bitmap);
        this.mParameters = this.formParameters();
        this.mResponse = this.getResponseString();
        this.addEmailSubject();
        String[] stringArray = new String[]{this.mParameters, this.mResponse, string2};
        this.addEmailBody(stringArray);
        this.addTextAttachment(PARAMETERS_FILENAME, this.mParameters);
        this.addTextAttachment(MARKUP_FILENAME, this.mResponse);
        this.addImageAttachment(SCREEN_SHOT_FILENAME, bitmap);
    }

    private void addEmailBody(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuilder.append(stringArray[i2]);
            if (i2 == -1 + stringArray.length) continue;
            stringBuilder.append(BODY_SEPARATOR);
        }
        this.mEmailIntent.putExtra("android.intent.extra.TEXT", stringBuilder.toString());
    }

    private void addEmailSubject() {
        this.mEmailIntent.putExtra("android.intent.extra.SUBJECT", "New creative violation report - " + this.mDateString);
    }

    private void addImageAttachment(String string2, Bitmap bitmap) {
        FileOutputStream fileOutputStream = null;
        if (string2 == null || bitmap == null) {
            return;
        }
        try {
            fileOutputStream = this.mContext.openFileOutput(string2, 1);
            bitmap.compress(Bitmap.CompressFormat.PNG, 25, (OutputStream)fileOutputStream);
            Uri uri = Uri.fromFile((File)new File(this.mContext.getFilesDir() + File.separator + string2));
            this.mEmailAttachments.add(uri);
        }
        catch (Exception exception) {
            try {
                Log.d((String)"MoPub", (String)("Unable to write text attachment to file: " + string2));
            }
            catch (Throwable throwable) {
                Streams.closeStream(fileOutputStream);
                throw throwable;
            }
            Streams.closeStream(fileOutputStream);
            return;
        }
        Streams.closeStream(fileOutputStream);
        return;
    }

    private void addTextAttachment(String string2, String string3) {
        FileOutputStream fileOutputStream = null;
        if (string2 == null || string3 == null) {
            return;
        }
        try {
            fileOutputStream = this.mContext.openFileOutput(string2, 1);
            fileOutputStream.write(string3.getBytes());
            Uri uri = Uri.fromFile((File)new File(this.mContext.getFilesDir() + File.separator + string2));
            this.mEmailAttachments.add(uri);
        }
        catch (Exception exception) {
            try {
                Log.d((String)"MoPub", (String)("Unable to write text attachment to file: " + string2));
            }
            catch (Throwable throwable) {
                Streams.closeStream(fileOutputStream);
                throw throwable;
            }
            Streams.closeStream(fileOutputStream);
            return;
        }
        Streams.closeStream(fileOutputStream);
        return;
    }

    private void appendKeyValue(StringBuilder stringBuilder, String string2, String string3) {
        stringBuilder.append(string2);
        stringBuilder.append(" : ");
        stringBuilder.append(string3);
        stringBuilder.append("\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertBitmapInWEBPToBase64EncodedString(Bitmap bitmap) {
        String string2 = null;
        if (bitmap == null) return string2;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 25, (OutputStream)byteArrayOutputStream);
            String string3 = Base64.encodeToString(byteArrayOutputStream.toByteArray(), 0);
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String formParameters() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mAdConfiguration != null) {
            this.appendKeyValue(stringBuilder, "sdk_version", this.mAdConfiguration.getSdkVersion());
            this.appendKeyValue(stringBuilder, "creative_id", this.mAdConfiguration.getDspCreativeId());
            this.appendKeyValue(stringBuilder, "platform_version", Integer.toString(this.mAdConfiguration.getPlatformVersion()));
            this.appendKeyValue(stringBuilder, "device_model", this.mAdConfiguration.getDeviceModel());
            this.appendKeyValue(stringBuilder, "ad_unit_id", this.mAdConfiguration.getAdUnitId());
            this.appendKeyValue(stringBuilder, "device_locale", this.mAdConfiguration.getDeviceLocale());
            this.appendKeyValue(stringBuilder, "device_id", this.mAdConfiguration.getHashedUdid());
            this.appendKeyValue(stringBuilder, "network_type", this.mAdConfiguration.getNetworkType());
            this.appendKeyValue(stringBuilder, "platform", this.mAdConfiguration.getPlatform());
            this.appendKeyValue(stringBuilder, "timestamp", this.getFormattedTimeStamp(this.mAdConfiguration.getTimeStamp()));
            this.appendKeyValue(stringBuilder, "ad_type", this.mAdConfiguration.getAdType());
            this.appendKeyValue(stringBuilder, "ad_size", "{" + this.mAdConfiguration.getWidth() + ", " + this.mAdConfiguration.getHeight() + "}");
        }
        return stringBuilder.toString();
    }

    private String getFormattedTimeStamp(long l2) {
        if (l2 != -1L) {
            return new SimpleDateFormat(DATE_FORMAT_PATTERN).format(new Date(l2));
        }
        return null;
    }

    private String getResponseString() {
        if (this.mAdConfiguration != null) {
            return this.mAdConfiguration.getResponseString();
        }
        return "";
    }

    private void initEmailIntent() {
        this.mEmailIntent = new Intent("android.intent.action.SEND_MULTIPLE", Uri.parse((String)EMAIL_SCHEME));
        this.mEmailIntent.setType("plain/text");
        this.mEmailIntent.putExtra("android.intent.extra.EMAIL", new String[]{EMAIL_RECIPIENT});
    }

    /*
     * Enabled aggressive block sorting
     */
    private Bitmap takeScreenShot() {
        Bitmap bitmap;
        boolean bl2;
        View view;
        block3: {
            block2: {
                if (this.mView == null || this.mView.getRootView() == null) break block2;
                view = this.mView.getRootView();
                bl2 = view.isDrawingCacheEnabled();
                view.setDrawingCacheEnabled(true);
                bitmap = view.getDrawingCache();
                if (bitmap != null) break block3;
            }
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap);
        view.setDrawingCacheEnabled(bl2);
        return bitmap2;
    }

    @Deprecated
    ArrayList<Uri> getEmailAttachments() {
        return this.mEmailAttachments;
    }

    @Deprecated
    Intent getEmailIntent() {
        return this.mEmailIntent;
    }

    @Deprecated
    String getParameters() {
        return this.mParameters;
    }

    @Deprecated
    String getResponse() {
        return this.mResponse;
    }

    public void send() {
        this.mEmailIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.mEmailAttachments);
        Intent intent = Intent.createChooser((Intent)this.mEmailIntent, (CharSequence)"Send Email...");
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
    }
}

