/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.mopub.mobileads.AdAlertReporter;
import com.mopub.mobileads.AdConfiguration;

public class AdAlertGestureListener
extends GestureDetector.SimpleOnGestureListener {
    private static final float MAXIMUM_THRESHOLD_X_IN_DIPS = 100.0f;
    private static final float MAXIMUM_THRESHOLD_Y_IN_DIPS = 50.0f;
    private static final int MINIMUM_NUMBER_OF_ZIGZAGS_TO_FLAG = 4;
    private AdAlertReporter mAdAlertReporter;
    private AdConfiguration mAdConfiguration;
    private float mCurrentThresholdInDips = 100.0f;
    private ZigZagState mCurrentZigZagState = ZigZagState.UNSET;
    private boolean mHasCrossedLeftThreshold;
    private boolean mHasCrossedRightThreshold;
    private int mNumberOfZigZags;
    private float mPivotPositionX;
    private float mPreviousPositionX;
    private View mView;

    AdAlertGestureListener(View view, AdConfiguration adConfiguration) {
        if (view != null && view.getWidth() > 0) {
            this.mCurrentThresholdInDips = Math.min(100.0f, (float)view.getWidth() / 3.0f);
        }
        this.mView = view;
        this.mAdConfiguration = adConfiguration;
    }

    private void incrementNumberOfZigZags() {
        this.mNumberOfZigZags = 1 + this.mNumberOfZigZags;
        if (this.mNumberOfZigZags >= 4) {
            this.mCurrentZigZagState = ZigZagState.FINISHED;
        }
    }

    private boolean isMovingLeft(float f2) {
        return f2 < this.mPreviousPositionX;
    }

    private boolean isMovingRight(float f2) {
        return f2 > this.mPreviousPositionX;
    }

    private boolean isTouchOutOfBoundsOnYAxis(float f2, float f3) {
        return Math.abs(f3 - f2) > 50.0f;
    }

    private boolean leftThresholdReached(float f2) {
        if (this.mHasCrossedLeftThreshold) {
            return true;
        }
        if (f2 <= this.mPivotPositionX - this.mCurrentThresholdInDips) {
            this.mHasCrossedRightThreshold = false;
            this.mHasCrossedLeftThreshold = true;
            this.incrementNumberOfZigZags();
            return true;
        }
        return false;
    }

    private boolean rightThresholdReached(float f2) {
        if (this.mHasCrossedRightThreshold) {
            return true;
        }
        if (f2 >= this.mPivotPositionX + this.mCurrentThresholdInDips) {
            this.mHasCrossedLeftThreshold = false;
            this.mHasCrossedRightThreshold = true;
            return true;
        }
        return false;
    }

    private void updateInitialState(float f2) {
        if (f2 > this.mPivotPositionX) {
            this.mCurrentZigZagState = ZigZagState.GOING_RIGHT;
        }
    }

    private void updateZag(float f2) {
        if (this.leftThresholdReached(f2) && this.isMovingRight(f2)) {
            this.mCurrentZigZagState = ZigZagState.GOING_RIGHT;
            this.mPivotPositionX = f2;
        }
    }

    private void updateZig(float f2) {
        if (this.rightThresholdReached(f2) && this.isMovingLeft(f2)) {
            this.mCurrentZigZagState = ZigZagState.GOING_LEFT;
            this.mPivotPositionX = f2;
        }
    }

    void finishGestureDetection() {
        ZigZagState zigZagState = this.mCurrentZigZagState;
        if (zigZagState == ZigZagState.FINISHED) {
            this.mAdAlertReporter = new AdAlertReporter(this.mView.getContext(), this.mView, this.mAdConfiguration);
            this.mAdAlertReporter.send();
        }
        this.reset();
    }

    @Deprecated
    AdAlertReporter getAdAlertReporter() {
        return this.mAdAlertReporter;
    }

    @Deprecated
    ZigZagState getCurrentZigZagState() {
        return this.mCurrentZigZagState;
    }

    @Deprecated
    float getMinimumDipsInZigZag() {
        return this.mCurrentThresholdInDips;
    }

    @Deprecated
    int getNumberOfZigzags() {
        return this.mNumberOfZigZags;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
        if (this.mCurrentZigZagState == ZigZagState.FINISHED) {
            return super.onScroll(motionEvent, motionEvent2, f2, f3);
        }
        if (this.isTouchOutOfBoundsOnYAxis(motionEvent.getY(), motionEvent2.getY())) {
            this.mCurrentZigZagState = ZigZagState.FAILED;
            return super.onScroll(motionEvent, motionEvent2, f2, f3);
        }
        switch (this.mCurrentZigZagState) {
            case UNSET: {
                this.mPivotPositionX = motionEvent.getX();
                this.updateInitialState(motionEvent2.getX());
                break;
            }
            case GOING_RIGHT: {
                this.updateZig(motionEvent2.getX());
                break;
            }
            case GOING_LEFT: {
                this.updateZag(motionEvent2.getX());
                break;
            }
        }
        this.mPreviousPositionX = motionEvent2.getX();
        return super.onScroll(motionEvent, motionEvent2, f2, f3);
    }

    void reset() {
        this.mNumberOfZigZags = 0;
        this.mCurrentZigZagState = ZigZagState.UNSET;
    }

    static final class ZigZagState
    extends Enum<ZigZagState> {
        private static final /* synthetic */ ZigZagState[] $VALUES;
        public static final /* enum */ ZigZagState FAILED;
        public static final /* enum */ ZigZagState FINISHED;
        public static final /* enum */ ZigZagState GOING_LEFT;
        public static final /* enum */ ZigZagState GOING_RIGHT;
        public static final /* enum */ ZigZagState UNSET;

        static {
            UNSET = new ZigZagState();
            GOING_RIGHT = new ZigZagState();
            GOING_LEFT = new ZigZagState();
            FINISHED = new ZigZagState();
            FAILED = new ZigZagState();
            ZigZagState[] zigZagStateArray = new ZigZagState[]{UNSET, GOING_RIGHT, GOING_LEFT, FINISHED, FAILED};
            $VALUES = zigZagStateArray;
        }

        public static ZigZagState valueOf(String string2) {
            return Enum.valueOf(ZigZagState.class, string2);
        }

        public static ZigZagState[] values() {
            return (ZigZagState[])$VALUES.clone();
        }
    }
}

