/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.google.gson.stream;

import com.millennialmedia.google.gson.internal.JsonReaderInternalAccess;
import com.millennialmedia.google.gson.internal.bind.JsonTreeReader;
import com.millennialmedia.google.gson.stream.JsonToken;
import com.millennialmedia.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_EOF = 17;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private final char[] buffer = new char[1024];
    private final Reader in;
    private boolean lenient = false;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    private int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int pos = 0;
    private int[] stack = new int[32];
    private int stackSize = 0;

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                    return;
                }
                int n2 = jsonReader.peeked;
                if (n2 == 0) {
                    n2 = jsonReader.doPeek();
                }
                if (n2 == 13) {
                    JsonReader.access$002(jsonReader, 9);
                    return;
                }
                if (n2 == 12) {
                    JsonReader.access$002(jsonReader, 8);
                    return;
                }
                if (n2 == 14) {
                    JsonReader.access$002(jsonReader, 10);
                    return;
                }
                throw new IllegalStateException("Expected a name but was " + (Object)((Object)jsonReader.peek()) + " " + " at line " + jsonReader.getLineNumber() + " column " + jsonReader.getColumnNumber());
            }
        };
    }

    public JsonReader(Reader reader) {
        int[] nArray = this.stack;
        int n2 = this.stackSize;
        this.stackSize = n2 + 1;
        nArray[n2] = 6;
        if (reader == null) {
            throw new NullPointerException("in == null");
        }
        this.in = reader;
    }

    static /* synthetic */ int access$002(JsonReader jsonReader, int n2) {
        jsonReader.peeked = n2;
        return n2;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void consumeNonExecutePrefix() throws IOException {
        this.nextNonWhitespace(true);
        this.pos = -1 + this.pos;
        if (this.pos + NON_EXECUTE_PREFIX.length <= this.limit || this.fillBuffer(NON_EXECUTE_PREFIX.length)) {
            int n2 = 0;
            while (true) {
                if (n2 >= NON_EXECUTE_PREFIX.length) {
                    this.pos += NON_EXECUTE_PREFIX.length;
                    return;
                }
                if (this.buffer[n2 + this.pos] != NON_EXECUTE_PREFIX[n2]) break;
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int doPeek() throws IOException {
        int n2;
        int n3 = this.stack[-1 + this.stackSize];
        if (n3 == 1) {
            this.stack[-1 + this.stackSize] = 2;
        } else if (n3 == 2) {
            switch (this.nextNonWhitespace(true)) {
                case 44: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated array");
                }
                case 93: {
                    this.peeked = 4;
                    return 4;
                }
                case 59: {
                    this.checkLenient();
                    break;
                }
            }
        } else {
            if (n3 == 3 || n3 == 5) {
                this.stack[-1 + this.stackSize] = 4;
                if (n3 == 5) {
                    switch (this.nextNonWhitespace(true)) {
                        default: {
                            throw this.syntaxError("Unterminated object");
                        }
                        case 125: {
                            this.peeked = 2;
                            return 2;
                        }
                        case 59: {
                            this.checkLenient();
                            break;
                        }
                        case 44: 
                    }
                }
                int n4 = this.nextNonWhitespace(true);
                switch (n4) {
                    default: {
                        this.checkLenient();
                        this.pos = -1 + this.pos;
                        if (!this.isLiteral((char)n4)) throw this.syntaxError("Expected name");
                        this.peeked = 14;
                        return 14;
                    }
                    case 34: {
                        this.peeked = 13;
                        return 13;
                    }
                    case 39: {
                        this.checkLenient();
                        this.peeked = 12;
                        return 12;
                    }
                    case 125: {
                        if (n3 == 5) throw this.syntaxError("Expected name");
                        this.peeked = 2;
                        return 2;
                    }
                }
            }
            if (n3 == 4) {
                this.stack[-1 + this.stackSize] = 5;
                switch (this.nextNonWhitespace(true)) {
                    case 58: {
                        break;
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                    case 61: {
                        this.checkLenient();
                        if (this.pos >= this.limit && !this.fillBuffer(1) || this.buffer[this.pos] != '>') break;
                        this.pos = 1 + this.pos;
                        break;
                    }
                }
            } else if (n3 == 6) {
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[-1 + this.stackSize] = 7;
            } else if (n3 == 7) {
                if (this.nextNonWhitespace(false) == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
                this.pos = -1 + this.pos;
            } else if (n3 == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        switch (this.nextNonWhitespace(true)) {
            default: {
                this.pos = -1 + this.pos;
                if (this.stackSize == 1) {
                    this.checkLenient();
                }
                if ((n2 = this.peekKeyword()) == 0) break;
                return n2;
            }
            case 93: {
                if (n3 == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (n3 != 1 && n3 != 2) {
                    throw this.syntaxError("Unexpected value");
                }
                this.checkLenient();
                this.pos = -1 + this.pos;
                this.peeked = 7;
                return 7;
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                if (this.stackSize == 1) {
                    this.checkLenient();
                }
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        n2 = this.peekNumber();
        if (n2 != 0) {
            return n2;
        }
        if (!this.isLiteral(this.buffer[this.pos])) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean fillBuffer(int n2) throws IOException {
        char[] cArray = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(cArray, this.pos, cArray, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        do {
            int n3 = this.in.read(cArray, this.limit, cArray.length - this.limit);
            boolean bl2 = false;
            if (n3 == -1) return bl2;
            this.limit = n3 + this.limit;
            if (this.lineNumber != 0 || this.lineStart != 0 || this.limit <= 0 || cArray[0] != '\ufeff') continue;
            this.pos = 1 + this.pos;
            this.lineStart = 1 + this.lineStart;
            ++n2;
        } while (this.limit < n2);
        return true;
    }

    private int getColumnNumber() {
        return 1 + (this.pos - this.lineStart);
    }

    private int getLineNumber() {
        return 1 + this.lineNumber;
    }

    private boolean isLiteral(char c2) throws IOException {
        switch (c2) {
            default: {
                return true;
            }
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': 
        }
        return false;
    }

    private int nextNonWhitespace(boolean bl2) throws IOException {
        char[] cArray = this.buffer;
        int n2 = this.pos;
        int n3 = this.limit;
        block4: while (true) {
            int n4;
            block17: {
                block16: {
                    block14: {
                        block15: {
                            if (n2 != n3) break block14;
                            this.pos = n2;
                            if (this.fillBuffer(1)) break block15;
                            if (bl2) {
                                throw new EOFException("End of input at line " + this.getLineNumber() + " column " + this.getColumnNumber());
                            }
                            break block16;
                        }
                        n2 = this.pos;
                        n3 = this.limit;
                    }
                    n4 = n2 + 1;
                    char c2 = cArray[n2];
                    if (c2 == '\n') {
                        this.lineNumber = 1 + this.lineNumber;
                        this.lineStart = n4;
                        n2 = n4;
                        continue;
                    }
                    if (c2 != ' ' && c2 != '\r') {
                        if (c2 == '\t') {
                            n2 = n4;
                            continue;
                        }
                        if (c2 == '/') {
                            this.pos = n4;
                            if (n4 == n3) {
                                this.pos = -1 + this.pos;
                                boolean bl3 = this.fillBuffer(2);
                                this.pos = 1 + this.pos;
                                if (!bl3) {
                                    return c2;
                                }
                            }
                            this.checkLenient();
                            switch (cArray[this.pos]) {
                                default: {
                                    return c2;
                                }
                                case '*': {
                                    this.pos = 1 + this.pos;
                                    if (!this.skipTo("*/")) {
                                        throw this.syntaxError("Unterminated comment");
                                    }
                                    n2 = 2 + this.pos;
                                    n3 = this.limit;
                                    continue block4;
                                }
                                case '/': 
                            }
                            this.pos = 1 + this.pos;
                            this.skipToEndOfLine();
                            n2 = this.pos;
                            n3 = this.limit;
                            continue;
                        }
                        if (c2 == '#') {
                            this.pos = n4;
                            this.checkLenient();
                            this.skipToEndOfLine();
                            n2 = this.pos;
                            n3 = this.limit;
                            continue;
                        }
                        this.pos = n4;
                        return c2;
                    }
                    break block17;
                }
                return -1;
            }
            n2 = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String nextQuotedValue(char c2) throws IOException {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            int n2 = this.pos;
            int n3 = this.limit;
            int n4 = n2;
            int n5 = n2;
            while (n5 < n3) {
                int n6 = n5 + 1;
                char c3 = cArray[n5];
                if (c3 == c2) {
                    this.pos = n6;
                    stringBuilder.append(cArray, n4, -1 + (n6 - n4));
                    return stringBuilder.toString();
                }
                if (c3 == '\\') {
                    this.pos = n6;
                    stringBuilder.append(cArray, n4, -1 + (n6 - n4));
                    stringBuilder.append(this.readEscapeCharacter());
                    n6 = this.pos;
                    n3 = this.limit;
                    n4 = n6;
                } else if (c3 == '\n') {
                    this.lineNumber = 1 + this.lineNumber;
                    this.lineStart = n6;
                }
                n5 = n6;
            }
            stringBuilder.append(cArray, n4, n5 - n4);
            this.pos = n5;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    /*
     * Enabled aggressive block sorting
     */
    private String nextUnquotedValue() throws IOException {
        String string2;
        int n2;
        StringBuilder stringBuilder;
        block11: {
            stringBuilder = null;
            n2 = 0;
            block4: while (true) {
                if (n2 + this.pos < this.limit) {
                    switch (this.buffer[n2 + this.pos]) {
                        default: {
                            ++n2;
                            continue block4;
                        }
                        case '#': 
                        case '/': 
                        case ';': 
                        case '=': 
                        case '\\': {
                            this.checkLenient();
                            break;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case ',': 
                        case ':': 
                        case '[': 
                        case ']': 
                        case '{': 
                        case '}': {
                            break;
                        }
                    }
                    break block11;
                }
                if (n2 < this.buffer.length) {
                    if (this.fillBuffer(n2 + 1)) {
                        continue;
                    }
                    break block11;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(this.buffer, this.pos, n2);
                this.pos = n2 + this.pos;
                boolean bl2 = this.fillBuffer(1);
                n2 = 0;
                if (!bl2) break;
            }
            n2 = 0;
        }
        if (stringBuilder == null) {
            string2 = new String(this.buffer, this.pos, n2);
        } else {
            stringBuilder.append(this.buffer, this.pos, n2);
            string2 = stringBuilder.toString();
        }
        this.pos = n2 + this.pos;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int peekKeyword() throws IOException {
        int n2;
        String string2;
        String string3;
        char c2 = this.buffer[this.pos];
        if (c2 == 't' || c2 == 'T') {
            string3 = "true";
            string2 = "TRUE";
            n2 = 5;
        } else if (c2 == 'f' || c2 == 'F') {
            string3 = "false";
            string2 = "FALSE";
            n2 = 6;
        } else {
            if (c2 != 'n' && c2 != 'N') {
                return 0;
            }
            string3 = "null";
            string2 = "NULL";
            n2 = 7;
        }
        int n3 = string3.length();
        for (int i2 = 1; i2 < n3; ++i2) {
            if (i2 + this.pos >= this.limit && !this.fillBuffer(i2 + 1)) {
                return 0;
            }
            char c3 = this.buffer[i2 + this.pos];
            if (c3 == string3.charAt(i2) || c3 == string2.charAt(i2)) continue;
            return 0;
        }
        if ((n3 + this.pos < this.limit || this.fillBuffer(n3 + 1)) && this.isLiteral(this.buffer[n3 + this.pos])) {
            return 0;
        }
        this.pos = n3 + this.pos;
        this.peeked = n2;
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private int peekNumber() throws IOException {
        block19: {
            block18: {
                block23: {
                    block21: {
                        block22: {
                            block20: {
                                var1_1 = this.buffer;
                                var2_2 = this.pos;
                                var3_3 = this.limit;
                                var4_4 = 0L;
                                var6_5 = false;
                                var7_6 = true;
                                var8_7 = 0;
                                var9_8 = 0;
                                block6: while (true) {
                                    if (var2_2 + var9_8 == var3_3) {
                                        if (var9_8 == var1_1.length) {
                                            return 0;
                                        }
                                        if (!this.fillBuffer(var9_8 + 1)) lbl-1000:
                                        // 2 sources

                                        {
                                            while (var8_7 == 2 && var7_6 && (var4_4 != -9223372036854775808L || var6_5)) {
                                                if (var6_5) lbl-1000:
                                                // 2 sources

                                                {
                                                    while (true) {
                                                        this.peekedLong = var4_4;
                                                        this.pos = var9_8 + this.pos;
                                                        this.peeked = 15;
                                                        return 15;
                                                    }
                                                }
                                                break block18;
                                            }
                                            break block19;
                                        }
                                        var2_2 = this.pos;
                                        var3_3 = this.limit;
                                    }
                                    var10_9 = var1_1[var2_2 + var9_8];
                                    switch (var10_9) {
                                        default: {
                                            if (var10_9 >= '0' && var10_9 <= '9') break block6;
                                            if (!this.isLiteral(var10_9)) ** GOTO lbl-1000
                                            return 0;
                                        }
                                        case '-': {
                                            if (var8_7 == 0) {
                                                var6_5 = true;
                                                var8_7 = 1;
lbl35:
                                                // 10 sources

                                                while (true) {
                                                    ++var9_8;
                                                    continue block6;
                                                    break;
                                                }
                                            }
                                            if (var8_7 != 5) ** GOTO lbl41
                                            var8_7 = 6;
                                            ** GOTO lbl35
lbl41:
                                            // 1 sources

                                            return 0;
                                        }
                                        case '+': {
                                            if (var8_7 != 5) ** GOTO lbl46
                                            var8_7 = 6;
                                            ** GOTO lbl35
lbl46:
                                            // 1 sources

                                            return 0;
                                        }
                                        case 'E': 
                                        case 'e': {
                                            if (var8_7 != 2 && var8_7 != 4) ** GOTO lbl51
                                            var8_7 = 5;
                                            ** GOTO lbl35
lbl51:
                                            // 1 sources

                                            return 0;
                                        }
                                        case '.': {
                                            if (var8_7 != 2) ** GOTO lbl56
                                            var8_7 = 3;
                                            ** GOTO lbl35
lbl56:
                                            // 1 sources

                                            return 0;
                                        }
                                    }
                                    break;
                                }
                                if (var8_7 != 1 && var8_7 != 0) break block20;
                                var4_4 = -(var10_9 - 48);
                                var8_7 = 2;
                                ** GOTO lbl35
                            }
                            if (var8_7 != 2) break block21;
                            if (var4_4 == 0L) {
                                return 0;
                            }
                            var11_10 = 10L * var4_4 - (long)(var10_9 - 48);
                            if (var4_4 <= -922337203685477580L && (var4_4 != -922337203685477580L || var11_10 >= var4_4)) break block22;
                            var13_11 = true;
lbl68:
                            // 2 sources

                            while (true) {
                                var7_6 &= var13_11;
                                var4_4 = var11_10;
                                ** GOTO lbl35
                                break;
                            }
                        }
                        var13_11 = false;
                        ** while (true)
                    }
                    if (var8_7 != 3) break block23;
                    var8_7 = 4;
                    ** GOTO lbl35
                }
                if (var8_7 != 5 && var8_7 != 6) ** GOTO lbl35
                var8_7 = 7;
                ** while (true)
            }
            var4_4 = -var4_4;
            ** while (true)
        }
        if (var8_7 == 2 || var8_7 == 4 || var8_7 == 7) {
            this.peekedNumberLength = var9_8;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private void push(int n2) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = new int[2 * this.stackSize];
            System.arraycopy(this.stack, 0, nArray, 0, this.stackSize);
            this.stack = nArray;
        }
        int[] nArray = this.stack;
        int n3 = this.stackSize;
        this.stackSize = n3 + 1;
        nArray[n3] = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char[] cArray = this.buffer;
        int n2 = this.pos;
        this.pos = n2 + 1;
        char c2 = cArray[n2];
        switch (c2) {
            default: {
                return c2;
            }
            case 'u': {
                if (4 + this.pos > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                char c3 = '\u0000';
                int n3 = this.pos;
                int n4 = n3 + 4;
                while (true) {
                    if (n3 >= n4) {
                        this.pos = 4 + this.pos;
                        return c3;
                    }
                    char c4 = this.buffer[n3];
                    char c5 = (char)(c3 << 4);
                    if (c4 >= '0' && c4 <= '9') {
                        c3 = (char)(c5 + (c4 - 48));
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        c3 = (char)(c5 + (10 + (c4 - 97)));
                    } else {
                        if (c4 < 'A') throw new NumberFormatException("\\u" + new String(this.buffer, this.pos, 4));
                        if (c4 > 'F') throw new NumberFormatException("\\u" + new String(this.buffer, this.pos, 4));
                        c3 = (char)(c5 + (10 + (c4 - 65)));
                    }
                    ++n3;
                }
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': 
        }
        this.lineNumber = 1 + this.lineNumber;
        this.lineStart = this.pos;
        return c2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skipQuotedValue(char c2) throws IOException {
        char[] cArray = this.buffer;
        do {
            int n2 = this.pos;
            int n3 = this.limit;
            int n4 = n2;
            while (n4 < n3) {
                int n5 = n4 + 1;
                char c3 = cArray[n4];
                if (c3 == c2) {
                    this.pos = n5;
                    return;
                }
                if (c3 == '\\') {
                    this.pos = n5;
                    this.readEscapeCharacter();
                    n5 = this.pos;
                    n3 = this.limit;
                } else if (c3 == '\n') {
                    this.lineNumber = 1 + this.lineNumber;
                    this.lineStart = n5;
                }
                n4 = n5;
            }
            this.pos = n4;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean skipTo(String string2) throws IOException {
        while (this.pos + string2.length() <= this.limit || this.fillBuffer(string2.length())) {
            if (this.buffer[this.pos] == '\n') {
                this.lineNumber = 1 + this.lineNumber;
                this.lineStart = 1 + this.pos;
            } else {
                int n2 = 0;
                while (true) {
                    if (n2 >= string2.length()) {
                        return true;
                    }
                    if (this.buffer[n2 + this.pos] != string2.charAt(n2)) break;
                    ++n2;
                }
            }
            this.pos = 1 + this.pos;
        }
        return false;
    }

    private void skipToEndOfLine() throws IOException {
        char c2;
        do {
            if (this.pos < this.limit || this.fillBuffer(1)) {
                char[] cArray = this.buffer;
                int n2 = this.pos;
                this.pos = n2 + 1;
                c2 = cArray[n2];
                if (c2 != '\n') continue;
                this.lineNumber = 1 + this.lineNumber;
                this.lineStart = this.pos;
            }
            return;
        } while (c2 != '\r');
    }

    private void skipUnquotedValue() throws IOException {
        do {
            int n2 = 0;
            block5: while (n2 + this.pos < this.limit) {
                switch (this.buffer[n2 + this.pos]) {
                    default: {
                        ++n2;
                        continue block5;
                    }
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': 
                }
                this.pos = n2 + this.pos;
                return;
            }
            this.pos = n2 + this.pos;
        } while (this.fillBuffer(1));
    }

    private IOException syntaxError(String string2) throws IOException {
        throw new MalformedJsonException(string2 + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    public void beginArray() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 3) {
            this.push(1);
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_ARRAY but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    public void beginObject() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 1) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_OBJECT but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    public void endArray() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 4) {
            this.stackSize = -1 + this.stackSize;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_ARRAY but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    public void endObject() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 2) {
            this.stackSize = -1 + this.stackSize;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_OBJECT but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    public boolean hasNext() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        return n2 != 2 && n2 != 4;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public boolean nextBoolean() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 5) {
            this.peeked = 0;
            return true;
        }
        if (n2 == 6) {
            this.peeked = 0;
            return false;
        }
        throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    /*
     * Enabled aggressive block sorting
     */
    public double nextDouble() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            this.peeked = 0;
            return this.peekedLong;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n2 == 8 || n2 == 9) {
            char c2 = n2 == 8 ? (char)'\'' : '\"';
            this.peekedString = this.nextQuotedValue(c2);
        } else if (n2 == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (n2 != 11) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + d2 + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.peekedString = null;
        this.peeked = 0;
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int nextInt() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            int n3 = (int)this.peekedLong;
            if (this.peekedLong != (long)n3) {
                throw new NumberFormatException("Expected an int but was " + this.peekedLong + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            this.peeked = 0;
            return n3;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            if (n2 != 8 && n2 != 9) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            char c2 = n2 == 8 ? (char)'\'' : '\"';
            this.peekedString = this.nextQuotedValue(c2);
            try {
                int n4 = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                return n4;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        int n5 = (int)d2;
        if ((double)n5 != d2) {
            throw new NumberFormatException("Expected an int but was " + this.peekedString + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.peekedString = null;
        this.peeked = 0;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long nextLong() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            this.peeked = 0;
            return this.peekedLong;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            if (n2 != 8 && n2 != 9) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            char c2 = n2 == 8 ? (char)'\'' : '\"';
            this.peekedString = this.nextQuotedValue(c2);
            try {
                long l2 = Long.parseLong(this.peekedString);
                this.peeked = 0;
                return l2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        long l3 = (long)d2;
        if ((double)l3 != d2) {
            throw new NumberFormatException("Expected a long but was " + this.peekedString + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.peekedString = null;
        this.peeked = 0;
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextName() throws IOException {
        String string2;
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 14) {
            string2 = this.nextUnquotedValue();
        } else if (n2 == 12) {
            string2 = this.nextQuotedValue('\'');
        } else {
            if (n2 != 13) {
                throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            string2 = this.nextQuotedValue('\"');
        }
        this.peeked = 0;
        return string2;
    }

    public void nextNull() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 7) {
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected null but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextString() throws IOException {
        String string2;
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 10) {
            string2 = this.nextUnquotedValue();
        } else if (n2 == 8) {
            string2 = this.nextQuotedValue('\'');
        } else if (n2 == 9) {
            string2 = this.nextQuotedValue('\"');
        } else if (n2 == 11) {
            string2 = this.peekedString;
            this.peekedString = null;
        } else if (n2 == 15) {
            string2 = Long.toString(this.peekedLong);
        } else {
            if (n2 != 16) {
                throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            string2 = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        }
        this.peeked = 0;
        return string2;
    }

    public JsonToken peek() throws IOException {
        int n2 = this.peeked;
        if (n2 == 0) {
            n2 = this.doPeek();
        }
        switch (n2) {
            default: {
                throw new AssertionError();
            }
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: 
        }
        return JsonToken.END_DOCUMENT;
    }

    public final void setLenient(boolean bl2) {
        this.lenient = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void skipValue() throws IOException {
        int n2 = 0;
        do {
            int n3;
            if ((n3 = this.peeked) == 0) {
                n3 = this.doPeek();
            }
            if (n3 == 3) {
                this.push(1);
                ++n2;
            } else if (n3 == 1) {
                this.push(3);
                ++n2;
            } else if (n3 == 4) {
                this.stackSize = -1 + this.stackSize;
                --n2;
            } else if (n3 == 2) {
                this.stackSize = -1 + this.stackSize;
                --n2;
            } else if (n3 == 14 || n3 == 10) {
                this.skipUnquotedValue();
            } else if (n3 == 8 || n3 == 12) {
                this.skipQuotedValue('\'');
            } else if (n3 == 9 || n3 == 13) {
                this.skipQuotedValue('\"');
            } else if (n3 == 16) {
                this.pos += this.peekedNumberLength;
            }
            this.peeked = 0;
        } while (n2 != 0);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " at line " + this.getLineNumber() + " column " + this.getColumnNumber();
    }
}

