/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.google.gson.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LinkedHashTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Comparator<Comparable> NATURAL_ORDER;
    Comparator<? super K> comparator;
    private EntrySet entrySet;
    final Node<K, V> header;
    private KeySet keySet;
    int modCount = 0;
    int size = 0;
    Node<K, V>[] table;
    int threshold;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !LinkedHashTreeMap.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
        NATURAL_ORDER = new Comparator<Comparable>(){

            @Override
            public int compare(Comparable comparable, Comparable comparable2) {
                return comparable.compareTo(comparable2);
            }
        };
    }

    public LinkedHashTreeMap() {
        this(NATURAL_ORDER);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LinkedHashTreeMap(Comparator<? super K> comparator) {
        void var1_2;
        if (comparator == null) {
            Comparator<Comparable> comparator2 = NATURAL_ORDER;
        }
        this.comparator = var1_2;
        this.header = new Node();
        this.table = new Node[16];
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    private void doubleCapacity() {
        this.table = LinkedHashTreeMap.doubleCapacity(this.table);
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    /*
     * Unable to fully structure code
     */
    static <K, V> Node<K, V>[] doubleCapacity(Node<K, V>[] var0) {
        var1_1 = var0.length;
        var2_2 = new Node[var1_1 * 2];
        var3_3 = new AvlIterator<K, V>();
        var4_4 = new AvlBuilder<K, V>();
        var5_5 = new AvlBuilder<K, V>();
        block0: for (var6_6 = 0; var6_6 < var1_1; ++var6_6) {
            block9: {
                var7_7 = var0[var6_6];
                if (var7_7 == null) lbl-1000:
                // 2 sources

                {
                    continue block0;
                }
                var3_3.reset(var7_7);
                var8_8 = 0;
                var9_9 = 0;
                while ((var10_10 = var3_3.next()) != null) {
                    if ((var1_1 & var10_10.hash) == 0) {
                        ++var8_8;
                        continue;
                    }
                    ++var9_9;
                }
                if (var8_8 > 0 && var9_9 > 0) {
                    var4_4.reset(var8_8);
                    var5_5.reset(var9_9);
                    var3_3.reset(var7_7);
                    while ((var13_13 = var3_3.next()) != null) {
                        if ((var1_1 & var13_13.hash) == 0) {
                            var4_4.add(var13_13);
                            continue;
                        }
                        var5_5.add(var13_13);
                    }
                    var12_12 = var4_4.root();
                    var11_11 = var5_5.root();
lbl32:
                    // 3 sources

                    while (true) {
                        var2_2[var6_6] = var12_12;
                        var2_2[var6_6 + var1_1] = var11_11;
                        ** continue;
                        break;
                    }
                }
                if (var8_8 <= 0) break block9;
                var12_12 = var7_7;
                var11_11 = null;
                ** GOTO lbl32
            }
            var11_11 = var7_7;
            var12_12 = null;
            ** continue;
        }
        return var2_2;
    }

    private boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rebalance(Node<K, V> node, boolean bl2) {
        Node<K, V> node2 = node;
        while (node2 != null) {
            Node node3;
            int n2;
            Node node4 = node2.left;
            int n3 = node4 != null ? node4.height : 0;
            int n4 = n3 - (n2 = (node3 = node2.right) != null ? node3.height : 0);
            if (n4 == -2) {
                Node node5;
                int n5;
                Node node6 = node3.left;
                int n6 = node6 != null ? node6.height : 0;
                int n7 = n6 - (n5 = (node5 = node3.right) != null ? node5.height : 0);
                if (n7 == -1 || n7 == 0 && !bl2) {
                    this.rotateLeft(node2);
                } else {
                    if (!$assertionsDisabled && n7 != 1) {
                        throw new AssertionError();
                    }
                    this.rotateRight(node3);
                    this.rotateLeft(node2);
                }
                if (bl2) {
                    return;
                }
            } else if (n4 == 2) {
                Node node7;
                int n8;
                Node node8 = node4.left;
                int n9 = node8 != null ? node8.height : 0;
                int n10 = n9 - (n8 = (node7 = node4.right) != null ? node7.height : 0);
                if (n10 == 1 || n10 == 0 && !bl2) {
                    this.rotateRight(node2);
                } else {
                    if (!$assertionsDisabled && n10 != -1) {
                        throw new AssertionError();
                    }
                    this.rotateLeft(node4);
                    this.rotateRight(node2);
                }
                if (bl2) return;
            } else if (n4 == 0) {
                node2.height = n3 + 1;
                if (bl2) {
                    return;
                }
            } else {
                if (!$assertionsDisabled && n4 != -1 && n4 != 1) {
                    throw new AssertionError();
                }
                node2.height = 1 + Math.max(n3, n2);
                if (!bl2) {
                    return;
                }
            }
            node2 = node2.parent;
        }
    }

    private void replaceInParent(Node<K, V> node, Node<K, V> node2) {
        Node node3 = node.parent;
        node.parent = null;
        if (node2 != null) {
            node2.parent = node3;
        }
        if (node3 != null) {
            if (node3.left == node) {
                node3.left = node2;
                return;
            }
            if (!$assertionsDisabled && node3.right != node) {
                throw new AssertionError();
            }
            node3.right = node2;
            return;
        }
        int n2 = node.hash & -1 + this.table.length;
        this.table[n2] = node2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rotateLeft(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node3.left;
        Node node5 = node3.right;
        node.right = node4;
        if (node4 != null) {
            node4.parent = node;
        }
        this.replaceInParent(node, node3);
        node3.left = node;
        node.parent = node3;
        int n2 = node2 != null ? node2.height : 0;
        int n3 = node4 != null ? node4.height : 0;
        int n4 = node.height = 1 + Math.max(n2, n3);
        int n5 = 0;
        if (node5 != null) {
            n5 = node5.height;
        }
        node3.height = 1 + Math.max(n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rotateRight(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node2.left;
        Node node5 = node2.right;
        node.left = node5;
        if (node5 != null) {
            node5.parent = node;
        }
        this.replaceInParent(node, node2);
        node2.right = node;
        node.parent = node2;
        int n2 = node3 != null ? node3.height : 0;
        int n3 = node5 != null ? node5.height : 0;
        int n4 = node.height = 1 + Math.max(n2, n3);
        int n5 = 0;
        if (node4 != null) {
            n5 = node4.height;
        }
        node2.height = 1 + Math.max(n4, n5);
    }

    private static int secondaryHash(int n2) {
        int n3 = n2 ^ (n2 >>> 20 ^ n2 >>> 12);
        return n3 ^ n3 >>> 7 ^ n3 >>> 4;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        this.modCount = 1 + this.modCount;
        Node<K, V> node = this.header;
        Node node2 = node.next;
        while (node2 != node) {
            Node node3 = node2.next;
            node2.prev = null;
            node2.next = null;
            node2 = node3;
        }
        node.prev = node;
        node.next = node;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet;
        EntrySet entrySet2 = this.entrySet;
        if (entrySet2 != null) {
            return entrySet2;
        }
        this.entrySet = entrySet = new EntrySet();
        return entrySet;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    Node<K, V> find(K k2, boolean bl2) {
        Node<K, V> node;
        block11: {
            Node<K, V> node2;
            int n2;
            Node<K, V> node3;
            int n3;
            block7: {
                Comparator<K> comparator = this.comparator;
                Node<K, V>[] nodeArray = this.table;
                n3 = LinkedHashTreeMap.secondaryHash(k2.hashCode());
                int n4 = n3 & -1 + nodeArray.length;
                node3 = nodeArray[n4];
                n2 = 0;
                boolean bl3 = true;
                while (true) {
                    Node node4;
                    block10: {
                        block9: {
                            Comparable comparable;
                            block8: {
                                if (!bl3 || (bl3 = false)) break block8;
                                if (node3 == null) break block9;
                                comparable = comparator == NATURAL_ORDER ? (Comparable)k2 : null;
                            }
                            if ((n2 = comparable != null ? comparable.compareTo(node3.key) : comparator.compare(k2, node3.key)) == 0) {
                                return node3;
                            }
                            node4 = n2 < 0 ? node3.left : node3.right;
                            if (node4 != null) break block10;
                        }
                        Node<K, V> node5 = null;
                        if (!bl2) return node5;
                        node2 = this.header;
                        if (node3 == null) {
                            if (comparator != NATURAL_ORDER || k2 instanceof Comparable) break;
                            throw new ClassCastException(k2.getClass().getName() + " is not Comparable");
                        }
                        break block7;
                    }
                    node3 = node4;
                }
                node = new Node<K, V>(node3, k2, n3, node2, node2.prev);
                nodeArray[n4] = node;
                break block11;
            }
            node = new Node<K, V>(node3, k2, n3, node2, node2.prev);
            if (n2 < 0) {
                node3.left = node;
            } else {
                node3.right = node;
            }
            this.rebalance(node3, true);
        }
        int n5 = this.size;
        this.size = n5 + 1;
        if (n5 > this.threshold) {
            this.doubleCapacity();
        }
        this.modCount = 1 + this.modCount;
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Node<K, V> node = this.findByObject(entry.getKey());
        if (node == null) return null;
        if (!this.equal(node.value, entry.getValue())) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Node<K, V> findByObject(Object object) {
        Node<Object, V> node = null;
        if (object == null) return node;
        try {
            Node<Object, V> node2 = this.find(object, false);
            return node2;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public V get(Object object) {
        Node<K, V> node = this.findByObject(object);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet;
        KeySet keySet2 = this.keySet;
        if (keySet2 != null) {
            return keySet2;
        }
        this.keySet = keySet = new KeySet();
        return keySet;
    }

    @Override
    public V put(K k2, V v2) {
        if (k2 == null) {
            throw new NullPointerException("key == null");
        }
        Node<K, V> node = this.find(k2, true);
        Object v3 = node.value;
        node.value = v2;
        return v3;
    }

    @Override
    public V remove(Object object) {
        Node<K, V> node = this.removeInternalByKey(object);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void removeInternal(Node<K, V> node, boolean bl2) {
        if (bl2) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
            node.prev = null;
            node.next = null;
        }
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node.parent;
        if (node2 != null && node3 != null) {
            Node node5 = node2.height > node3.height ? node2.last() : node3.first();
            this.removeInternal(node5, false);
            Node node6 = node.left;
            int n2 = 0;
            if (node6 != null) {
                n2 = node6.height;
                node5.left = node6;
                node6.parent = node5;
                node.left = null;
            }
            Node node7 = node.right;
            int n3 = 0;
            if (node7 != null) {
                n3 = node7.height;
                node5.right = node7;
                node7.parent = node5;
                node.right = null;
            }
            node5.height = 1 + Math.max(n2, n3);
            this.replaceInParent(node, node5);
            return;
        }
        if (node2 != null) {
            this.replaceInParent(node, node2);
            node.left = null;
        } else if (node3 != null) {
            this.replaceInParent(node, node3);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(node4, false);
        this.size = -1 + this.size;
        this.modCount = 1 + this.modCount;
    }

    Node<K, V> removeInternalByKey(Object object) {
        Node<K, V> node = this.findByObject(object);
        if (node != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    @Override
    public int size() {
        return this.size;
    }

    static final class AvlBuilder<K, V> {
        private int leavesSkipped;
        private int leavesToSkip;
        private int size;
        private Node<K, V> stack;

        AvlBuilder() {
        }

        /*
         * Enabled aggressive block sorting
         */
        void add(Node<K, V> node) {
            node.right = null;
            node.parent = null;
            node.left = null;
            node.height = 1;
            if (this.leavesToSkip > 0 && (1 & this.size) == 0) {
                this.size = 1 + this.size;
                this.leavesToSkip = -1 + this.leavesToSkip;
                this.leavesSkipped = 1 + this.leavesSkipped;
            }
            node.parent = this.stack;
            this.stack = node;
            this.size = 1 + this.size;
            if (this.leavesToSkip > 0 && (1 & this.size) == 0) {
                this.size = 1 + this.size;
                this.leavesToSkip = -1 + this.leavesToSkip;
                this.leavesSkipped = 1 + this.leavesSkipped;
            }
            int n2 = 4;
            while ((this.size & n2 - 1) == n2 - 1) {
                if (this.leavesSkipped == 0) {
                    Node<K, V> node2 = this.stack;
                    Node node3 = node2.parent;
                    Node node4 = node3.parent;
                    node3.parent = node4.parent;
                    this.stack = node3;
                    node3.left = node4;
                    node3.right = node2;
                    node3.height = 1 + node2.height;
                    node4.parent = node3;
                    node2.parent = node3;
                } else if (this.leavesSkipped == 1) {
                    Node<K, V> node5 = this.stack;
                    Node node6 = node5.parent;
                    this.stack = node6;
                    node6.right = node5;
                    node6.height = 1 + node5.height;
                    node5.parent = node6;
                    this.leavesSkipped = 0;
                } else if (this.leavesSkipped == 2) {
                    this.leavesSkipped = 0;
                }
                n2 *= 2;
            }
            return;
        }

        void reset(int n2) {
            this.leavesToSkip = -1 + 2 * Integer.highestOneBit(n2) - n2;
            this.size = 0;
            this.leavesSkipped = 0;
            this.stack = null;
        }

        Node<K, V> root() {
            Node<K, V> node = this.stack;
            if (node.parent != null) {
                throw new IllegalStateException();
            }
            return node;
        }
    }

    static class AvlIterator<K, V> {
        private Node<K, V> stackTop;

        AvlIterator() {
        }

        public Node<K, V> next() {
            Node<K, V> node = this.stackTop;
            if (node == null) {
                return null;
            }
            Node node2 = node.parent;
            node.parent = null;
            Node node3 = node.right;
            while (node3 != null) {
                node3.parent = node2;
                node2 = node3;
                node3 = node3.left;
            }
            this.stackTop = node2;
            return node;
        }

        void reset(Node<K, V> node) {
            Node<K, V> node2 = null;
            Node<K, V> node3 = node;
            while (node3 != null) {
                node3.parent = node2;
                node2 = node3;
                node3 = node3.left;
            }
            this.stackTop = node2;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            LinkedHashTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Map.Entry && LinkedHashTreeMap.this.findByEntry((Map.Entry)object) != null;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedTreeMapIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextNode();
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean remove(Object object) {
            Node node;
            if (!(object instanceof Map.Entry) || (node = LinkedHashTreeMap.this.findByEntry((Map.Entry)object)) == null) {
                return false;
            }
            LinkedHashTreeMap.this.removeInternal(node, true);
            return true;
        }

        @Override
        public int size() {
            return LinkedHashTreeMap.this.size;
        }
    }

    class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public void clear() {
            LinkedHashTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return LinkedHashTreeMap.this.containsKey(object);
        }

        @Override
        public Iterator<K> iterator() {
            return new LinkedTreeMapIterator<K>(){

                @Override
                public K next() {
                    return this.nextNode().key;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            return LinkedHashTreeMap.this.removeInternalByKey(object) != null;
        }

        @Override
        public int size() {
            return LinkedHashTreeMap.this.size;
        }
    }

    private abstract class LinkedTreeMapIterator<T>
    implements Iterator<T> {
        int expectedModCount;
        Node<K, V> lastReturned;
        Node<K, V> next;

        private LinkedTreeMapIterator() {
            this.next = LinkedHashTreeMap.this.header.next;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashTreeMap.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.next != LinkedHashTreeMap.this.header;
        }

        final Node<K, V> nextNode() {
            Node node = this.next;
            if (node == LinkedHashTreeMap.this.header) {
                throw new NoSuchElementException();
            }
            if (LinkedHashTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = node.next;
            this.lastReturned = node;
            return node;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LinkedHashTreeMap.this.removeInternal(this.lastReturned, true);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashTreeMap.this.modCount;
        }
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        int height;
        final K key;
        Node<K, V> left;
        Node<K, V> next;
        Node<K, V> parent;
        Node<K, V> prev;
        Node<K, V> right;
        V value;

        Node() {
            this.key = null;
            this.hash = -1;
            this.prev = this;
            this.next = this;
        }

        Node(Node<K, V> node, K k2, int n2, Node<K, V> node2, Node<K, V> node3) {
            this.parent = node;
            this.key = k2;
            this.hash = n2;
            this.height = 1;
            this.next = node2;
            this.prev = node3;
            node3.next = this;
            node2.prev = this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = false;
            if (!bl2) return bl3;
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                Object k2 = entry.getKey();
                bl3 = false;
                if (k2 != null) return bl3;
            } else {
                boolean bl4 = this.key.equals(entry.getKey());
                bl3 = false;
                if (!bl4) return bl3;
            }
            if (this.value == null) {
                Object v2 = entry.getValue();
                bl3 = false;
                if (v2 != null) return bl3;
                return true;
            } else {
                boolean bl5 = this.value.equals(entry.getValue());
                bl3 = false;
                if (!bl5) return bl3;
            }
            return true;
        }

        public Node<K, V> first() {
            Node<K, V> node = this;
            Node<K, V> node2 = node.left;
            while (node2 != null) {
                node = node2;
                node2 = node.left;
            }
            return node;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int hashCode() {
            int n2 = this.key == null ? 0 : this.key.hashCode();
            V v2 = this.value;
            int n3 = 0;
            if (v2 == null) {
                return n2 ^ n3;
            }
            n3 = this.value.hashCode();
            return n2 ^ n3;
        }

        public Node<K, V> last() {
            Node<K, V> node = this;
            Node<K, V> node2 = node.right;
            while (node2 != null) {
                node = node2;
                node2 = node.right;
            }
            return node;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

