/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.google.gson.internal;

import com.millennialmedia.google.gson.internal.$Gson$Preconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private $Gson$Types() {
    }

    public static GenericArrayType arrayOf(Type type) {
        return new GenericArrayTypeImpl(type);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            void var4_3;
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                GenericArrayTypeImpl genericArrayTypeImpl = new GenericArrayTypeImpl($Gson$Types.canonicalize(clazz.getComponentType()));
                return (Type)var4_3;
            }
            Class clazz2 = clazz;
            return (Type)var4_3;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new ParameterizedTypeImpl(parameterizedType.getOwnerType(), parameterizedType.getRawType(), parameterizedType.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(((GenericArrayType)type).getGenericComponentType());
        }
        if (!(type instanceof WildcardType)) return type;
        WildcardType wildcardType = (WildcardType)type;
        return new WildcardTypeImpl(wildcardType.getUpperBounds(), wildcardType.getLowerBounds());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkNotPrimitive(Type type) {
        boolean bl2 = !(type instanceof Class) || !((Class)type).isPrimitive();
        $Gson$Preconditions.checkArgument(bl2);
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object obj = typeVariable.getGenericDeclaration();
        if (obj instanceof Class) {
            return (Class)obj;
        }
        return null;
    }

    static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Type type, Type type2) {
        boolean bl2;
        boolean bl3 = true;
        if (type == type2) {
            return bl3;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            boolean bl4 = type2 instanceof ParameterizedType;
            bl2 = false;
            if (!bl4) return bl2;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ParameterizedType parameterizedType2 = (ParameterizedType)type2;
            if (!$Gson$Types.equal(parameterizedType.getOwnerType(), parameterizedType2.getOwnerType())) return false;
            if (!parameterizedType.getRawType().equals(parameterizedType2.getRawType())) return false;
            if (!Arrays.equals(parameterizedType.getActualTypeArguments(), parameterizedType2.getActualTypeArguments())) return false;
            return bl3;
        }
        if (type instanceof GenericArrayType) {
            boolean bl5 = type2 instanceof GenericArrayType;
            bl2 = false;
            if (!bl5) return bl2;
            GenericArrayType genericArrayType = (GenericArrayType)type;
            GenericArrayType genericArrayType2 = (GenericArrayType)type2;
            return $Gson$Types.equals(genericArrayType.getGenericComponentType(), genericArrayType2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            boolean bl6 = type2 instanceof WildcardType;
            bl2 = false;
            if (!bl6) return bl2;
            WildcardType wildcardType = (WildcardType)type;
            WildcardType wildcardType2 = (WildcardType)type2;
            if (!Arrays.equals(wildcardType.getUpperBounds(), wildcardType2.getUpperBounds())) return false;
            if (!Arrays.equals(wildcardType.getLowerBounds(), wildcardType2.getLowerBounds())) return false;
            return bl3;
        }
        boolean bl7 = type instanceof TypeVariable;
        bl2 = false;
        if (!bl7) return bl2;
        boolean bl8 = type2 instanceof TypeVariable;
        bl2 = false;
        if (!bl8) return bl2;
        TypeVariable typeVariable = (TypeVariable)type;
        TypeVariable typeVariable2 = (TypeVariable)type2;
        if (typeVariable.getGenericDeclaration() != typeVariable2.getGenericDeclaration()) return false;
        if (!typeVariable.getName().equals(typeVariable2.getName())) return false;
        return bl3;
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return ((Class)type).getComponentType();
    }

    public static Type getCollectionElementType(Type type, Class<?> clazz) {
        Type type2 = $Gson$Types.getSupertype(type, clazz, Collection.class);
        if (type2 instanceof WildcardType) {
            type2 = ((WildcardType)type2).getUpperBounds()[0];
        }
        if (type2 instanceof ParameterizedType) {
            return ((ParameterizedType)type2).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    static Type getGenericSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == clazz) {
            return type;
        }
        if (clazz2.isInterface()) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (classArray[i2] == clazz2) {
                    return clazz.getGenericInterfaces()[i2];
                }
                if (!clazz2.isAssignableFrom(classArray[i2])) continue;
                return $Gson$Types.getGenericSupertype(clazz.getGenericInterfaces()[i2], classArray[i2], clazz2);
            }
        }
        if (!clazz.isInterface()) {
            while (clazz != Object.class) {
                Class<?> clazz3 = clazz.getSuperclass();
                if (clazz3 == clazz2) {
                    return clazz.getGenericSuperclass();
                }
                if (clazz2.isAssignableFrom(clazz3)) {
                    return $Gson$Types.getGenericSupertype(clazz.getGenericSuperclass(), clazz3, clazz2);
                }
                clazz = clazz3;
            }
        }
        return clazz2;
    }

    public static Type[] getMapKeyAndValueTypes(Type type, Class<?> clazz) {
        if (type == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        Type type2 = $Gson$Types.getSupertype(type, clazz, Map.class);
        if (type2 instanceof ParameterizedType) {
            return ((ParameterizedType)type2).getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getRawType(Type type) {
        String string2;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)type).getRawType();
            $Gson$Preconditions.checkArgument(type2 instanceof Class);
            return (Class)type2;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance($Gson$Types.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return $Gson$Types.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type == null) {
            string2 = "null";
            throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + string2);
        }
        string2 = type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + string2);
    }

    static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        $Gson$Preconditions.checkArgument(clazz2.isAssignableFrom(clazz));
        return $Gson$Types.resolve(type, clazz, $Gson$Types.getGenericSupertype(type, clazz, clazz2));
    }

    private static int hashCodeOrZero(Object object) {
        if (object != null) {
            return object.hashCode();
        }
        return 0;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!object.equals(objectArray[i2])) continue;
            return i2;
        }
        throw new NoSuchElementException();
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type type, Type type2, Type ... typeArray) {
        return new ParameterizedTypeImpl(type, type2, typeArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Type resolve(Type type, Class<?> clazz, Type type2) {
        Type type3;
        while (type2 instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type2;
            if ((type2 = $Gson$Types.resolveTypeVariable(type, clazz, typeVariable)) != typeVariable) continue;
            return type2;
        }
        if (type2 instanceof Class && ((Class)type2).isArray()) {
            void var17_6;
            Type type4;
            Class clazz2 = (Class)type2;
            Class<?> clazz3 = clazz2.getComponentType();
            if (clazz3 == (type4 = $Gson$Types.resolve(type, clazz, clazz3))) {
                return var17_6;
            }
            GenericArrayType genericArrayType = $Gson$Types.arrayOf(type4);
            return var17_6;
        }
        if (type2 instanceof GenericArrayType) {
            Type type5;
            type3 = (GenericArrayType)type2;
            Type type6 = type3.getGenericComponentType();
            if (type6 == (type5 = $Gson$Types.resolve(type, clazz, type6))) return type3;
            return $Gson$Types.arrayOf(type5);
        }
        if (type2 instanceof ParameterizedType) {
            type3 = (ParameterizedType)type2;
            Type type7 = type3.getOwnerType();
            Type type8 = $Gson$Types.resolve(type, clazz, type7);
            boolean bl2 = type8 != type7;
            Type[] typeArray = type3.getActualTypeArguments();
            int n2 = 0;
            int n3 = typeArray.length;
            while (true) {
                if (n2 >= n3) {
                    if (!bl2) return type3;
                    return $Gson$Types.newParameterizedTypeWithOwner(type8, type3.getRawType(), typeArray);
                }
                Type type9 = $Gson$Types.resolve(type, clazz, typeArray[n2]);
                if (type9 != typeArray[n2]) {
                    if (!bl2) {
                        typeArray = (Type[])typeArray.clone();
                        bl2 = true;
                    }
                    typeArray[n2] = type9;
                }
                ++n2;
            }
        }
        if (!(type2 instanceof WildcardType)) return type2;
        type3 = (WildcardType)type2;
        Type[] typeArray = type3.getLowerBounds();
        Type[] typeArray2 = type3.getUpperBounds();
        if (typeArray.length == 1) {
            Type type10 = $Gson$Types.resolve(type, clazz, typeArray[0]);
            if (type10 == typeArray[0]) return type3;
            return $Gson$Types.supertypeOf(type10);
        }
        if (typeArray2.length != 1) return type3;
        Type type11 = $Gson$Types.resolve(type, clazz, typeArray2[0]);
        if (type11 == typeArray2[0]) return type3;
        return $Gson$Types.subtypeOf(type11);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Type type2;
        Class<?> clazz2 = $Gson$Types.declaringClassOf(typeVariable);
        if (clazz2 == null || !((type2 = $Gson$Types.getGenericSupertype(type, clazz, clazz2)) instanceof ParameterizedType)) {
            return typeVariable;
        }
        int n2 = $Gson$Types.indexOf(clazz2.getTypeParameters(), typeVariable);
        return ((ParameterizedType)type2).getActualTypeArguments()[n2];
    }

    public static WildcardType subtypeOf(Type type) {
        return new WildcardTypeImpl(new Type[]{type}, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type type) {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{type});
    }

    public static String typeToString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private static final long serialVersionUID;
        private final Type componentType;

        public GenericArrayTypeImpl(Type type) {
            this.componentType = $Gson$Types.canonicalize(type);
        }

        public boolean equals(Object object) {
            return object instanceof GenericArrayType && $Gson$Types.equals(this, (GenericArrayType)object);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return $Gson$Types.typeToString(this.componentType) + "[]";
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private static final long serialVersionUID;
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        /*
         * Enabled aggressive block sorting
         */
        public ParameterizedTypeImpl(Type type, Type type2, Type ... typeArray) {
            block5: {
                boolean bl2;
                block7: {
                    block6: {
                        if (!(type2 instanceof Class)) break block5;
                        Class clazz = (Class)type2;
                        boolean bl3 = type != null || clazz.getEnclosingClass() == null;
                        $Gson$Preconditions.checkArgument(bl3);
                        if (type == null) break block6;
                        Class<?> clazz2 = clazz.getEnclosingClass();
                        bl2 = false;
                        if (clazz2 == null) break block7;
                    }
                    bl2 = true;
                }
                $Gson$Preconditions.checkArgument(bl2);
            }
            Type type3 = type == null ? null : $Gson$Types.canonicalize(type);
            this.ownerType = type3;
            this.rawType = $Gson$Types.canonicalize(type2);
            this.typeArguments = (Type[])typeArray.clone();
            int n2 = 0;
            while (n2 < this.typeArguments.length) {
                $Gson$Preconditions.checkNotNull(this.typeArguments[n2]);
                $Gson$Types.checkNotPrimitive(this.typeArguments[n2]);
                this.typeArguments[n2] = $Gson$Types.canonicalize(this.typeArguments[n2]);
                ++n2;
            }
            return;
        }

        public boolean equals(Object object) {
            return object instanceof ParameterizedType && $Gson$Types.equals(this, (ParameterizedType)object);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ $Gson$Types.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(30 * (1 + this.typeArguments.length));
            stringBuilder.append($Gson$Types.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append("<").append($Gson$Types.typeToString(this.typeArguments[0]));
            for (int i2 = 1; i2 < this.typeArguments.length; ++i2) {
                stringBuilder.append(", ").append($Gson$Types.typeToString(this.typeArguments[i2]));
            }
            return stringBuilder.append(">").toString();
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private static final long serialVersionUID;
        private final Type lowerBound;
        private final Type upperBound;

        /*
         * Enabled aggressive block sorting
         */
        public WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            boolean bl2 = true;
            boolean bl3 = typeArray2.length <= bl2 ? bl2 : false;
            $Gson$Preconditions.checkArgument(bl3);
            boolean bl4 = typeArray.length == bl2 ? bl2 : false;
            $Gson$Preconditions.checkArgument(bl4);
            if (typeArray2.length != bl2) {
                $Gson$Preconditions.checkNotNull(typeArray[0]);
                $Gson$Types.checkNotPrimitive(typeArray[0]);
                this.lowerBound = null;
                this.upperBound = $Gson$Types.canonicalize(typeArray[0]);
                return;
            }
            $Gson$Preconditions.checkNotNull(typeArray2[0]);
            $Gson$Types.checkNotPrimitive(typeArray2[0]);
            if (typeArray[0] != Object.class) {
                bl2 = false;
            }
            $Gson$Preconditions.checkArgument(bl2);
            this.lowerBound = $Gson$Types.canonicalize(typeArray2[0]);
            this.upperBound = Object.class;
        }

        public boolean equals(Object object) {
            return object instanceof WildcardType && $Gson$Types.equals(this, (WildcardType)object);
        }

        @Override
        public Type[] getLowerBounds() {
            if (this.lowerBound != null) {
                Type[] typeArray = new Type[]{this.lowerBound};
                return typeArray;
            }
            return EMPTY_TYPE_ARRAY;
        }

        @Override
        public Type[] getUpperBounds() {
            Type[] typeArray = new Type[]{this.upperBound};
            return typeArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n2;
            if (this.lowerBound != null) {
                n2 = 31 + this.lowerBound.hashCode();
                return n2 ^ 31 + this.upperBound.hashCode();
            }
            n2 = 1;
            return n2 ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + $Gson$Types.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + $Gson$Types.typeToString(this.upperBound);
        }
    }
}

