/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.google.gson;

import com.millennialmedia.google.gson.Gson;
import com.millennialmedia.google.gson.JsonDeserializer;
import com.millennialmedia.google.gson.JsonElement;
import com.millennialmedia.google.gson.JsonSerializer;
import com.millennialmedia.google.gson.TypeAdapter;
import com.millennialmedia.google.gson.TypeAdapterFactory;
import com.millennialmedia.google.gson.internal.$Gson$Preconditions;
import com.millennialmedia.google.gson.internal.Streams;
import com.millennialmedia.google.gson.reflect.TypeToken;
import com.millennialmedia.google.gson.stream.JsonReader;
import com.millennialmedia.google.gson.stream.JsonWriter;
import java.io.IOException;

final class TreeTypeAdapter<T>
extends TypeAdapter<T> {
    private TypeAdapter<T> delegate;
    private final JsonDeserializer<T> deserializer;
    private final Gson gson;
    private final JsonSerializer<T> serializer;
    private final TypeAdapterFactory skipPast;
    private final TypeToken<T> typeToken;

    private TreeTypeAdapter(JsonSerializer<T> jsonSerializer, JsonDeserializer<T> jsonDeserializer, Gson gson, TypeToken<T> typeToken, TypeAdapterFactory typeAdapterFactory) {
        this.serializer = jsonSerializer;
        this.deserializer = jsonDeserializer;
        this.gson = gson;
        this.typeToken = typeToken;
        this.skipPast = typeAdapterFactory;
    }

    private TypeAdapter<T> delegate() {
        TypeAdapter<T> typeAdapter = this.delegate;
        if (typeAdapter != null) {
            return typeAdapter;
        }
        TypeAdapter<T> typeAdapter2 = this.gson.getDelegateAdapter(this.skipPast, this.typeToken);
        this.delegate = typeAdapter2;
        return typeAdapter2;
    }

    public static TypeAdapterFactory newFactory(TypeToken<?> typeToken, Object object) {
        return new SingleTypeFactory(object, typeToken, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeAdapterFactory newFactoryWithMatchRawType(TypeToken<?> typeToken, Object object) {
        boolean bl2;
        if (typeToken.getType() == typeToken.getRawType()) {
            bl2 = true;
            return new SingleTypeFactory(object, typeToken, bl2, null);
        }
        bl2 = false;
        return new SingleTypeFactory(object, typeToken, bl2, null);
    }

    public static TypeAdapterFactory newTypeHierarchyFactory(Class<?> clazz, Object object) {
        return new SingleTypeFactory(object, null, false, clazz);
    }

    @Override
    public T read(JsonReader jsonReader) throws IOException {
        if (this.deserializer == null) {
            return this.delegate().read(jsonReader);
        }
        JsonElement jsonElement = Streams.parse(jsonReader);
        if (jsonElement.isJsonNull()) {
            return null;
        }
        return this.deserializer.deserialize(jsonElement, this.typeToken.getType(), this.gson.deserializationContext);
    }

    @Override
    public void write(JsonWriter jsonWriter, T t2) throws IOException {
        if (this.serializer == null) {
            this.delegate().write(jsonWriter, t2);
            return;
        }
        if (t2 == null) {
            jsonWriter.nullValue();
            return;
        }
        Streams.write(this.serializer.serialize(t2, this.typeToken.getType(), this.gson.serializationContext), jsonWriter);
    }

    private static class SingleTypeFactory
    implements TypeAdapterFactory {
        private final JsonDeserializer<?> deserializer;
        private final TypeToken<?> exactType;
        private final Class<?> hierarchyType;
        private final boolean matchRawType;
        private final JsonSerializer<?> serializer;

        /*
         * Enabled aggressive block sorting
         */
        private SingleTypeFactory(Object object, TypeToken<?> typeToken, boolean bl2, Class<?> clazz) {
            JsonSerializer jsonSerializer = object instanceof JsonSerializer ? (JsonSerializer)object : null;
            this.serializer = jsonSerializer;
            JsonDeserializer jsonDeserializer = object instanceof JsonDeserializer ? (JsonDeserializer)object : null;
            this.deserializer = jsonDeserializer;
            boolean bl3 = this.serializer != null || this.deserializer != null;
            $Gson$Preconditions.checkArgument(bl3);
            this.exactType = typeToken;
            this.matchRawType = bl2;
            this.hierarchyType = clazz;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            boolean bl2;
            if (this.exactType != null) {
                if (!this.exactType.equals(typeToken)) {
                    if (!this.matchRawType) return null;
                    if (this.exactType.getType() != typeToken.getRawType()) return null;
                }
                bl2 = true;
            } else {
                bl2 = this.hierarchyType.isAssignableFrom(typeToken.getRawType());
            }
            if (!bl2) return null;
            return new TreeTypeAdapter(this.serializer, this.deserializer, gson, typeToken, this);
        }
    }
}

