/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.google.gson;

import com.millennialmedia.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;

public abstract class FieldNamingPolicy
extends Enum<FieldNamingPolicy>
implements FieldNamingStrategy {
    private static final /* synthetic */ FieldNamingPolicy[] $VALUES;
    public static final /* enum */ FieldNamingPolicy IDENTITY = new FieldNamingPolicy(){

        @Override
        public String translateName(Field field) {
            return field.getName();
        }
    };
    public static final /* enum */ FieldNamingPolicy LOWER_CASE_WITH_DASHES;
    public static final /* enum */ FieldNamingPolicy LOWER_CASE_WITH_UNDERSCORES;
    public static final /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE;
    public static final /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE_WITH_SPACES;

    static {
        UPPER_CAMEL_CASE = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return FieldNamingPolicy.upperCaseFirstLetter(field.getName());
            }
        };
        UPPER_CAMEL_CASE_WITH_SPACES = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return FieldNamingPolicy.upperCaseFirstLetter(FieldNamingPolicy.separateCamelCase(field.getName(), " "));
            }
        };
        LOWER_CASE_WITH_UNDERSCORES = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return FieldNamingPolicy.separateCamelCase(field.getName(), "_").toLowerCase();
            }
        };
        LOWER_CASE_WITH_DASHES = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return FieldNamingPolicy.separateCamelCase(field.getName(), "-").toLowerCase();
            }
        };
        FieldNamingPolicy[] fieldNamingPolicyArray = new FieldNamingPolicy[]{IDENTITY, UPPER_CAMEL_CASE, UPPER_CAMEL_CASE_WITH_SPACES, LOWER_CASE_WITH_UNDERSCORES, LOWER_CASE_WITH_DASHES};
        $VALUES = fieldNamingPolicyArray;
    }

    private static String modifyString(char c2, String string2, int n2) {
        if (n2 < string2.length()) {
            return c2 + string2.substring(n2);
        }
        return String.valueOf(c2);
    }

    private static String separateCamelCase(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (Character.isUpperCase(c2) && stringBuilder.length() != 0) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String upperCaseFirstLetter(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        char c2 = string2.charAt(0);
        while (true) {
            if (n2 >= -1 + string2.length() || Character.isLetter(c2)) {
                if (n2 != string2.length()) break;
                return stringBuilder.toString();
            }
            stringBuilder.append(c2);
            c2 = string2.charAt(++n2);
        }
        if (Character.isUpperCase(c2)) return string2;
        return stringBuilder.append(FieldNamingPolicy.modifyString(Character.toUpperCase(c2), string2, n2 + 1)).toString();
    }

    public static FieldNamingPolicy valueOf(String string2) {
        return Enum.valueOf(FieldNamingPolicy.class, string2);
    }

    public static FieldNamingPolicy[] values() {
        return (FieldNamingPolicy[])$VALUES.clone();
    }
}

