/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;
import android.widget.VideoView;
import com.millennialmedia.android.AdProperties;
import com.millennialmedia.android.HttpRedirection;
import com.millennialmedia.android.MMActivity;
import com.millennialmedia.android.MMBaseActivity;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.OverlaySettings;
import com.millennialmedia.android.VideoImage;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

class VideoPlayerActivity
extends MMBaseActivity
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener {
    private static final int CONTROLS_ID = 83756563;
    private static final String END_VIDEO = "endVideo";
    protected static final int MESSAGE_CHECK_PLAYING_VIDEO = 4;
    protected static final int MESSAGE_DELAYED_BUTTON = 3;
    protected static final int MESSAGE_INACTIVITY_ANIMATION = 1;
    protected static final int MESSAGE_ONE_SECOND_CHECK = 2;
    protected static final int MESSAGE_SET_TRANSPARENCY = 5;
    private static final String RESTART_VIDEO = "restartVideo";
    AdProperties adProperties;
    View blackView;
    protected int currentVideoPosition = 0;
    protected boolean hasBottomBar = true;
    private boolean hasFocus;
    boolean isPaused;
    boolean isUserPausing = false;
    protected boolean isVideoCompleted;
    private boolean isVideoCompletedOnce;
    String lastOverlayOrientation;
    protected VideoView mVideoView;
    Button pausePlay;
    ProgressBar progBar;
    HttpRedirection.RedirectionListenerImpl redirectListenerImpl;
    private boolean shouldSetUri = true;
    TransparentHandler transparentHandler = new TransparentHandler(this);
    RelativeLayout videoLayout;

    VideoPlayerActivity() {
    }

    static /* synthetic */ boolean access$102(VideoPlayerActivity videoPlayerActivity, boolean bl2) {
        videoPlayerActivity.shouldSetUri = bl2;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initBottomBar(RelativeLayout relativeLayout) {
        RelativeLayout relativeLayout2 = new RelativeLayout((Context)this.activity);
        relativeLayout2.setId(83756563);
        relativeLayout2.setBackgroundColor(-16777216);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        relativeLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams.addRule(12);
        Button button = new Button((Context)this.activity);
        this.pausePlay = new Button((Context)this.activity);
        Button button2 = new Button((Context)this.activity);
        button.setBackgroundResource(17301541);
        if (this.mVideoView.isPlaying()) {
            this.pausePlay.setBackgroundResource(17301539);
        } else {
            this.pausePlay.setBackgroundResource(17301540);
        }
        button2.setBackgroundResource(17301560);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-2, -2);
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-2, -2);
        RelativeLayout.LayoutParams layoutParams4 = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams2.addRule(14);
        relativeLayout2.addView((View)this.pausePlay, (ViewGroup.LayoutParams)layoutParams2);
        layoutParams4.addRule(0, this.pausePlay.getId());
        relativeLayout2.addView((View)button);
        layoutParams3.addRule(11);
        relativeLayout2.addView((View)button2, (ViewGroup.LayoutParams)layoutParams3);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (VideoPlayerActivity.this.mVideoView != null) {
                    VideoPlayerActivity.this.mVideoView.seekTo(0);
                }
            }
        });
        this.pausePlay.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void onClick(View view) {
                block8: {
                    block7: {
                        if (VideoPlayerActivity.this.mVideoView == null) break block7;
                        if (!VideoPlayerActivity.this.mVideoView.isPlaying()) break block8;
                        VideoPlayerActivity.this.pauseVideoByUser();
                        VideoPlayerActivity.this.pausePlay.setBackgroundResource(17301540);
                    }
                    return;
                }
                if (VideoPlayerActivity.this.isVideoCompleted) {
                    VideoPlayerActivity.this.playVideo(0);
                } else if (VideoPlayerActivity.this.isUserPausing && !VideoPlayerActivity.this.isVideoCompleted) {
                    VideoPlayerActivity.this.resumeVideo();
                } else {
                    VideoPlayerActivity.this.playVideo(VideoPlayerActivity.this.currentVideoPosition);
                }
                VideoPlayerActivity.this.pausePlay.setBackgroundResource(17301539);
            }
        });
        button2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (VideoPlayerActivity.this.mVideoView != null) {
                    VideoPlayerActivity.access$102(VideoPlayerActivity.this, true);
                    VideoPlayerActivity.this.dismiss();
                }
            }
        });
        relativeLayout.addView((View)relativeLayout2, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initRedirectListener() {
        this.redirectListenerImpl = new VideoRedirectionListener(this);
    }

    private void initVideoListeners() {
        this.mVideoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mVideoView.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mVideoView.setOnErrorListener((MediaPlayer.OnErrorListener)this);
    }

    private void initWindow() {
        this.requestWindowFeature(1);
        this.getWindow().clearFlags(2048);
        this.getWindow().addFlags(1024);
    }

    private boolean isActionSupported(String string2) {
        return string2 != null && (string2.equalsIgnoreCase(RESTART_VIDEO) || string2.equalsIgnoreCase(END_VIDEO));
    }

    private boolean isActionable(Uri uri) {
        if (uri.getScheme().equalsIgnoreCase("mmsdk")) {
            if (this.isActionSupported(uri.getHost())) {
                return true;
            }
            MMSDK.Log.v("Unrecognized mmsdk:// URI %s.", uri);
        }
        return false;
    }

    private void makeTransparent() {
        if (!this.transparentHandler.hasMessages(4)) {
            this.transparentHandler.sendEmptyMessage(4);
        }
    }

    private void startVideo(int n2) {
        this.mVideoView.requestFocus();
        this.mVideoView.seekTo(n2);
        if (((PowerManager)this.getSystemService("power")).isScreenOn()) {
            if (this.progBar != null) {
                this.progBar.bringToFront();
                this.progBar.setVisibility(0);
            }
            if (this.pausePlay != null) {
                this.pausePlay.setBackgroundResource(17301539);
            }
            this.mVideoView.start();
            this.makeTransparent();
        }
    }

    protected boolean canFadeButtons() {
        return !this.isVideoCompleted;
    }

    protected void dismiss() {
        MMSDK.Log.d("Video ad player closed");
        if (this.mVideoView != null) {
            if (this.mVideoView.isPlaying()) {
                this.mVideoView.stopPlayback();
            }
            this.mVideoView = null;
        }
        this.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    void dispatchButtonClick(String string2) {
        block3: {
            block2: {
                if (string2 == null) break block2;
                MMSDK.Log.d("Button Click with URL: %s", string2);
                this.redirectListenerImpl.url = string2;
                this.redirectListenerImpl.weakContext = new WeakReference<MMActivity>(this.activity);
                if (!this.redirectListenerImpl.isHandlingMMVideo(Uri.parse((String)string2))) break block3;
            }
            return;
        }
        HttpRedirection.startActivityFromUri(this.redirectListenerImpl);
    }

    protected void enableButtons() {
    }

    protected void endVideo() {
        MMSDK.Log.d("End Video.");
        if (this.mVideoView != null) {
            this.shouldSetUri = true;
            this.dismiss();
        }
    }

    protected void errorPlayVideo(String string2) {
        Toast.makeText((Context)this.activity, (CharSequence)"Sorry. There was a problem playing the video", (int)1).show();
        if (this.mVideoView != null) {
            this.mVideoView.stopPlayback();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleTransparentMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 4: {
                if (this.mVideoView != null && this.mVideoView.isPlaying() && this.mVideoView.getCurrentPosition() > 0) {
                    this.mVideoView.setBackgroundColor(0);
                    this.transparentHandler.sendEmptyMessageDelayed(5, 100L);
                    return;
                }
                this.transparentHandler.sendEmptyMessageDelayed(4, 50L);
                return;
            }
            case 5: {
                if (this.mVideoView == null || !this.mVideoView.isPlaying() || this.mVideoView.getCurrentPosition() <= 0) return;
                this.blackView.setVisibility(4);
                this.progBar.setVisibility(4);
                return;
            }
        }
    }

    protected RelativeLayout initLayout() {
        RelativeLayout relativeLayout = new RelativeLayout((Context)this.activity);
        relativeLayout.setId(400);
        relativeLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        relativeLayout.setBackgroundColor(-16777216);
        this.videoLayout = new RelativeLayout((Context)this.activity);
        this.videoLayout.setBackgroundColor(-16777216);
        this.videoLayout.setId(410);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams2.addRule(13);
        layoutParams.addRule(13);
        this.mVideoView = new VideoView((Context)this.activity);
        this.mVideoView.setId(411);
        this.mVideoView.getHolder().setFormat(-2);
        this.mVideoView.setBackgroundColor(-16777216);
        this.initVideoListeners();
        this.videoLayout.addView((View)this.mVideoView, (ViewGroup.LayoutParams)layoutParams2);
        this.blackView = new View((Context)this.activity);
        this.blackView.setBackgroundColor(-16777216);
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-1, -1);
        relativeLayout.addView((View)this.videoLayout, (ViewGroup.LayoutParams)layoutParams);
        if (this.hasBottomBar) {
            layoutParams3.addRule(2, 83756563);
            this.initBottomBar(relativeLayout);
        }
        this.blackView.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        relativeLayout.addView(this.blackView);
        this.progBar = new ProgressBar((Context)this.activity);
        this.progBar.setIndeterminate(true);
        RelativeLayout.LayoutParams layoutParams4 = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams4.addRule(13);
        this.progBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
        relativeLayout.addView((View)this.progBar);
        this.progBar.setVisibility(4);
        return relativeLayout;
    }

    protected void initSavedInstance(Bundle bundle) {
        if (bundle != null) {
            this.isVideoCompleted = bundle.getBoolean("videoCompleted");
            this.isVideoCompletedOnce = bundle.getBoolean("videoCompletedOnce");
            this.currentVideoPosition = bundle.getInt("videoPosition");
            this.hasBottomBar = bundle.getBoolean("hasBottomBar");
            this.shouldSetUri = bundle.getBoolean("shouldSetUri");
        }
    }

    protected boolean isPlayable() {
        return this.mVideoView != null && !this.mVideoView.isPlaying() && !this.isVideoCompleted;
    }

    protected void logButtonEvent(VideoImage videoImage) {
        MMSDK.Log.d("Cached video button event logged");
        for (int i2 = 0; i2 < videoImage.eventLoggingUrls.length; ++i2) {
            MMSDK.Event.logEvent(videoImage.eventLoggingUrls[i2]);
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        this.isVideoCompletedOnce = true;
        this.isVideoCompleted = true;
        if (this.pausePlay != null && !this.mVideoView.isPlaying()) {
            this.pausePlay.setBackgroundResource(17301540);
        }
        MMSDK.Log.v("Video player on complete");
    }

    @Override
    public void onCreate(Bundle bundle) {
        this.setTheme(16973829);
        super.onCreate(bundle);
        MMSDK.Log.d("Setting up the video player");
        this.initWindow();
        this.initSavedInstance(bundle);
        this.initRedirectListener();
        this.setContentView((View)this.initLayout());
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        return false;
    }

    @Override
    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (n2 == 4 && keyEvent.getRepeatCount() == 0 && !this.isVideoCompletedOnce) {
            return true;
        }
        return super.onKeyDown(n2, keyEvent);
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.isPaused = true;
        MMSDK.Log.v("VideoPlayer - onPause");
        this.pauseVideo();
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        MMSDK.Log.d("Video Prepared");
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        this.currentVideoPosition = bundle.getInt("currentVideoPosition");
        this.isVideoCompleted = bundle.getBoolean("isVideoCompleted");
        this.isVideoCompletedOnce = bundle.getBoolean("isVideoCompletedOnce");
        this.hasBottomBar = bundle.getBoolean("hasBottomBar", this.hasBottomBar);
        this.shouldSetUri = bundle.getBoolean("shouldSetUri", this.shouldSetUri);
        this.isUserPausing = bundle.getBoolean("isUserPausing", this.isUserPausing);
        this.isPaused = bundle.getBoolean("isPaused", this.isPaused);
        super.onRestoreInstanceState(bundle);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.blackView.bringToFront();
        this.blackView.setVisibility(0);
        this.isPaused = false;
        MMSDK.Log.v("VideoPlayer - onResume");
        if (this.hasFocus && !this.isUserPausing) {
            this.resumeVideo();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        bundle.putInt("currentVideoPosition", this.currentVideoPosition);
        bundle.putBoolean("isVideoCompleted", this.isVideoCompleted);
        bundle.putBoolean("isVideoCompletedOnce", this.isVideoCompletedOnce);
        bundle.putBoolean("hasBottomBar", this.hasBottomBar);
        bundle.putBoolean("shouldSetUri", this.shouldSetUri);
        bundle.putBoolean("isUserPausing", this.isUserPausing);
        bundle.putBoolean("isPaused", this.isPaused);
        super.onSaveInstanceState(bundle);
    }

    @Override
    public void onWindowFocusChanged(boolean bl2) {
        super.onWindowFocusChanged(bl2);
        this.hasFocus = bl2;
        if (!this.isPaused && bl2 && !this.isUserPausing) {
            this.resumeVideo();
        }
    }

    protected void pauseVideo() {
        if (this.mVideoView != null && this.mVideoView.isPlaying()) {
            this.currentVideoPosition = this.mVideoView.getCurrentPosition();
            this.mVideoView.pause();
            MMSDK.Log.v("Video paused");
        }
    }

    protected void pauseVideoByUser() {
        this.isUserPausing = true;
        this.pauseVideo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void playVideo(int n2) {
        try {
            this.isUserPausing = false;
            String string2 = this.getIntent().getData().toString();
            MMSDK.Log.d("playVideo path: %s", string2);
            if (string2 == null || string2.length() == 0 || this.mVideoView == null) {
                this.errorPlayVideo("no name or null videoview");
                return;
            }
            this.isVideoCompleted = false;
            if (this.shouldSetUri && this.mVideoView != null) {
                this.mVideoView.setVideoURI(Uri.parse((String)string2));
            }
            this.startVideo(n2);
            return;
        }
        catch (Exception exception) {
            MMSDK.Log.e("error: " + exception.getMessage(), exception);
            this.errorPlayVideo("error: " + exception.getMessage());
            return;
        }
    }

    void processVideoPlayerUri(final String string2) {
        this.runOnUiThread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                if (string2.equalsIgnoreCase(VideoPlayerActivity.RESTART_VIDEO)) {
                    VideoPlayerActivity.this.restartVideo();
                    return;
                } else {
                    if (!string2.equalsIgnoreCase(VideoPlayerActivity.END_VIDEO)) return;
                    VideoPlayerActivity.this.endVideo();
                    return;
                }
            }
        });
    }

    protected void restartVideo() {
        MMSDK.Log.d("Restart Video.");
        if (this.mVideoView != null) {
            this.playVideo(0);
        }
    }

    protected void resumeVideo() {
        if (this.isPlayable()) {
            this.playVideo(this.currentVideoPosition);
        }
    }

    protected void setButtonAlpha(ImageButton imageButton, float f2) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(f2, f2);
        alphaAnimation.setDuration(0L);
        alphaAnimation.setFillEnabled(true);
        alphaAnimation.setFillBefore(true);
        alphaAnimation.setFillAfter(true);
        imageButton.startAnimation((Animation)alphaAnimation);
    }

    private static class TransparentHandler
    extends Handler {
        private WeakReference<VideoPlayerActivity> activityRef;

        public TransparentHandler(VideoPlayerActivity videoPlayerActivity) {
            this.activityRef = new WeakReference<VideoPlayerActivity>(videoPlayerActivity);
        }

        public void handleMessage(Message message) {
            VideoPlayerActivity videoPlayerActivity = (VideoPlayerActivity)this.activityRef.get();
            if (videoPlayerActivity != null) {
                videoPlayerActivity.handleTransparentMessage(message);
            }
        }
    }

    static class VideoRedirectionListener
    extends HttpRedirection.RedirectionListenerImpl {
        WeakReference<VideoPlayerActivity> activityRef;

        public VideoRedirectionListener(VideoPlayerActivity videoPlayerActivity) {
            if (videoPlayerActivity != null) {
                this.activityRef = new WeakReference<VideoPlayerActivity>(videoPlayerActivity);
                if (videoPlayerActivity.activity != null) {
                    this.creatorAdImplInternalId = videoPlayerActivity.activity.creatorAdImplInternalId;
                }
            }
        }

        @Override
        public JSONObject getAdProperties() {
            VideoPlayerActivity videoPlayerActivity = (VideoPlayerActivity)this.activityRef.get();
            if (videoPlayerActivity != null && videoPlayerActivity.adProperties != null) {
                return videoPlayerActivity.adProperties.getAdProperties();
            }
            return null;
        }

        @Override
        public OverlaySettings getOverlaySettings() {
            VideoPlayerActivity videoPlayerActivity = (VideoPlayerActivity)this.activityRef.get();
            OverlaySettings overlaySettings = null;
            if (videoPlayerActivity != null) {
                String string2 = videoPlayerActivity.lastOverlayOrientation;
                overlaySettings = null;
                if (string2 != null) {
                    overlaySettings = new OverlaySettings();
                    overlaySettings.orientation = videoPlayerActivity.lastOverlayOrientation;
                }
            }
            return overlaySettings;
        }

        @Override
        public boolean isHandlingMMVideo(Uri uri) {
            final VideoPlayerActivity videoPlayerActivity = (VideoPlayerActivity)this.activityRef.get();
            if (videoPlayerActivity != null) {
                videoPlayerActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        videoPlayerActivity.enableButtons();
                    }
                });
                if (uri != null && videoPlayerActivity.isActionable(uri)) {
                    videoPlayerActivity.processVideoPlayerUri(uri.getHost());
                    return true;
                }
            }
            return false;
        }
    }
}

