/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.json.JSONArray;
import org.json.JSONObject;

class VideoImage
implements Parcelable,
Externalizable {
    public static final Parcelable.Creator<VideoImage> CREATOR = new Parcelable.Creator<VideoImage>(){

        public VideoImage createFromParcel(Parcel parcel) {
            return new VideoImage(parcel);
        }

        public VideoImage[] newArray(int n2) {
            return new VideoImage[n2];
        }
    };
    static final long serialVersionUID = 808334584720834205L;
    int anchor;
    int anchor2;
    long appearanceDelay;
    ImageButton button;
    long contentLength;
    String[] eventLoggingUrls;
    long fadeDuration;
    float fromAlpha;
    String imageUrl;
    long inactivityTimeout;
    boolean isLeaveBehind;
    RelativeLayout.LayoutParams layoutParams;
    String linkUrl;
    String overlayOrientation;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int paddingTop;
    int position;
    int position2;
    float toAlpha;

    public VideoImage() {
        this.paddingTop = 0;
        this.paddingBottom = 0;
        this.paddingLeft = 0;
        this.paddingRight = 0;
        this.fromAlpha = 1.0f;
        this.toAlpha = 1.0f;
        this.fadeDuration = 1000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    VideoImage(Parcel parcel) {
        int n2 = 1;
        this.paddingTop = 0;
        this.paddingBottom = 0;
        this.paddingLeft = 0;
        this.paddingRight = 0;
        this.fromAlpha = 1.0f;
        this.toAlpha = 1.0f;
        this.fadeDuration = 1000L;
        try {
            this.imageUrl = parcel.readString();
            this.contentLength = parcel.readLong();
            this.eventLoggingUrls = new String[parcel.readInt()];
            parcel.readStringArray(this.eventLoggingUrls);
            this.linkUrl = parcel.readString();
            this.overlayOrientation = parcel.readString();
            this.paddingTop = parcel.readInt();
            this.paddingBottom = parcel.readInt();
            this.paddingLeft = parcel.readInt();
            this.paddingRight = parcel.readInt();
            this.position = parcel.readInt();
            this.anchor = parcel.readInt();
            this.position2 = parcel.readInt();
            this.anchor2 = parcel.readInt();
            this.appearanceDelay = parcel.readLong();
            this.inactivityTimeout = parcel.readLong();
            this.fromAlpha = parcel.readFloat();
            this.toAlpha = parcel.readFloat();
            this.fadeDuration = parcel.readLong();
            if (parcel.readInt() != n2) {
                n2 = 0;
            }
            this.isLeaveBehind = n2;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    VideoImage(JSONObject jSONObject) {
        this.paddingTop = 0;
        this.paddingBottom = 0;
        this.paddingLeft = 0;
        this.paddingRight = 0;
        this.fromAlpha = 1.0f;
        this.toAlpha = 1.0f;
        this.fadeDuration = 1000L;
        this.deserializeFromObj(jSONObject);
    }

    private void deserializeFromObj(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        this.imageUrl = jSONObject.optString("image", null);
        this.contentLength = jSONObject.optLong("contentLength");
        JSONArray jSONArray = jSONObject.optJSONArray("activity");
        if (jSONArray != null) {
            this.eventLoggingUrls = new String[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                this.eventLoggingUrls[i2] = jSONArray.optString(i2);
            }
        } else {
            this.eventLoggingUrls = new String[0];
        }
        this.linkUrl = jSONObject.optString("url", null);
        this.overlayOrientation = jSONObject.optString("overlayOrientation", null);
        this.position = jSONObject.optInt("android-layout");
        this.anchor = jSONObject.optInt("android-layoutAnchor");
        this.position2 = jSONObject.optInt("android-layout2");
        this.anchor2 = jSONObject.optInt("android-layoutAnchor2");
        this.paddingTop = jSONObject.optInt("android-paddingTop");
        this.paddingLeft = jSONObject.optInt("android-paddingLeft");
        this.paddingRight = jSONObject.optInt("android-paddingRight");
        this.paddingBottom = jSONObject.optInt("android-paddingBottom");
        this.appearanceDelay = (long)(1000.0 * jSONObject.optDouble("appearanceDelay", 0.0));
        this.inactivityTimeout = (long)(1000.0 * jSONObject.optDouble("inactivityTimeout", 0.0));
        JSONObject jSONObject2 = jSONObject.optJSONObject("opacity");
        if (jSONObject2 != null) {
            this.fromAlpha = (float)jSONObject2.optDouble("start", 1.0);
            this.toAlpha = (float)jSONObject2.optDouble("end", 1.0);
            this.fadeDuration = (long)(1000.0 * jSONObject2.optDouble("fadeDuration", 1.0));
        }
        this.isLeaveBehind = jSONObject.optBoolean("is_leavebehind");
    }

    public int describeContents() {
        return 0;
    }

    String getImageName() {
        Uri uri;
        if (this.imageUrl != null && (uri = Uri.parse((String)this.imageUrl)) != null && uri.getLastPathSegment() != null) {
            return uri.getLastPathSegment().replaceFirst("\\.[^\\.]*$", ".dat");
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.imageUrl = (String)objectInput.readObject();
        this.contentLength = objectInput.readLong();
        int n2 = objectInput.readInt();
        this.eventLoggingUrls = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.eventLoggingUrls[i2] = (String)objectInput.readObject();
        }
        this.linkUrl = (String)objectInput.readObject();
        this.overlayOrientation = (String)objectInput.readObject();
        this.paddingTop = objectInput.readInt();
        this.paddingBottom = objectInput.readInt();
        this.paddingLeft = objectInput.readInt();
        this.paddingRight = objectInput.readInt();
        this.position = objectInput.readInt();
        this.anchor = objectInput.readInt();
        this.position2 = objectInput.readInt();
        this.anchor2 = objectInput.readInt();
        this.appearanceDelay = objectInput.readLong();
        this.inactivityTimeout = objectInput.readLong();
        this.fromAlpha = objectInput.readFloat();
        this.toAlpha = objectInput.readFloat();
        this.fadeDuration = objectInput.readLong();
        this.isLeaveBehind = objectInput.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.imageUrl);
        objectOutput.writeLong(this.contentLength);
        objectOutput.writeInt(this.eventLoggingUrls.length);
        String[] stringArray = this.eventLoggingUrls;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectOutput.writeObject(stringArray[i2]);
        }
        objectOutput.writeObject(this.linkUrl);
        objectOutput.writeObject(this.overlayOrientation);
        objectOutput.writeInt(this.paddingTop);
        objectOutput.writeInt(this.paddingBottom);
        objectOutput.writeInt(this.paddingLeft);
        objectOutput.writeInt(this.paddingRight);
        objectOutput.writeInt(this.position);
        objectOutput.writeInt(this.anchor);
        objectOutput.writeInt(this.position2);
        objectOutput.writeInt(this.anchor2);
        objectOutput.writeLong(this.appearanceDelay);
        objectOutput.writeLong(this.inactivityTimeout);
        objectOutput.writeFloat(this.fromAlpha);
        objectOutput.writeFloat(this.toAlpha);
        objectOutput.writeLong(this.fadeDuration);
        objectOutput.writeBoolean(this.isLeaveBehind);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.imageUrl);
        parcel.writeLong(this.contentLength);
        parcel.writeInt(this.eventLoggingUrls.length);
        parcel.writeStringArray(this.eventLoggingUrls);
        parcel.writeString(this.linkUrl);
        parcel.writeString(this.overlayOrientation);
        parcel.writeInt(this.paddingTop);
        parcel.writeInt(this.paddingBottom);
        parcel.writeInt(this.paddingLeft);
        parcel.writeInt(this.paddingRight);
        parcel.writeInt(this.position);
        parcel.writeInt(this.anchor);
        parcel.writeInt(this.position2);
        parcel.writeInt(this.anchor2);
        parcel.writeLong(this.appearanceDelay);
        parcel.writeLong(this.inactivityTimeout);
        parcel.writeFloat(this.fromAlpha);
        parcel.writeFloat(this.toAlpha);
        parcel.writeLong(this.fadeDuration);
        int n3 = this.isLeaveBehind ? 1 : 0;
        parcel.writeInt(n3);
    }
}

