/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.CachedAd;
import com.millennialmedia.android.DTOCachedVideo;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.HttpGetRequest;
import com.millennialmedia.android.HttpRedirection;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.Utils;
import com.millennialmedia.android.VideoImage;
import com.millennialmedia.android.VideoLogEvent;
import java.io.Externalizable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class VideoAd
extends CachedAd
implements Parcelable,
Externalizable {
    public static final Parcelable.Creator<VideoAd> CREATOR = new Parcelable.Creator<VideoAd>(){

        public VideoAd createFromParcel(Parcel parcel) {
            return new VideoAd(parcel);
        }

        public VideoAd[] newArray(int n2) {
            return new VideoAd[n2];
        }
    };
    static final String VIDEO_FILE_ID = "video.dat";
    static final long serialVersionUID = 2679125946930815832L;
    ArrayList<VideoLogEvent> activities;
    ArrayList<VideoImage> buttons = new ArrayList();
    String[] cacheComplete;
    String[] cacheFailed;
    String cacheMissURL;
    DTOCachedVideo cachedVideoDto;
    long closeDelayMillis;
    long contentLength;
    long duration;
    String[] endActivity;
    String endOverlayURL;
    String onCompletionUrl;
    boolean reloadNonEndOverlayOnRestart;
    boolean showControls;
    boolean showCountdown;
    String[] startActivity;
    boolean stayInPlayer;
    boolean usingInternalStorage;
    String[] videoError;
    private String videoFileId;
    String webOverlayURL;

    public VideoAd() {
        this.activities = new ArrayList();
    }

    VideoAd(Parcel parcel) {
        super(parcel);
        this.activities = new ArrayList();
        try {
            this.startActivity = new String[parcel.readInt()];
            parcel.readStringArray(this.startActivity);
            this.endActivity = new String[parcel.readInt()];
            parcel.readStringArray(this.endActivity);
            boolean[] blArray = new boolean[5];
            parcel.readBooleanArray(blArray);
            this.showControls = blArray[0];
            this.stayInPlayer = blArray[1];
            this.showCountdown = blArray[2];
            this.reloadNonEndOverlayOnRestart = blArray[3];
            this.usingInternalStorage = blArray[4];
            this.onCompletionUrl = parcel.readString();
            this.webOverlayURL = parcel.readString();
            this.endOverlayURL = parcel.readString();
            this.cacheMissURL = parcel.readString();
            this.videoFileId = parcel.readString();
            this.duration = parcel.readLong();
            this.contentLength = parcel.readLong();
            this.closeDelayMillis = parcel.readLong();
            this.buttons = parcel.readArrayList(VideoImage.class.getClassLoader());
            this.activities = parcel.readArrayList(VideoLogEvent.class.getClassLoader());
            this.cacheComplete = new String[parcel.readInt()];
            parcel.readStringArray(this.cacheComplete);
            this.cacheFailed = new String[parcel.readInt()];
            parcel.readStringArray(this.cacheFailed);
            this.videoError = new String[parcel.readInt()];
            parcel.readStringArray(this.videoError);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    VideoAd(String string2) {
        JSONObject jSONObject;
        this.activities = new ArrayList();
        if (string2 == null) return;
        try {
            JSONObject jSONObject2;
            jSONObject = jSONObject2 = new JSONObject(string2);
            if (jSONObject == null) return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
        JSONObject jSONObject3 = jSONObject.optJSONObject("video");
        if (jSONObject3 == null) return;
        this.deserializeFromObj(jSONObject3);
    }

    static boolean downloadVideoFile(Context context, String string2, String string3) {
        File file = AdCache.getCacheDirectory(context);
        if (file == null || !file.isDirectory()) {
            return false;
        }
        MMSDK.Log.v("Downloading (" + string3 + VIDEO_FILE_ID + ") content to %s", file);
        boolean bl2 = AdCache.downloadComponent(string2, string3 + VIDEO_FILE_ID, file, context);
        String string4 = "Caching completed successfully (" + string3 + VIDEO_FILE_ID + ")? %b";
        Object[] objectArray = new Object[]{bl2};
        MMSDK.Log.v(string4, objectArray);
        return bl2;
    }

    static Uri getVideoUri(Context context, String string2) {
        return Uri.fromFile((File)AdCache.getDownloadFile(context, string2 + VIDEO_FILE_ID));
    }

    private void handleSharedVideoFile(Context context) {
        AdCache.iterateCachedAds(context, 2, new VideoIterator(context, this));
    }

    static boolean hasVideoFile(Context context, String string2) {
        return AdCache.hasDownloadFile(context, string2 + VIDEO_FILE_ID);
    }

    static void playAd(Context context, String string2, HttpRedirection.RedirectionListenerImpl redirectionListenerImpl) {
        block3: {
            block2: {
                if (string2 == null) break block2;
                VideoAd videoAd = (VideoAd)AdCache.load(context, string2);
                if (videoAd == null || !videoAd.canShow(context, null, false)) break block3;
                redirectionListenerImpl.updateLastVideoViewedTime();
                MMSDK.Log.v("mmvideo: attempting to play video %s", string2);
                videoAd.show(context, redirectionListenerImpl.creatorAdImplInternalId);
                redirectionListenerImpl.startingVideo();
            }
            return;
        }
        MMSDK.Log.v("mmvideo: Ad %s cannot be shown at this time.", string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    boolean canShow(Context context, MMAdImpl mMAdImpl, boolean bl2) {
        if (bl2) {
            if (!this.isExpired() && this.isOnDisk(context) && HandShake.sharedHandShake(context).canDisplayCachedAd(mMAdImpl.adType, this.deferredViewStart)) return true;
            return false;
        }
        if (this.isExpired() || !this.isOnDisk(context)) return false;
        return true;
    }

    @Override
    void delete(Context context) {
        super.delete(context);
        this.handleSharedVideoFile(context);
        AdCache.cachedVideoWasRemoved(context, this.acid);
        Object[] objectArray = new Object[]{this.getId()};
        MMSDK.Log.v("Ad %s was deleted.", objectArray);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    protected void deserializeFromObj(JSONObject jSONObject) {
        JSONArray jSONArray;
        JSONArray jSONArray2;
        JSONArray jSONArray3;
        JSONArray jSONArray4;
        JSONArray jSONArray5;
        super.deserializeFromObj(jSONObject);
        JSONArray jSONArray6 = jSONObject.optJSONArray("startActivity");
        this.webOverlayURL = jSONObject.optString("overlayURL", null);
        this.endOverlayURL = jSONObject.optString("endURL", null);
        this.cacheMissURL = jSONObject.optString("cacheMissURL", null);
        this.videoFileId = jSONObject.optString("videoFileId", null);
        if (jSONArray6 != null) {
            this.startActivity = new String[jSONArray6.length()];
            for (int i2 = 0; i2 < jSONArray6.length(); ++i2) {
                this.startActivity[i2] = jSONArray6.optString(i2);
            }
        } else {
            this.startActivity = new String[0];
        }
        if ((jSONArray5 = jSONObject.optJSONArray("endActivity")) != null) {
            this.endActivity = new String[jSONArray5.length()];
            for (int i3 = 0; i3 < jSONArray5.length(); ++i3) {
                this.endActivity[i3] = jSONArray5.optString(i3);
            }
        } else {
            this.endActivity = new String[0];
        }
        if ((jSONArray4 = jSONObject.optJSONArray("cacheComplete")) != null) {
            this.cacheComplete = new String[jSONArray4.length()];
            for (int i4 = 0; i4 < jSONArray4.length(); ++i4) {
                this.cacheComplete[i4] = jSONArray4.optString(i4);
            }
        } else {
            this.cacheComplete = new String[0];
        }
        if ((jSONArray3 = jSONObject.optJSONArray("cacheFailed")) != null) {
            this.cacheFailed = new String[jSONArray3.length()];
            for (int i5 = 0; i5 < jSONArray3.length(); ++i5) {
                this.cacheFailed[i5] = jSONArray3.optString(i5);
            }
        } else {
            this.cacheFailed = new String[0];
        }
        if ((jSONArray2 = jSONObject.optJSONArray("videoError")) != null) {
            this.videoError = new String[jSONArray2.length()];
            for (int i6 = 0; i6 < jSONArray2.length(); ++i6) {
                this.videoError[i6] = jSONArray2.optString(i6);
            }
        } else {
            this.videoError = new String[0];
        }
        this.showControls = jSONObject.optBoolean("showVideoPlayerControls");
        this.showCountdown = jSONObject.optBoolean("showCountdownHUD");
        this.reloadNonEndOverlayOnRestart = jSONObject.optBoolean("reloadOverlayOnRestart");
        JSONObject jSONObject2 = jSONObject.optJSONObject("onCompletion");
        if (jSONObject2 != null) {
            this.onCompletionUrl = jSONObject2.optString("url", null);
            this.stayInPlayer = jSONObject2.optBoolean("stayInPlayer");
        }
        this.duration = (long)(1000.0 * jSONObject.optDouble("duration", 0.0));
        this.contentLength = jSONObject.optLong("contentLength");
        this.closeDelayMillis = jSONObject.optLong("closeAfterDelay");
        JSONArray jSONArray7 = jSONObject.optJSONArray("buttons");
        if (jSONArray7 != null) {
            for (int i7 = 0; i7 < jSONArray7.length(); ++i7) {
                JSONObject jSONObject3 = jSONArray7.optJSONObject(i7);
                if (jSONObject3 == null) continue;
                VideoImage videoImage = new VideoImage(jSONObject3);
                this.buttons.add(videoImage);
            }
        }
        if ((jSONArray = jSONObject.optJSONArray("log")) != null) {
            for (int i8 = 0; i8 < jSONArray.length(); ++i8) {
                JSONObject jSONObject4 = jSONArray.optJSONObject(i8);
                if (jSONObject4 == null) continue;
                VideoLogEvent videoLogEvent = new VideoLogEvent(jSONObject4);
                this.activities.add(videoLogEvent);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    boolean download(Context context) {
        File file = AdCache.getCacheDirectory(context);
        if (file == null || !file.isDirectory()) {
            return false;
        }
        this.usingInternalStorage = AdCache.isInternalDir(context, file);
        MMSDK.Log.v("Downloading content to %s", file);
        boolean bl2 = AdCache.downloadComponent(this.contentUrl, this.videoFileId + VIDEO_FILE_ID, file, context);
        if (bl2) {
            for (int i2 = 0; i2 < this.buttons.size(); ++i2) {
                VideoImage videoImage = this.buttons.get(i2);
                bl2 = AdCache.downloadComponent(videoImage.imageUrl, this.getId() + videoImage.getImageName(), file, context);
                if (!bl2) break;
            }
        }
        if (!bl2) {
            if (this.downloadAllOrNothing) {
                this.delete(context);
            }
            HttpGetRequest.log(this.cacheFailed);
        } else if (bl2) {
            if (this.acid != null && this.acid.length() > 0) {
                AdCache.cachedVideoWasAdded(context, this.acid);
            }
            HttpGetRequest.log(this.cacheComplete);
        }
        Object[] objectArray = new Object[]{bl2};
        MMSDK.Log.v("Caching completed successfully? %b", objectArray);
        return bl2;
    }

    @Override
    int getType() {
        return 1;
    }

    @Override
    String getTypeString() {
        return "Video";
    }

    Intent getVideoExtrasIntent(Context context, long l2) {
        Intent intent = new Intent();
        intent.putExtra("videoId", this.getId());
        if (l2 != -4L) {
            intent.putExtra("internalId", l2);
        }
        intent.setData(Uri.parse((String)(AdCache.getCacheDirectory(context).getAbsolutePath() + File.separator + this.videoFileId + VIDEO_FILE_ID)));
        return intent;
    }

    boolean hasEndCard() {
        Iterator<VideoImage> iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isLeaveBehind) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean isOnDisk(Context context) {
        VideoImage videoImage;
        File file = AdCache.getCacheDirectory(context);
        boolean bl2 = false;
        if (file == null) return bl2;
        boolean bl3 = file.exists();
        bl2 = false;
        if (!bl3) return bl2;
        String[] stringArray = file.list(new VideoFilenameFilter(this));
        bl2 = false;
        if (stringArray != null) {
            int n2 = stringArray.length;
            int n3 = 1 + this.buttons.size();
            bl2 = false;
            if (n2 >= n3) {
                bl2 = true;
            }
        }
        if (!bl2) return bl2;
        if (!new File(file, this.videoFileId + VIDEO_FILE_ID).exists()) {
            return false;
        }
        Iterator<VideoImage> iterator = this.buttons.iterator();
        do {
            if (!iterator.hasNext()) return bl2;
            videoImage = iterator.next();
        } while (new File(file, this.getId() + videoImage.getImageName()).exists());
        return false;
    }

    void logBeginEvent() {
        if (this.startActivity != null) {
            MMSDK.Log.d("Cached video begin event logged");
            for (int i2 = 0; i2 < this.startActivity.length; ++i2) {
                MMSDK.Event.logEvent(this.startActivity[i2]);
            }
        }
    }

    void logEndEvent() {
        if (this.endActivity != null) {
            MMSDK.Log.d("Cached video end event logged");
            for (int i2 = 0; i2 < this.endActivity.length; ++i2) {
                MMSDK.Event.logEvent(this.endActivity[i2]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.showControls = objectInput.readBoolean();
        this.onCompletionUrl = (String)objectInput.readObject();
        this.webOverlayURL = (String)objectInput.readObject();
        this.endOverlayURL = (String)objectInput.readObject();
        this.cacheMissURL = (String)objectInput.readObject();
        this.videoFileId = (String)objectInput.readObject();
        this.stayInPlayer = objectInput.readBoolean();
        this.showCountdown = objectInput.readBoolean();
        this.reloadNonEndOverlayOnRestart = objectInput.readBoolean();
        int n2 = objectInput.readInt();
        this.startActivity = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.startActivity[i2] = (String)objectInput.readObject();
        }
        int n3 = objectInput.readInt();
        this.endActivity = new String[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            this.endActivity[i3] = (String)objectInput.readObject();
        }
        this.duration = objectInput.readLong();
        this.usingInternalStorage = objectInput.readBoolean();
        this.contentLength = objectInput.readLong();
        this.closeDelayMillis = objectInput.readLong();
        int n4 = objectInput.readInt();
        this.cacheComplete = new String[n4];
        for (int i4 = 0; i4 < n4; ++i4) {
            this.cacheComplete[i4] = (String)objectInput.readObject();
        }
        int n5 = objectInput.readInt();
        this.cacheFailed = new String[n5];
        for (int i5 = 0; i5 < n5; ++i5) {
            this.cacheFailed[i5] = (String)objectInput.readObject();
        }
        int n6 = objectInput.readInt();
        this.videoError = new String[n6];
        for (int i6 = 0; i6 < n6; ++i6) {
            this.videoError[i6] = (String)objectInput.readObject();
        }
        this.buttons.clear();
        int n7 = objectInput.readInt();
        for (int i7 = 0; i7 < n7; ++i7) {
            VideoImage videoImage = (VideoImage)objectInput.readObject();
            this.buttons.add(videoImage);
        }
        this.activities.clear();
        int n8 = objectInput.readInt();
        for (int i8 = 0; i8 < n8; ++i8) {
            VideoLogEvent videoLogEvent = (VideoLogEvent)objectInput.readObject();
            this.activities.add(videoLogEvent);
        }
    }

    @Override
    boolean saveAssets(Context context) {
        return true;
    }

    void setDtoCachedVideo(DTOCachedVideo dTOCachedVideo) {
        this.cachedVideoDto = dTOCachedVideo;
    }

    @Override
    void show(Context context, long l2) {
        Utils.IntentUtils.startCachedVideoPlayerActivity(context, this.getVideoExtrasIntent(context, l2));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.showControls);
        objectOutput.writeObject(this.onCompletionUrl);
        objectOutput.writeObject(this.webOverlayURL);
        objectOutput.writeObject(this.endOverlayURL);
        objectOutput.writeObject(this.cacheMissURL);
        objectOutput.writeObject(this.videoFileId);
        objectOutput.writeBoolean(this.stayInPlayer);
        objectOutput.writeBoolean(this.showCountdown);
        objectOutput.writeBoolean(this.reloadNonEndOverlayOnRestart);
        objectOutput.writeInt(this.startActivity.length);
        String[] stringArray = this.startActivity;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectOutput.writeObject(stringArray[i2]);
        }
        objectOutput.writeInt(this.endActivity.length);
        String[] stringArray2 = this.endActivity;
        int n3 = stringArray2.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            objectOutput.writeObject(stringArray2[i3]);
        }
        objectOutput.writeLong(this.duration);
        objectOutput.writeBoolean(this.usingInternalStorage);
        objectOutput.writeLong(this.contentLength);
        objectOutput.writeLong(this.closeDelayMillis);
        objectOutput.writeInt(this.cacheComplete.length);
        String[] stringArray3 = this.cacheComplete;
        int n4 = stringArray3.length;
        for (int i4 = 0; i4 < n4; ++i4) {
            objectOutput.writeObject(stringArray3[i4]);
        }
        objectOutput.writeInt(this.cacheFailed.length);
        String[] stringArray4 = this.cacheFailed;
        int n5 = stringArray4.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            objectOutput.writeObject(stringArray4[i5]);
        }
        objectOutput.writeInt(this.videoError.length);
        String[] stringArray5 = this.videoError;
        int n6 = stringArray5.length;
        for (int i6 = 0; i6 < n6; ++i6) {
            objectOutput.writeObject(stringArray5[i6]);
        }
        objectOutput.writeInt(this.buttons.size());
        Iterator<VideoImage> iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            objectOutput.writeObject(iterator.next());
        }
        objectOutput.writeInt(this.activities.size());
        Iterator<VideoLogEvent> iterator2 = this.activities.iterator();
        while (iterator2.hasNext()) {
            objectOutput.writeObject(iterator2.next());
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeInt(this.startActivity.length);
        parcel.writeStringArray(this.startActivity);
        parcel.writeInt(this.endActivity.length);
        parcel.writeStringArray(this.endActivity);
        boolean[] blArray = new boolean[]{this.showControls, this.stayInPlayer, this.showCountdown, this.reloadNonEndOverlayOnRestart, this.usingInternalStorage};
        parcel.writeBooleanArray(blArray);
        parcel.writeString(this.onCompletionUrl);
        parcel.writeString(this.endOverlayURL);
        parcel.writeString(this.webOverlayURL);
        parcel.writeString(this.cacheMissURL);
        parcel.writeString(this.videoFileId);
        parcel.writeLong(this.duration);
        parcel.writeLong(this.contentLength);
        parcel.writeLong(this.closeDelayMillis);
        parcel.writeList(this.buttons);
        parcel.writeList(this.activities);
        parcel.writeInt(this.cacheComplete.length);
        parcel.writeStringArray(this.cacheComplete);
        parcel.writeInt(this.cacheFailed.length);
        parcel.writeStringArray(this.cacheFailed);
        parcel.writeInt(this.videoError.length);
        parcel.writeStringArray(this.videoError);
    }

    private static class VideoFilenameFilter
    implements FilenameFilter {
        private WeakReference<VideoAd> videoAdRef;

        public VideoFilenameFilter(VideoAd videoAd) {
            this.videoAdRef = new WeakReference<VideoAd>(videoAd);
        }

        @Override
        public boolean accept(File file, String string2) {
            String string3;
            VideoAd videoAd = (VideoAd)this.videoAdRef.get();
            if (videoAd == null || (string3 = videoAd.getId()) == null) {
                return false;
            }
            return string2.startsWith(string3);
        }
    }

    private static class VideoIterator
    extends AdCache.Iterator {
        private WeakReference<Context> contextRef;
        boolean hasSharedVideoFile = false;
        private WeakReference<VideoAd> videoAdRef;

        public VideoIterator(Context context, VideoAd videoAd) {
            this.videoAdRef = new WeakReference<VideoAd>(videoAd);
            this.contextRef = new WeakReference<Context>(context);
        }

        @Override
        boolean callback(CachedAd cachedAd) {
            if (cachedAd != null && cachedAd instanceof VideoAd) {
                VideoAd videoAd = (VideoAd)cachedAd;
                VideoAd videoAd2 = (VideoAd)this.videoAdRef.get();
                if (videoAd2 != null && videoAd.videoFileId.equals(videoAd2.videoFileId)) {
                    this.hasSharedVideoFile = true;
                }
            }
            return super.callback(cachedAd);
        }

        void deleteVideoFile(Context context) {
            VideoAd videoAd = (VideoAd)this.videoAdRef.get();
            if (videoAd != null && AdCache.deleteFile(context, videoAd.videoFileId + VideoAd.VIDEO_FILE_ID)) {
                Object[] objectArray = new Object[]{videoAd.videoFileId};
                MMSDK.Log.v("VideoAd video file %s was deleted.", objectArray);
            }
        }

        @Override
        void done() {
            Context context;
            if (!this.hasSharedVideoFile && (context = (Context)this.contextRef.get()) != null) {
                this.deleteVideoFile(context);
            }
            super.done();
        }
    }
}

