/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.millennialmedia.android.AdViewOverlayActivity;
import com.millennialmedia.android.HttpRedirection;
import com.millennialmedia.android.MMActivity;
import com.millennialmedia.android.MMSDK;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

class Utils {
    Utils() {
    }

    static class HttpUtils {
        HttpUtils() {
        }

        static void executeUrl(final String string2) {
            ThreadUtils.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        new DefaultHttpClient().execute((HttpUriRequest)new HttpGet(string2));
                        MMSDK.Log.d("Executed Url :\"" + string2 + "\"");
                        return;
                    }
                    catch (IOException iOException) {
                        MMSDK.Log.e(iOException);
                        return;
                    }
                }
            });
        }
    }

    static class IntentUtils {
        IntentUtils() {
        }

        private static void fixDataAndTypeForVideo(Context context, Intent intent) {
            Uri uri = intent.getData();
            if (uri != null) {
                String string2 = uri.getLastPathSegment();
                if (TextUtils.isEmpty((CharSequence)intent.getStringExtra("class")) && !TextUtils.isEmpty((CharSequence)string2) && (string2.endsWith(".mp4") || string2.endsWith(".3gp") || string2.endsWith(".mkv") || string2.endsWith("content.once"))) {
                    intent.setDataAndType(intent.getData(), "video/*");
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        static Intent getIntentForUri(HttpRedirection.RedirectionListenerImpl redirectionListenerImpl) {
            Context context;
            Uri uri;
            block33: {
                block32: {
                    if (redirectionListenerImpl == null) break block32;
                    uri = redirectionListenerImpl.destinationUri;
                    context = (Context)redirectionListenerImpl.weakContext.get();
                    if (context != null) break block33;
                }
                return null;
            }
            Intent intent = null;
            if (uri != null) {
                String string2 = uri.getScheme();
                intent = null;
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("market")) {
                        MMSDK.Log.v("Creating Android Market intent.");
                        intent = new Intent("android.intent.action.VIEW", uri);
                        MMSDK.Event.intentStarted(context, "market", redirectionListenerImpl.creatorAdImplInternalId);
                    } else if (string2.equalsIgnoreCase("rtsp")) {
                        MMSDK.Log.v("Creating streaming video player intent.");
                        intent = new Intent(context, MMActivity.class);
                        intent.setData(uri);
                        intent.putExtra("class", "com.millennialmedia.android.VideoPlayerActivity");
                    } else if (string2.equalsIgnoreCase("tel")) {
                        MMSDK.Log.v("Creating telephone intent.");
                        intent = new Intent("android.intent.action.DIAL", uri);
                        MMSDK.Event.intentStarted(context, "tel", redirectionListenerImpl.creatorAdImplInternalId);
                    } else if (string2.equalsIgnoreCase("sms")) {
                        MMSDK.Log.v("Creating txt message intent.");
                        intent = new Intent("android.intent.action.VIEW");
                        String string3 = uri.getSchemeSpecificPart();
                        int n2 = string3.indexOf("?body=");
                        if (n2 != -1) {
                            string3 = string3.substring(0, n2);
                        }
                        intent.putExtra("address", string3.replace(',', ';'));
                        if (n2 != -1) {
                            intent.putExtra("sms_body", uri.getSchemeSpecificPart().substring(n2 + 6));
                        }
                        intent.setType("vnd.android-dir/mms-sms");
                        MMSDK.Event.intentStarted(context, "sms", redirectionListenerImpl.creatorAdImplInternalId);
                    } else if (string2.equalsIgnoreCase("mailto")) {
                        intent = new Intent("android.intent.action.VIEW", uri);
                        MMSDK.Event.intentStarted(context, "email", redirectionListenerImpl.creatorAdImplInternalId);
                    } else if (string2.equalsIgnoreCase("geo")) {
                        MMSDK.Log.v("Creating Google Maps intent.");
                        intent = new Intent("android.intent.action.VIEW", uri);
                        MMSDK.Event.intentStarted(context, "geo", redirectionListenerImpl.creatorAdImplInternalId);
                    } else if (string2.equalsIgnoreCase("https")) {
                        MMSDK.Log.v("Creating launch browser intent.");
                        intent = new Intent("android.intent.action.VIEW", uri);
                        MMSDK.Event.intentStarted(context, "browser", redirectionListenerImpl.creatorAdImplInternalId);
                    } else if (string2.equalsIgnoreCase("mmbrowser")) {
                        String string4 = uri.toString().substring(12);
                        if (string4 != null && !string4.contains("://")) {
                            string4 = string4.replaceFirst("//", "://");
                        }
                        MMSDK.Log.v("MMBrowser - Creating launch browser intent.");
                        intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string4));
                        MMSDK.Event.intentStarted(context, "browser", redirectionListenerImpl.creatorAdImplInternalId);
                    } else if (string2.equalsIgnoreCase("http")) {
                        if (uri.getLastPathSegment() != null && (uri.getLastPathSegment().endsWith(".mp4") || uri.getLastPathSegment().endsWith(".3gp"))) {
                            MMSDK.Log.v("Creating video player intent.");
                            intent = new Intent(context, MMActivity.class);
                            intent.setData(uri);
                            intent.putExtra("class", "com.millennialmedia.android.VideoPlayerActivity");
                            MMSDK.Event.intentStarted(context, "streamingVideo", redirectionListenerImpl.creatorAdImplInternalId);
                        } else {
                            if (redirectionListenerImpl.canOpenOverlay()) {
                                MMSDK.Log.v("Creating launch overlay intent.");
                                Intent intent2 = new Intent(context, MMActivity.class);
                                intent2.putExtra("class", AdViewOverlayActivity.class.getCanonicalName());
                                intent2.setData(uri);
                                return intent2;
                            }
                            MMSDK.Log.v("Creating launch browser intent.");
                            MMSDK.Event.intentStarted(context, "browser", redirectionListenerImpl.creatorAdImplInternalId);
                            intent = new Intent("android.intent.action.VIEW", uri);
                        }
                    } else {
                        MMSDK.Log.v("Creating intent for unrecognized URI. %s", uri);
                        intent = new Intent("android.intent.action.VIEW", uri);
                    }
                }
            }
            if (intent != null) {
                MMSDK.Log.v("%s resolved to Intent: %s", uri, intent);
                return intent;
            }
            MMSDK.Log.v("%s", uri);
            return intent;
        }

        static void startActionView(Context context, String string2) {
            IntentUtils.startActivity(context, new Intent("android.intent.action.VIEW", Uri.parse((String)string2)));
        }

        static void startActivity(Context context, Intent intent) {
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            IntentUtils.fixDataAndTypeForVideo(context, intent);
            context.startActivity(intent);
        }

        static void startAdViewOverlayActivity(Context context) {
            Intent intent = new Intent(context, MMActivity.class);
            intent.putExtra("class", "com.millennialmedia.android.AdViewOverlayActivity");
            IntentUtils.startActivity(context, intent);
        }

        static void startAdViewOverlayActivity(Context context, Intent intent) {
            intent.setClass(context, MMActivity.class);
            intent.putExtra("class", "com.millennialmedia.android.AdViewOverlayActivity");
            IntentUtils.startActivity(context, intent);
        }

        static void startAdViewOverlayActivityWithData(Context context, String string2) {
            Intent intent = new Intent(context, MMActivity.class);
            intent.putExtra("class", "com.millennialmedia.android.AdViewOverlayActivity");
            intent.setData(Uri.parse((String)string2));
            IntentUtils.startActivity(context, intent);
        }

        static void startCachedVideoPlayerActivity(Context context, Intent intent) {
            intent.setClass(context, MMActivity.class);
            intent.putExtra("class", "com.millennialmedia.android.CachedVideoPlayerActivity");
            IntentUtils.startActivity(context, intent);
        }

        static void startPickerActivity(Context context, File file, String string2) {
            Intent intent = new Intent(context, MMActivity.class);
            intent.setData(Uri.fromFile((File)file));
            intent.putExtra("type", string2);
            intent.putExtra("class", "com.millennialmedia.android.BridgeMMMedia$PickerActivity");
            IntentUtils.startActivity(context, intent);
        }

        static void startVideoPlayerActivityWithData(Context context, Uri uri) {
            Intent intent = new Intent(context, MMActivity.class);
            intent.setData(uri);
            intent.putExtra("class", "com.millennialmedia.android.VideoPlayerActivity");
            IntentUtils.startActivity(context, intent);
        }

        static void startVideoPlayerActivityWithData(Context context, File file) {
            IntentUtils.startVideoPlayerActivityWithData(context, Uri.fromFile((File)file));
        }

        static void startVideoPlayerActivityWithData(Context context, String string2) {
            IntentUtils.startVideoPlayerActivityWithData(context, Uri.parse((String)string2));
        }
    }

    static class ThreadUtils {
        private static final ExecutorService cachedThreadExecutor = Executors.newCachedThreadPool();

        ThreadUtils() {
        }

        static void execute(Runnable runnable) {
            cachedThreadExecutor.execute(runnable);
        }
    }
}

