/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.millennialmedia.android.HttpMMHeaders;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.google.gson.Gson;
import com.millennialmedia.google.gson.annotations.SerializedName;

class OverlaySettings
implements Parcelable {
    public static final Parcelable.Creator<OverlaySettings> CREATOR = new Parcelable.Creator<OverlaySettings>(){

        public OverlaySettings createFromParcel(Parcel parcel) {
            return new OverlaySettings(parcel);
        }

        public OverlaySettings[] newArray(int n2) {
            return new OverlaySettings[n2];
        }
    };
    static final String PROPERTIES_ACID = "acid";
    static final String PROPERTIES_ALLOW_ORIENTATION_CHANGE = "allowOrientationChange";
    static final String PROPERTIES_CUSTOM_CLOSE = "useCustomClose";
    static final String PROPERTIES_ENABLE_HARDWARE_ACCEL = "enableHardwareAccel";
    static final String PROPERTIES_FORCE_ORIENTATION = "forceOrientation";
    static final String PROPERTIES_HEIGHT = "height";
    static final String PROPERTIES_MODAL = "modal";
    static final String PROPERTIES_ORIENTATION = "orientation";
    static final String PROPERTIES_TRANSITION = "transition";
    static final String PROPERTIES_TRANSITION_DURATION = "transitionDuration";
    static final String PROPERTIES_TRANSPARENT = "transparent";
    static final String PROPERTIES_WIDTH = "width";
    String adUrl;
    boolean allowOrientationChange;
    String content;
    long creatorAdImplId;
    boolean hasLoadedExpandUrl;
    int height;
    boolean isFromInterstitial;
    @SerializedName(value="transparent")
    private boolean isTransparent;
    HttpMMHeaders mmHeaders;
    boolean modal;
    String orientation;
    boolean shouldLaunchToOverlay;
    int shouldResizeOverlay;
    private String transition;
    @SerializedName(value="transitionDuration")
    private long transitionTimeInMillis;
    String urlToLoad;
    private boolean useCustomClose;
    int width;

    OverlaySettings() {
        this.transition = "";
        this.orientation = "";
        this.urlToLoad = "";
        this.allowOrientationChange = true;
        this.content = "";
        this.adUrl = "";
        this.hasLoadedExpandUrl = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OverlaySettings(Parcel parcel) {
        long l2 = 0L;
        this.transition = "";
        this.orientation = "";
        this.urlToLoad = "";
        this.allowOrientationChange = true;
        this.content = "";
        this.adUrl = "";
        this.hasLoadedExpandUrl = false;
        try {
            boolean[] blArray = new boolean[6];
            parcel.readBooleanArray(blArray);
            this.shouldLaunchToOverlay = blArray[0];
            this.isTransparent = blArray[1];
            this.useCustomClose = blArray[2];
            this.modal = blArray[3];
            this.isFromInterstitial = blArray[4];
            this.allowOrientationChange = blArray[5];
            this.shouldResizeOverlay = parcel.readInt();
            this.transition = parcel.readString();
            this.transitionTimeInMillis = parcel.readLong();
            if (this.transitionTimeInMillis >= l2) {
                l2 = this.transitionTimeInMillis;
            }
            this.transitionTimeInMillis = l2;
            this.orientation = parcel.readString();
            this.creatorAdImplId = parcel.readLong();
            this.urlToLoad = parcel.readString();
            this.height = parcel.readInt();
            this.width = parcel.readInt();
            this.content = parcel.readString();
            this.adUrl = parcel.readString();
            this.mmHeaders = (HttpMMHeaders)parcel.readParcelable(HttpMMHeaders.class.getClassLoader());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static final OverlaySettings createFromJson(String string2) {
        return new Gson().fromJson(string2, OverlaySettings.class);
    }

    public int describeContents() {
        return 0;
    }

    boolean enableHardwareAccel() {
        return this.mmHeaders != null && this.mmHeaders.enableHardwareAccel;
    }

    String getAcid() {
        if (this.mmHeaders != null && !TextUtils.isEmpty((CharSequence)this.mmHeaders.acid)) {
            return this.mmHeaders.acid;
        }
        return "";
    }

    boolean getIsTransparent() {
        return this.isTransparent || this.mmHeaders != null && this.mmHeaders.isTransparent;
    }

    String getTransition() {
        if (!TextUtils.isEmpty((CharSequence)this.transition)) {
            return this.transition;
        }
        if (this.mmHeaders != null && !TextUtils.isEmpty((CharSequence)this.mmHeaders.transition)) {
            return this.mmHeaders.transition;
        }
        return "none";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getTransitionDurationInMillis() {
        long l2 = 0L;
        if (this.transitionTimeInMillis > l2) {
            return this.transitionTimeInMillis;
        }
        if (this.mmHeaders == null) return l2;
        return this.mmHeaders.transitionTimeInMillis;
    }

    boolean getUseCustomClose() {
        return this.useCustomClose || this.mmHeaders != null && this.mmHeaders.useCustomClose;
    }

    boolean hasExpandUrl() {
        return this.urlToLoad != null && !this.urlToLoad.equals("");
    }

    boolean hasLoadedExpandUrl() {
        boolean bl2 = true;
        if (!this.hasLoadedExpandUrl) {
            this.hasLoadedExpandUrl = bl2;
            bl2 = false;
        }
        return bl2;
    }

    boolean isExpanded() {
        return !this.isFromInterstitial && this.creatorAdImplId != 0L;
    }

    boolean isFromInterstitial() {
        return this.isFromInterstitial && this.creatorAdImplId != 0L;
    }

    void log() {
        MMSDK.Log.v(this.toString());
    }

    void setIsTransparent(boolean bl2) {
        this.isTransparent = bl2;
    }

    void setTransition(String string2) {
        this.transition = string2;
    }

    void setTransitionDurationInMillis(long l2) {
        this.transitionTimeInMillis = l2;
    }

    void setUseCustomClose(boolean bl2) {
        this.useCustomClose = bl2;
    }

    void setWebMMHeaders(HttpMMHeaders httpMMHeaders) {
        this.mmHeaders = httpMMHeaders;
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.height, this.width, this.modal, this.urlToLoad, this.creatorAdImplId, this.shouldResizeOverlay, this.transitionTimeInMillis, this.transition, this.isTransparent, this.useCustomClose, this.orientation};
        return String.format("height %d width %d modal %b urlToLoad %s creatorAdImplId %s shouldResizeOverlay: %d transitionTime: %d overlayTransition: %s shouldMakeOverlayTransparent: %b shouldShowCustomClose: %b Orientation: %s", objectArray);
    }

    public void writeToParcel(Parcel parcel, int n2) {
        boolean[] blArray = new boolean[]{this.shouldLaunchToOverlay, this.isTransparent, this.useCustomClose, this.modal, this.isFromInterstitial, this.allowOrientationChange};
        parcel.writeBooleanArray(blArray);
        parcel.writeInt(this.shouldResizeOverlay);
        parcel.writeString(this.transition);
        parcel.writeLong(this.transitionTimeInMillis);
        parcel.writeString(this.orientation);
        parcel.writeLong(this.creatorAdImplId);
        parcel.writeString(this.urlToLoad);
        parcel.writeInt(this.height);
        parcel.writeInt(this.width);
        parcel.writeString(this.content);
        parcel.writeString(this.adUrl);
        parcel.writeParcelable((Parcelable)this.mmHeaders, n2);
    }
}

