/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.nuance.nmdp.speechkit.DataUploadCommand;
import com.nuance.nmdp.speechkit.DataUploadResult;
import com.nuance.nmdp.speechkit.GenericCommand;
import com.nuance.nmdp.speechkit.GenericResult;
import com.nuance.nmdp.speechkit.Recognition;
import com.nuance.nmdp.speechkit.Recognizer;
import com.nuance.nmdp.speechkit.SpeechError;
import com.nuance.nmdp.speechkit.SpeechKit;
import com.nuance.nmdp.speechkit.Vocalizer;
import com.nuance.nmdp.speechkit.recognitionresult.DetailedResult;
import com.nuance.nmdp.speechkit.util.dataupload.Action;
import com.nuance.nmdp.speechkit.util.dataupload.Data;
import com.nuance.nmdp.speechkit.util.dataupload.DataBlock;
import com.nuance.nmdp.speechkit.util.pdx.PdxValue;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NVASpeechKit {
    static final float AUDIO_LEVEL_CHANGE_INTERVAL = 0.25f;
    static final float AUDIO_LEVEL_MAX = 90.0f;
    private static final int AUDIO_LEVEL_UPDATE_FREQUENCY = 50;
    private static final int AUDIO_SAMPLE_PERIOD = 2000;
    static final float SAMPLING_BG_INTERVAL = 0.1f;
    private static String nuanceIdCache = null;
    HandShake.NuanceCredentials _credentials;
    public Result[] _results = null;
    private Runnable audioLevelCallback;
    private AudioLevelTracker audioLevelTracker = new AudioLevelTracker();
    private Runnable audioSampleCallback = new Runnable(){

        @Override
        public void run() {
            NVASpeechKit.this.endRecording();
        }
    };
    private GenericCommand.Listener commandListener;
    private DataUploadCommand.Listener dataUploadListener;
    private String nuance_transaction_session_id;
    private String packageName;
    private DataUploadCommand pendingDataUploadCommand;
    private CustomWordsOp pendingDataUploadCommandType;
    private SpeechKit sk;
    private Recognizer skCurrentRecognizer;
    private Vocalizer skCurrentVocalizer;
    private Recognizer.Listener skRecogListener;
    private Vocalizer.Listener skVocalListener;
    private Listener speechKitListener;
    private Handler speeckKitHandler;
    private State state;
    private WeakReference<MMWebView> webViewRef;

    public NVASpeechKit(MMWebView mMWebView) {
        this.audioLevelCallback = new Runnable(){

            @Override
            public void run() {
                if (NVASpeechKit.this.skCurrentRecognizer != null) {
                    double d2 = AudioLevelTracker.normalize(NVASpeechKit.this.skCurrentRecognizer.getAudioLevel());
                    MMSDK.Log.d("audiolevel changed: level=" + d2);
                    if (NVASpeechKit.this.audioLevelTracker.update(d2) && NVASpeechKit.this.speechKitListener != null) {
                        NVASpeechKit.this.speechKitListener.onAudioLevelUpdate(d2);
                    }
                    if (NVASpeechKit.this.state == State.RECORDING || ((NVASpeechKit)NVASpeechKit.this).audioLevelTracker.isTrackingAudioSample) {
                        NVASpeechKit.this.speeckKitHandler.postDelayed(NVASpeechKit.this.audioLevelCallback, 50L);
                    }
                }
            }
        };
        this.commandListener = new GenericCommand.Listener(){

            /*
             * Enabled aggressive block sorting
             */
            public void onComplete(GenericCommand genericCommand, GenericResult genericResult, SpeechError speechError) {
                if (speechError != null) {
                    MMSDK.Log.e("GenericCommand listener. Error: " + speechError.getErrorDetail());
                } else {
                    MMSDK.Log.d("GenericCommand listener. Success: " + genericResult.getQueryResult());
                }
                NVASpeechKit.this.notifySpeechResults();
            }
        };
        this.dataUploadListener = new DataUploadCommand.Listener(){

            /*
             * Enabled aggressive block sorting
             */
            private void notifyListener(DataUploadCommand dataUploadCommand) {
                if (NVASpeechKit.this.speechKitListener != null && NVASpeechKit.this.pendingDataUploadCommand == dataUploadCommand) {
                    if (NVASpeechKit.this.pendingDataUploadCommandType == CustomWordsOp.Add) {
                        NVASpeechKit.this.speechKitListener.onCustomWordsAdded();
                    } else {
                        NVASpeechKit.this.speechKitListener.onCustomWordsDeleted();
                    }
                }
                NVASpeechKit.access$802(NVASpeechKit.this, null);
            }

            public void onError(DataUploadCommand dataUploadCommand, SpeechError speechError) {
                MMSDK.Log.e("DataUploadCommand listener error. command:" + dataUploadCommand.toString() + " Error:" + speechError.getErrorDetail());
                this.notifyListener(dataUploadCommand);
            }

            public void onResults(DataUploadCommand dataUploadCommand, DataUploadResult dataUploadResult) {
                MMSDK.Log.d("DataUploadCommand listener successful command:" + dataUploadCommand.toString() + " isVocRegenerated:" + dataUploadResult.isVocRegenerated() + " results:" + dataUploadResult.toString());
                this.notifyListener(dataUploadCommand);
            }
        };
        this.speechKitListener = new Listener(){

            @Override
            public void onAudioLevelUpdate(double d2) {
                NVASpeechKit.this.audioLevelChange(d2);
            }

            @Override
            public void onAudioSampleUpdate(double d2) {
                NVASpeechKit.this.backgroundAudioLevel(d2);
            }

            @Override
            public void onCustomWordsAdded() {
            }

            @Override
            public void onCustomWordsDeleted() {
            }

            @Override
            public void onError() {
            }

            @Override
            public void onResults() {
                JSONArray jSONArray = NVASpeechKit.this.resultsToJSON(NVASpeechKit.this.getResults());
                NVASpeechKit.this.recognitionResult(jSONArray.toString());
            }

            @Override
            public void onStateChange(State state) {
                switch (8.$SwitchMap$com$millennialmedia$android$NVASpeechKit$State[state.ordinal()]) {
                    default: {
                        return;
                    }
                    case 1: {
                        NVASpeechKit.this.voiceStateChangeError();
                        return;
                    }
                    case 2: {
                        NVASpeechKit.this.voiceStateChangeProcessing();
                        return;
                    }
                    case 3: {
                        NVASpeechKit.this.voiceStateChangeReady();
                        return;
                    }
                    case 4: {
                        NVASpeechKit.this.voiceStateChangeRecording();
                        return;
                    }
                    case 5: 
                }
                NVASpeechKit.this.voiceStateChangeVocalizing();
            }
        };
        if (mMWebView != null) {
            this.webViewRef = new WeakReference<MMWebView>(mMWebView);
            this.initInternalData(mMWebView.getContext().getApplicationContext());
        }
        this.state = State.READY;
    }

    static /* synthetic */ Recognizer access$002(NVASpeechKit nVASpeechKit, Recognizer recognizer) {
        nVASpeechKit.skCurrentRecognizer = recognizer;
        return recognizer;
    }

    static /* synthetic */ String access$1702(NVASpeechKit nVASpeechKit, String string2) {
        nVASpeechKit.nuance_transaction_session_id = string2;
        return string2;
    }

    static /* synthetic */ DataUploadCommand access$802(NVASpeechKit nVASpeechKit, DataUploadCommand dataUploadCommand) {
        nVASpeechKit.pendingDataUploadCommand = dataUploadCommand;
        return dataUploadCommand;
    }

    private String byte2Str(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = 0xFF & byArray[i2];
            String string2 = Integer.toHexString(n2);
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void cancelAudioLevelCallbacks() {
        if (this.speeckKitHandler != null) {
            this.speeckKitHandler.removeCallbacks(this.audioSampleCallback);
            this.speeckKitHandler.removeCallbacks(this.audioLevelCallback);
        }
    }

    private Recognizer.Listener createRecognizerListener() {
        return new Recognizer.Listener(){

            public void onError(Recognizer recognizer, SpeechError speechError) {
                MMSDK.Log.d("Speech Kit Error code:" + speechError.getErrorCode() + " detail:" + speechError.getErrorDetail() + " suggestions:" + speechError.getSuggestion());
                NVASpeechKit.this.cancelAudioLevelCallbacks();
                NVASpeechKit.this.handleSpeechError(speechError);
                NVASpeechKit.access$002(NVASpeechKit.this, null);
                if (NVASpeechKit.this.sk != null) {
                    MMSDK.Log.d("Recognizer.Listener.onError: session id [" + NVASpeechKit.this.sk.getSessionId() + "]");
                }
            }

            public void onRecordingBegin(Recognizer recognizer) {
                MMSDK.Log.d("recording begins");
                NVASpeechKit.this._results = null;
                if (!NVASpeechKit.this.audioLevelTracker.isTrackingAudioSample()) {
                    NVASpeechKit.this.setState(State.RECORDING);
                }
                NVASpeechKit.this.startProgress(recognizer);
                if (NVASpeechKit.this.audioLevelTracker.isTrackingAudioSample()) {
                    NVASpeechKit.this.speeckKitHandler.removeCallbacks(NVASpeechKit.this.audioSampleCallback);
                    NVASpeechKit.this.speeckKitHandler.postDelayed(NVASpeechKit.this.audioSampleCallback, 2000L);
                }
            }

            public void onRecordingDone(Recognizer recognizer) {
                MMSDK.Log.d("recording has ended");
                NVASpeechKit.this.cancelAudioLevelCallbacks();
                if (!NVASpeechKit.this.audioLevelTracker.isTrackingAudioSample()) {
                    NVASpeechKit.this.setState(State.PROCESSING);
                }
                if (NVASpeechKit.this.sk != null) {
                    NVASpeechKit.access$1702(NVASpeechKit.this, NVASpeechKit.this.sk.getSessionId());
                }
            }

            public void onResults(Recognizer recognizer, Recognition recognition) {
                MMSDK.Log.d("recording results returned.");
                NVASpeechKit.this.cancelAudioLevelCallbacks();
                if (!((NVASpeechKit)NVASpeechKit.this).audioLevelTracker.isTrackingAudioSample) {
                    NVASpeechKit.this.processResults(recognition.getDetailedResults());
                    if (NVASpeechKit.this.nuance_transaction_session_id != null) {
                        MMSDK.Log.d("Recognizer.Listener.onResults: session id [" + NVASpeechKit.this.nuance_transaction_session_id + "]");
                    }
                    NVASpeechKit.this.logEvent();
                    return;
                }
                NVASpeechKit.this._results = new Result[0];
                NVASpeechKit.this.notifySpeechResults();
            }
        };
    }

    private Vocalizer.Listener createVocalizerListener() {
        return new Vocalizer.Listener(){

            public void onSpeakingBegin(Vocalizer vocalizer, String string2, Object object) {
                MMSDK.Log.d("Vocalization begins. text=" + string2);
                NVASpeechKit.this.setState(State.VOCALIZING);
            }

            public void onSpeakingDone(Vocalizer vocalizer, String string2, SpeechError speechError, Object object) {
                MMSDK.Log.d("Vocalization has ended.");
                if (speechError != null) {
                    MMSDK.Log.e("Vocalizer error: " + speechError.getErrorDetail());
                    NVASpeechKit.this.handleSpeechError(speechError);
                    return;
                }
                NVASpeechKit.this.setState(State.READY);
            }
        };
    }

    private String getAdId() {
        MMWebView mMWebView;
        if (this.webViewRef != null && (mMWebView = (MMWebView)((Object)this.webViewRef.get())) != null) {
            return mMWebView.getAdId();
        }
        return "DEFAULT_AD_ID";
    }

    private MMWebView getMMWebView() {
        if (this.webViewRef != null) {
            return (MMWebView)((Object)this.webViewRef.get());
        }
        return null;
    }

    private String getSpeechError(SpeechError speechError) {
        if (speechError == null) {
            return "No Error given";
        }
        return "Speech Kit Error code:" + speechError.getErrorCode() + " detail:" + speechError.getErrorDetail() + " suggestions:" + speechError.getSuggestion();
    }

    private void handleSpeechError(SpeechError speechError) {
        switch (speechError.getErrorCode()) {
            default: {
                if (this.speechKitListener != null) {
                    this.speechKitListener.onError();
                    this.setState(State.ERROR);
                    this.voiceError(this.getSpeechError(speechError));
                }
                return;
            }
            case 2: {
                if (!this.audioLevelTracker.isTrackingAudioSample) {
                    this.setState(State.PROCESSING);
                }
                this._results = new Result[0];
                this.notifySpeechResults();
                return;
            }
            case 5: 
        }
        this.setState(State.READY);
        this.skCurrentRecognizer = null;
    }

    private void initInternalData(Context context) {
        if (this.packageName == null) {
            this.packageName = context.getApplicationContext().getPackageName();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void notifySpeechResults() {
        if (this.speechKitListener != null && this._results != null) {
            if (this.audioLevelTracker.isTrackingAudioSample) {
                this.speechKitListener.onAudioSampleUpdate(this.audioLevelTracker.averageLevel);
                this.audioLevelTracker.reset();
            } else {
                this.speechKitListener.onResults();
            }
        }
        this.setState(State.READY);
        this.skCurrentRecognizer = null;
    }

    private void processResults(List<DetailedResult> list) {
        MMSDK.Log.d("processResults called.");
        this._results = new Result[list.size()];
        int n2 = 0;
        for (DetailedResult detailedResult : list) {
            Result[] resultArray = this._results;
            int n3 = n2 + 1;
            resultArray[n2] = new Result(detailedResult.toString(), detailedResult.getConfidenceScore());
            n2 = n3;
        }
    }

    private void releaseWebView() {
        if (this.getMMWebView() != null) {
            this.webViewRef.clear();
        }
    }

    private JSONArray resultsToJSON(Result[] resultArray) {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < resultArray.length; ++i2) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("score", (Object)("" + resultArray[i2].getResultScore()));
                jSONObject.put("result", (Object)resultArray[i2].getResultString());
                jSONArray.put((Object)jSONObject);
                continue;
            }
            catch (JSONException jSONException) {
                MMSDK.Log.d("JSON creation error.");
                jSONException.printStackTrace();
                jSONArray = null;
                break;
            }
        }
        return jSONArray;
    }

    private void setState(State state) {
        synchronized (this) {
            MMSDK.Log.d("recording results returned. state=" + (Object)((Object)state));
            State state2 = this.state;
            this.state = state;
            if (this.speechKitListener != null && this.state != state2) {
                this.speechKitListener.onStateChange(state);
            }
            return;
        }
    }

    private void startProgress(Recognizer recognizer) {
        this.speeckKitHandler.removeCallbacks(this.audioLevelCallback);
        this.speeckKitHandler.postDelayed(this.audioLevelCallback, 50L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] string2Byte(String string2) {
        if (string2 == null) {
            return null;
        }
        byte[] byArray = new byte[string2.length() / 2];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)Integer.parseInt(string2.substring(n2 * 2, 2 + n2 * 2), 16);
            ++n2;
        }
        return byArray;
    }

    void audioLevelChange(double d2) {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.audioLevelChange(" + d2 + ")");
        }
    }

    void backgroundAudioLevel(double d2) {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.backgroundAudioLevel(" + d2 + ")");
        }
    }

    public void cancelRecording() {
        if (this.skCurrentRecognizer != null) {
            MMSDK.Log.d("cancel RECORDING");
            this.skCurrentRecognizer.cancel();
            this.skCurrentRecognizer = null;
            this.setState(State.READY);
        }
    }

    public boolean endRecording() {
        if (this.skCurrentRecognizer != null) {
            MMSDK.Log.d("end RECORDING");
            this.skCurrentRecognizer.stopRecording();
            this.skCurrentRecognizer = null;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getNuanceId() {
        synchronized (this) {
            if (nuanceIdCache != null) {
                return nuanceIdCache;
            }
            WeakReference<MMWebView> weakReference = this.webViewRef;
            Context context = null;
            if (weakReference != null) {
                MMWebView mMWebView = (MMWebView)((Object)this.webViewRef.get());
                context = null;
                if (mMWebView != null) {
                    context = mMWebView.getContext();
                }
            }
            String string2 = null;
            if (context == null) return string2;
            String string3 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            string2 = null;
            if (string3 == null) return string2;
            try {
                String string4;
                nuanceIdCache = string2 = (string4 = MMSDK.byteArrayToString(MessageDigest.getInstance("SHA1").digest(string3.getBytes())));
            }
            catch (Exception exception) {
                MMSDK.Log.v(exception.getMessage());
                return null;
            }
            return string2;
        }
    }

    public Result[] getResults() {
        return this._results;
    }

    String getSessionId() {
        if (this.sk != null) {
            return this.sk.getSessionId();
        }
        return "";
    }

    public State getState() {
        synchronized (this) {
            State state = this.state;
            return state;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initialize(HandShake.NuanceCredentials nuanceCredentials, Context context) {
        MMSDK.Log.d("initialize called.");
        if (nuanceCredentials == null || context == null) {
            return false;
        }
        this._credentials = nuanceCredentials;
        if (this.sk != null) {
            try {
                this.sk.connect();
            }
            catch (IllegalStateException illegalStateException) {
                this.sk = null;
            }
        }
        if (this.sk == null) {
            byte[] byArray = this.string2Byte(nuanceCredentials.appKey);
            MMSDK.Log.d(nuanceCredentials.toString());
            this.sk = SpeechKit.initialize((Context)context, (String)"1.0", (String)nuanceCredentials.appID, (String)nuanceCredentials.server, (int)nuanceCredentials.port, (boolean)false, (byte[])byArray, (SpeechKit.CmdSetType)SpeechKit.CmdSetType.NVC);
            this.skVocalListener = this.createVocalizerListener();
            this.skRecogListener = this.createRecognizerListener();
            this.speeckKitHandler = new Handler(Looper.getMainLooper());
            this.sk.connect();
            this.setState(State.READY);
            return true;
        }
        MMSDK.Log.d("Already initialized. Skipping.");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void logEvent() {
        String string2;
        if (this.sk == null) {
            return;
        }
        PdxValue.Dictionary dictionary = new PdxValue.Dictionary();
        dictionary.put("nva_ad_network_id", "MillenialMedia");
        dictionary.put("nva_device_id", this.getNuanceId());
        dictionary.put("nva_ad_publisher_id", this.packageName);
        String string3 = "";
        if (this._credentials != null && !TextUtils.isEmpty((CharSequence)this._credentials.sessionID)) {
            string3 = this._credentials.sessionID;
            dictionary.put("nva_ad_session_id", this._credentials.sessionID);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.getAdId()))) {
            dictionary.put("nva_ad_id", string2);
        }
        if (this.nuance_transaction_session_id != null) {
            dictionary.put("nva_nvc_session_id", this.nuance_transaction_session_id);
            this.nuance_transaction_session_id = null;
        } else {
            this.sk.getSessionId();
        }
        MMSDK.Log.d("Sending log revision command to server. sessionId[" + this.sk.getSessionId() + "] deviceId[" + this.getNuanceId() + "] adId[" + string2 + "] mmSessionId[" + string3 + "]");
        this.sk.createLogRevisionCmd("NVA_LOG_EVENT", dictionary, this.sk.getSessionId(), this.commandListener, this.speeckKitHandler).start();
    }

    void recognitionResult(String string2) {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.recognitionResult(" + string2 + ")");
        }
    }

    public void release() {
        MMSDK.Log.d("release called.");
        this.stopActions();
        this.cancelAudioLevelCallbacks();
        if (this.sk != null) {
            this.sk.release();
            this.setState(State.READY);
            this.sk = null;
        }
        this.pendingDataUploadCommand = null;
        this.releaseWebView();
    }

    public void setSpeechKitListener(Listener listener) {
        this.speechKitListener = listener;
    }

    public boolean startRecording(String string2) {
        MMSDK.Log.d("RECORDING INVOKED.");
        if (this.state == State.READY && this.sk != null) {
            this.nuance_transaction_session_id = null;
            this.skCurrentRecognizer = this.sk.createRecognizer("dictation", 1, string2, this.skRecogListener, this.speeckKitHandler);
            MMSDK.Log.d("START RECORDING");
            this.skCurrentRecognizer.start();
            return true;
        }
        return false;
    }

    public void startSampleRecording() {
        this.audioLevelTracker.startTrackingAudioSample();
        this.startRecording("en_US");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopActions() {
        if (this.sk == null) return;
        try {
            this.sk.cancelCurrent();
            return;
        }
        catch (Exception exception) {
            MMSDK.Log.e("No speech kit to disconnect.", exception);
            return;
        }
    }

    public boolean textToSpeech(String string2, String string3) {
        MMSDK.Log.d("TTS INVOKED.");
        if (this.state == State.READY && this.sk != null) {
            this.skCurrentVocalizer = this.sk.createVocalizerWithLanguage(string3, this.skVocalListener, this.speeckKitHandler);
            this.skCurrentVocalizer.speakString(string2, (Object)this);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateCustomWords(CustomWordsOp customWordsOp, String[] stringArray) {
        if (this.sk == null) {
            return;
        }
        DataBlock dataBlock = new DataBlock();
        StringBuilder stringBuilder = new StringBuilder().append("Creating dataupload command and ");
        String string2 = customWordsOp == CustomWordsOp.Add ? "adding" : "deleting";
        MMSDK.Log.d(stringBuilder.append(string2).append(" words.").toString());
        Data data = new Data("nva_custom_word_uploads", Data.DataType.CUSTOMWORDS);
        Action.ActionType actionType = customWordsOp == CustomWordsOp.Add ? Action.ActionType.ADD : Action.ActionType.REMOVE;
        Action action = new Action(actionType);
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                data.addAction(action);
                dataBlock.addData(data);
                int n4 = dataBlock.getChecksum();
                this.pendingDataUploadCommandType = customWordsOp;
                this.pendingDataUploadCommand = this.sk.createDataUploadCmd(dataBlock, n4, n4, this.dataUploadListener, this.speeckKitHandler);
                this.pendingDataUploadCommand.start();
                return;
            }
            String string3 = stringArray[n3];
            action.addWord(string3);
            MMSDK.Log.d("\tword: '" + string3 + "'");
            ++n3;
        }
    }

    void voiceError(String string2) {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.voiceError('" + string2 + "')");
        }
    }

    void voiceStateChangeError() {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.voiceStateChange('error')");
        }
    }

    void voiceStateChangeProcessing() {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.voiceStateChange('processing')");
        }
    }

    void voiceStateChangeReady() {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.voiceStateChange('ready')");
        }
    }

    void voiceStateChangeRecording() {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.voiceStateChange('recording')");
        }
    }

    void voiceStateChangeVocalizing() {
        MMWebView mMWebView = this.getMMWebView();
        if (mMWebView != null) {
            mMWebView.loadUrl("javascript:MMJS.sdk.voiceStateChange('vocalizing')");
        }
    }

    static class AudioLevelTracker {
        private static final double MAX = 80.0;
        private static final double MIN = 40.0;
        private static final double NORMALIZE_FACTOR = 4.004004004004004;
        private static final double SCALE = 9.99;
        double audioLevel;
        int audioLevelCount;
        double averageLevel;
        boolean isTrackingAudioSample;

        public AudioLevelTracker() {
            this.reset();
        }

        private static double normalize(double d2) {
            return Math.min(9.99, Math.max(Math.floor(d2 - 40.0) / 4.004004004004004, 0.0));
        }

        public boolean isTrackingAudioSample() {
            return this.isTrackingAudioSample;
        }

        public void reset() {
            this.averageLevel = 0.0;
            this.audioLevelCount = 0;
            this.isTrackingAudioSample = false;
        }

        public void startTrackingAudioSample() {
            this.reset();
            this.isTrackingAudioSample = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean update(double d2) {
            double d3 = this.averageLevel;
            double d4 = this.audioLevel;
            this.audioLevel = d2;
            this.audioLevelCount = 1 + this.audioLevelCount;
            this.averageLevel = (d2 + d3 * (double)(-1 + this.audioLevelCount)) / (double)this.audioLevelCount;
            return !this.isTrackingAudioSample && this.audioLevel != d4;
        }
    }

    public static final class CustomWordsOp
    extends Enum<CustomWordsOp> {
        private static final /* synthetic */ CustomWordsOp[] $VALUES;
        public static final /* enum */ CustomWordsOp Add = new CustomWordsOp();
        public static final /* enum */ CustomWordsOp Remove = new CustomWordsOp();

        static {
            CustomWordsOp[] customWordsOpArray = new CustomWordsOp[]{Add, Remove};
            $VALUES = customWordsOpArray;
        }

        public static CustomWordsOp valueOf(String string2) {
            return Enum.valueOf(CustomWordsOp.class, string2);
        }

        public static CustomWordsOp[] values() {
            return (CustomWordsOp[])$VALUES.clone();
        }
    }

    public static interface Listener {
        public void onAudioLevelUpdate(double var1);

        public void onAudioSampleUpdate(double var1);

        public void onCustomWordsAdded();

        public void onCustomWordsDeleted();

        public void onError();

        public void onResults();

        public void onStateChange(State var1);
    }

    public class Result {
        public final int resultScore;
        public final String resultString;

        public Result(String string2, double d2) {
            this.resultString = string2;
            this.resultScore = (int)d2;
        }

        public int getResultScore() {
            return this.resultScore;
        }

        public String getResultString() {
            return this.resultString;
        }
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ERROR = new State("error");
        public static final /* enum */ State PROCESSING;
        public static final /* enum */ State READY;
        public static final /* enum */ State RECORDING;
        public static final /* enum */ State VOCALIZING;
        private String name;

        static {
            VOCALIZING = new State("vocalizing");
            RECORDING = new State("recording");
            READY = new State("ready");
            PROCESSING = new State("processing");
            State[] stateArray = new State[]{ERROR, VOCALIZING, RECORDING, READY, PROCESSING};
            $VALUES = stateArray;
        }

        private State(String string3) {
            this.name = string3;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public String toString() {
            return this.name;
        }
    }
}

