/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import com.millennialmedia.android.AdViewOverlayView;
import com.millennialmedia.android.BridgeMMSpeechkit;
import com.millennialmedia.android.DTOAdViewLayout;
import com.millennialmedia.android.DTOResizeParameters;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.HttpMMHeaders;
import com.millennialmedia.android.MMActivity;
import com.millennialmedia.android.MMAd;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMAdImplController;
import com.millennialmedia.android.MMAdView;
import com.millennialmedia.android.MMLayout;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MRaid;
import com.millennialmedia.google.gson.Gson;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.json.JSONObject;

class MMWebView
extends WebView {
    static final String JS_INTERFACE_NAME = "interface";
    static final String PROPERTY_BANNER_TYPE = "PROPERTY_BANNER_TYPE";
    static final String PROPERTY_EXPANDING = "PROPERTY_EXPANDING";
    static final String PROPERTY_STATE = "PROPERTY_STATE";
    private HttpMMHeaders _lastHeaders;
    long creatorAdImplId;
    int currentColor;
    String currentUrl;
    boolean hadFirstRecordingCreation = false;
    boolean hadFirstSpeechKitCreation = false;
    volatile boolean isExpanding;
    boolean isSendingSize = true;
    volatile boolean isUserClosedResize;
    volatile boolean isVisible = false;
    volatile String mraidState;
    int oldHeight = -50;
    int oldWidth = -50;
    volatile boolean requiresPreAdSizeFix;
    final GestureDetector tapDetector;
    final String userAgent;

    /*
     * Enabled aggressive block sorting
     */
    public MMWebView(Context context, long l2) {
        super(context);
        MMSDK.Log.d("Setting isExpanding in constructor to " + this.isExpanding);
        this.setWillNotDraw(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnTouchListener(new WebTouchListener(this));
        this.mraidState = "loading";
        this.creatorAdImplId = l2;
        Object[] objectArray = new Object[]{this.creatorAdImplId};
        MMSDK.Log.v("Assigning WebView internal id: %d", objectArray);
        this.setId((int)(15063L + this.creatorAdImplId));
        if (HandShake.sharedHandShake((Context)context).hardwareAccelerationEnabled) {
            this.enableHardwareAcceleration();
        } else {
            this.disableAllAcceleration();
        }
        this.setMediaPlaybackRequiresUserGesture(false);
        this.setWebChromeClient(new MyWebChromeClient(this));
        WebSettings webSettings = this.getSettings();
        this.userAgent = webSettings.getUserAgentString();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setDefaultTextEncodingName("UTF-8");
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setGeolocationEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        this.tapDetector = new GestureDetector(context.getApplicationContext(), (GestureDetector.OnGestureListener)new WebGestureListener(this));
    }

    private boolean hasDefaultResizeParams() {
        return this.oldWidth == -50 && this.oldHeight == -50;
    }

    private boolean isInterstitial() {
        return this.getBanner() == null;
    }

    private boolean needsSamsungJBOpenGlFixNoAcceleration() {
        int n2 = Integer.parseInt(Build.VERSION.SDK);
        return "Nexus S".equals(Build.MODEL) && "samsung".equals(Build.MANUFACTURER) && (n2 == 16 || n2 == 17);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean allowMicrophoneCreationCommands() {
        boolean bl2 = true;
        if (this.hadFirstRecordingCreation) {
            return this.allowRecordingCommands();
        }
        this.hadFirstRecordingCreation = bl2;
        if (!this.isInterstitial()) return false;
        if (this.isVisible) return bl2;
        return false;
    }

    boolean allowRecordingCommands() {
        return this.hasWindowFocus() && this.isInterstitial();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean allowSpeechCreationCommands() {
        boolean bl2 = true;
        if (this.hadFirstSpeechKitCreation) {
            return this.allowRecordingCommands();
        }
        this.hadFirstSpeechKitCreation = bl2;
        if (!this.isInterstitial()) return false;
        if (this.isVisible) return bl2;
        return false;
    }

    void animateTransition(final MMAdImpl mMAdImpl) {
        FutureTask<Void> futureTask = new FutureTask<Void>(new Callable<Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() {
                try {
                    MMWebView.this.buildDrawingCache();
                    Bitmap bitmap = MMWebView.this.getDrawingCache();
                    if (bitmap != null) {
                        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap);
                        mMAdImpl.prepareTransition(bitmap2);
                    }
                    MMWebView.this.destroyDrawingCache();
                    return null;
                }
                catch (Exception exception) {
                    MMSDK.Log.d(exception);
                    return null;
                }
            }
        });
        MMSDK.runOnUiThread(futureTask);
        try {
            futureTask.get();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (ExecutionException executionException) {
            return;
        }
    }

    boolean canScroll() {
        return this.getParent() instanceof MMAdView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        try {
            this.resetSpeechKit();
        }
        catch (Exception exception) {}
        super.destroy();
    }

    void disableAllAcceleration() {
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Paint.class};
            Method method = WebView.class.getMethod("setLayerType", classArray);
            Object[] objectArray = new Object[]{0, null};
            method.invoke((Object)this, objectArray);
            MMSDK.Log.d("Remove allAcceleration");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void enableHardwareAcceleration() {
        if (this.needsSamsungJBOpenGlFixNoAcceleration()) return;
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Paint.class};
            Method method = WebView.class.getMethod("setLayerType", classArray);
            Object[] objectArray = new Object[]{2, null};
            method.invoke((Object)this, objectArray);
            MMSDK.Log.d("Enabled hardwareAcceleration");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void enableSendingSize() {
        this.isSendingSize = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void enableSoftwareAcceleration() {
        if (this.needsSamsungJBOpenGlFixNoAcceleration()) return;
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Paint.class};
            Method method = WebView.class.getMethod("setLayerType", classArray);
            Object[] objectArray = new Object[]{1, null};
            method.invoke((Object)this, objectArray);
            MMSDK.Log.d("Enable softwareAcceleration");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Activity getActivity() {
        synchronized (this) {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) return null;
            if (!(viewParent instanceof ViewGroup)) return null;
            Context context = ((ViewGroup)viewParent).getContext();
            if (context == null) return null;
            if (!(context instanceof MMActivity)) return null;
            return (MMActivity)context;
        }
    }

    String getAdId() {
        if (this._lastHeaders != null && !TextUtils.isEmpty((CharSequence)this._lastHeaders.acid)) {
            return this._lastHeaders.acid;
        }
        return "DEFAULT_AD_ID";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    AdViewOverlayView getAdViewOverlayView() {
        synchronized (this) {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) return null;
            if (!(viewParent instanceof AdViewOverlayView)) return null;
            return (AdViewOverlayView)viewParent;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MMAdView getBanner() {
        synchronized (this) {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) return null;
            if (!(viewParent instanceof MMAdView)) return null;
            return (MMAdView)viewParent;
        }
    }

    HttpMMHeaders getLastHeaders() {
        return this._lastHeaders;
    }

    MMAdView getMMAdView() {
        if (this.getParent() instanceof MMAdView) {
            return (MMAdView)this.getParent();
        }
        return null;
    }

    MMLayout getMMLayout() {
        if (this.getParent() instanceof MMLayout) {
            return (MMLayout)this.getParent();
        }
        return null;
    }

    String getUserAgent() {
        return this.userAgent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isCurrentParent(long l2) {
        ViewParent viewParent = this.getParent();
        if (viewParent == null) {
            return false;
        }
        MMSDK.Log.w("Id check for parent: " + l2 + " versus " + ((MMLayout)viewParent).adImpl.internalId);
        if (l2 != ((MMLayout)viewParent).adImpl.internalId) return false;
        return true;
    }

    boolean isMraidResized() {
        return "resized".equals(this.mraidState);
    }

    boolean isOriginalUrl(String string2) {
        return !TextUtils.isEmpty((CharSequence)this.currentUrl) && string2.equals(this.currentUrl + "?") || string2.equals(this.currentUrl + "#");
    }

    boolean isParentBannerAd() {
        if (this.getParent() != null) {
            return (ViewGroup)this.getParent() instanceof MMAdView;
        }
        return false;
    }

    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        this.currentUrl = string2;
        super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
    }

    public void loadUrl(final String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (string2.startsWith("http")) {
            this.currentUrl = string2;
        }
        MMSDK.Log.v("loadUrl @@" + string2);
        if (MMSDK.isUiThread()) {
            try {
                super.loadUrl(string2);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        MMSDK.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MMWebView.this.loadUrl(string2);
            }
        });
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        int n4 = View.MeasureSpec.getSize((int)n3);
        int n5 = View.MeasureSpec.getSize((int)n2);
        int n6 = this.getMeasuredHeight();
        if (n6 == 0) {
            n6 = n4;
        }
        if (this.requiresPreAdSizeFix) {
            this.setMeasuredDimension(1, 1);
            return;
        }
        this.setMeasuredDimension(n5, n6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onPauseWebView() {
        if (Build.VERSION.SDK_INT < 11) return;
        try {
            WebView.class.getMethod("onPause", new Class[0]).invoke((Object)this, new Object[0]);
            return;
        }
        catch (Exception exception) {
            MMSDK.Log.w("No onPause()");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onResumeWebView() {
        if (Build.VERSION.SDK_INT < 11) return;
        try {
            WebView.class.getMethod("onResume", new Class[0]).invoke((Object)this, new Object[0]);
            return;
        }
        catch (Exception exception) {
            MMSDK.Log.w("No onResume()");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        int[] nArray = new int[2];
        this.getLocationInWindow(nArray);
        DisplayMetrics displayMetrics = MMSDK.getMetrics(this.getContext());
        if (displayMetrics != null) {
            DTOAdViewLayout dTOAdViewLayout = new DTOAdViewLayout((int)((float)nArray[0] / displayMetrics.density), (int)((float)nArray[1] / displayMetrics.density), (int)((float)n2 / displayMetrics.density), (int)((float)n3 / displayMetrics.density));
            String string2 = new Gson().toJson(dTOAdViewLayout);
            if (this.isSendingSize) {
                this.loadUrl("javascript:MMJS.sdk.setAdSize(" + string2 + ");");
                MMSDK.Log.w(" @@@ SENDING IT!!!@@@@@  adSize ! " + string2);
                if (this.getHeight() != 1 || this.getWidth() != 1) {
                    MMSDK.runOnUiThreadDelayed(new Runnable(){

                        @Override
                        public void run() {
                            MMWebView.this.isSendingSize = false;
                        }
                    }, 800L);
                }
            } else {
                MMSDK.Log.w(" @@@ Not sending adSize ! " + string2);
            }
        }
        super.onSizeChanged(n2, n3, n4, n5);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.requestFocus();
        }
        if (this.tapDetector != null) {
            this.tapDetector.onTouchEvent(motionEvent);
        }
        if (motionEvent.getAction() == 1) {
            Object[] objectArray = new Object[]{motionEvent.getAction(), Float.valueOf(motionEvent.getX()), Float.valueOf(motionEvent.getY())};
            MMSDK.Log.v("Ad clicked: action=%d x=%f y=%f", objectArray);
        }
        return super.onTouchEvent(motionEvent);
    }

    void removeFromParent() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this);
        }
    }

    void resetSpeechKit() {
        BridgeMMSpeechkit.releaseSpeechKit();
        this.hadFirstSpeechKitCreation = false;
        this.hadFirstRecordingCreation = false;
    }

    void setAdProperties(JSONObject jSONObject) {
        if (jSONObject != null) {
            this.loadUrl("javascript:MMJS.sdk.setAdProperties(" + jSONObject + ");");
        }
    }

    public void setBackgroundColor(int n2) {
        this.currentColor = n2;
        if (n2 == 0) {
            this.enableSoftwareAcceleration();
        }
        super.setBackgroundColor(n2);
    }

    void setLastHeaders(HttpMMHeaders httpMMHeaders) {
        this._lastHeaders = httpMMHeaders;
    }

    void setMediaPlaybackRequiresUserGesture(boolean bl2) {
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            Method method = WebView.class.getMethod("setMediaPlaybackRequiresUserGesture", classArray);
            Object[] objectArray = new Object[]{bl2};
            method.invoke((Object)this, objectArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void setMraidDefault() {
        this.loadUrl("javascript:MMJS.sdk.setState('default')");
        this.mraidState = "default";
        this.isSendingSize = true;
    }

    void setMraidExpanded() {
        MMSDK.Log.d("Changing state to EXPANDED for ---- " + this.toString() + "---- of creatorId ---" + this.creatorAdImplId + " ----");
        this.loadUrl("javascript:MMJS.sdk.setState('expanded');");
        this.mraidState = "expanded";
        this.hadFirstSpeechKitCreation = false;
        this.hadFirstRecordingCreation = false;
        this.isSendingSize = true;
    }

    void setMraidHidden() {
        this.loadUrl("javascript:MMJS.sdk.setState('hidden')");
        this.mraidState = "hidden";
    }

    void setMraidPlacementTypeInline() {
        this.loadUrl("javascript:MMJS.sdk.setPlacementType('inline');");
    }

    void setMraidPlacementTypeInterstitial() {
        this.loadUrl("javascript:MMJS.sdk.setPlacementType('interstitial');");
    }

    void setMraidReady() {
        this.loadUrl("javascript:MMJS.sdk.ready();");
    }

    void setMraidResize(final DTOResizeParameters dTOResizeParameters) {
        synchronized (this) {
            if (MMSDK.hasSetTranslationMethod()) {
                final MMAdView mMAdView = this.getMMAdView();
                this.isUserClosedResize = false;
                MMSDK.Log.d("New DTOResizeParameters = " + dTOResizeParameters);
                if (mMAdView != null) {
                    MMSDK.runOnUiThread(new Runnable(){

                        private void handleMraidResize(DTOResizeParameters dTOResizeParameters2) {
                            MMAdView mMAdView2 = mMAdView;
                            mMAdView2.getClass();
                            MMAdView.BannerBounds bannerBounds = new MMAdView.BannerBounds(mMAdView2, dTOResizeParameters2);
                            this.setUnresizeParameters();
                            bannerBounds.modifyLayoutParams(MMWebView.this.getLayoutParams());
                        }

                        private void setUnresizeParameters() {
                            if (MMWebView.this.hasDefaultResizeParams()) {
                                ViewGroup.LayoutParams layoutParams = MMWebView.this.getLayoutParams();
                                MMWebView.this.oldWidth = layoutParams.width;
                                MMWebView.this.oldHeight = layoutParams.height;
                                if (MMWebView.this.oldWidth <= 0) {
                                    MMWebView.this.oldWidth = MMWebView.this.getWidth();
                                }
                                if (MMWebView.this.oldHeight <= 0) {
                                    MMWebView.this.oldHeight = MMWebView.this.getHeight();
                                }
                            }
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            MMWebView mMWebView = MMWebView.this;
                            synchronized (mMWebView) {
                                MMWebView.this.isSendingSize = true;
                                mMAdView.handleMraidResize(dTOResizeParameters);
                                this.handleMraidResize(dTOResizeParameters);
                                MMWebView.this.loadUrl("javascript:MMJS.sdk.setState('resized');");
                                MMWebView.this.mraidState = "resized";
                                return;
                            }
                        }
                    });
                }
            }
            return;
        }
    }

    void setMraidViewableHidden() {
        this.loadUrl("javascript:MMJS.sdk.setViewable(false)");
        this.isVisible = false;
    }

    void setMraidViewableVisible() {
        this.loadUrl("javascript:MMJS.sdk.setViewable(true)");
        this.isVisible = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setWebViewContent(String string2, String string3, Context context) {
        if (string2 == null || string3 == null) {
            return;
        }
        final String string4 = string3.substring(0, 1 + string3.lastIndexOf("/"));
        this.resetSpeechKit();
        String string5 = string2;
        if (MRaid.hasMraidLocally(context)) {
            string5 = MRaid.injectMraidJs(context, string5);
        } else {
            MMSDK.Log.e("MMJS is not downloaded");
        }
        final String string6 = string5;
        if (MMSDK.logLevel >= 5) {
            MMSDK.Log.v("Received ad with base url %s.", string3);
            MMSDK.Log.v(string2);
        }
        MMSDK.runOnUiThread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                if (HandShake.sharedHandShake((Context)MMWebView.this.getContext()).hardwareAccelerationEnabled) {
                    MMWebView.this.enableHardwareAcceleration();
                } else if (MMWebView.this.currentColor == 0) {
                    MMWebView.this.enableSoftwareAcceleration();
                } else {
                    MMWebView.this.disableAllAcceleration();
                }
                MMWebView.this.isSendingSize = true;
                MMWebView.this.loadDataWithBaseURL(string4, string6, "text/html", "UTF-8", null);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    void setWebViewContent(String string2, String string3, final MMAdImpl mMAdImpl) {
        if (string2 == null || string3 == null || mMAdImpl == null) {
            return;
        }
        this.unresizeToDefault(mMAdImpl);
        this.resetSpeechKit();
        final String string4 = string3.substring(0, 1 + string3.lastIndexOf("/"));
        if (MMSDK.logLevel >= 5) {
            MMSDK.Log.v("Received ad with base url %s.", string4);
            MMSDK.Log.v(string2);
        }
        if (mMAdImpl.isTransitionAnimated()) {
            this.animateTransition(mMAdImpl);
        }
        final String string5 = mMAdImpl.ignoreDensityScaling ? "<head><meta name=\"viewport\" content=\"target-densitydpi=device-dpi\" /></head>" + string2 : string2;
        if (MRaid.hasMraidLocally(mMAdImpl.getContext())) {
            string5 = MRaid.injectMraidJs(mMAdImpl.getContext(), string5);
        } else {
            MMSDK.Log.e("MMJS is not downloaded");
        }
        MMSDK.runOnUiThread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                MMAd mMAd;
                if (HandShake.sharedHandShake((Context)MMWebView.this.getContext()).hardwareAccelerationEnabled) {
                    MMWebView.this.enableHardwareAcceleration();
                } else if (MMWebView.this.currentColor == 0) {
                    MMWebView.this.enableSoftwareAcceleration();
                } else {
                    MMWebView.this.disableAllAcceleration();
                }
                if ((mMAd = mMAdImpl.getCallingAd()) != null && mMAd instanceof MMLayout) {
                    ((MMLayout)mMAd).removeVideo();
                }
                MMWebView.this.isSendingSize = true;
                MMWebView.this.loadDataWithBaseURL(string4, string5, "text/html", "UTF-8", null);
            }
        });
    }

    void setmicrophoneAudioLevelChange(double d2) {
        this.loadUrl("javascript:MMJS.sdk.microphoneAudioLevelChange(" + d2 + ")");
    }

    void setmicrophoneStateChange(String string2) {
        this.loadUrl("javascript:MMJS.sdk.microphoneStateChange('" + string2 + "')");
    }

    public String toString() {
        return "MMWebView originally from(" + this.creatorAdImplId + ") MRaidState(" + this.mraidState + ")." + super.toString();
    }

    void unresizeToDefault(MMAdImpl mMAdImpl) {
        synchronized (this) {
            MMAd mMAd;
            if (MMSDK.hasSetTranslationMethod() && this.isMraidResized() && mMAdImpl != null && (mMAd = mMAdImpl.getCallingAd()) instanceof MMAdView) {
                final MMAdView mMAdView = (MMAdView)mMAd;
                this.isUserClosedResize = true;
                MMSDK.runOnUiThread(new Runnable(){

                    void handleUnresize() {
                        if (MMSDK.hasSetTranslationMethod() && !MMWebView.this.hasDefaultResizeParams()) {
                            ViewGroup.LayoutParams layoutParams = MMWebView.this.getLayoutParams();
                            layoutParams.width = MMWebView.this.oldWidth;
                            layoutParams.height = MMWebView.this.oldHeight;
                            MMWebView.this.oldWidth = -50;
                            MMWebView.this.oldHeight = -50;
                            MMWebView.this.requestLayout();
                        }
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        MMWebView mMWebView = MMWebView.this;
                        synchronized (mMWebView) {
                            mMAdView.handleUnresize();
                            this.handleUnresize();
                            MMWebView.this.setMraidDefault();
                            MMWebView.this.isSendingSize = true;
                            MMWebView.this.invalidate();
                            return;
                        }
                    }
                });
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateArgumentsWithSettings(Map<String, String> map) {
        String string2 = this.isParentBannerAd() ? "true" : "false";
        map.put(PROPERTY_BANNER_TYPE, string2);
        map.put(PROPERTY_STATE, this.mraidState);
        map.put(PROPERTY_EXPANDING, String.valueOf(this.creatorAdImplId));
    }

    private static class MyWebChromeClient
    extends WebChromeClient {
        private static final String KEY_USE_GEO = "mm_use_geo_location";
        WeakReference<MMWebView> webRef;

        MyWebChromeClient(MMWebView mMWebView) {
            this.webRef = new WeakReference<MMWebView>(mMWebView);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getApplicationName(Context context) {
            void var5_6;
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                ApplicationInfo applicationInfo2;
                applicationInfo = applicationInfo2 = packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                CharSequence charSequence = packageManager.getApplicationLabel(applicationInfo);
                return (String)var5_6;
            }
            return (String)var5_6;
        }

        private boolean isFirstGeoRequest() {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            boolean bl2 = false;
            if (mMWebView != null) {
                boolean bl3 = mMWebView.getContext().getSharedPreferences("MillennialMediaSettings", 0).contains(KEY_USE_GEO);
                bl2 = false;
                if (!bl3) {
                    bl2 = true;
                }
            }
            return bl2;
        }

        private boolean retrieveUseGeo() {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            boolean bl2 = false;
            if (mMWebView != null) {
                bl2 = mMWebView.getContext().getSharedPreferences("MillennialMediaSettings", 0).getBoolean(KEY_USE_GEO, false);
            }
            return bl2;
        }

        private void saveUseGeo(boolean bl2) {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            if (mMWebView != null) {
                SharedPreferences.Editor editor = mMWebView.getContext().getSharedPreferences("MillennialMediaSettings", 0).edit();
                editor.putBoolean(KEY_USE_GEO, bl2);
                editor.commit();
            }
        }

        public void onConsoleMessage(String string2, int n2, String string3) {
            super.onConsoleMessage(string2, n2, string3);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onGeolocationPermissionsShowPrompt(final String string2, final GeolocationPermissions.Callback callback) {
            if (!this.isFirstGeoRequest()) {
                callback.invoke(string2, false, false);
                return;
            }
            if (this.retrieveUseGeo()) {
                callback.invoke(string2, true, true);
                return;
            } else {
                Activity activity;
                MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
                if (mMWebView == null || (activity = mMWebView.getActivity()) == null) return;
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                builder.setTitle((CharSequence)this.getApplicationName((Context)activity));
                builder.setMessage((CharSequence)"Would like to use your Current Location.").setPositiveButton((CharSequence)"Allow", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n2) {
                        MyWebChromeClient.this.saveUseGeo(true);
                        callback.invoke(string2, true, true);
                    }
                }).setNegativeButton((CharSequence)"Don't Allow", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n2) {
                        MyWebChromeClient.this.saveUseGeo(false);
                        callback.invoke(string2, false, false);
                    }
                });
                builder.create().show();
                return;
            }
        }

        public boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            if (mMWebView != null) {
                if (mMWebView.getContext() != mMWebView.getContext().getApplicationContext()) {
                    return super.onJsAlert(webView, string2, string3, jsResult);
                }
                Toast.makeText((Context)mMWebView.getContext(), (CharSequence)string3, (int)0).show();
            }
            return true;
        }

        public boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            if (mMWebView != null) {
                if (mMWebView.getContext() != mMWebView.getContext().getApplicationContext()) {
                    return super.onJsBeforeUnload(webView, string2, string3, jsResult);
                }
                Toast.makeText((Context)mMWebView.getContext(), (CharSequence)string3, (int)0).show();
            }
            return true;
        }

        public boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            if (mMWebView != null) {
                if (mMWebView.getContext() != mMWebView.getContext().getApplicationContext()) {
                    return super.onJsConfirm(webView, string2, string3, jsResult);
                }
                Toast.makeText((Context)mMWebView.getContext(), (CharSequence)string3, (int)0).show();
            }
            return true;
        }

        public boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            if (mMWebView != null) {
                if (mMWebView.getContext() != mMWebView.getContext().getApplicationContext()) {
                    return super.onJsPrompt(webView, string2, string3, string4, jsPromptResult);
                }
                Toast.makeText((Context)mMWebView.getContext(), (CharSequence)string3, (int)0).show();
            }
            return true;
        }
    }

    private static class WebGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        WeakReference<MMWebView> webRef;

        public WebGestureListener(MMWebView mMWebView) {
            this.webRef = new WeakReference<MMWebView>(mMWebView);
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            if (mMWebView != null) {
                MMSDK.Event.adSingleTap(MMAdImplController.getAdImplWithId(mMWebView.creatorAdImplId));
            }
            return false;
        }
    }

    private static class WebTouchListener
    implements View.OnTouchListener {
        WeakReference<MMWebView> webRef;

        WebTouchListener(MMWebView mMWebView) {
            this.webRef = new WeakReference<MMWebView>(mMWebView);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onTouch(View view, MotionEvent motionEvent) {
            MMWebView mMWebView = (MMWebView)((Object)this.webRef.get());
            boolean bl2 = motionEvent.getAction() == 2;
            if (mMWebView == null) return bl2;
            if (!bl2) return false;
            if (!mMWebView.canScroll()) return false;
            return true;
        }
    }
}

