/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.CachedAd;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.HttpGetRequest;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMConversionTracker;
import com.millennialmedia.android.MMException;
import com.millennialmedia.android.MMRequest;
import com.millennialmedia.android.Utils;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.apache.http.conn.util.InetAddressUtils;

public final class MMSDK {
    private static final String BASE_URL_TRACK_EVENT = "http://ads.mp.mydas.mobi/pixel?id=";
    static final int CACHE_REQUEST_TIMEOUT = 30000;
    static final int CLOSE_ACTIVITY_DURATION = 400;
    static String COMMA;
    public static final String DEFAULT_APID = "28911";
    public static final String DEFAULT_BANNER_APID = "28913";
    public static final String DEFAULT_RECT_APID = "28914";
    static final String EMPTY = "";
    static final int HANDSHAKE_REQUEST_TIMEOUT = 3000;
    static final String JSON_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss ZZZZ";
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_ERROR = 0;
    public static final int LOG_LEVEL_INFO = 2;
    @Deprecated
    public static final int LOG_LEVEL_INTERNAL = 4;
    @Deprecated
    public static final int LOG_LEVEL_PRIVATE_VERBOSE = 5;
    public static final int LOG_LEVEL_VERBOSE = 3;
    static final int OPEN_ACTIVITY_DURATION = 600;
    static final String PREFS_NAME = "MillennialMediaSettings";
    static final int REQUEST_TIMEOUT = 10000;
    public static final String SDKLOG = "MillennialMediaSDK";
    public static final String VERSION = "5.1.0-13.08.12.a";
    @Deprecated
    public static boolean debugMode;
    @Deprecated
    static boolean disableAdMinRefresh;
    private static String getMMdidValue;
    private static boolean hasSpeechKit;
    private static boolean isBroadcastingEvents;
    static int logLevel;
    static String macId;
    static Handler mainHandler;
    private static int nextDefaultId;

    static {
        disableAdMinRefresh = false;
        nextDefaultId = 1897808289;
        COMMA = ",";
        mainHandler = new Handler(Looper.getMainLooper());
        getMMdidValue = null;
        hasSpeechKit = false;
        try {
            System.loadLibrary("nmsp_speex");
            hasSpeechKit = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    private MMSDK() {
    }

    static String byteArrayToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            Object[] objectArray = new Object[]{byArray[i2]};
            stringBuilder.append(String.format("%02X", objectArray));
        }
        return stringBuilder.toString();
    }

    static void checkActivity(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getActivityInfo(new ComponentName(context, "com.millennialmedia.android.MMActivity"), 128);
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e("Activity MMActivity not declared in AndroidManifest.xml");
            nameNotFoundException.printStackTrace();
            MMSDK.createMissingPermissionDialog(context, "MMActivity class").show();
            return;
        }
    }

    static void checkPermissions(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") == -1) {
            MMSDK.createMissingPermissionDialog(context, "INTERNET permission").show();
        }
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == -1) {
            MMSDK.createMissingPermissionDialog(context, "ACCESS_NETWORK_STATE permission").show();
        }
    }

    private static AlertDialog createMissingPermissionDialog(Context context, String string2) {
        AlertDialog alertDialog = new AlertDialog.Builder(context).create();
        alertDialog.setTitle((CharSequence)"Whoops!");
        alertDialog.setMessage((CharSequence)String.format("The developer has forgot to declare the %s in the manifest file. Please reach out to the developer to remove this error.", string2));
        alertDialog.setButton(-3, (CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                dialogInterface.cancel();
            }
        });
        alertDialog.show();
        return alertDialog;
    }

    public static boolean getBroadcastEvents() {
        return isBroadcastingEvents;
    }

    static Configuration getConfiguration(Context context) {
        return context.getResources().getConfiguration();
    }

    static String getConnectionType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return "unknown";
        }
        if (connectivityManager.getActiveNetworkInfo() != null && connectivityManager.getActiveNetworkInfo().isConnected()) {
            int n2 = connectivityManager.getActiveNetworkInfo().getType();
            int n3 = connectivityManager.getActiveNetworkInfo().getSubtype();
            if (n2 == 1) {
                return "wifi";
            }
            if (n2 == 0) {
                switch (n3) {
                    default: {
                        return "unknown";
                    }
                    case 7: {
                        return "1xrtt";
                    }
                    case 4: {
                        return "cdma";
                    }
                    case 2: {
                        return "edge";
                    }
                    case 14: {
                        return "ehrpd";
                    }
                    case 5: {
                        return "evdo_0";
                    }
                    case 6: {
                        return "evdo_a";
                    }
                    case 12: {
                        return "evdo_b";
                    }
                    case 1: {
                        return "gprs";
                    }
                    case 8: {
                        return "hsdpa";
                    }
                    case 10: {
                        return "hspa";
                    }
                    case 15: {
                        return "hspap";
                    }
                    case 9: {
                        return "hsupa";
                    }
                    case 11: {
                        return "iden";
                    }
                    case 13: {
                        return "lte";
                    }
                    case 3: 
                }
                return "umts";
            }
            return "unknown";
        }
        return "offline";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getDefaultAdId() {
        synchronized (MMSDK.class) {
            int n2;
            nextDefaultId = n2 = 1 + nextDefaultId;
            return n2;
        }
    }

    static float getDensity(Context context) {
        DisplayMetrics displayMetrics = MMSDK.getMetrics(context);
        if (displayMetrics == null) {
            return 1.0f;
        }
        return displayMetrics.density;
    }

    private static String getDensityString(Context context) {
        return Float.toString(MMSDK.getDensity(context));
    }

    static String getDpiHeight(Context context) {
        String string2;
        if (MMSDK.needsRawDisplayMethod() && !TextUtils.isEmpty((CharSequence)(string2 = MMSDK.getRawSize(context, "getRawHeight")))) {
            return string2;
        }
        return MMSDK.getDpiHeightFrom(MMSDK.getMetrics(context));
    }

    private static String getDpiHeightFrom(DisplayMetrics displayMetrics) {
        return Integer.toString(displayMetrics.heightPixels);
    }

    static String getDpiWidth(Context context) {
        String string2;
        if (MMSDK.needsRawDisplayMethod() && !TextUtils.isEmpty((CharSequence)(string2 = MMSDK.getRawSize(context, "getRawWidth")))) {
            return string2;
        }
        return MMSDK.getDpiWidthFrom(MMSDK.getMetrics(context));
    }

    private static String getDpiWidthFrom(DisplayMetrics displayMetrics) {
        return Integer.toString(displayMetrics.widthPixels);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getIpAddress(Context context) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block3: while (true) {
                if (!enumeration.hasMoreElements()) return stringBuilder.toString();
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (true) {
                    String string2;
                    if (!enumeration2.hasMoreElements()) continue block3;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    if (InetAddressUtils.isIPv4Address((String)(string2 = inetAddress.getHostAddress().toUpperCase()))) {
                        stringBuilder.append(string2);
                        continue;
                    }
                    int n2 = string2.indexOf(37);
                    String string3 = n2 < 0 ? string2 : string2.substring(0, n2);
                    stringBuilder.append(string3);
                }
                break;
            }
        }
        catch (Exception exception) {
            Log.e(exception);
            return EMPTY;
        }
    }

    public static int getLogLevel() {
        return logLevel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getMMdid(Context context) {
        synchronized (MMSDK.class) {
            if (getMMdidValue != null) {
                return getMMdidValue;
            }
            String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            String string3 = null;
            if (string2 == null) return string3;
            StringBuilder stringBuilder = new StringBuilder("mmh_");
            try {
                stringBuilder.append(MMSDK.byteArrayToString(MessageDigest.getInstance("MD5").digest(string2.getBytes())));
                stringBuilder.append("_");
                stringBuilder.append(MMSDK.byteArrayToString(MessageDigest.getInstance("SHA1").digest(string2.getBytes())));
                getMMdidValue = string3 = stringBuilder.toString();
            }
            catch (Exception exception) {
                Log.v(exception.getMessage());
                return null;
            }
            return string3;
        }
    }

    static String getMcc(Context context) {
        String string2;
        Configuration configuration = MMSDK.getConfiguration(context);
        if (configuration.mcc == 0 && (string2 = MMSDK.getNetworkOperator(context)) != null && string2.length() >= 6) {
            return string2.substring(0, 3);
        }
        return String.valueOf(configuration.mcc);
    }

    static int getMediaVolume(Context context) {
        return ((AudioManager)context.getApplicationContext().getSystemService("audio")).getStreamVolume(3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DisplayMetrics getMetrics(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (!MMSDK.needsRealDisplayMethod()) return displayMetrics;
        try {
            Display.class.getMethod("getRealMetrics", new Class[0]).invoke((Object)displayMetrics, new Object[0]);
        }
        catch (Exception exception) {
            return displayMetrics;
        }
        return displayMetrics;
    }

    static String getMnc(Context context) {
        String string2;
        Configuration configuration = MMSDK.getConfiguration(context);
        if (configuration.mnc == 0 && (string2 = MMSDK.getNetworkOperator(context)) != null && string2.length() >= 6) {
            return string2.substring(3);
        }
        return String.valueOf(configuration.mnc);
    }

    static String getNetworkOperator(Context context) {
        return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperator();
    }

    static String getOrientation(Context context) {
        switch (context.getResources().getConfiguration().orientation) {
            default: {
                return "default";
            }
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
            case 3: 
        }
        return "square";
    }

    static final String getOrientationLocked(Context context) {
        if (Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"accelerometer_rotation").equals("1")) {
            return "false";
        }
        return "true";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getRawSize(Context context, String string2) {
        boolean bl2 = context instanceof Activity;
        String string3 = null;
        if (!bl2) return string3;
        Display display = ((Activity)context).getWindowManager().getDefaultDisplay();
        try {
            String string4 = String.valueOf((Integer)Display.class.getMethod(string2, new Class[0]).invoke((Object)display, new Object[0]));
            return string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String getSupportsSms(Context context) {
        return String.valueOf(context.getPackageManager().hasSystemFeature("android.hardware.telephony"));
    }

    static String getSupportsTel(Context context) {
        return String.valueOf(context.getPackageManager().hasSystemFeature("android.hardware.telephony"));
    }

    static boolean hasSetTranslationMethod() {
        return Integer.parseInt(Build.VERSION.SDK) >= 11;
    }

    private static String hasSpeechKit(Context context) {
        if (hasSpeechKit) {
            return "true";
        }
        return "false";
    }

    static String hasVoiceAbility(Context context) {
        if (!context.getPackageManager().hasSystemFeature("android.hardware.microphone")) {
            return "false";
        }
        if (MMSDK.getMediaVolume(context) == 0) {
            return "false";
        }
        int n2 = ((AudioManager)context.getApplicationContext().getSystemService("audio")).getRingerMode();
        if (n2 == 0 || n2 == 1) {
            return "false";
        }
        return "true";
    }

    public static void initialize(Context context) {
        HandShake handShake = HandShake.sharedHandShake(context);
        handShake.sendInitRequest();
        handShake.startSession();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void insertUrlCommonValues(Context context, Map<String, String> map) {
        String string2;
        String string3;
        String string4;
        map.put("density", MMSDK.getDensityString(context));
        map.put("hpx", MMSDK.getDpiHeight(context));
        map.put("wpx", MMSDK.getDpiWidth(context));
        map.put("sk", MMSDK.hasSpeechKit(context));
        map.put("mic", MMSDK.hasVoiceAbility(context));
        if (MMSDK.isCachedVideoSupportedOnDevice(context)) {
            map.put("cachedvideo", "true");
        } else {
            map.put("cachedvideo", "false");
        }
        if (Build.MODEL != null) {
            map.put("dm", Build.MODEL);
        }
        if (Build.VERSION.RELEASE != null) {
            map.put("dv", "Android" + Build.VERSION.RELEASE);
        }
        if ((string4 = MMSDK.getMMdid(context)) != null) {
            map.put("mmdid", string4);
        }
        map.put("sdkversion", VERSION);
        map.put("mmisdk", VERSION);
        map.put("mcc", MMSDK.getMcc(context));
        map.put("mnc", MMSDK.getMnc(context));
        Locale locale = Locale.getDefault();
        if (locale != null) {
            map.put("language", locale.getLanguage());
            map.put("country", locale.getCountry());
        }
        try {
            String string5 = context.getPackageName();
            map.put("pkid", string5);
            PackageManager packageManager = context.getPackageManager();
            map.put("pknm", ((Object)packageManager.getApplicationLabel(packageManager.getApplicationInfo(string5, 0))).toString());
        }
        catch (Exception exception) {}
        if (debugMode) {
            map.put("debug", "true");
        }
        if ((string3 = HandShake.sharedHandShake(context).getSchemesList(context)) != null) {
            map.put("appsids", string3);
        }
        if ((string2 = AdCache.getCachedVideoList(context)) != null) {
            map.put("vid", string2);
        }
        try {
            String string6;
            StatFs statFs;
            String string7 = MMSDK.getConnectionType(context);
            if (AdCache.isExternalStorageAvailable(context)) {
                String string8 = AdCache.getCacheDirectory(context).getAbsolutePath();
                statFs = new StatFs(string8);
            } else {
                String string9 = context.getFilesDir().getPath();
                statFs = new StatFs(string9);
            }
            String string10 = Long.toString((long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize());
            Intent intent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            String string11 = null;
            String string12 = null;
            if (intent != null) {
                string12 = intent.getIntExtra("plugged", 0) == 0 ? "false" : "true";
                string11 = Integer.toString((int)(100.0f / (float)intent.getIntExtra("scale", 100) * (float)intent.getIntExtra("level", 0)));
            }
            if (string11 != null && string11.length() > 0) {
                map.put("bl", string11);
            }
            if (string12 != null && string12.length() > 0) {
                map.put("plugged", string12);
            }
            if (string10.length() > 0) {
                map.put("space", string10);
            }
            if (string7 != null) {
                map.put("conn", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = URLEncoder.encode(MMSDK.getIpAddress(context), "UTF-8")))) {
                map.put("pip", string6);
            }
        }
        catch (Exception exception) {
            Log.v(exception);
        }
        MMRequest.insertLocation(map);
    }

    static boolean isCachedVideoSupportedOnDevice(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != -1 && (!Build.VERSION.SDK.equalsIgnoreCase("8") || Environment.getExternalStorageState().equals("mounted") && AdCache.isExternalEnabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isConnected(Context context) {
        boolean bl2 = true;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        if (connectivityManager.getActiveNetworkInfo() == null) return false;
        if (connectivityManager.getActiveNetworkInfo().isConnected() != bl2) return false;
        return bl2;
    }

    static boolean isUiThread() {
        return mainHandler.getLooper() == Looper.myLooper();
    }

    private static boolean needsRawDisplayMethod() {
        return Integer.parseInt(Build.VERSION.SDK) >= 13 && Integer.parseInt(Build.VERSION.SDK) <= 16;
    }

    private static boolean needsRealDisplayMethod() {
        return Integer.parseInt(Build.VERSION.SDK) >= 17;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void printDiagnostics(MMAdImpl mMAdImpl) {
        Context context;
        block3: {
            block2: {
                if (mMAdImpl == null) break block2;
                context = mMAdImpl.getContext();
                Object[] objectArray = new Object[]{mMAdImpl.getId()};
                Log.i("MMAd External ID: %d", objectArray);
                Object[] objectArray2 = new Object[]{mMAdImpl.internalId};
                Log.i("MMAd Internal ID: %d", objectArray2);
                Object[] objectArray3 = new Object[]{mMAdImpl.apid};
                Log.i("APID: %s", objectArray3);
                Object[] objectArray4 = new Object[1];
                String string2 = AdCache.isExternalStorageAvailable(context) ? EMPTY : "not ";
                objectArray4[0] = string2;
                Log.i("SD card is %savailable.", objectArray4);
                if (context != null) break block3;
            }
            return;
        }
        Object[] objectArray = new Object[]{context.getPackageName()};
        Log.i("Package: %s", objectArray);
        Object[] objectArray5 = new Object[]{MMSDK.getMMdid(context)};
        Log.i("MMDID: %s", objectArray5);
        Log.i("Permissions:");
        Object[] objectArray6 = new Object[1];
        String string3 = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == -1 ? "not " : EMPTY;
        objectArray6[0] = string3;
        Log.i("android.permission.ACCESS_NETWORK_STATE is %spresent", objectArray6);
        Object[] objectArray7 = new Object[1];
        String string4 = context.checkCallingOrSelfPermission("android.permission.INTERNET") == -1 ? "not " : EMPTY;
        objectArray7[0] = string4;
        Log.i("android.permission.INTERNET is %spresent", objectArray7);
        Object[] objectArray8 = new Object[1];
        String string5 = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == -1 ? "not " : EMPTY;
        objectArray8[0] = string5;
        Log.i("android.permission.WRITE_EXTERNAL_STORAGE is %spresent", objectArray8);
        Object[] objectArray9 = new Object[1];
        String string6 = context.checkCallingOrSelfPermission("android.permission.VIBRATE") == -1 ? "not " : EMPTY;
        objectArray9[0] = string6;
        Log.i("android.permission.VIBRATE is %spresent", objectArray9);
        Object[] objectArray10 = new Object[1];
        String string7 = context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == -1 ? "not " : EMPTY;
        objectArray10[0] = string7;
        Log.i("android.permission.ACCESS_COARSE_LOCATION is %spresent", objectArray10);
        Object[] objectArray11 = new Object[1];
        String string8 = context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == -1 ? "not " : EMPTY;
        objectArray11[0] = string8;
        Log.i("android.permission.ACCESS_FINE_LOCATION is %spresent", objectArray11);
        Log.i("Cached Ads:");
        AdCache.iterateCachedAds(context, 2, new AdCache.Iterator(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            boolean callback(CachedAd cachedAd) {
                Object[] objectArray = new Object[4];
                objectArray[0] = cachedAd.getTypeString();
                objectArray[1] = cachedAd.getId();
                String string2 = cachedAd.isOnDisk(context) ? MMSDK.EMPTY : "not ";
                objectArray[2] = string2;
                String string3 = cachedAd.isExpired() ? MMSDK.EMPTY : "not ";
                objectArray[3] = string3;
                Log.i("%s %s is %son disk. Is %sexpired.", objectArray);
                return true;
            }
        });
    }

    static boolean removeAccelForJira1164() {
        return Integer.parseInt(Build.VERSION.SDK) >= 14;
    }

    public static void resetCache(Context context) {
        AdCache.resetCache(context);
    }

    static void runOnUiThread(Runnable runnable) {
        if (MMSDK.isUiThread()) {
            runnable.run();
            return;
        }
        mainHandler.post(runnable);
    }

    static void runOnUiThreadDelayed(Runnable runnable, long l2) {
        mainHandler.postDelayed(runnable, l2);
    }

    public static void setBroadcastEvents(boolean bl2) {
        isBroadcastingEvents = bl2;
    }

    public static void setLogLevel(int n2) {
        logLevel = n2;
    }

    static void setMMdid(String string2) {
        synchronized (MMSDK.class) {
            getMMdidValue = string2;
            return;
        }
    }

    static boolean supportsFullScreenInline() {
        return Integer.parseInt(Build.VERSION.SDK) >= 11;
    }

    public static void trackConversion(Context context, String string2) {
        MMConversionTracker.trackConversion(context, string2, null);
    }

    public static void trackConversion(Context context, String string2, MMRequest mMRequest) {
        MMConversionTracker.trackConversion(context, string2, mMRequest);
    }

    public static void trackEvent(Context context, String string2) {
        String string3;
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)(string3 = MMSDK.getMMdid(context)))) {
            Utils.HttpUtils.executeUrl(BASE_URL_TRACK_EVENT + string2 + "&mmdid=" + string3);
        }
    }

    static class Event {
        public static final String INTENT_EMAIL = "email";
        public static final String INTENT_EXTERNAL_BROWSER = "browser";
        public static final String INTENT_MAPS = "geo";
        public static final String INTENT_MARKET = "market";
        public static final String INTENT_PHONE_CALL = "tel";
        public static final String INTENT_STREAMING_VIDEO = "streamingVideo";
        public static final String INTENT_TXT_MESSAGE = "sms";
        private static final String KEY_ERROR = "error";
        static final String KEY_INTENT_TYPE = "intentType";
        static final String KEY_INTERNAL_ID = "internalId";
        static final String KEY_PACKAGE_NAME = "packageName";

        Event() {
        }

        /*
         * Enabled aggressive block sorting
         */
        static void adSingleTap(final MMAdImpl mMAdImpl) {
            block3: {
                block2: {
                    if (mMAdImpl == null) break block2;
                    MMSDK.runOnUiThread(new Runnable(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            if (mMAdImpl == null || mMAdImpl.requestListener == null) return;
                            try {
                                mMAdImpl.requestListener.onSingleTap(mMAdImpl.getCallingAd());
                                return;
                            }
                            catch (Exception exception) {
                                Log.w("Exception raised in your RequestListener: ", exception);
                                return;
                            }
                        }
                    });
                    if (isBroadcastingEvents) break block3;
                }
                return;
            }
            Event.sendIntent(mMAdImpl.getContext(), new Intent("millennialmedia.action.ACTION_OVERLAY_TAP"), mMAdImpl.internalId);
            Event.sendIntent(mMAdImpl.getContext(), new Intent("millennialmedia.action.ACTION_AD_SINGLE_TAP"), mMAdImpl.internalId);
        }

        static void displayStarted(MMAdImpl mMAdImpl) {
            if (mMAdImpl == null) {
                Log.w("No Context in the listener: ");
                return;
            }
            if (isBroadcastingEvents) {
                Event.sendIntent(mMAdImpl.getContext(), new Intent("millennialmedia.action.ACTION_DISPLAY_STARTED"), mMAdImpl.internalId);
            }
            Event.overlayOpened(mMAdImpl);
        }

        /*
         * Enabled aggressive block sorting
         */
        static void fetchStartedCaching(final MMAdImpl mMAdImpl) {
            if (mMAdImpl == null) {
                Log.w("No Context in the listener: ");
                return;
            } else {
                MMSDK.runOnUiThread(new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (mMAdImpl == null || mMAdImpl.requestListener == null) return;
                        try {
                            mMAdImpl.requestListener.MMAdRequestIsCaching(mMAdImpl.getCallingAd());
                            return;
                        }
                        catch (Exception exception) {
                            Log.w("Exception raised in your RequestListener: ", exception);
                            return;
                        }
                    }
                });
                if (!isBroadcastingEvents) return;
                Event.sendIntent(mMAdImpl.getContext(), new Intent("millennialmedia.action.ACTION_FETCH_STARTED_CACHING"), mMAdImpl.internalId);
                return;
            }
        }

        static void intentStarted(Context context, String string2, long l2) {
            if (isBroadcastingEvents && string2 != null) {
                Event.sendIntent(context, new Intent("millennialmedia.action.ACTION_INTENT_STARTED").putExtra(KEY_INTENT_TYPE, string2), l2);
            }
        }

        protected static void logEvent(final String string2) {
            Log.d("Logging event to: %s", string2);
            Utils.ThreadUtils.execute(new Runnable(){

                @Override
                public void run() {
                    HttpGetRequest httpGetRequest = new HttpGetRequest();
                    try {
                        httpGetRequest.get(string2);
                        return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        static void overlayClosed(final MMAdImpl mMAdImpl) {
            if (mMAdImpl == null) {
                Log.w("No Context in the listener: ");
                return;
            } else {
                MMSDK.runOnUiThread(new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (mMAdImpl == null || mMAdImpl.requestListener == null) return;
                        try {
                            mMAdImpl.requestListener.MMAdOverlayClosed(mMAdImpl.getCallingAd());
                            return;
                        }
                        catch (Exception exception) {
                            Log.w("Exception raised in your RequestListener: ", exception);
                            return;
                        }
                    }
                });
                if (!isBroadcastingEvents || mMAdImpl.getContext() == null) return;
                Event.sendIntent(mMAdImpl.getContext(), new Intent("millennialmedia.action.ACTION_OVERLAY_CLOSED"), mMAdImpl.internalId);
                return;
            }
        }

        static void overlayOpened(final MMAdImpl mMAdImpl) {
            if (mMAdImpl == null) {
                Log.w("No Context in the listener: ");
                return;
            }
            MMSDK.runOnUiThread(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (mMAdImpl == null || mMAdImpl.requestListener == null) return;
                    try {
                        mMAdImpl.requestListener.MMAdOverlayLaunched(mMAdImpl.getCallingAd());
                        return;
                    }
                    catch (Exception exception) {
                        Log.w("Exception raised in your RequestListener: ", exception);
                        return;
                    }
                }
            });
            Event.overlayOpenedBroadCast(mMAdImpl.getContext(), mMAdImpl.internalId);
        }

        static void overlayOpenedBroadCast(Context context, long l2) {
            if (isBroadcastingEvents) {
                Event.sendIntent(context, new Intent("millennialmedia.action.ACTION_OVERLAY_OPENED"), l2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        static void requestCompleted(final MMAdImpl mMAdImpl) {
            if (mMAdImpl == null) {
                Log.w("No Context in the listener: ");
                return;
            } else {
                MMSDK.runOnUiThread(new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (mMAdImpl == null || mMAdImpl.requestListener == null) return;
                        try {
                            mMAdImpl.requestListener.requestCompleted(mMAdImpl.getCallingAd());
                            return;
                        }
                        catch (Exception exception) {
                            Log.w("Exception raised in your RequestListener: ", exception);
                            return;
                        }
                    }
                });
                if (!isBroadcastingEvents) return;
                String string2 = mMAdImpl.getRequestCompletedAction();
                Event.sendIntent(mMAdImpl.getContext(), new Intent(string2), mMAdImpl.internalId);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        static void requestFailed(final MMAdImpl mMAdImpl, final MMException mMException) {
            if (mMAdImpl == null) {
                Log.w("No Context in the listener: ");
                return;
            } else {
                MMSDK.runOnUiThread(new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        if (mMAdImpl == null || mMAdImpl.requestListener == null) return;
                        try {
                            mMAdImpl.requestListener.requestFailed(mMAdImpl.getCallingAd(), mMException);
                            return;
                        }
                        catch (Exception exception) {
                            Log.w("Exception raised in your RequestListener: ", exception);
                            return;
                        }
                    }
                });
                if (!isBroadcastingEvents) return;
                String string2 = mMAdImpl.getRequestFailedAction();
                Event.sendIntent(mMAdImpl.getContext(), new Intent(string2).putExtra(KEY_ERROR, (Serializable)mMException), mMAdImpl.internalId);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private static final void sendIntent(Context context, Intent intent, long l2) {
            if (context != null) {
                intent.addCategory("millennialmedia.category.CATEGORY_SDK");
                if (l2 != -4L) {
                    intent.putExtra(KEY_INTERNAL_ID, l2);
                }
                intent.putExtra(KEY_PACKAGE_NAME, context.getPackageName());
                String string2 = intent.getStringExtra(KEY_INTENT_TYPE);
                String string3 = !TextUtils.isEmpty((CharSequence)string2) ? String.format(" Type[%s]", string2) : MMSDK.EMPTY;
                Log.v(" @@ Intent: " + intent.getAction() + " " + string3 + " for " + l2);
                context.sendBroadcast(intent);
            }
        }
    }

    static class Log {
        Log() {
        }

        static void d(String string2) {
            if (logLevel >= 1) {
                android.util.Log.i((String)MMSDK.SDKLOG, (String)("Diagnostic - " + string2));
            }
        }

        static void d(String string2, Object ... objectArray) {
            if (logLevel >= 1) {
                android.util.Log.i((String)MMSDK.SDKLOG, (String)("Diagnostic - " + String.format(string2, objectArray)));
            }
        }

        static void d(Throwable throwable) {
            if (logLevel >= 1) {
                Log.d(android.util.Log.getStackTraceString((Throwable)throwable));
            }
        }

        static void e(String string2) {
            android.util.Log.e((String)MMSDK.SDKLOG, (String)string2);
        }

        static void e(String string2, Object ... objectArray) {
            android.util.Log.e((String)MMSDK.SDKLOG, (String)String.format(string2, objectArray));
        }

        static void e(Throwable throwable) {
            Log.e(android.util.Log.getStackTraceString((Throwable)throwable));
        }

        static void i(String string2) {
            android.util.Log.i((String)MMSDK.SDKLOG, (String)string2);
        }

        static void i(String string2, Object ... objectArray) {
            android.util.Log.i((String)MMSDK.SDKLOG, (String)String.format(string2, objectArray));
        }

        static void i(Throwable throwable) {
            Log.i(android.util.Log.getStackTraceString((Throwable)throwable));
        }

        static void p(String string2) {
            if (logLevel > 3) {
                android.util.Log.i((String)MMSDK.SDKLOG, (String)("Private - " + string2));
            }
        }

        static void p(String string2, Object ... objectArray) {
            if (logLevel > 3) {
                android.util.Log.i((String)MMSDK.SDKLOG, (String)("Private - " + String.format(string2, objectArray)));
            }
        }

        static void p(Throwable throwable) {
            if (logLevel > 3) {
                Log.p(android.util.Log.getStackTraceString((Throwable)throwable));
            }
        }

        static void v(String string2) {
            if (logLevel >= 3) {
                android.util.Log.i((String)MMSDK.SDKLOG, (String)("Verbose - " + string2));
            }
        }

        static void v(String string2, Object ... objectArray) {
            if (logLevel >= 3) {
                android.util.Log.i((String)MMSDK.SDKLOG, (String)("Verbose - " + String.format(string2, objectArray)));
            }
        }

        static void v(Throwable throwable) {
            if (logLevel >= 3) {
                Log.v(android.util.Log.getStackTraceString((Throwable)throwable));
            }
        }

        static void w(String string2) {
            android.util.Log.w((String)MMSDK.SDKLOG, (String)string2);
        }

        static void w(String string2, Object ... objectArray) {
            android.util.Log.w((String)MMSDK.SDKLOG, (String)String.format(string2, objectArray));
        }

        static void w(Throwable throwable) {
            Log.w(android.util.Log.getStackTraceString((Throwable)throwable));
        }
    }
}

