/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.AdProperties;
import com.millennialmedia.android.BridgeMMMedia;
import com.millennialmedia.android.BridgeMMMicrophone;
import com.millennialmedia.android.BridgeMMSpeechkit;
import com.millennialmedia.android.InlineVideoView;
import com.millennialmedia.android.MMAd;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMAdImplController;
import com.millennialmedia.android.MMRequest;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.millennialmedia.android.RequestListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

abstract class MMLayout
extends RelativeLayout
implements MMAd,
InlineVideoView.TransparentFix {
    static final String BOTTOM_CENTER = "bottom-center";
    static final String BOTTOM_LEFT = "bottom-left";
    static final String BOTTOM_RIGHT = "bottom-right";
    static final String CENTER = "center";
    private static final int CLOSE_AREA_SIZE = 50;
    public static final String KEY_HEIGHT = "height";
    public static final String KEY_WIDTH = "width";
    static final String TOP_CENTER = "top-center";
    static final String TOP_LEFT = "top-left";
    static final String TOP_RIGHT = "top-right";
    private static boolean appInit;
    MMAdImpl adImpl;
    View blackView;
    View closeAreaView;
    private GestureDetector diagnosticDetector;
    String goalId;
    RelativeLayout inlineVideoLayout;
    InlineVideoView inlineVideoView;
    boolean isResizing;

    protected MMLayout(Context context) {
        super(context);
        this.initLayout(context);
    }

    @Deprecated
    protected MMLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initLayout(context);
    }

    private void initInlineVideoTransparentFix() {
        ViewParent viewParent;
        if (this.blackView != null && (viewParent = this.blackView.getParent()) != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.blackView);
            this.blackView = null;
        }
        this.blackView = new View(this.getContext());
        this.blackView.setBackgroundColor(-16777216);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.blackView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.inlineVideoLayout != null && this.blackView.getParent() == null) {
            this.inlineVideoLayout.addView(this.blackView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void internalSetCloseArea(String string2) {
        if (this.closeAreaView == null) {
            this.closeAreaView = new View(this.getContext());
            float f2 = this.getContext().getResources().getDisplayMetrics().density;
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)(50.0f * f2), (int)(50.0f * f2));
            if (TOP_RIGHT.equals(string2)) {
                layoutParams.addRule(11);
            } else if (TOP_CENTER.equals(string2)) {
                layoutParams.addRule(14);
            } else if (BOTTOM_LEFT.equals(string2)) {
                layoutParams.addRule(12);
            } else if (BOTTOM_CENTER.equals(string2)) {
                layoutParams.addRule(12);
                layoutParams.addRule(14);
            } else if (BOTTOM_RIGHT.equals(string2)) {
                layoutParams.addRule(12);
                layoutParams.addRule(11);
            } else if (CENTER.equals(string2)) {
                layoutParams.addRule(13);
            }
            this.closeAreaView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MMLayout.this.closeAreaTouched();
                }
            });
            this.addView(this.closeAreaView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void addBlackView() {
        this.initInlineVideoTransparentFix();
        if (this.blackView != null) {
            this.blackView.setVisibility(0);
        }
    }

    void addInlineVideo() {
        if (this.inlineVideoLayout != null && this.inlineVideoLayout.getParent() != null) {
            ((ViewGroup)this.inlineVideoLayout.getParent()).removeView((View)this.inlineVideoLayout);
        }
        this.inlineVideoLayout = new RelativeLayout(this.getContext());
        this.inlineVideoLayout.setId(892934232);
        if (this.inlineVideoView.getParent() != null) {
            ((ViewGroup)this.inlineVideoView.getParent()).removeView((View)this.inlineVideoView);
        }
        this.inlineVideoLayout.addView((View)this.inlineVideoView);
        if (this.blackView != null) {
            if (this.blackView.getParent() == null) {
                this.inlineVideoLayout.addView(this.blackView);
            }
            this.blackView.bringToFront();
        }
        this.addView((View)this.inlineVideoLayout, (ViewGroup.LayoutParams)this.inlineVideoView.getCustomLayoutParams());
    }

    boolean adjustVideo(final InlineVideoView.InlineParams inlineParams) {
        MMSDK.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MMLayout.this.inlineVideoView != null) {
                    MMLayout.this.inlineVideoView.adjustVideo(inlineParams);
                }
            }
        });
        return false;
    }

    void closeAreaTouched() {
    }

    protected void finalize() throws Throwable {
        if (this.getId() == -1) {
            this.adImpl.isFinishing = true;
            MMSDK.Log.d("finalize() for " + this.adImpl);
            MMAdImplController.removeAdViewController(this.adImpl);
        }
    }

    void fullScreenVideoLayout() {
    }

    @Override
    public String getApid() {
        return this.adImpl.getApid();
    }

    @Override
    public boolean getIgnoresDensityScaling() {
        return this.adImpl.getIgnoresDensityScaling();
    }

    @Override
    public RequestListener getListener() {
        return this.adImpl.getListener();
    }

    @Override
    public MMRequest getMMRequest() {
        return this.adImpl.getMMRequest();
    }

    void initInlineVideo(InlineVideoView.InlineParams inlineParams) {
        if (this.inlineVideoView != null) {
            ViewGroup viewGroup = (ViewGroup)this.inlineVideoView.getParent();
            if (viewGroup != null) {
                viewGroup.removeView((View)this.inlineVideoView);
            }
            if (this.inlineVideoView.isPlaying()) {
                this.inlineVideoView.stopPlayback();
            }
            this.inlineVideoView = null;
        }
        this.inlineVideoView = new InlineVideoView(this);
        this.inlineVideoView.initInlineVideo(inlineParams);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13, -1);
        this.inlineVideoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addInlineVideo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void initLayout(Context context) {
        try {
            MMSDK.Log.i("Initializing MMLayout.");
            MMSDK.checkPermissions(context);
            MMSDK.checkActivity(context);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            MMSDK.Log.e("There was an exception initializing the MMAdView. %s", objectArray);
            exception.printStackTrace();
        }
        this.diagnosticDetector = new GestureDetector(context.getApplicationContext(), (GestureDetector.OnGestureListener)new LayoutGestureListener(this));
        if (!appInit) {
            MMSDK.Log.d("********** Millennial Device Id *****************");
            MMSDK.Log.d(MMSDK.getMMdid(context));
            MMSDK.Log.d("Use the above identifier to register this device and receive test ads. Test devices can be registered and administered through your account at http://mmedia.com.");
            MMSDK.Log.d("*************************************************");
            AdCache.cleanCache(context);
            appInit = true;
        }
    }

    boolean isVideoPlayingStreaming() {
        return this.inlineVideoView != null && this.inlineVideoView.isPlayingStreaming();
    }

    void loadUrl(String string2) {
        if (MMSDK.isConnected(this.getContext())) {
            if (this.adImpl.controller != null) {
                this.adImpl.controller.loadUrl(string2);
            }
            return;
        }
        MMSDK.Log.e("No network available, can't load overlay.");
    }

    void loadWebContent(String string2, String string3) {
        if (MMSDK.isConnected(this.getContext())) {
            if (this.adImpl.controller != null) {
                this.adImpl.controller.loadWebContent(string2, string3);
            }
            return;
        }
        MMSDK.Log.e("No network available, can't load overlay.");
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            MMSDK.Log.d("onAttachedToWindow for " + this.adImpl);
            if (this.getId() == -1) {
                MMSDK.Log.w("MMAd missing id from getId(). Performance will be affected for configuration changes.");
            }
            if (!this.isResizing) {
                MMAdImplController.assignAdViewController(this.adImpl);
            }
            if (this.inlineVideoLayout != null) {
                this.inlineVideoLayout.bringToFront();
            }
            if (this.adImpl != null && this.adImpl.controller != null && this.adImpl.controller.webView != null) {
                this.adImpl.controller.webView.enableSendingSize();
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        MMSDK.Log.d("onDetachedFromWindow for" + this.adImpl);
        if (!this.isResizing) {
            MMAdImplController.removeAdViewController(this.adImpl);
        }
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        Bundle bundle = (Bundle)parcelable;
        long l2 = this.adImpl.internalId;
        this.adImpl.internalId = bundle.getLong("MMAdImplId");
        this.adImpl.linkForExpansionId = bundle.getLong("MMAdImplLinkedId");
        MMSDK.Log.d("onRestoreInstanceState replacing adImpl-" + l2 + " with " + this.adImpl + " id=" + this.getId());
        String string2 = bundle.getString("inlineVideoViewGson");
        if (string2 != null) {
            this.initInlineVideo(InlineVideoView.InlineParams.getInlineParams(string2));
        }
        super.onRestoreInstanceState(bundle.getParcelable("super"));
    }

    protected Parcelable onSaveInstanceState() {
        super.onSaveInstanceState();
        MMSDK.Log.d("onSaveInstanceState saving - " + this.adImpl + " id=" + this.getId());
        Bundle bundle = new Bundle();
        bundle.putParcelable("super", super.onSaveInstanceState());
        bundle.putLong("MMAdImplId", this.adImpl.internalId);
        bundle.putLong("MMAdImplLinkedId", this.adImpl.linkForExpansionId);
        if (this.inlineVideoView != null) {
            if (this.inlineVideoView.isPlaying()) {
                this.inlineVideoView.inlineParams.currentPosition = this.inlineVideoView.getCurrentPosition();
            }
            bundle.putString("inlineVideoViewGson", this.inlineVideoView.getGsonState());
        }
        return bundle;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.diagnosticDetector.onTouchEvent(motionEvent) || !this.isClickable() || super.onTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void onWindowFocusChanged(boolean bl2) {
        BridgeMMMedia.Audio audio;
        Activity activity;
        super.onWindowFocusChanged(bl2);
        if (bl2) {
            if (this.inlineVideoView != null) {
                this.inlineVideoView.resumeVideo();
            }
        } else if (this.inlineVideoView != null) {
            this.inlineVideoView.pauseVideo();
        }
        Object[] objectArray = new Object[]{this.adImpl, bl2, MMAdImplController.controllersToString()};
        MMSDK.Log.d("Window Focus Changed. For %s, Window in focus?: %b Controllers: %s", objectArray);
        if (this.adImpl != null && this.adImpl.controller != null && this.adImpl.controller.webView != null) {
            if (bl2) {
                this.adImpl.controller.webView.onResumeWebView();
                this.adImpl.controller.webView.setMraidViewableVisible();
            } else {
                BridgeMMSpeechkit.releaseSpeechKit();
                this.adImpl.controller.webView.setMraidViewableHidden();
                this.adImpl.controller.webView.onPauseWebView();
            }
        }
        if (!bl2 && this.getContext() instanceof Activity && ((activity = (Activity)this.getContext()) == null || activity.isFinishing() && this.adImpl != null)) {
            this.adImpl.isFinishing = true;
            MMSDK.Log.d("Window Focus Changed.removing " + this.adImpl);
            if (this.adImpl.controller != null && this.adImpl.controller.webView != null) {
                this.adImpl.controller.webView.setMraidHidden();
            }
            MMAdImplController.removeAdViewController(this.adImpl);
        }
        if ((audio = BridgeMMMedia.Audio.sharedAudio(this.getContext())) != null) {
            synchronized (this) {
                audio.stop();
            }
        }
        BridgeMMMicrophone.Recorder.getInstance().stopRecording();
    }

    void pauseVideo() {
        if (this.inlineVideoView != null) {
            this.inlineVideoView.pauseVideo();
        }
    }

    void playVideo() {
        if (this.inlineVideoView != null) {
            this.inlineVideoView.playVideo();
        }
    }

    @Override
    public void removeBlackView() {
        if (this.blackView != null) {
            this.blackView.setVisibility(4);
        }
    }

    void removeCloseTouchDelegate() {
        if (this.closeAreaView != null && this.closeAreaView.getParent() != null && this.closeAreaView.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.closeAreaView.getParent()).removeView(this.closeAreaView);
            this.closeAreaView = null;
        }
    }

    void removeVideo() {
        if (this.inlineVideoView != null) {
            this.inlineVideoView.removeVideo();
            this.inlineVideoView = null;
        }
    }

    void repositionVideoLayout() {
    }

    void resumeVideo() {
        if (this.inlineVideoView != null) {
            this.inlineVideoView.resumeVideo();
        }
    }

    @Override
    public void setApid(String string2) {
        this.adImpl.setApid(string2);
    }

    void setCloseArea(final String string2) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MMLayout.this.internalSetCloseArea(string2);
            }
        });
    }

    @Override
    public void setIgnoresDensityScaling(boolean bl2) {
        this.adImpl.setIgnoresDensityScaling(bl2);
    }

    @Override
    public void setListener(RequestListener requestListener) {
        this.adImpl.setListener(requestListener);
    }

    @Override
    public void setMMRequest(MMRequest mMRequest) {
        this.adImpl.setMMRequest(mMRequest);
    }

    void setMediaPlaybackRequiresUserGesture(boolean bl2) {
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            Method method = WebView.class.getMethod("setMediaPlaybackRequiresUserGesture", classArray);
            Object[] objectArray = new Object[]{bl2};
            method.invoke((Object)this, objectArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void setVideoSource(String string2) {
        if (this.inlineVideoView != null) {
            this.inlineVideoView.setVideoSource(string2);
        }
    }

    void stopVideo() {
        if (this.inlineVideoView != null) {
            this.inlineVideoView.stopVideo();
        }
    }

    class LayoutAdProperties
    extends AdProperties {
        LayoutAdProperties(Context context) {
            super(context);
        }

        @Override
        String getAdDpiIndependentHeight() {
            float f2 = MMSDK.getDensity(this.getContext());
            return String.valueOf((int)((float)MMLayout.this.getHeight() / f2));
        }

        @Override
        String getAdDpiIndependentWidth() {
            float f2 = MMSDK.getDensity(this.getContext());
            return String.valueOf((int)((float)MMLayout.this.getWidth() / f2));
        }
    }

    private static class LayoutGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        WeakReference<MMLayout> layoutRef;

        public LayoutGestureListener(MMLayout mMLayout) {
            this.layoutRef = new WeakReference<MMLayout>(mMLayout);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
            if (motionEvent == null) return false;
            if (motionEvent2 == null) {
                return false;
            }
            if (Math.abs((int)(motionEvent2.getX() - motionEvent.getX())) <= 200) return false;
            if (!(Math.abs(f2) > Math.abs(f3))) return false;
            if (!(f2 > 0.0f)) {
                MMLayout mMLayout = (MMLayout)this.layoutRef.get();
                if (mMLayout == null) return true;
                MMSDK.printDiagnostics(mMLayout.adImpl);
                return true;
            }
            if (MMSDK.logLevel == 0) {
                MMSDK.Log.i("Enabling debug and verbose logging.");
                MMSDK.logLevel = 3;
                return true;
            }
            MMSDK.Log.i("Disabling debug and verbose logging.");
            MMSDK.logLevel = 0;
            return true;
        }
    }

    class MMLayoutMMAdImpl
    extends MMAdImpl {
        public MMLayoutMMAdImpl(Context context) {
            super(context);
            this.adProperties = new LayoutAdProperties(this.getContext());
        }

        @Override
        public void addView(MMWebView mMWebView, RelativeLayout.LayoutParams layoutParams) {
            MMSDK.Log.w("MMLayout adding view (" + (Object)((Object)mMWebView) + ") to " + this);
            MMLayout.this.addView((View)mMWebView, (ViewGroup.LayoutParams)layoutParams);
        }

        @Override
        MMLayout getCallingAd() {
            return MMLayout.this;
        }

        @Override
        int getId() {
            return MMLayout.this.getId();
        }

        @Override
        public void removeView(MMWebView mMWebView) {
            MMLayout.this.removeView((View)mMWebView);
        }

        @Override
        public void setClickable(boolean bl2) {
            MMLayout.this.setClickable(bl2);
        }
    }
}

