/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import com.millennialmedia.android.AdProperties;
import com.millennialmedia.android.MMAd;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMAdImplController;
import com.millennialmedia.android.MMException;
import com.millennialmedia.android.MMRequest;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.RequestListener;

public final class MMInterstitial
implements MMAd {
    MMAdImpl adImpl;
    int externalId;

    public MMInterstitial(Context context) {
        this.adImpl = new MMInterstitialAdImpl(context.getApplicationContext());
        this.adImpl.adType = "i";
    }

    private void fetchInternal() {
        if (this.isAdAvailable()) {
            MMSDK.Log.d("Ad already fetched and ready for display...");
            MMSDK.Event.requestFailed(this.adImpl, new MMException(17));
            return;
        }
        MMSDK.Log.d("Fetching new ad...");
        this.adImpl.requestAd();
    }

    public boolean display() {
        return this.display(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean display(boolean bl2) {
        int n2;
        if (!MMSDK.isUiThread()) {
            MMSDK.Log.e(MMException.getErrorCodeMessage(3));
            return false;
        }
        try {
            n2 = this.displayInternal();
            if (n2 != 0 && bl2) {
                throw new MMException(n2);
            }
        }
        catch (Exception exception) {
            if (!bl2) return false;
            throw new MMException(exception);
        }
        if (n2 != 0) return false;
        return true;
    }

    int displayInternal() {
        try {
            MMAdImplController.assignAdViewController(this.adImpl);
            if (this.adImpl.controller != null) {
                int n2 = this.adImpl.controller.display(this.adImpl);
                return n2;
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            MMSDK.Log.e("There was an exception displaying a cached ad. %s", objectArray);
            exception.printStackTrace();
        }
        return 100;
    }

    public void fetch() {
        if (this.adImpl != null && this.adImpl.requestListener != null) {
            this.fetch(this.adImpl.mmRequest, this.adImpl.requestListener);
            return;
        }
        this.fetchInternal();
    }

    public void fetch(MMRequest mMRequest) {
        if (this.adImpl != null && this.adImpl.requestListener != null) {
            this.fetch(mMRequest, this.adImpl.requestListener);
            return;
        }
        this.fetchInternal();
    }

    public void fetch(MMRequest mMRequest, RequestListener requestListener) {
        if (this.adImpl != null) {
            this.adImpl.mmRequest = mMRequest;
            this.adImpl.requestListener = requestListener;
        }
        this.fetchInternal();
    }

    @Override
    public String getApid() {
        return this.adImpl.getApid();
    }

    @Override
    public boolean getIgnoresDensityScaling() {
        return this.adImpl.getIgnoresDensityScaling();
    }

    @Override
    public RequestListener getListener() {
        return this.adImpl.getListener();
    }

    @Override
    public MMRequest getMMRequest() {
        return this.adImpl.getMMRequest();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAdAvailable() {
        boolean bl2 = true;
        if (!MMSDK.isUiThread()) {
            MMSDK.Log.e(MMException.getErrorCodeMessage(3));
            return false;
        }
        try {
            MMAdImplController.assignAdViewController(this.adImpl);
            if (this.adImpl.controller == null) return false;
            int n2 = this.adImpl.controller.isAdAvailable(this.adImpl);
            if (n2 != 0) return false;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[bl2];
            objectArray[0] = exception.getMessage();
            MMSDK.Log.e("There was an exception checking for a cached ad. %s", objectArray);
            exception.printStackTrace();
            return false;
        }
        return bl2;
    }

    @Override
    public void setApid(String string2) {
        this.adImpl.setApid(string2);
    }

    @Override
    public void setIgnoresDensityScaling(boolean bl2) {
        this.adImpl.setIgnoresDensityScaling(bl2);
    }

    @Override
    public void setListener(RequestListener requestListener) {
        this.adImpl.setListener(requestListener);
    }

    @Override
    public void setMMRequest(MMRequest mMRequest) {
        this.adImpl.setMMRequest(mMRequest);
    }

    class MMInterstitialAdImpl
    extends MMAdImpl {
        public MMInterstitialAdImpl(Context context) {
            super(context);
            this.adProperties = new AdProperties(this.getContext());
        }

        @Override
        MMInterstitial getCallingAd() {
            return MMInterstitial.this;
        }
    }
}

