/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.widget.RelativeLayout;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.CachedAd;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.HttpGetRequest;
import com.millennialmedia.android.HttpMMHeaders;
import com.millennialmedia.android.InterstitialAd;
import com.millennialmedia.android.MMAd;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMException;
import com.millennialmedia.android.MMInterstitial;
import com.millennialmedia.android.MMLayout;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.millennialmedia.android.Utils;
import com.millennialmedia.android.VideoAd;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

class MMAdImplController
implements AdCache.AdCacheTaskListener {
    static final long NO_ID_RETURNED = -4L;
    private static final Map<Long, MMAdImplController> saveableControllers = new ConcurrentHashMap<Long, MMAdImplController>();
    private static final Map<Long, WeakReference<MMAdImplController>> weakUnsaveableAdRef = new ConcurrentHashMap<Long, WeakReference<MMAdImplController>>();
    volatile WeakReference<MMAdImpl> adImplRef;
    volatile long linkedAdImplId;
    RequestAdRunnable requestAdRunnable;
    volatile MMWebView webView;

    /*
     * Enabled aggressive block sorting
     */
    private MMAdImplController(MMAdImpl mMAdImpl) {
        MMSDK.Log.d("**************** creating new controller.");
        this.adImplRef = new WeakReference<MMAdImpl>(mMAdImpl);
        if (mMAdImpl.linkForExpansionId != 0L) {
            this.linkForExpansion(mMAdImpl);
            this.webView = MMAdImplController.getWebViewFromExistingAdImpl(mMAdImpl);
            return;
        }
        if (mMAdImpl instanceof MMInterstitial.MMInterstitialAdImpl) return;
        if (mMAdImpl.isBanner()) {
            this.webView = new MMWebView(mMAdImpl.getContext().getApplicationContext(), mMAdImpl.internalId);
            this.webView.requiresPreAdSizeFix = true;
            return;
        }
        this.webView = new MMWebView(mMAdImpl.getContext(), mMAdImpl.internalId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void assignAdViewController(MMAdImpl mMAdImpl) {
        synchronized (MMAdImplController.class) {
            if (mMAdImpl.controller != null) {
                if (!saveableControllers.containsValue(mMAdImpl.controller)) {
                    if (mMAdImpl.isLifecycleObservable()) {
                        saveableControllers.put(mMAdImpl.internalId, mMAdImpl.controller);
                        if (weakUnsaveableAdRef.containsKey(mMAdImpl.internalId)) {
                            weakUnsaveableAdRef.remove(mMAdImpl.internalId);
                        }
                    } else if (!weakUnsaveableAdRef.containsKey(mMAdImpl.internalId)) {
                        weakUnsaveableAdRef.put(mMAdImpl.internalId, new WeakReference<MMAdImplController>(mMAdImpl.controller));
                    }
                }
                MMSDK.Log.d(mMAdImpl + " - Has a controller");
            } else {
                MMSDK.Log.d("*****************************************assignAdViewController for " + mMAdImpl);
                MMAdImplController mMAdImplController = saveableControllers.get(mMAdImpl.internalId);
                if (mMAdImplController == null) {
                    WeakReference<MMAdImplController> weakReference = weakUnsaveableAdRef.get(mMAdImpl.internalId);
                    if (weakReference != null) {
                        mMAdImplController = (MMAdImplController)weakReference.get();
                    }
                    if (mMAdImplController == null) {
                        mMAdImplController = new MMAdImplController(mMAdImpl);
                        if (mMAdImpl.isLifecycleObservable()) {
                            saveableControllers.put(mMAdImpl.internalId, mMAdImplController);
                        } else {
                            weakUnsaveableAdRef.put(mMAdImpl.internalId, new WeakReference<MMAdImplController>(mMAdImplController));
                        }
                    }
                }
                mMAdImpl.controller = mMAdImplController;
                mMAdImplController.adImplRef = new WeakReference<MMAdImpl>(mMAdImpl);
                if (mMAdImplController.webView != null && !(mMAdImpl instanceof MMInterstitial.MMInterstitialAdImpl)) {
                    MMAdImplController.setupWebView(mMAdImpl);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean attachWebViewFromOverlay(MMAdImpl mMAdImpl) {
        synchronized (MMAdImplController.class) {
            boolean bl2 = false;
            if (mMAdImpl == null) {
                return bl2;
            }
            MMSDK.Log.d("attachWebViewFromOverlay with " + mMAdImpl);
            if (mMAdImpl.controller != null && mMAdImpl.controller.webView != null) {
                mMAdImpl.controller.webView.resetSpeechKit();
            }
            MMAdImpl mMAdImpl2 = MMAdImplController.getAdImplWithId(mMAdImpl.linkForExpansionId);
            bl2 = false;
            if (mMAdImpl2 == null) return bl2;
            MMAdImplController mMAdImplController = mMAdImpl2.controller;
            bl2 = false;
            if (mMAdImplController == null) return bl2;
            if (mMAdImpl2.controller.webView == null) {
                mMAdImpl2.controller.webView = mMAdImpl.controller.webView;
                mMAdImpl.removeView(mMAdImpl.controller.webView);
                mMAdImpl.controller.webView = null;
            }
            mMAdImpl2.controller.webView.setMraidDefault();
            mMAdImpl2.controller.webView.setWebViewClient(mMAdImpl2.getMMWebViewClient());
            return true;
        }
    }

    static String controllersToString() {
        return weakUnsaveableAdRef.toString() + " SAVED:" + saveableControllers.toString();
    }

    static void destroyOtherInlineVideo(Context context) {
        Iterator<Map.Entry<Long, MMAdImplController>> iterator = saveableControllers.entrySet().iterator();
        while (iterator.hasNext()) {
            MMAd mMAd;
            MMAdImpl mMAdImpl;
            MMAdImplController mMAdImplController = iterator.next().getValue();
            if (mMAdImplController == null || (mMAdImpl = (MMAdImpl)mMAdImplController.adImplRef.get()) == null || (mMAd = mMAdImpl.getCallingAd()) == null || !(mMAd instanceof MMLayout)) continue;
            ((MMLayout)mMAd).removeVideo();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MMAdImpl getAdImplWithId(long l2) {
        synchronized (MMAdImplController.class) {
            WeakReference<MMAdImplController> weakReference;
            long l3 = l2 - -4L;
            long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
            MMAdImpl mMAdImpl = null;
            if (l4 == false) return mMAdImpl;
            MMAdImplController mMAdImplController = saveableControllers.get(l2);
            if (mMAdImplController == null && (weakReference = weakUnsaveableAdRef.get(l2)) != null) {
                mMAdImplController = (MMAdImplController)weakReference.get();
            }
            mMAdImpl = null;
            if (mMAdImplController == null) return mMAdImpl;
            return (MMAdImpl)mMAdImplController.adImplRef.get();
        }
    }

    static MMWebView getWebViewFromExistingAdImpl(MMAdImpl mMAdImpl) {
        synchronized (MMAdImplController.class) {
            MMWebView mMWebView;
            block6: {
                MMSDK.Log.i("getWebViewFromExistingLayout(" + mMAdImpl.internalId + " taking from " + mMAdImpl.linkForExpansionId + ")");
                MMAdImpl mMAdImpl2 = MMAdImplController.getAdImplWithId(mMAdImpl.linkForExpansionId);
                mMWebView = null;
                if (mMAdImpl2 == null) break block6;
                MMAdImplController mMAdImplController = mMAdImpl2.controller;
                mMWebView = null;
                if (mMAdImplController == null) break block6;
                mMWebView = mMAdImpl2.controller.webView;
                mMAdImpl2.controller.webView = null;
            }
            return mMWebView;
            finally {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDownloadingCachedAd(MMAdImpl mMAdImpl) {
        boolean bl2 = true;
        synchronized (this) {
            Context context = mMAdImpl.getContext();
            if (HandShake.sharedHandShake(context).isAdTypeDownloading(mMAdImpl.adType)) {
                MMSDK.Log.i("There is a download in progress. Defering call for new ad");
                MMSDK.Event.requestFailed(mMAdImpl, new MMException(12));
            } else {
                MMSDK.Log.d("No download in progress.");
                CachedAd cachedAd = AdCache.loadIncompleteDownload(context, mMAdImpl.getCachedName());
                if (cachedAd != null) {
                    MMSDK.Log.i("Last ad wasn't fully downloaded. Download again.");
                    MMSDK.Event.fetchStartedCaching(mMAdImpl);
                    AdCache.startDownloadTask(context, mMAdImpl.getCachedName(), cachedAd, this);
                } else {
                    MMSDK.Log.i("No incomplete downloads.");
                    return false;
                }
            }
            return bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void removeAdViewController(MMAdImpl mMAdImpl) {
        synchronized (MMAdImplController.class) {
            MMAdImplController mMAdImplController = mMAdImpl.controller;
            if (mMAdImplController != null) {
                if (mMAdImpl.isLifecycleObservable()) {
                    saveableControllers.put(mMAdImpl.internalId, mMAdImpl.controller);
                    if (weakUnsaveableAdRef.get(mMAdImpl.internalId) != null) {
                        weakUnsaveableAdRef.remove(mMAdImpl.internalId);
                    }
                } else {
                    weakUnsaveableAdRef.put(mMAdImpl.internalId, new WeakReference<MMAdImplController>(mMAdImpl.controller));
                }
                MMSDK.Log.d("****************RemoveAdviewcontroller - " + mMAdImpl);
                if (mMAdImpl.isFinishing) {
                    saveableControllers.remove(mMAdImpl.internalId);
                    weakUnsaveableAdRef.remove(mMAdImpl.internalId);
                }
                MMAdImplController mMAdImplController2 = mMAdImpl.controller;
                mMAdImpl.controller = null;
                MMSDK.Log.d("****************RemoveAdviewcontroller - controllers " + MMAdImplController.controllersToString());
                if (mMAdImplController2.webView != null) {
                    MMSDK.Log.d("****************RemoveAdviewcontroller - controller!=null, expanding=" + mMAdImplController2.webView.isExpanding);
                    mMAdImpl.removeView(mMAdImplController2.webView);
                    mMAdImplController2.webView.isExpanding = false;
                    if (mMAdImpl.isFinishing && mMAdImpl.linkForExpansionId == 0L) {
                        mMAdImplController2.webView.destroy();
                        mMAdImplController2.webView = null;
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requestAdInternal(MMAdImpl mMAdImpl) {
        if (mMAdImpl.apid == null) {
            MMException mMException = new MMException("MMAdView found with a null apid. New ad requests on this MMAdView are disabled until an apid has been assigned.", 1);
            MMSDK.Log.e(mMException);
            MMSDK.Event.requestFailed(mMAdImpl, mMException);
            return;
        }
        if (!mMAdImpl.isBanner() && this.isDownloadingCachedAd(mMAdImpl)) return;
        synchronized (this) {
            if (this.requestAdRunnable != null) {
                MMSDK.Log.i(MMException.getErrorCodeMessage(12));
                MMSDK.Event.requestFailed(mMAdImpl, new MMException(12));
                return;
            }
            this.requestAdRunnable = new RequestAdRunnable();
            Utils.ThreadUtils.execute(this.requestAdRunnable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setupWebView(MMAdImpl mMAdImpl) {
        synchronized (MMAdImplController.class) {
            MMAdImplController mMAdImplController = mMAdImpl.controller;
            mMAdImplController.webView.setWebViewClient(mMAdImpl.getMMWebViewClient());
            if (!mMAdImplController.webView.isCurrentParent(mMAdImpl.internalId)) {
                RelativeLayout.LayoutParams layoutParams;
                if (mMAdImpl.isBanner()) {
                    layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                    if (mMAdImplController.webView.isMraidResized()) {
                        mMAdImplController.webView.unresizeToDefault(mMAdImpl);
                    }
                } else {
                    layoutParams = new RelativeLayout.LayoutParams(-2, -1);
                }
                mMAdImplController.webView.removeFromParent();
                mMAdImpl.addView(mMAdImplController.webView, layoutParams);
            }
            return;
        }
    }

    int checkReason(MMAdImpl mMAdImpl, CachedAd cachedAd) {
        if (cachedAd.isExpired()) {
            Object[] objectArray = new Object[]{cachedAd.getId()};
            MMSDK.Log.d("%s is expired.", objectArray);
            return 21;
        }
        if (!cachedAd.isOnDisk(mMAdImpl.getContext())) {
            Object[] objectArray = new Object[]{cachedAd.getId()};
            MMSDK.Log.d("%s is not on disk.", objectArray);
            return 22;
        }
        if (!HandShake.sharedHandShake(mMAdImpl.getContext()).canDisplayCachedAd(mMAdImpl.adType, cachedAd.deferredViewStart)) {
            Object[] objectArray = new Object[]{cachedAd.getId()};
            MMSDK.Log.d("%s cannot be shown at this time.", objectArray);
            return 24;
        }
        return 100;
    }

    int display(MMAdImpl mMAdImpl) {
        CachedAd cachedAd = AdCache.loadNextCachedAd(mMAdImpl.getContext(), mMAdImpl.getCachedName());
        if (cachedAd != null) {
            if (cachedAd.canShow(mMAdImpl.getContext(), mMAdImpl, true)) {
                MMSDK.Event.displayStarted(mMAdImpl);
                AdCache.setNextCachedAd(mMAdImpl.getContext(), mMAdImpl.getCachedName(), null);
                cachedAd.show(mMAdImpl.getContext(), mMAdImpl.internalId);
                HandShake.sharedHandShake(mMAdImpl.getContext()).updateLastVideoViewedTime(mMAdImpl.getContext(), mMAdImpl.adType);
                return 0;
            }
            return this.checkReason(mMAdImpl, cachedAd);
        }
        return 20;
    }

    @Override
    public void downloadCompleted(CachedAd cachedAd, boolean bl2) {
        MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
        if (mMAdImpl == null) {
            MMSDK.Log.e(MMException.getErrorCodeMessage(25));
            return;
        }
        if (bl2) {
            AdCache.setNextCachedAd(mMAdImpl.getContext(), mMAdImpl.getCachedName(), cachedAd.getId());
        }
        if (bl2) {
            MMSDK.Event.requestCompleted(mMAdImpl);
            return;
        }
        MMSDK.Event.requestFailed(mMAdImpl, new MMException(15));
    }

    @Override
    public void downloadStart(CachedAd cachedAd) {
    }

    public String getDefaultUserAgentString(Context context) {
        return System.getProperty("http.agent");
    }

    HttpMMHeaders getLastHeaders() {
        if (this.webView == null) {
            return null;
        }
        return this.webView.getLastHeaders();
    }

    String getUserAgent() {
        MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
        String string2 = null;
        if (mMAdImpl != null) {
            Context context = mMAdImpl.getContext();
            string2 = null;
            if (context != null) {
                string2 = this.getDefaultUserAgentString(context);
            }
        }
        if (TextUtils.isEmpty(string2)) {
            string2 = Build.MODEL;
        }
        return string2;
    }

    int isAdAvailable(MMAdImpl mMAdImpl) {
        CachedAd cachedAd = AdCache.loadNextCachedAd(mMAdImpl.getContext(), mMAdImpl.getCachedName());
        if (cachedAd != null) {
            if (cachedAd.canShow(mMAdImpl.getContext(), mMAdImpl, true)) {
                return 0;
            }
            return this.checkReason(mMAdImpl, cachedAd);
        }
        MMSDK.Log.i("No next ad.");
        return 20;
    }

    void linkForExpansion(MMAdImpl mMAdImpl) {
        MMAdImpl mMAdImpl2 = MMAdImplController.getAdImplWithId(mMAdImpl.linkForExpansionId);
        if (mMAdImpl2 != null) {
            this.linkedAdImplId = mMAdImpl.linkForExpansionId;
            mMAdImpl2.controller.linkedAdImplId = mMAdImpl.internalId;
            mMAdImpl2.linkForExpansionId = mMAdImpl.internalId;
        }
    }

    void loadUrl(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && this.webView != null) {
            this.webView.loadUrl(string2);
        }
    }

    void loadWebContent(String string2, String string3) {
        MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
        if (mMAdImpl != null && this.webView != null) {
            this.webView.setWebViewContent(string2, string3, mMAdImpl);
        }
    }

    void requestAd() {
        MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
        if (mMAdImpl == null) {
            MMSDK.Log.e(MMException.getErrorCodeMessage(25));
            MMSDK.Event.requestFailed(mMAdImpl, new MMException(25));
            return;
        }
        if (!mMAdImpl.isRefreshable()) {
            MMSDK.Event.requestFailed(mMAdImpl, new MMException(16));
            return;
        }
        if (!MMSDK.isUiThread()) {
            MMSDK.Log.e(MMException.getErrorCodeMessage(3));
            MMSDK.Event.requestFailed(mMAdImpl, new MMException(3));
            return;
        }
        if (HandShake.sharedHandShake((Context)mMAdImpl.getContext()).kill) {
            MMSDK.Log.i("The server is no longer allowing ads.");
            MMSDK.Event.requestFailed(mMAdImpl, new MMException(16));
            return;
        }
        try {
            MMSDK.Log.d("adLayout - requestAd");
            this.requestAdInternal(mMAdImpl);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            MMSDK.Log.e("There was an exception with the ad request. %s", objectArray);
            exception.printStackTrace();
            return;
        }
    }

    void setLastHeaders(HttpMMHeaders httpMMHeaders) {
        if (this.webView != null) {
            this.webView.setLastHeaders(httpMMHeaders);
        }
    }

    void setWebViewContent(String string2, String string3) {
        if (this.webView != null) {
            this.webView.setWebViewContent(string2, string3, (MMAdImpl)this.adImplRef.get());
        }
    }

    public String toString() {
        MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
        StringBuilder stringBuilder = new StringBuilder();
        if (mMAdImpl != null) {
            stringBuilder.append(mMAdImpl + "-LinkInC=" + this.linkedAdImplId);
        }
        return stringBuilder.toString() + " w/" + (Object)((Object)this.webView);
    }

    void unresizeToDefault() {
        if (this.webView != null) {
            this.webView.unresizeToDefault((MMAdImpl)this.adImplRef.get());
        }
    }

    private class RequestAdRunnable
    implements Runnable {
        String adUrl;
        HttpMMHeaders mmHeaders;

        private RequestAdRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isAdUrlBuildable() {
            this.adUrl = null;
            WeakReference<MMAdImpl> weakReference = MMAdImplController.this.adImplRef;
            MMAdImpl mMAdImpl = null;
            if (weakReference != null) {
                mMAdImpl = (MMAdImpl)MMAdImplController.this.adImplRef.get();
            }
            if (mMAdImpl != null) {
                try {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                    mMAdImpl.insertUrlAdMetaValues(treeMap);
                    MMSDK.insertUrlCommonValues(mMAdImpl.getContext(), treeMap);
                    treeMap.put("ua", mMAdImpl.controller.getUserAgent());
                    StringBuilder stringBuilder = new StringBuilder(HandShake.getAdUrl());
                    MMSDK.Log.d(treeMap.entrySet().toString());
                    for (Map.Entry entry : treeMap.entrySet()) {
                        Object[] objectArray = new Object[]{entry.getKey(), URLEncoder.encode((String)entry.getValue(), "UTF-8")};
                        stringBuilder.append(String.format("%s=%s&", objectArray));
                    }
                    stringBuilder.delete(-1 + stringBuilder.length(), stringBuilder.length());
                    this.adUrl = stringBuilder.toString();
                    Object[] objectArray = new Object[]{this.adUrl};
                    MMSDK.Log.d("Calling for an advertisement: %s", objectArray);
                    return true;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return this.failWithErrorMessage(new MMException(unsupportedEncodingException));
                }
            }
            this.failWithInfoMessage(new MMException(25));
            return true;
        }

        private boolean isHandledHtmlResponse(HttpEntity httpEntity) {
            block9: {
                MMAdImpl mMAdImpl;
                block8: {
                    try {
                        WeakReference<MMAdImpl> weakReference = MMAdImplController.this.adImplRef;
                        mMAdImpl = null;
                        if (weakReference == null) break block8;
                    }
                    catch (IOException iOException) {
                        return this.failWithErrorMessage(new MMException("Exception raised in HTTP stream: " + iOException.getMessage(), iOException));
                    }
                    mMAdImpl = (MMAdImpl)MMAdImplController.this.adImplRef.get();
                }
                if (mMAdImpl == null) break block9;
                if (!mMAdImpl.isBanner()) {
                    InterstitialAd interstitialAd = new InterstitialAd();
                    interstitialAd.content = HttpGetRequest.convertStreamToString(httpEntity.getContent());
                    interstitialAd.setId(mMAdImpl.adType);
                    interstitialAd.adUrl = this.adUrl;
                    interstitialAd.mmHeaders = this.mmHeaders;
                    if (MMSDK.logLevel >= 5) {
                        Object[] objectArray = new Object[]{interstitialAd.adUrl};
                        MMSDK.Log.v("Received interstitial ad with url %s.", objectArray);
                        MMSDK.Log.v(interstitialAd.content);
                    }
                    AdCache.save(mMAdImpl.getContext(), interstitialAd);
                    AdCache.setNextCachedAd(mMAdImpl.getContext(), mMAdImpl.getCachedName(), interstitialAd.getId());
                    MMSDK.Event.fetchStartedCaching(mMAdImpl);
                    MMSDK.Event.requestCompleted(mMAdImpl);
                } else {
                    if (mMAdImpl.controller != null) {
                        mMAdImpl.controller.setLastHeaders(this.mmHeaders);
                        mMAdImpl.controller.setWebViewContent(HttpGetRequest.convertStreamToString(httpEntity.getContent()), this.adUrl);
                    }
                    MMSDK.Event.requestCompleted(mMAdImpl);
                }
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isHandledJsonResponse(HttpEntity httpEntity) {
            VideoAd videoAd;
            MMAdImpl mMAdImpl;
            block11: {
                block10: {
                    WeakReference<MMAdImpl> weakReference = MMAdImplController.this.adImplRef;
                    mMAdImpl = null;
                    if (weakReference != null) {
                        mMAdImpl = (MMAdImpl)MMAdImplController.this.adImplRef.get();
                    }
                    if (mMAdImpl == null) break block10;
                    if (mMAdImpl.isBanner()) {
                        return this.failWithErrorMessage(new MMException("Millennial ad return unsupported format.", 15));
                    }
                    try {
                        videoAd = (VideoAd)CachedAd.parseJSON(HttpGetRequest.convertStreamToString(httpEntity.getContent()));
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        return this.failWithInfoMessage(new MMException("Millennial ad return failed. Invalid response data.", illegalStateException));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return this.failWithInfoMessage(new MMException("Millennial ad return failed. " + iOException.getMessage(), iOException));
                    }
                    if (videoAd == null || !videoAd.isValid()) break block10;
                    MMSDK.Log.i("Cached video ad JSON received: " + videoAd.getId());
                    if (!videoAd.isExpired()) break block11;
                    MMSDK.Log.i("New ad has expiration date in the past. Not downloading ad content.");
                    videoAd.delete(mMAdImpl.getContext());
                    MMSDK.Event.requestFailed(mMAdImpl, new MMException(15));
                }
                return true;
            }
            if (AdCache.loadNextCachedAd(mMAdImpl.getContext(), mMAdImpl.getCachedName()) != null) {
                MMSDK.Log.i("Previously fetched ad exists in the playback queue. Not downloading ad content.");
                videoAd.delete(mMAdImpl.getContext());
                MMSDK.Event.requestFailed(mMAdImpl, new MMException(17));
                return true;
            }
            AdCache.save(mMAdImpl.getContext(), videoAd);
            if (!videoAd.isOnDisk(mMAdImpl.getContext())) {
                MMSDK.Event.logEvent(videoAd.cacheMissURL);
                MMSDK.Log.d("Downloading ad...");
                MMSDK.Event.fetchStartedCaching(mMAdImpl);
                videoAd.downloadPriority = 3;
                AdCache.startDownloadTask(mMAdImpl.getContext(), mMAdImpl.getCachedName(), videoAd, mMAdImpl.controller);
                return true;
            }
            MMSDK.Log.d("Cached ad is valid. Moving it to the front of the queue.");
            AdCache.setNextCachedAd(mMAdImpl.getContext(), mMAdImpl.getCachedName(), videoAd.getId());
            MMSDK.Event.fetchStartedCaching(mMAdImpl);
            MMSDK.Event.requestCompleted(mMAdImpl);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isHandledResponse(HttpResponse httpResponse) {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                this.failWithInfoMessage(new MMException("Null HTTP entity", 14));
                return false;
            }
            if (httpEntity.getContentLength() == 0L) {
                this.failWithInfoMessage(new MMException("Millennial ad return failed. Zero content length returned.", 14));
                return false;
            }
            this.saveMacId(httpResponse);
            Header header = httpEntity.getContentType();
            if (header != null && header.getValue() != null) {
                if (header.getValue().toLowerCase().startsWith("application/json")) {
                    this.isHandledJsonResponse(httpEntity);
                    return true;
                }
                if (header.getValue().toLowerCase().startsWith("text/html")) {
                    Header header2 = httpResponse.getFirstHeader("X-MM-Video");
                    this.mmHeaders = new HttpMMHeaders(httpResponse.getAllHeaders());
                    if (header2 != null && header2.getValue().equalsIgnoreCase("true")) {
                        WeakReference<MMAdImpl> weakReference = MMAdImplController.this.adImplRef;
                        MMAdImpl mMAdImpl = null;
                        if (weakReference != null) {
                            mMAdImpl = (MMAdImpl)MMAdImplController.this.adImplRef.get();
                        }
                        if (mMAdImpl != null) {
                            Context context = mMAdImpl.getContext();
                            HandShake.sharedHandShake(context).updateLastVideoViewedTime(context, mMAdImpl.adType);
                        }
                    }
                    this.isHandledHtmlResponse(httpEntity);
                    return true;
                }
                this.failWithInfoMessage(new MMException("Millennial ad return failed. Invalid (JSON/HTML expected) mime type returned.", 15));
                return false;
            }
            this.failWithInfoMessage(new MMException("Millennial ad return failed. HTTP Header value null.", 15));
            return false;
        }

        private void saveMacId(HttpResponse httpResponse) {
            Header[] headerArray = httpResponse.getHeaders("Set-Cookie");
            int n2 = headerArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                String string2 = headerArray[i2].getValue();
                int n4 = string2.indexOf("MAC-ID=");
                if (n4 < 0 || (n3 = string2.indexOf(59, n4)) <= n4) continue;
                MMSDK.macId = string2.substring(n4 + 7, n3);
            }
        }

        boolean fail(MMException mMException) {
            WeakReference<MMAdImpl> weakReference = MMAdImplController.this.adImplRef;
            MMAdImpl mMAdImpl = null;
            if (weakReference != null) {
                mMAdImpl = (MMAdImpl)MMAdImplController.this.adImplRef.get();
            }
            MMSDK.Event.requestFailed(mMAdImpl, mMException);
            return false;
        }

        boolean failWithErrorMessage(MMException mMException) {
            MMSDK.Log.e(mMException.getMessage());
            return this.fail(mMException);
        }

        boolean failWithInfoMessage(MMException mMException) {
            MMSDK.Log.i(mMException.getMessage());
            return this.fail(mMException);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block13: {
                block14: {
                    HttpResponse httpResponse;
                    if (MMAdImplController.this.adImplRef == null) break block13;
                    MMAdImpl mMAdImpl = (MMAdImpl)MMAdImplController.this.adImplRef.get();
                    if (mMAdImpl == null || !MMSDK.isConnected(mMAdImpl.getContext())) break block14;
                    boolean bl2 = this.isAdUrlBuildable();
                    if (!bl2) {
                        MMAdImplController.this.requestAdRunnable = null;
                        return;
                    }
                    {
                        catch (Exception exception) {
                            this.failWithInfoMessage(new MMException("Request not filled, can't call for ads.", 14));
                            return;
                        }
                        try {
                            httpResponse = new HttpGetRequest().get(this.adUrl);
                            if (httpResponse == null) {
                                this.failWithErrorMessage(new MMException("HTTP response is null.", 14));
                                MMAdImplController.this.requestAdRunnable = null;
                                return;
                            }
                        }
                        catch (Exception exception) {}
                        this.failWithErrorMessage(new MMException("Ad request HTTP error. " + exception.getMessage(), 14));
                        MMAdImplController.this.requestAdRunnable = null;
                        return;
                    }
                    {
                        boolean bl3 = this.isHandledResponse(httpResponse);
                        if (!bl3) {
                            MMAdImplController.this.requestAdRunnable = null;
                            return;
                        }
                        break block13;
                    }
                }
                this.failWithInfoMessage(new MMException("No network available, can't call for ads.", 11));
                return;
            }
            MMAdImplController.this.requestAdRunnable = null;
            return;
            finally {
                MMAdImplController.this.requestAdRunnable = null;
            }
        }
    }
}

