/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.widget.RelativeLayout;
import com.millennialmedia.android.AdProperties;
import com.millennialmedia.android.BannerWebViewClient;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.HttpRedirection;
import com.millennialmedia.android.MMAd;
import com.millennialmedia.android.MMAdImplController;
import com.millennialmedia.android.MMRequest;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.millennialmedia.android.MMWebViewClient;
import com.millennialmedia.android.RequestListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONObject;

abstract class MMAdImpl
implements MMAd {
    static final String BANNER = "b";
    static final String INTERSTITIAL = "i";
    private static long nextAdViewId = 1L;
    AdProperties adProperties;
    String adType;
    String apid = "28911";
    WeakReference<Context> contextRef;
    MMAdImplController controller;
    boolean ignoreDensityScaling = false;
    long internalId;
    boolean isFinishing;
    long lastAdRequest;
    long linkForExpansionId;
    protected MMRequest mmRequest;
    MMWebViewClient mmWebViewClient;
    MMWebViewClient.MMWebViewClientListener mmWebViewClientListener;
    JSONObject obj;
    RequestListener requestListener;
    String userData;
    boolean xmlLayout = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MMAdImpl(Context context) {
        this.contextRef = new WeakReference<Context>(context);
        this.mmWebViewClientListener = new BasicWebViewClientListener(this);
        synchronized (MMAdImpl.class) {
            this.internalId = nextAdViewId;
            nextAdViewId = 1L + nextAdViewId;
            Object[] objectArray = new Object[]{this.internalId};
            MMSDK.Log.v("Assigning MMAdImpl internal id: %d", objectArray);
            return;
        }
    }

    static String[] getAdTypes() {
        return new String[]{BANNER, INTERSTITIAL};
    }

    void addView(MMWebView mMWebView, RelativeLayout.LayoutParams layoutParams) {
    }

    void animateTransition() {
    }

    JSONObject getAdProperties() {
        if (this.adProperties != null) {
            return this.adProperties.getAdProperties();
        }
        return null;
    }

    @Override
    public String getApid() {
        return this.apid;
    }

    String getCachedName() {
        if (this.adType != null && this.apid != null) {
            return this.adType + "_" + this.apid;
        }
        return null;
    }

    abstract MMAd getCallingAd();

    Context getContext() {
        if (this.contextRef != null) {
            return (Context)this.contextRef.get();
        }
        return null;
    }

    int getId() {
        return -1;
    }

    @Override
    public boolean getIgnoresDensityScaling() {
        return this.ignoreDensityScaling;
    }

    @Override
    public RequestListener getListener() {
        return this.requestListener;
    }

    @Override
    public MMRequest getMMRequest() {
        return this.mmRequest;
    }

    MMWebViewClient getMMWebViewClient() {
        MMSDK.Log.d("Returning a client for user: DefaultWebViewClient, adimpl=" + this);
        return new BannerWebViewClient(this.mmWebViewClientListener, new MMAdImplRedirectionListenerImpl(this));
    }

    String getReqType() {
        return "fetch";
    }

    String getRequestCompletedAction() {
        return "millennialmedia.action.ACTION_FETCH_SUCCEEDED";
    }

    String getRequestFailedAction() {
        return "millennialmedia.action.ACTION_FETCH_FAILED";
    }

    public boolean hasCachedVideoSupport() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void insertUrlAdMetaValues(Map<String, String> map) {
        Context context = this.getContext();
        map.put("ar", "manual");
        map.put("sdkapid", this.apid);
        map.put("do", MMSDK.getOrientation(context));
        map.put("olock", MMSDK.getOrientationLocked(context));
        if (!this.hasCachedVideoSupport()) {
            map.put("cachedvideo", "false");
        }
        map.put("reqtype", this.getReqType());
        if (this.mmRequest != null) {
            this.mmRequest.getUrlParams(map);
        }
        if (HandShake.sharedHandShake(context).canRequestVideo(context, this.adType)) {
            map.put("video", "true");
        } else {
            map.put("video", "false");
        }
        if (this.adType == null) {
            MMSDK.Log.e("******* SDK DEFAULTED TO MMBannerAdBottom. THIS MAY AFFECT THE ADS YOU RECIEVE!!! **********");
            map.put("at", BANNER);
            return;
        }
        if (!this.adType.equals(BANNER) && !this.adType.equals(INTERSTITIAL)) {
            MMSDK.Log.e("******* ERROR: INCORRECT AD TYPE IN MMADVIEW OBJECT PARAMETERS (" + this.adType + ") **********");
            return;
        }
        map.put("at", this.adType);
    }

    public boolean isBanner() {
        return false;
    }

    boolean isExpandingToUrl() {
        return false;
    }

    boolean isLifecycleObservable() {
        return false;
    }

    boolean isRefreshable() {
        long l2;
        if (MMSDK.disableAdMinRefresh) {
            MMSDK.Log.d("Minimum adrefresh time ignored");
            return true;
        }
        long l3 = System.currentTimeMillis();
        int n2 = (int)((l3 - this.lastAdRequest) / 1000L);
        if ((long)n2 >= (l2 = HandShake.sharedHandShake((Context)this.getContext()).adRefreshSecs)) {
            this.lastAdRequest = l3;
            return true;
        }
        Object[] objectArray = new Object[]{n2, l2 - (long)n2};
        MMSDK.Log.d("Cannot request ad. Last ad request was %d seconds ago. Next ad can be requested in %d seconds.", objectArray);
        return false;
    }

    boolean isTransitionAnimated() {
        return false;
    }

    boolean isUpdatingMraid() {
        return this.controller != null && this.controller.webView != null && !this.controller.webView.isExpanding;
    }

    void prepareTransition(Bitmap bitmap) {
    }

    void removeProgressBar() {
    }

    void removeView(MMWebView mMWebView) {
    }

    void requestAd() {
        MMAdImplController.assignAdViewController(this);
        if (this.controller != null) {
            this.controller.requestAd();
        }
    }

    @Override
    public void setApid(String string2) {
        if (HandShake.apid == null || HandShake.apid.equals("28911")) {
            HandShake.apid = this.apid;
        }
        this.apid = string2;
    }

    void setClickable(boolean bl2) {
    }

    @Override
    public void setIgnoresDensityScaling(boolean bl2) {
        this.ignoreDensityScaling = bl2;
    }

    @Override
    public void setListener(RequestListener requestListener) {
        this.requestListener = requestListener;
    }

    @Override
    public void setMMRequest(MMRequest mMRequest) {
        this.mmRequest = mMRequest;
    }

    public String toString() {
        return "AdType[(" + this.adType + ") InternalId(" + this.internalId + ") LinkedId(" + this.linkForExpansionId + ") isFinishing(" + this.isFinishing + ")]";
    }

    void unresizeToDefault() {
        if (this.controller != null) {
            this.controller.unresizeToDefault();
        }
    }

    static class BasicWebViewClientListener
    extends MMWebViewClient.MMWebViewClientListener {
        WeakReference<MMAdImpl> adImplRef;

        BasicWebViewClientListener(MMAdImpl mMAdImpl) {
            this.adImplRef = new WeakReference<MMAdImpl>(mMAdImpl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onPageFinished(String string2) {
            MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
            if (mMAdImpl != null) {
                mMAdImpl.setClickable(true);
                if (mMAdImpl.controller != null && mMAdImpl.controller.webView != null) {
                    MMWebView mMWebView = mMAdImpl.controller.webView;
                    synchronized (mMWebView) {
                        if (mMAdImpl.controller.webView.hasWindowFocus()) {
                            mMAdImpl.controller.webView.setMraidViewableVisible();
                        } else {
                            mMAdImpl.controller.webView.setMraidViewableHidden();
                        }
                        return;
                    }
                }
            }
        }

        @Override
        void onPageStarted(String string2) {
            MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
            if (mMAdImpl != null) {
                mMAdImpl.setClickable(false);
            }
        }
    }

    static class MMAdImplRedirectionListenerImpl
    extends HttpRedirection.RedirectionListenerImpl {
        WeakReference<MMAdImpl> adImplRef;

        public MMAdImplRedirectionListenerImpl(MMAdImpl mMAdImpl) {
            if (mMAdImpl != null) {
                this.adImplRef = new WeakReference<MMAdImpl>(mMAdImpl);
                this.creatorAdImplInternalId = mMAdImpl.internalId;
            }
        }

        @Override
        public JSONObject getAdProperties() {
            MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
            if (mMAdImpl != null) {
                return mMAdImpl.getAdProperties();
            }
            return null;
        }

        @Override
        public boolean isActivityStartable(Uri uri) {
            Context context;
            MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
            return mMAdImpl == null || (context = mMAdImpl.getContext()) == null || !(context instanceof Activity) || !((Activity)context).isFinishing();
        }

        @Override
        public void startingActivity(Uri uri) {
            MMAdImpl mMAdImpl;
            super.startingActivity(uri);
            if ((uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) && (mMAdImpl = (MMAdImpl)this.adImplRef.get()) != null) {
                MMSDK.Event.overlayOpened(mMAdImpl);
            }
        }

        @Override
        public void updateLastVideoViewedTime() {
            MMAdImpl mMAdImpl = (MMAdImpl)this.adImplRef.get();
            if (mMAdImpl != null && mMAdImpl.adType != null) {
                HandShake.sharedHandShake(mMAdImpl.getContext()).updateLastVideoViewedTime(mMAdImpl.getContext(), mMAdImpl.adType);
            }
        }
    }
}

