/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.millennialmedia.android.CachedAd;
import com.millennialmedia.android.HandShake;
import com.millennialmedia.android.HttpMMHeaders;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.OverlaySettings;
import com.millennialmedia.android.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class InterstitialAd
extends CachedAd
implements Parcelable,
Externalizable {
    public static final Parcelable.Creator<InterstitialAd> CREATOR = new Parcelable.Creator<InterstitialAd>(){

        public InterstitialAd createFromParcel(Parcel parcel) {
            return new InterstitialAd(parcel);
        }

        public InterstitialAd[] newArray(int n2) {
            return new InterstitialAd[n2];
        }
    };
    static final String EXTRA_AD_URL = "EXTRA_AD_URL";
    static final String EXTRA_CONTENT = "EXTRA_CONTENT";
    static final long serialVersionUID = 5158660334173309853L;
    String adUrl;
    String content;
    HttpMMHeaders mmHeaders;

    public InterstitialAd() {
    }

    InterstitialAd(Parcel parcel) {
        super(parcel);
        try {
            this.content = parcel.readString();
            this.adUrl = parcel.readString();
            this.mmHeaders = (HttpMMHeaders)parcel.readParcelable(HttpMMHeaders.class.getClassLoader());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private Intent getExpandExtrasIntent(Context context, long l2) {
        Intent intent = new Intent();
        OverlaySettings overlaySettings = new OverlaySettings();
        overlaySettings.creatorAdImplId = l2;
        overlaySettings.content = this.content;
        overlaySettings.adUrl = this.adUrl;
        overlaySettings.setWebMMHeaders(this.mmHeaders);
        overlaySettings.isFromInterstitial = true;
        intent.putExtra("settings", (Parcelable)overlaySettings);
        intent.putExtra("internalId", l2);
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    boolean canShow(Context context, MMAdImpl mMAdImpl, boolean bl2) {
        if (bl2) {
            if (this.content != null && this.content.length() > 0 && this.adUrl != null && this.adUrl.length() > 0 && HandShake.sharedHandShake(context).canDisplayCachedAd(mMAdImpl.adType, this.deferredViewStart)) return true;
            return false;
        }
        if (this.content == null || this.content.length() <= 0 || this.adUrl == null || this.adUrl.length() <= 0) return false;
        return true;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    boolean download(Context context) {
        return true;
    }

    @Override
    int getType() {
        return 2;
    }

    @Override
    String getTypeString() {
        return "Interstitial";
    }

    @Override
    boolean isOnDisk(Context context) {
        return true;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.content = (String)objectInput.readObject();
        this.adUrl = (String)objectInput.readObject();
        this.mmHeaders = (HttpMMHeaders)objectInput.readObject();
    }

    @Override
    boolean saveAssets(Context context) {
        return true;
    }

    @Override
    void show(Context context, long l2) {
        Utils.IntentUtils.startAdViewOverlayActivity(context, this.getExpandExtrasIntent(context, l2));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.content);
        objectOutput.writeObject(this.adUrl);
        objectOutput.writeObject(this.mmHeaders);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeString(this.content);
        parcel.writeString(this.adUrl);
        parcel.writeParcelable((Parcelable)this.mmHeaders, n2);
    }
}

