/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.millennialmedia.android.AdViewOverlayView;
import com.millennialmedia.android.Base64;
import com.millennialmedia.android.MMAdImplController;
import com.millennialmedia.android.MMLayout;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.Utils;
import com.millennialmedia.android.VideoAd;
import com.millennialmedia.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;

class InlineVideoView
extends VideoView
implements Serializable {
    private static final String ANCHOR_IN_PNG = "iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABOpJREFUeNrUmmtIY0cUgCfJ3VBXUXxR0dp2Ya0aBSFi6yOtFPGF1d1WavrAXy1YwVcLLaQpttsH+lcbirYq0a3Ptd0WpKi1P1SMaAitJNptalcQIwV/iI+o2ST39kx6I9cY3STcuSYHhjuTzD33fJk5M+fciWh9fR0tLCwgrhwfH6OcnBwkl8ur9vb2DIODg5aIiAjkq1itViQWi1FYWBgiKYmJiQhptdpzX6SlpSGz2fwRwzDHR0dH83V1dYn+KK6oqLjR19enQISluLgYof7+/jMfZmRkIIvFcoc5K783NTU95YvSsrKyFLvd/s/a2pqRNEBJSclZAJlMhra2tjyNP4Vobm5OukxhaWlpysnJyQPceXl5WS8SicgDDAwMuBrp6enY+M+Zy2UFIJ72pqy8vDwFfOcvd0ebzWYoLCwkD9DR0YFSU1Ox8W2Mb7IKEM+4lWBnHRoaSnM6nX97jhhAkQfQ6/XXNjY27jD+iamhoeFZiqLQyMhIOrQfeuljhCklJg4AD7rFBCA0Tf+h0+luQ9V80UgBAEUaQAzrvB7qk/7eDA6alZeXdx+qKRd0wb++hPRKJIZNaru+vv4NqP/Gs25sPEUcIDw8HHV1de2BY1bzDCFmC1kA91rd2dmJIV6D6nRIjQC3ARD7LMQvPOmWCArAQlhbWlqUPEBIrgQAC2xuh42NjUoI5O5BkwmpEXCLRqM5XFlZ+Qaq9qB2Yq9jL5HgHRaW+bzvoSkNZic+9wA2tnmxpqbmB2jGB7sPUB67KzZeAcb/CM24kHBi9z6Ar8PDwy8plcr7PBgvnBND9uSa82D8y2D8TzwZLxgAhRN4yF+zwfhfeX7gdSjXiANgp11cXDyCjOxr1ick7MojYQ2g2Cu3fvpZcnKyOCEhQcL5xd1XK+QLu8QB2GDuTyjvB6IgKSkJZWZmejouLrTBYLAJvoz6KxaLxVVYcbLljOTm5oqioqLwlHJw+jB4+s7NzQX8bIfDQX6jwdLb2/upTCZ7kzWcZouTHSUnZHd2tv2IvdrZ4vC4uuv09va2eXx8XCMIgNVqxXPsOW/fZWdnB6TTZrNp8egJAgByyKey/f19LeTD7+IFSCwQgINH47+rrKx8Z2lpyRkZGSkYwCM+lBwcHHwLxtfB1ME+hN+ohM4IsMa/B8YzPuUDwQSwu7urAePrZ2dnGd73AdJTCGK1n2traxvBeP8ysmAZAQhHXlCpVK/Ex8dfKUCgaSkO8xMKCgpGJycnb3uDCBUnvi6Xy4cA4lZcXFxIAmAJA4iRqamp12NjY0+TsJDaB0CeAIjB6enpmujo6P8PE0NtJ8Y5CEDcnZiYUOJQngpBACzS/Pz8u1lZWfSVr0I7OzufrK6uqgMZCUjG3qauEgDCgy+qqqq+woftsFGJIGf40g+dD+fn51XnzolJCCQtb3meP21ubn7GPcXE89lkMql9POFab21tTYVMDwkCMDMzo+Q+fXR0VI1DYW/5tdFoVD3G+AdtbW2uY62ioiJhAKqrq1/lGo9PNy8S/P8HgPjwEuNvuvueO6knDTA2NvbxZcY/BmKtvb39JrefC6Cnp4c4AMQyT3Z3d5f6cw9+3aPT6T7AlkNEalKr1Tc8+ygUCiSC7B7BMkYUgKZpnIQjqVTqeo3pYxjtGglY65+H+ib40b949Lj/v4iJiUH/CTAAFI2ZNCJ5irUAAAAASUVORK5CYII=";
    private static final String ANCHOR_OUT_PNG = "iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABEZJREFUeNrUml9IU1Ecx8+2uwnCrBlaGD2YEKiVla2ypAj8X+l8KYpkLxUFoT0VBT1YUYYP6ktQCGUQgQr+w0o3sgdDEv+AaBH9odicEq4XY25u7vY9dhe3m9N5d+8Z/uDHvRzPn+/nnN/5d6eG5/mNhJCjcAPcD18QngHhPSDxBVE+cfo/aXa7/afL5eKJipaSkkI4QfwzuBZOGwwKQoKS90jTqOvm5uZqrFbrYzUB8vPzFwEMgnhqGtq44LLN4/F8bmxsfEdUNo1GswjgF3peo0SlED9hsVhKbTbbV8LAtELMBhUSP1ZeXn6clXgxwEK0FSHmqfgTvb293whD45QAEMQfh3gHYWxa0eohy2ZmZt4i5o/19PQwFx8CmI9mBLq6umrQ804SI4t6BCoqKh5UVVWZYwVAsBMfhrv56GwKEPtYay8oKFgEyIH/4KO36crKyoOxADDTxnll7AcgDrEG2A2f5JUzCpHLEmAn3MEraxTiCCuAdPj3ZcR4ZEK4MbH3qw2w7FFidna2t6mpiU7M1zLqT8QSu43FMroV/vm/bvd47Dhvm2ge9OQGJL1ZTfc7nc77WVlZOhYhtAX+USLeVlhYaBJnXg0ExN/LyMhgNolT4B9CjeNg9hLiE5YqAAgTsthWEp+ens50Gd0If08b93q9r8KJF0GsR1Z7GPG3WfS8FCCBzgGfz/e6qKgoIZKCWCLXS0dicnKyOjMzk/1Roq+vj+AsfyA7OzthNYUBYYTuF/BALMT/BcDlW3YFubm58Qi5vampqTE5iFIATq/Xy66gv7/fg8eQ3PJ5eXmbdTrduqGhofdut1vOHZwQbFQx6b2GhoZMhN8n+K/h4eHypKSkiMvGxcXRsN9XXV29KSYA9fX1GRD+RbQGeAFxMhIIKr6zs/M0yvjh55gDQPx2ifiQ+QBxKjk5eSXxZwTx1C4xBYB4evL9tsw+6B0ZGVkSwmAwkI6ODip+XpT/MjOAurq6HSucev+OBCAqxBCCeKtEPLUrqgPQxtHzeyIUH7L50dHRs4mJiYt1tLe3W0VhI7arqgMUFxfHSw+LEZpvcHDwZHd39+kw4qnd4NQOnfHxcf/ExMQAdurV3g0MZrP5ufDROdyHZ71WbQCHw+HHjnkRIE9lfrda7qs5p2UxgV0ulxeXo3OAeKJw1TotqyV0enqajsR5hSEMzACoTU1NBXD4oxCNClXJMQUQwolCXMDEfqRAdXrmAAIETyf22NjYQ/Ln5621MwJiCIvFcjEQCAysuREI7dC1tbVVuA/simYEuFiJb2lpuVZaWlqz5iYxvQE2NzcrIZ59CHEYcPT89bKyshql+oMZAGKdtLa23oT4u0r2CRMAk8mkb2truwPxt5SeTpzf71cdIC0tzVhSUpKP1++hARFcu8RzqbSwBzoN1mOCXVFVgGAwSHJycuKMRmM8+fcfSqQg0jQuzN90Qj3O3wIMAN8Np0JgnxtnAAAAAElFTkSuQmCC";
    static final int TIME_TO_UPDATE_SEEK_JS = 500;
    private int duration;
    InlineParams inlineParams;
    MediaController mediaController;
    WeakReference<MMLayout> mmLayoutRef;
    TransparentFix transFix;
    TransparentHandler transparentHandler = new TransparentHandler(this);
    Handler videoHandler;

    public InlineVideoView(MMLayout mMLayout) {
        super(mMLayout.getContext());
        this.setId(8832429);
        this.setFocusable(true);
        MMAdImplController.destroyOtherInlineVideo(mMLayout.getContext());
        this.mmLayoutRef = new WeakReference<MMLayout>(mMLayout);
    }

    private MediaPlayer.OnCompletionListener createOnCompletionListener() {
        return new VideoCompletionListener(this);
    }

    private MediaPlayer.OnErrorListener createOnErrorListener() {
        return new VideoErrorListener(this);
    }

    private MediaPlayer.OnPreparedListener createOnPreparedListener() {
        return new VideoPreparedListener(this);
    }

    private View.OnTouchListener createOnTouchListener() {
        return new VideoTouchListener(this);
    }

    private Handler createVideoHandler() {
        return new VideoHandler(this);
    }

    private void downloadCacheVideo() {
        Utils.ThreadUtils.execute(new DownloadRunnable(this));
    }

    private Uri getVideoUri() {
        if (this.hasCachedVideo() && !this.inlineParams.isPlayingStreaming) {
            this.inlineParams.isPlayingStreaming = false;
            return VideoAd.getVideoUri(this.getContext(), this.inlineParams.cachedVideoID);
        }
        if (!TextUtils.isEmpty((CharSequence)this.inlineParams.streamVideoURI)) {
            this.inlineParams.isPlayingStreaming = true;
            return Uri.parse((String)this.inlineParams.streamVideoURI);
        }
        return null;
    }

    private boolean hasCachedVideo() {
        return !TextUtils.isEmpty((CharSequence)this.inlineParams.cachedVideoID) && VideoAd.hasVideoFile(this.getContext(), this.inlineParams.cachedVideoID);
    }

    private void initInternalInlineVideo() {
        this.videoHandler = this.createVideoHandler();
        this.setVideoURI(this.getVideoUri());
        this.setBackgroundColor(-16777216);
        this.setClickable(true);
        this.setOnErrorListener(this.createOnErrorListener());
        this.setOnCompletionListener(this.createOnCompletionListener());
        this.setOnPreparedListener(this.createOnPreparedListener());
        this.setOnTouchListener(this.createOnTouchListener());
        if (this.inlineParams.autoPlay) {
            this.seekTo(this.inlineParams.currentPosition);
            this.startInternal();
            if (this.videoHandler != null && !this.videoHandler.hasMessages(2)) {
                this.videoHandler.sendMessageDelayed(Message.obtain((Handler)this.videoHandler, (int)2), 500L);
            }
        }
        if (this.inlineParams.showControls) {
            this.mediaController = new MediaController(this);
            this.setMediaController(this.mediaController);
            this.mediaController.show();
        }
        MMSDK.Log.e("Finished inserting inlineVideo player");
    }

    private void makeTransparent() {
        if (!this.transparentHandler.hasMessages(4)) {
            this.transparentHandler.sendEmptyMessage(4);
        }
    }

    private void removeFromParent() {
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        if (viewGroup != null) {
            viewGroup.removeView((View)this);
        }
    }

    private void removeKeyboardFocusViewJira1642() {
        ((InputMethodManager)this.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.getWindowToken(), 0);
        this.requestFocus();
    }

    private void resumeInternal(boolean bl2) {
        if (!this.inlineParams.isCompleted) {
            this.seekTo(this.inlineParams.currentPosition);
            if (bl2 || this.inlineParams.autoPlay) {
                this.startInternal();
                if (this.videoHandler != null && !this.videoHandler.hasMessages(2)) {
                    this.videoHandler.sendMessageDelayed(Message.obtain((Handler)this.videoHandler, (int)2), 500L);
                }
            }
        }
    }

    private void setInlineVideoParams(InlineParams inlineParams) {
        this.inlineParams = inlineParams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean adjustVideo(InlineParams inlineParams) {
        synchronized (this) {
            this.setAdjustVideoParams(inlineParams);
            MMSDK.Log.e("Called initInlineVideo inside reposition section code");
            boolean bl2 = this.isPlaying();
            this.stopPlayback();
            MMLayout mMLayout = (MMLayout)this.mmLayoutRef.get();
            if (mMLayout != null) {
                mMLayout.addInlineVideo();
            }
            this.resumeInternal(bl2);
            return true;
        }
    }

    void downloadVideo() {
        VideoAd.downloadVideoFile(this.getContext(), this.inlineParams.cachedVideoURI, this.inlineParams.cachedVideoID);
    }

    public RelativeLayout.LayoutParams getCustomLayoutParams() {
        if (this.inlineParams.goingFullScreen) {
            return new RelativeLayout.LayoutParams(-1, -1);
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)(this.inlineParams.scaleFactor * (float)this.inlineParams.width), (int)(this.inlineParams.scaleFactor * (float)this.inlineParams.height));
        layoutParams.topMargin = (int)(this.inlineParams.scaleFactor * (float)this.inlineParams.y);
        layoutParams.leftMargin = (int)(this.inlineParams.scaleFactor * (float)this.inlineParams.x);
        MMSDK.Log.d("lp height = " + layoutParams.height);
        return layoutParams;
    }

    String getGsonState() {
        return new Gson().toJson(this.inlineParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleTransparentMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 4: {
                if (this.isPlaying() && this.getCurrentPosition() > 0) {
                    this.transparentHandler.sendEmptyMessageDelayed(5, 100L);
                    return;
                }
                this.transparentHandler.sendEmptyMessageDelayed(4, 50L);
                return;
            }
            case 5: {
                if (!this.isPlaying() || this.getCurrentPosition() <= 0) return;
                this.setBackgroundColor(0);
                if (this.mmLayoutRef == null || this.mmLayoutRef.get() == null) return;
                ((MMLayout)this.mmLayoutRef.get()).removeBlackView();
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initInlineVideo(InlineParams inlineParams) {
        synchronized (this) {
            this.setInlineVideoParams(inlineParams);
            if (!TextUtils.isEmpty((CharSequence)this.inlineParams.cachedVideoURI)) {
                this.downloadCacheVideo();
            }
            if (this.isValid()) {
                this.initInternalInlineVideo();
            } else {
                MMSDK.Log.e("The videoURI attribute was not specified on the video marker div.");
            }
            return;
        }
    }

    boolean isPlayingStreaming() {
        return this.inlineParams != null && this.inlineParams.isPlayingStreaming;
    }

    boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.inlineParams.streamVideoURI) || this.hasCachedVideo();
    }

    void onCompletion(MediaPlayer mediaPlayer) {
        if (this.videoHandler != null && this.videoHandler.hasMessages(2)) {
            this.videoHandler.removeMessages(2);
        }
        this.inlineParams.isCompleted = true;
        this.inlineParams.currentPosition = this.duration;
        if (this.inlineParams.currentPosition == -1) {
            this.inlineParams.currentPosition = 0;
        }
        this.updateVideoSeekTimeFinal();
    }

    boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        MMLayout mMLayout;
        if (this.videoHandler != null && this.videoHandler.hasMessages(2)) {
            this.videoHandler.removeMessages(2);
        }
        if ((mMLayout = (MMLayout)this.mmLayoutRef.get()) == null) {
            MMSDK.Log.w("MMLayout weak reference broken");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder().append("javascript:MMJS.setError(");
        Object[] objectArray = new Object[]{n2, n3};
        mMLayout.loadUrl(stringBuilder.append(String.format("Error while playing, %d - %d", objectArray)).append(");").toString());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void onMediaControllerClick(View view) {
        MMLayout mMLayout = (MMLayout)this.mmLayoutRef.get();
        if (mMLayout == null) return;
        this.setBackgroundColor(-16777216);
        if (this.isPlaying()) {
            this.inlineParams.currentPosition = this.getCurrentPosition();
        }
        if (this.inlineParams.goingFullScreen) {
            this.inlineParams.goingFullScreen = false;
            if (this.inlineParams.originalOrientation != 1) {
                boolean bl2 = this.isPlaying();
                this.stopPlayback();
                mMLayout.repositionVideoLayout();
                this.resumeInternal(bl2);
                return;
            }
            Activity activity = (Activity)this.getContext();
            if (activity == null) return;
            activity.setRequestedOrientation(1);
            return;
        }
        this.inlineParams.originalOrientation = this.getContext().getResources().getConfiguration().orientation;
        this.inlineParams.goingFullScreen = true;
        if (this.inlineParams.originalOrientation == 2) {
            boolean bl3 = this.isPlaying();
            this.stopPlayback();
            mMLayout.fullScreenVideoLayout();
            this.resumeInternal(bl3);
            return;
        }
        Activity activity = (Activity)this.getContext();
        if (activity == null) return;
        activity.setRequestedOrientation(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void onPrepared(MediaPlayer mediaPlayer) {
        if (this.inlineParams.autoPlay) {
            this.makeTransparent();
        }
        this.seekTo(this.inlineParams.currentPosition);
        if (this.inlineParams.autoPlay || !this.inlineParams.isInitialPlayBack) {
            this.getHeight();
        } else {
            this.inlineParams.isInitialPlayBack = false;
        }
        this.duration = this.getDuration();
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof AdViewOverlayView.SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        AdViewOverlayView.SavedState savedState = (AdViewOverlayView.SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.inlineParams.inflateFromGson(savedState.gson);
    }

    public Parcelable onSaveInstanceState() {
        AdViewOverlayView.SavedState savedState = new AdViewOverlayView.SavedState(super.onSaveInstanceState());
        if (this.isPlaying()) {
            this.inlineParams.currentPosition = this.getCurrentPosition();
        }
        savedState.gson = this.getGsonState();
        return savedState;
    }

    boolean onTouch(View view, MotionEvent motionEvent) {
        if (motionEvent.getAction() == 1) {
            MMLayout mMLayout = (MMLayout)this.mmLayoutRef.get();
            if (mMLayout == null) {
                MMSDK.Log.w("MMLayout weak reference broken");
                return false;
            }
            if (!TextUtils.isEmpty((CharSequence)this.inlineParams.touchCallBack)) {
                String string2 = "javascript:" + this.inlineParams.touchCallBack + "(%f,%f)";
                Object[] objectArray = new Object[]{Float.valueOf(motionEvent.getX()), Float.valueOf(motionEvent.getY())};
                mMLayout.loadUrl(String.format(string2, objectArray));
            }
            if (this.inlineParams.showControls && this.mediaController != null && !this.mediaController.isShowing()) {
                this.mediaController.show();
                return true;
            }
        }
        return true;
    }

    void pauseVideo() {
        if (this.videoHandler != null && this.videoHandler.hasMessages(2)) {
            this.videoHandler.removeMessages(2);
        }
        if (this.isPlaying()) {
            this.inlineParams.currentPosition = this.getCurrentPosition();
            this.pause();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void playVideo() {
        if (!this.isPlaying()) {
            if (this.inlineParams.isStopped && this.getVideoUri() != null) {
                this.inlineParams.isStopped = false;
                this.setVideoURI(this.getVideoUri());
                this.seekTo(0);
            } else if (this.inlineParams.isCompleted) {
                this.seekTo(0);
            }
            this.inlineParams.isCompleted = false;
            this.startInternal();
        }
        if (this.videoHandler != null && !this.videoHandler.hasMessages(2)) {
            this.videoHandler.sendMessageDelayed(Message.obtain((Handler)this.videoHandler, (int)2), 500L);
        }
    }

    void removeVideo() {
        if (this.videoHandler != null && this.videoHandler.hasMessages(2)) {
            this.videoHandler.removeMessages(2);
        }
        if (this.isPlaying()) {
            this.stopPlayback();
        }
        this.setOnCompletionListener(null);
        this.setOnErrorListener(null);
        this.setOnPreparedListener(null);
        this.setOnTouchListener(null);
        this.removeFromParent();
    }

    void resumeVideo() {
        if (!this.isPlaying() && !this.inlineParams.isCompleted) {
            this.startInternal();
            if (this.videoHandler != null && !this.videoHandler.hasMessages(2)) {
                this.videoHandler.sendMessageDelayed(Message.obtain((Handler)this.videoHandler, (int)2), 500L);
            }
        }
    }

    void setAdjustVideoParams(InlineParams inlineParams) {
        this.inlineParams.x = inlineParams.x;
        this.inlineParams.y = inlineParams.y;
        this.inlineParams.width = inlineParams.width;
        this.inlineParams.height = inlineParams.height;
    }

    void setVideoSource(String string2) {
        if (this.isPlaying()) {
            this.stopPlayback();
        }
        this.inlineParams.currentPosition = 0;
        this.setBackgroundColor(-16777216);
        this.setVideoURI(Uri.parse((String)string2));
        this.startInternal();
    }

    public void start() {
        this.makeTransparent();
        this.removeKeyboardFocusViewJira1642();
        super.start();
    }

    public void startInternal() {
        if (((PowerManager)this.getContext().getSystemService("power")).isScreenOn()) {
            this.start();
        }
    }

    public void stopPlayback() {
        if (this.videoHandler != null && this.videoHandler.hasMessages(2)) {
            this.videoHandler.removeMessages(2);
        }
        if (this.isPlaying()) {
            this.inlineParams.currentPosition = 0;
        }
        super.stopPlayback();
    }

    void stopVideo() {
        if (this.videoHandler != null && this.videoHandler.hasMessages(2)) {
            this.videoHandler.removeMessages(2);
        }
        if (this.isPlaying()) {
            this.inlineParams.isStopped = true;
            this.inlineParams.currentPosition = 0;
            if (this.mmLayoutRef != null && this.mmLayoutRef.get() != null) {
                ((MMLayout)this.mmLayoutRef.get()).addBlackView();
            }
            this.stopPlayback();
        }
    }

    public String toString() {
        return this.inlineParams.toString();
    }

    void updateVideoSeekTime() {
        int n2 = this.getCurrentPosition();
        if (n2 >= 0) {
            MMSDK.Log.d("Time is " + n2);
            this.updateVideoSeekTime(Math.floor((float)n2 / 1000.0f));
        }
    }

    void updateVideoSeekTime(double d2) {
        MMLayout mMLayout = (MMLayout)this.mmLayoutRef.get();
        if (mMLayout == null) {
            MMSDK.Log.w("MMLayout weak reference broken");
        }
        mMLayout.loadUrl("javascript:MMJS.inlineVideo.updateVideoSeekTime(" + d2 + ");");
    }

    void updateVideoSeekTimeFinal() {
        if (this.duration > 0) {
            MMSDK.Log.d("Time is " + this.duration);
            this.updateVideoSeekTime(Math.ceil((float)this.duration / 1000.0f));
        }
    }

    private static class DownloadRunnable
    implements Runnable {
        private WeakReference<InlineVideoView> inlineVideoRef;

        public DownloadRunnable(InlineVideoView inlineVideoView) {
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        @Override
        public void run() {
            InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
            if (inlineVideoView != null) {
                inlineVideoView.downloadVideo();
            }
        }
    }

    static class InlineParams {
        boolean autoPlay;
        int bodyHeight;
        int bodyWidth;
        String cachedVideoID;
        String cachedVideoURI;
        int currentPosition;
        boolean goingFullScreen;
        int height;
        boolean isCompleted;
        boolean isInitialPlayBack = true;
        boolean isPlayingStreaming;
        boolean isStopped;
        int originalOrientation;
        float scaleFactor;
        boolean showControls;
        String streamVideoURI;
        String touchCallBack;
        int width;
        int x;
        int y;

        InlineParams(HashMap<String, String> hashMap, Context context) {
            if (hashMap.get("x") != null) {
                this.x = (int)Float.parseFloat(hashMap.get("x"));
            }
            if (hashMap.get("y") != null) {
                this.y = (int)Float.parseFloat(hashMap.get("y"));
            }
            if (hashMap.get("width") != null) {
                this.width = (int)Float.parseFloat(hashMap.get("width"));
            }
            if (hashMap.get("height") != null) {
                this.height = (int)Float.parseFloat(hashMap.get("height"));
            }
            this.streamVideoURI = hashMap.get("streamVideoURI");
            this.cachedVideoURI = hashMap.get("cachedVideoURI");
            this.cachedVideoID = hashMap.get("cachedVideoID");
            if (hashMap.get("autoPlay") != null) {
                this.autoPlay = Boolean.parseBoolean(hashMap.get("autoPlay"));
            }
            if (hashMap.get("showControls") != null) {
                this.showControls = Boolean.parseBoolean(hashMap.get("showControls"));
            }
            if (hashMap.get("bodyWidth") != null) {
                this.bodyWidth = (int)Float.parseFloat(hashMap.get("bodyWidth"));
            }
            if (hashMap.get("bodyHeight") != null) {
                this.bodyHeight = (int)Float.parseFloat(hashMap.get("bodyHeight"));
            }
            this.touchCallBack = hashMap.get("touchCallback");
            this.scaleFactor = context.getResources().getDisplayMetrics().density;
        }

        static InlineParams getInlineParams(String string2) {
            return new Gson().fromJson(string2, InlineParams.class);
        }

        void inflateFromGson(String string2) {
            InlineParams inlineParams = new Gson().fromJson(string2, InlineParams.class);
            this.x = inlineParams.x;
            this.y = inlineParams.y;
            this.bodyWidth = inlineParams.bodyWidth;
            this.bodyHeight = inlineParams.bodyHeight;
            this.width = inlineParams.width;
            this.height = inlineParams.height;
            this.currentPosition = inlineParams.currentPosition;
            this.streamVideoURI = inlineParams.streamVideoURI;
            this.cachedVideoURI = inlineParams.cachedVideoURI;
            this.cachedVideoID = inlineParams.cachedVideoID;
            this.touchCallBack = inlineParams.touchCallBack;
            this.autoPlay = inlineParams.autoPlay;
            this.showControls = inlineParams.showControls;
            this.isInitialPlayBack = inlineParams.isInitialPlayBack;
            this.scaleFactor = inlineParams.scaleFactor;
            this.goingFullScreen = inlineParams.goingFullScreen;
            this.originalOrientation = inlineParams.originalOrientation;
            this.isCompleted = inlineParams.isCompleted;
            MMSDK.Log.d("gson*****" + string2);
            MMSDK.Log.d("PARAMS*****" + inlineParams);
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.cachedVideoID, this.x, this.y, this.bodyWidth, this.bodyHeight, this.currentPosition, this.autoPlay};
            return String.format("%s id, %d x, %d y, %d bWidth, %d bHeight, %d pos, %b autoPlay", objectArray);
        }
    }

    private static class MediaController
    extends android.widget.MediaController {
        BitmapDrawable inDrawable;
        private WeakReference<InlineVideoView> inlineVideoRef;
        BitmapDrawable outDrawable;

        public MediaController(InlineVideoView inlineVideoView) {
            super(inlineVideoView.getContext());
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setAnchorView(View view) {
            InlineVideoView inlineVideoView;
            super.setAnchorView(view);
            Button button = new Button(this.getContext());
            if (this.inDrawable == null) {
                try {
                    this.inDrawable = new BitmapDrawable((InputStream)new ByteArrayInputStream(Base64.decode(InlineVideoView.ANCHOR_IN_PNG)));
                }
                catch (Exception exception) {
                    MMSDK.Log.e("Exception image:" + exception.getMessage());
                }
            }
            if (this.outDrawable == null) {
                try {
                    this.outDrawable = new BitmapDrawable((InputStream)new ByteArrayInputStream(Base64.decode(InlineVideoView.ANCHOR_OUT_PNG)));
                }
                catch (Exception exception) {
                    MMSDK.Log.e("Exception image:" + exception.getMessage());
                }
            }
            if ((inlineVideoView = (InlineVideoView)this.inlineVideoRef.get()) != null) {
                if (inlineVideoView.inlineParams.goingFullScreen) {
                    button.setBackgroundDrawable((Drawable)this.inDrawable);
                } else {
                    button.setBackgroundDrawable((Drawable)this.outDrawable);
                }
                button.setOnClickListener((View.OnClickListener)new MediaClickListener(inlineVideoView));
            }
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 5);
            layoutParams.setMargins(0, 20, 10, 0);
            this.addView((View)button, (ViewGroup.LayoutParams)layoutParams);
        }

        static final class MediaClickListener
        implements View.OnClickListener {
            private WeakReference<InlineVideoView> inlineVideoRef;

            public MediaClickListener(InlineVideoView inlineVideoView) {
                this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
            }

            public void onClick(View view) {
                InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
                if (inlineVideoView != null) {
                    inlineVideoView.onMediaControllerClick(view);
                }
            }
        }
    }

    static interface TransparentFix {
        public void removeBlackView();
    }

    private static class TransparentHandler
    extends Handler {
        private WeakReference<InlineVideoView> inlineVideoRef;

        public TransparentHandler(InlineVideoView inlineVideoView) {
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        public void handleMessage(Message message) {
            InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
            if (inlineVideoView != null) {
                inlineVideoView.handleTransparentMessage(message);
            }
        }
    }

    private static class VideoCompletionListener
    implements MediaPlayer.OnCompletionListener {
        private WeakReference<InlineVideoView> inlineVideoRef;

        public VideoCompletionListener(InlineVideoView inlineVideoView) {
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
            if (inlineVideoView != null) {
                inlineVideoView.onCompletion(mediaPlayer);
            }
        }
    }

    private static class VideoErrorListener
    implements MediaPlayer.OnErrorListener {
        private WeakReference<InlineVideoView> inlineVideoRef;

        public VideoErrorListener(InlineVideoView inlineVideoView) {
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
            InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
            if (inlineVideoView != null) {
                inlineVideoView.onError(mediaPlayer, n2, n3);
            }
            return true;
        }
    }

    private static class VideoHandler
    extends Handler {
        private WeakReference<InlineVideoView> inlineVideoRef;

        public VideoHandler(InlineVideoView inlineVideoView) {
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 2: {
                    InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
                    if (inlineVideoView == null) return;
                    if (inlineVideoView.isPlaying()) {
                        inlineVideoView.updateVideoSeekTime();
                    }
                    inlineVideoView.videoHandler.sendMessageDelayed(Message.obtain((Handler)inlineVideoView.videoHandler, (int)2), 500L);
                    return;
                }
            }
        }
    }

    private static class VideoPreparedListener
    implements MediaPlayer.OnPreparedListener {
        private WeakReference<InlineVideoView> inlineVideoRef;

        public VideoPreparedListener(InlineVideoView inlineVideoView) {
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
            if (inlineVideoView != null) {
                inlineVideoView.onPrepared(mediaPlayer);
            }
        }
    }

    private static class VideoTouchListener
    implements View.OnTouchListener {
        private WeakReference<InlineVideoView> inlineVideoRef;

        public VideoTouchListener(InlineVideoView inlineVideoView) {
            this.inlineVideoRef = new WeakReference<InlineVideoView>(inlineVideoView);
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            InlineVideoView inlineVideoView = (InlineVideoView)this.inlineVideoRef.get();
            if (inlineVideoView != null) {
                return inlineVideoView.onTouch(view, motionEvent);
            }
            return true;
        }
    }
}

