/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import com.millennialmedia.android.AdViewOverlayActivity;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.OverlaySettings;
import com.millennialmedia.android.Utils;
import com.millennialmedia.android.VideoAd;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.json.JSONObject;

final class HttpRedirection {
    private static final String HEADER_LOCATION = "Location";
    private static final String HTTPS = "https";
    private static final String LOG_URL_FORMAT = "Redirecting to: %s";
    private static final String METHOD_GET = "GET";

    HttpRedirection() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final String navigateRedirects(String string2) {
        if (string2 == null) {
            return null;
        }
        HttpURLConnection.setFollowRedirects(false);
        try {
            while (!string2.startsWith(HTTPS)) {
                URL uRL = new URL(string2);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setConnectTimeout(10000);
                httpURLConnection.setRequestMethod(METHOD_GET);
                httpURLConnection.connect();
                int n2 = httpURLConnection.getResponseCode();
                if (n2 < 300) return string2;
                if (n2 >= 400) return string2;
                String string3 = httpURLConnection.getHeaderField(HEADER_LOCATION);
                URI uRI = new URI(string3);
                if (!uRI.isAbsolute()) {
                    string2 = uRL.toURI().resolve(uRI).toString();
                } else if (string3 != null) {
                    string2 = string3;
                }
                MMSDK.Log.v(LOG_URL_FORMAT, string2);
            }
            return string2;
        }
        catch (MalformedURLException malformedURLException) {
            return string2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            MMSDK.Log.d("Connection timeout.");
            return string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            MMSDK.Log.d("URI Syntax incorrect.");
            return string2;
        }
        catch (IOException iOException) {
            return string2;
        }
    }

    static void startActivityFromUri(RedirectionListenerImpl redirectionListenerImpl) {
        if (redirectionListenerImpl == null || redirectionListenerImpl.url == null || redirectionListenerImpl.weakContext == null) {
            return;
        }
        Utils.ThreadUtils.execute(new Runnable(new WeakReference<RedirectionListenerImpl>(redirectionListenerImpl)){
            final /* synthetic */ WeakReference val$listenerReference;
            {
                this.val$listenerReference = weakReference;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void handleDestinationUri(RedirectionListenerImpl redirectionListenerImpl) {
                String string2;
                Context context = (Context)redirectionListenerImpl.weakContext.get();
                if (context == null) return;
                String string3 = redirectionListenerImpl.destinationUri.getScheme();
                Intent intent = null;
                if (string3 != null) {
                    if (!string3.equalsIgnoreCase("mmvideo")) {
                        intent = Utils.IntentUtils.getIntentForUri(redirectionListenerImpl);
                    } else {
                        boolean bl2 = redirectionListenerImpl.isHandlingMMVideo(redirectionListenerImpl.destinationUri);
                        intent = null;
                        if (!bl2) {
                            VideoAd.playAd(context, redirectionListenerImpl.destinationUri.getHost(), redirectionListenerImpl);
                            return;
                        }
                    }
                }
                if (intent == null) return;
                OverlaySettings overlaySettings = redirectionListenerImpl.getOverlaySettings();
                if (intent != null && overlaySettings != null) {
                    if (redirectionListenerImpl.orientation != null) {
                        overlaySettings.orientation = redirectionListenerImpl.orientation;
                    }
                    intent.putExtra("settings", (Parcelable)overlaySettings);
                }
                if ((string2 = intent.getStringExtra("class")) != null) {
                    if (string2.equals(AdViewOverlayActivity.class.getCanonicalName())) return;
                }
                try {
                    if (!redirectionListenerImpl.isActivityStartable(redirectionListenerImpl.destinationUri)) return;
                    Utils.IntentUtils.startActivity(context, intent);
                    redirectionListenerImpl.startingActivity(redirectionListenerImpl.destinationUri);
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    Object[] objectArray = new Object[]{redirectionListenerImpl.destinationUri};
                    MMSDK.Log.e("No activity found for %s", objectArray);
                    return;
                }
            }

            @Override
            public void run() {
                String string2;
                block3: {
                    block2: {
                        RedirectionListenerImpl redirectionListenerImpl = (RedirectionListenerImpl)this.val$listenerReference.get();
                        if (redirectionListenerImpl == null || (string2 = HttpRedirection.navigateRedirects(redirectionListenerImpl.url)) == null) break block2;
                        redirectionListenerImpl.destinationUri = Uri.parse((String)string2);
                        if (redirectionListenerImpl.destinationUri == null) break block3;
                        this.handleDestinationUri(redirectionListenerImpl);
                    }
                    return;
                }
                MMSDK.Log.v("Could not start activity for %s", string2);
            }
        });
    }

    private static interface Listener {
        public boolean canOpenOverlay();

        public OverlaySettings getOverlaySettings();

        public boolean isActivityStartable(Uri var1);

        public boolean isExpandingToUrl();

        public boolean isHandlingMMVideo(Uri var1);

        public void startingActivity(Uri var1);

        public void startingVideo();

        public void updateLastVideoViewedTime();
    }

    static class RedirectionListenerImpl
    implements Listener {
        long creatorAdImplInternalId;
        Uri destinationUri;
        String orientation;
        String url;
        WeakReference<Context> weakContext;

        @Override
        public boolean canOpenOverlay() {
            return false;
        }

        public JSONObject getAdProperties() {
            return null;
        }

        @Override
        public OverlaySettings getOverlaySettings() {
            return null;
        }

        @Override
        public boolean isActivityStartable(Uri uri) {
            return true;
        }

        @Override
        public boolean isExpandingToUrl() {
            return false;
        }

        @Override
        public boolean isHandlingMMVideo(Uri uri) {
            return false;
        }

        @Override
        public void startingActivity(Uri uri) {
            MMSDK.Log.d("Starting activity for %s", uri);
        }

        @Override
        public void startingVideo() {
        }

        @Override
        public void updateLastVideoViewedTime() {
        }
    }
}

