/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.Map;
import org.apache.http.Header;

class HttpMMHeaders
implements Parcelable,
Serializable {
    public static final Parcelable.Creator<HttpMMHeaders> CREATOR = new Parcelable.Creator<HttpMMHeaders>(){

        public HttpMMHeaders createFromParcel(Parcel parcel) {
            return new HttpMMHeaders(parcel);
        }

        public HttpMMHeaders[] newArray(int n2) {
            return new HttpMMHeaders[n2];
        }
    };
    private static final String HEADER_MM_ACID = "X-MM-ACID";
    private static final String HEADER_MM_CUSTOM_CLOSE = "X-MM-USE-CUSTOM-CLOSE";
    private static final String HEADER_MM_ENABLE_HARDWARE_ACCEL = "X-MM-ENABLE-HARDWARE-ACCELERATION";
    private static final String HEADER_MM_TRANSITION = "X-MM-TRANSITION";
    private static final String HEADER_MM_TRANSITION_DURATION = "X-MM-TRANSITION-DURATION";
    private static final String HEADER_MM_TRANSPARENT = "X-MM-TRANSPARENT";
    static final long serialVersionUID = 3168621112125974L;
    String acid;
    boolean enableHardwareAccel;
    boolean isTransparent;
    String transition;
    long transitionTimeInMillis;
    boolean useCustomClose;

    public HttpMMHeaders(Parcel parcel) {
        try {
            boolean[] blArray = new boolean[3];
            parcel.readBooleanArray(blArray);
            this.isTransparent = blArray[0];
            this.useCustomClose = blArray[1];
            this.enableHardwareAccel = blArray[2];
            this.transition = parcel.readString();
            this.acid = parcel.readString();
            this.transitionTimeInMillis = parcel.readLong();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public HttpMMHeaders(Header[] headerArray) {
        for (Header header : headerArray) {
            this.checkTransparent(header);
            this.checkTransition(header);
            this.checkTransitionDuration(header);
            this.checkUseCustomClose(header);
            this.checkEnableHardwareAccel(header);
            this.checkAcid(header);
        }
    }

    private void checkAcid(Header header) {
        if (HEADER_MM_ACID.equalsIgnoreCase(header.getName())) {
            this.acid = header.getValue();
        }
    }

    private void checkEnableHardwareAccel(Header header) {
        if (HEADER_MM_ENABLE_HARDWARE_ACCEL.equalsIgnoreCase(header.getName())) {
            this.enableHardwareAccel = Boolean.parseBoolean(header.getValue());
        }
    }

    private void checkTransition(Header header) {
        if (HEADER_MM_TRANSITION.equalsIgnoreCase(header.getName())) {
            this.transition = header.getValue();
        }
    }

    private void checkTransitionDuration(Header header) {
        String string2;
        if (HEADER_MM_TRANSITION_DURATION.equalsIgnoreCase(header.getName()) && (string2 = header.getValue()) != null) {
            this.transitionTimeInMillis = (long)(1000.0f * Float.parseFloat(string2));
        }
    }

    private void checkTransparent(Header header) {
        String string2;
        if (HEADER_MM_TRANSPARENT.equalsIgnoreCase(header.getName()) && (string2 = header.getValue()) != null) {
            this.isTransparent = Boolean.parseBoolean(string2);
        }
    }

    private void checkUseCustomClose(Header header) {
        if (HEADER_MM_CUSTOM_CLOSE.equalsIgnoreCase(header.getName())) {
            this.useCustomClose = Boolean.parseBoolean(header.getValue());
        }
    }

    public int describeContents() {
        return 0;
    }

    void updateArgumentsWithSettings(Map<String, String> map) {
        map.put("transparent", String.valueOf(this.isTransparent));
        map.put("transition", String.valueOf(this.transition));
        map.put("acid", String.valueOf(this.acid));
        map.put("transitionDuration", String.valueOf(this.transitionTimeInMillis));
        map.put("useCustomClose", String.valueOf(this.useCustomClose));
        map.put("enableHardwareAccel", String.valueOf(this.enableHardwareAccel));
    }

    public void writeToParcel(Parcel parcel, int n2) {
        boolean[] blArray = new boolean[]{this.isTransparent, this.useCustomClose, this.enableHardwareAccel};
        parcel.writeBooleanArray(blArray);
        parcel.writeString(this.transition);
        parcel.writeString(this.acid);
        parcel.writeLong(this.transitionTimeInMillis);
    }
}

