/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.widget.Toast;
import com.millennialmedia.android.DTOCachedVideo;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MRaid;
import com.millennialmedia.android.PreCacheWorker;
import com.millennialmedia.android.Utils;
import com.millennialmedia.google.gson.Gson;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class HandShake {
    static final String BASE_URL = "http://androidsdk.ads.mp.mydas.mobi/";
    static final String BASE_URL_PATH = "getAd.php5?";
    private static final String HANDSHAKE_FALLBACK_URL = "http://ads.mp.mydas.mobi/appConfigServlet?apid=";
    private static final String HANDSHAKE_HTTPS_SCHEME = "https://";
    private static final String HANDSHAKE_HTTP_SCHEME = "http://";
    private static final String HANDSHAKE_URL_HOST = "ads.mp.mydas.mobi/";
    private static final String HANDSHAKE_URL_OVERRIDE_PARMS = "?apid=";
    private static final String HANDSHAKE_URL_PARMS = "appConfigServlet?apid=";
    private static final String KEY_CACHED_VIDEOS = "handshake_cachedvideos5.0";
    private static String adUrl;
    static String apid;
    private static boolean forceRefresh;
    private static String handShakeURL;
    private static HandShake sharedInstance;
    long adRefreshSecs;
    private LinkedHashMap<String, AdTypeHandShake> adTypeHandShakes;
    private WeakReference<Context> appContextRef;
    DTOCachedVideo[] cachedVideos;
    private WeakReference<Context> contextRef;
    long creativeCacheTimeout = 259200000L;
    private long deferredViewTimeout = 3600000L;
    String endSessionURL;
    private long handShakeCallback = 86400000L;
    private final Handler handler = new Handler(Looper.getMainLooper());
    boolean hardwareAccelerationEnabled;
    boolean kill = false;
    private long lastHandShake;
    String mmdid;
    String mmjsUrl;
    private String noVideosToCacheURL;
    NuanceCredentials nuanceCredentials;
    private ArrayList<Scheme> schemes;
    private String schemesList;
    String startSessionURL;
    private Runnable updateHandShakeRunnable;

    static {
        apid = "28913";
        handShakeURL = "https://ads.mp.mydas.mobi/appConfigServlet?apid=";
        adUrl = "http://androidsdk.ads.mp.mydas.mobi/getAd.php5?";
    }

    private HandShake() {
        this.adTypeHandShakes = new LinkedHashMap();
        this.schemes = new ArrayList();
        this.updateHandShakeRunnable = new Runnable(){

            @Override
            public void run() {
                Context context = (Context)HandShake.this.contextRef.get();
                if (context == null) {
                    context = (Context)HandShake.this.appContextRef.get();
                }
                if (context != null) {
                    HandShake.sharedHandShake(context);
                }
            }
        };
    }

    private HandShake(Context context) {
        this.adTypeHandShakes = new LinkedHashMap();
        this.schemes = new ArrayList();
        this.updateHandShakeRunnable = new /* invalid duplicate definition of identical inner class */;
        this.contextRef = new WeakReference<Context>(context);
        this.appContextRef = new WeakReference<Context>(context.getApplicationContext());
        if (forceRefresh || !this.loadHandShake(context) || System.currentTimeMillis() - this.lastHandShake > this.handShakeCallback) {
            forceRefresh = false;
            this.lastHandShake = System.currentTimeMillis();
            this.requestHandshake(false);
        }
    }

    static /* synthetic */ void access$1000(HandShake handShake, Context context) {
        handShake.sentFirstLaunch(context);
    }

    static /* synthetic */ boolean access$200(HandShake handShake, Context context) {
        return handShake.isFirstLaunch(context);
    }

    static /* synthetic */ String access$300() {
        return handShakeURL;
    }

    static /* synthetic */ String access$302(String string2) {
        handShakeURL = string2;
        return string2;
    }

    static /* synthetic */ JSONObject access$400(HandShake handShake, String string2) {
        return handShake.parseJson(string2);
    }

    static /* synthetic */ void access$500(HandShake handShake, JSONObject jSONObject) {
        handShake.deserializeFromObj(jSONObject);
    }

    static /* synthetic */ void access$600(HandShake handShake, Context context) {
        handShake.saveHandShake(context);
    }

    static /* synthetic */ Runnable access$700(HandShake handShake) {
        return handShake.updateHandShakeRunnable;
    }

    static /* synthetic */ long access$800(HandShake handShake) {
        return handShake.handShakeCallback;
    }

    static /* synthetic */ Handler access$900(HandShake handShake) {
        return handShake.handler;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void deserializeFromObj(JSONObject jSONObject) {
        block17: {
            final Context context = (Context)this.contextRef.get();
            if (jSONObject == null) {
                return;
            }
            try {
                JSONArray jSONArray = jSONObject.optJSONArray("errors");
                if (jSONArray != null) {
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        JSONObject jSONObject2 = jSONArray.optJSONObject(i2);
                        if (jSONObject2 == null) continue;
                        final String string2 = jSONObject2.optString("message", null);
                        String string3 = jSONObject2.optString("type", null);
                        if (string2 == null || string3 == null) continue;
                        if (string3.equalsIgnoreCase("log")) {
                            MMSDK.Log.e(string2);
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("prompt")) continue;
                        Handler handler = this.handler;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Toast.makeText((Context)context, (CharSequence)("Error: " + string2), (int)1).show();
                                    return;
                                }
                                catch (WindowManager.BadTokenException badTokenException) {
                                    badTokenException.printStackTrace();
                                    return;
                                }
                            }
                        };
                        handler.post(runnable);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            {
                JSONObject jSONObject3 = jSONObject.optJSONObject("adtypes");
                if (jSONObject3 != null) {
                    String[] stringArray = MMAdImpl.getAdTypes();
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        JSONObject jSONObject4 = jSONObject3.optJSONObject(stringArray[i3]);
                        if (jSONObject4 == null) continue;
                        AdTypeHandShake adTypeHandShake = new AdTypeHandShake();
                        adTypeHandShake.deserializeFromObj(jSONObject4);
                        adTypeHandShake.loadLastVideo(context, stringArray[i3]);
                        this.adTypeHandShakes.put(stringArray[i3], adTypeHandShake);
                    }
                }
                // MONITORENTER : this
            }
            JSONArray jSONArray = jSONObject.optJSONArray("schemes");
            if (jSONArray != null) {
                if (this.schemes != null && this.schemes.size() > 0) {
                    this.schemes.removeAll(this.schemes);
                }
                for (int i4 = 0; i4 < jSONArray.length(); ++i4) {
                    JSONObject jSONObject5 = jSONArray.optJSONObject(i4);
                    if (jSONObject5 == null) continue;
                    Scheme scheme = new Scheme();
                    scheme.deserializeFromObj(jSONObject5);
                    this.schemes.add(scheme);
                }
            }
            // MONITOREXIT : this
            {
                this.adRefreshSecs = jSONObject.optLong("adrefresh", 0L);
                this.deferredViewTimeout = 1000L * jSONObject.optLong("deferredviewtimeout", 3600L);
                this.kill = jSONObject.optBoolean("kill");
                HandShake.setAdUrl(context, jSONObject.optString("baseURL"));
                this.handShakeCallback = 1000L * jSONObject.optLong("handshakecallback", 86400L);
                this.creativeCacheTimeout = 1000L * jSONObject.optLong("creativeCacheTimeout", 259200L);
                this.hardwareAccelerationEnabled = jSONObject.optBoolean("hardwareAccelerationEnabled");
                this.startSessionURL = jSONObject.optString("startSessionURL");
                this.endSessionURL = jSONObject.optString("endSessionURL");
                String string4 = jSONObject.optString("nuanceCredentials");
                this.nuanceCredentials = new Gson().fromJson(string4, NuanceCredentials.class);
                this.mmjsUrl = jSONObject.optString("mmjs");
                this.handleCachedVideos(jSONObject, context);
                if (TextUtils.isEmpty((CharSequence)this.mmjsUrl) || MRaid.isMRaidUpdated(context, this.mmjsUrl)) break block17;
                MRaid.downloadMraidJs((Context)this.appContextRef.get(), this.mmjsUrl);
                return;
            }
        }
        MMSDK.Log.w("Not downloading MMJS - (" + this.mmjsUrl + ")");
    }

    static String getAdUrl() {
        if (!TextUtils.isEmpty((CharSequence)adUrl) && URLUtil.isHttpUrl((String)adUrl.replace(BASE_URL_PATH, ""))) {
            return adUrl;
        }
        return "http://androidsdk.ads.mp.mydas.mobi/getAd.php5?";
    }

    private void handleCachedVideos(JSONObject jSONObject, Context context) {
        JSONArray jSONArray = jSONObject.optJSONArray("cachedVideos");
        if (jSONArray != null) {
            this.cachedVideos = new Gson().fromJson(jSONArray.toString(), DTOCachedVideo[].class);
            MMSDK.Log.d(this.cachedVideos.toString());
        }
        this.noVideosToCacheURL = jSONObject.optString("noVideosToCacheURL");
        if (this.cachedVideos != null) {
            PreCacheWorker.preCacheVideos(this.cachedVideos, context, this.noVideosToCacheURL);
        }
    }

    private boolean isFirstLaunch(Context context) {
        if (context == null) {
            return false;
        }
        return context.getSharedPreferences("MillennialMediaSettings", 0).getBoolean("firstlaunchHandshake", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean loadHandShake(Context context) {
        String string2;
        String string3;
        SharedPreferences sharedPreferences = context.getSharedPreferences("MillennialMediaSettings", 0);
        if (sharedPreferences == null) {
            return false;
        }
        boolean bl2 = sharedPreferences.contains("handshake_deferredviewtimeout");
        boolean bl3 = false;
        if (bl2) {
            this.deferredViewTimeout = sharedPreferences.getLong("handshake_deferredviewtimeout", this.deferredViewTimeout);
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_baseUrl")) {
            adUrl = sharedPreferences.getString("handshake_baseUrl", adUrl);
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_callback")) {
            this.handShakeCallback = sharedPreferences.getLong("handshake_callback", this.handShakeCallback);
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_hardwareAccelerationEnabled")) {
            this.hardwareAccelerationEnabled = sharedPreferences.getBoolean("handshake_hardwareAccelerationEnabled", false);
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_startSessionURL")) {
            this.startSessionURL = sharedPreferences.getString("handshake_startSessionURL", "");
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_endSessionURL")) {
            this.endSessionURL = sharedPreferences.getString("handshake_endSessionURL", "");
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_nuanceCredentials")) {
            String string4 = sharedPreferences.getString("handshake_nuanceCredentials", "");
            this.nuanceCredentials = new Gson().fromJson(string4, NuanceCredentials.class);
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_mmdid")) {
            this.setMMdid(context, sharedPreferences.getString("handshake_mmdid", this.mmdid), false);
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_creativecachetimeout")) {
            this.creativeCacheTimeout = sharedPreferences.getLong("handshake_creativecachetimeout", this.creativeCacheTimeout);
            bl3 = true;
        }
        if (sharedPreferences.contains("handshake_mmjs")) {
            this.mmjsUrl = sharedPreferences.getString("handshake_mmjs", this.mmjsUrl);
            bl3 = true;
        }
        String[] stringArray = MMAdImpl.getAdTypes();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            AdTypeHandShake adTypeHandShake = new AdTypeHandShake();
            if (!adTypeHandShake.load(sharedPreferences, stringArray[i2])) continue;
            bl3 = true;
            this.adTypeHandShakes.put(stringArray[i2], adTypeHandShake);
        }
        // MONITORENTER : this
        if (sharedPreferences.contains("handshake_schemes") && (string3 = sharedPreferences.getString("handshake_schemes", "")).length() > 0) {
            String[] stringArray2 = string3.split("\n");
            int n2 = stringArray2.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                String[] stringArray3 = stringArray2[i3].split("\t");
                if (stringArray3.length < 2) continue;
                Scheme scheme = new Scheme(stringArray3[0], Integer.parseInt(stringArray3[1]));
                this.schemes.add(scheme);
            }
            bl3 = true;
        }
        // MONITOREXIT : this
        if (sharedPreferences.contains(KEY_CACHED_VIDEOS) && (string2 = sharedPreferences.getString(KEY_CACHED_VIDEOS, "")).length() > 0) {
            this.cachedVideos = new Gson().fromJson(string2, DTOCachedVideo[].class);
        }
        if (sharedPreferences.contains("handshake_lasthandshake")) {
            this.lastHandShake = sharedPreferences.getLong("handshake_lasthandshake", this.lastHandShake);
            bl3 = true;
        }
        if (!bl3) return bl3;
        MMSDK.Log.d("Handshake successfully loaded from shared preferences.");
        if (System.currentTimeMillis() - this.lastHandShake < this.handShakeCallback) {
            this.handler.postDelayed(this.updateHandShakeRunnable, this.handShakeCallback - (System.currentTimeMillis() - this.lastHandShake));
        }
        this.noVideosToCacheURL = sharedPreferences.getString("handshake_novideostocacheurl", "");
        if (this.cachedVideos == null) return bl3;
        PreCacheWorker.preCacheVideos(this.cachedVideos, context, this.noVideosToCacheURL);
        return bl3;
    }

    private JSONObject parseJson(String string2) {
        MMSDK.Log.d("JSON String: %s", string2);
        if (string2 != null) {
            try {
                JSONObject jSONObject = new JSONObject(string2);
                MMSDK.Log.v(jSONObject.toString());
                if (jSONObject.has("mmishake")) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("mmishake");
                    return jSONObject2;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return null;
    }

    private void requestHandshake(final boolean bl2) {
        Utils.ThreadUtils.execute(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [16 : 261->306)] java.io.IOException
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void saveHandShake(Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences("MillennialMediaSettings", 0).edit();
        editor.putLong("handshake_deferredviewtimeout", this.deferredViewTimeout);
        editor.putBoolean("handshake_kill", this.kill);
        editor.putString("handshake_baseUrl", adUrl);
        editor.putLong("handshake_callback", this.handShakeCallback);
        editor.putBoolean("handshake_hardwareAccelerationEnabled", this.hardwareAccelerationEnabled);
        editor.putString("handshake_startSessionURL", this.startSessionURL);
        if (this.nuanceCredentials != null) {
            editor.putString("handshake_nuanceCredentials", new Gson().toJson(this.nuanceCredentials));
        }
        editor.putString("handshake_endSessionURL", this.endSessionURL);
        editor.putLong("handshake_creativecaetimeout", this.creativeCacheTimeout);
        editor.putString("handshake_mmjs", this.mmjsUrl);
        for (String string2 : this.adTypeHandShakes.keySet()) {
            this.adTypeHandShakes.get(string2).save(editor, string2);
        }
        // MONITORENTER : this
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.schemes.size(); ++i2) {
            Scheme scheme = this.schemes.get(i2);
            if (i2 > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(scheme.scheme + "\t" + scheme.id);
        }
        editor.putString("handshake_schemes", stringBuilder.toString());
        // MONITOREXIT : this
        if (this.cachedVideos != null) {
            editor.putString(KEY_CACHED_VIDEOS, new Gson().toJson(this.cachedVideos));
        }
        editor.putString("handshake_novideostocacheurl", this.noVideosToCacheURL);
        editor.putLong("handshake_lasthandshake", this.lastHandShake);
        editor.commit();
    }

    private void sentFirstLaunch(Context context) {
        if (context != null) {
            SharedPreferences.Editor editor = context.getSharedPreferences("MillennialMediaSettings", 0).edit();
            editor.putBoolean("firstlaunchHandshake", false);
            editor.commit();
        }
    }

    static void setAdUrl(Context context, String string2) {
        block3: {
            block2: {
                if (TextUtils.isEmpty((CharSequence)string2)) break block2;
                if (string2.endsWith("/")) break block3;
                adUrl = string2 + "/" + BASE_URL_PATH;
            }
            return;
        }
        adUrl = string2 + BASE_URL_PATH;
    }

    static void setHandShakeURL(Context context, String string2) {
        synchronized (HandShake.class) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (string2.startsWith(HANDSHAKE_HTTP_SCHEME)) {
                    string2 = string2.replaceFirst(HANDSHAKE_HTTP_SCHEME, HANDSHAKE_HTTPS_SCHEME);
                }
                handShakeURL = string2 + HANDSHAKE_URL_OVERRIDE_PARMS;
                forceRefresh = true;
                sharedInstance = new HandShake(context);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static HandShake sharedHandShake(Context context) {
        synchronized (HandShake.class) {
            if (apid == null) {
                MMSDK.Log.e("No apid set for the handshake.");
                return null;
            }
            if (sharedInstance == null) {
                sharedInstance = new HandShake(context);
                return sharedInstance;
            } else {
                if (System.currentTimeMillis() - HandShake.sharedInstance.lastHandShake <= HandShake.sharedInstance.handShakeCallback) return sharedInstance;
                MMSDK.Log.d("Handshake expired, requesting new handshake from the server.");
                sharedInstance = new HandShake(context);
            }
            return sharedInstance;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canDisplayCachedAd(String string2, long l2) {
        synchronized (this) {
            AdTypeHandShake adTypeHandShake = this.adTypeHandShakes.get(string2);
            if (adTypeHandShake == null) return true;
            boolean bl2 = adTypeHandShake.canDisplayCachedAd(l2);
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean canRequestVideo(Context context, String string2) {
        synchronized (this) {
            AdTypeHandShake adTypeHandShake = this.adTypeHandShakes.get(string2);
            if (adTypeHandShake == null) return true;
            boolean bl2 = adTypeHandShake.canRequestVideo(context);
            return bl2;
        }
    }

    void endSession() {
        if (!TextUtils.isEmpty((CharSequence)this.endSessionURL)) {
            Utils.HttpUtils.executeUrl(this.endSessionURL);
        }
    }

    JSONArray getSchemesJSONArray(Context context) {
        synchronized (this) {
            JSONArray jSONArray;
            block6: {
                jSONArray = new JSONArray();
                if (this.schemes.size() <= 0) break block6;
                for (Scheme scheme : this.schemes) {
                    boolean bl2 = scheme.checkAvailability(context);
                    if (!bl2) continue;
                }
                {
                    try {
                        Scheme scheme;
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("scheme", (Object)scheme.scheme);
                        jSONObject.put("schemeid", scheme.id);
                        jSONArray.put((Object)jSONObject);
                        continue;
                    }
                    catch (JSONException jSONException) {
                        continue;
                    }
                }
            }
            return jSONArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getSchemesList(Context context) {
        synchronized (this) {
            if (this.schemesList != null) return this.schemesList;
            if (this.schemes.size() <= 0) return this.schemesList;
            StringBuilder stringBuilder = new StringBuilder();
            for (Scheme scheme : this.schemes) {
                if (!scheme.checkAvailability(context)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("," + scheme.id);
                    continue;
                }
                stringBuilder.append(Integer.toString(scheme.id));
            }
            if (stringBuilder.length() <= 0) return this.schemesList;
            this.schemesList = stringBuilder.toString();
            return this.schemesList;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isAdTypeDownloading(String string2) {
        synchronized (this) {
            AdTypeHandShake adTypeHandShake = this.adTypeHandShakes.get(string2);
            if (adTypeHandShake == null) return false;
            return adTypeHandShake.downloading;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void lockAdTypeDownload(String string2) {
        synchronized (this) {
            AdTypeHandShake adTypeHandShake = this.adTypeHandShakes.get(string2);
            if (adTypeHandShake != null) {
                adTypeHandShake.downloading = true;
            }
            return;
        }
    }

    void sendInitRequest() {
        this.requestHandshake(true);
    }

    void setMMdid(Context context, String string2) {
        this.setMMdid(context, string2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setMMdid(Context context, String string2, boolean bl2) {
        synchronized (this) {
            this.mmdid = string2 != null && (string2.length() == 0 || string2.equals("NULL")) ? null : string2;
            MMSDK.setMMdid(this.mmdid);
            if (bl2) {
                SharedPreferences.Editor editor = context.getSharedPreferences("MillennialMediaSettings", 0).edit();
                editor.putString("handshake_mmdid", this.mmdid);
                editor.commit();
            }
            return;
        }
    }

    void startSession() {
        if (!TextUtils.isEmpty((CharSequence)this.startSessionURL)) {
            Utils.HttpUtils.executeUrl(this.startSessionURL);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unlockAdTypeDownload(String string2) {
        synchronized (this) {
            AdTypeHandShake adTypeHandShake = this.adTypeHandShakes.get(string2);
            if (adTypeHandShake != null) {
                adTypeHandShake.downloading = false;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateLastVideoViewedTime(Context context, String string2) {
        synchronized (this) {
            AdTypeHandShake adTypeHandShake = this.adTypeHandShakes.get(string2);
            if (adTypeHandShake != null) {
                adTypeHandShake.updateLastVideoViewedTime(context, string2);
            }
            return;
        }
    }

    private class AdTypeHandShake {
        boolean downloading;
        long lastVideo = 0L;
        long videoInterval = 0L;

        AdTypeHandShake() {
        }

        boolean canDisplayCachedAd(long l2) {
            return System.currentTimeMillis() - l2 < HandShake.this.deferredViewTimeout;
        }

        boolean canRequestVideo(Context context) {
            Object[] objectArray = new Object[]{System.currentTimeMillis(), this.lastVideo / 1000L, (System.currentTimeMillis() - this.lastVideo) / 1000L, this.videoInterval / 1000L};
            MMSDK.Log.d("canRequestVideo() Current Time: %d Last Video: %d  Diff: %d  Video interval: %d", objectArray);
            return System.currentTimeMillis() - this.lastVideo > this.videoInterval;
        }

        void deserializeFromObj(JSONObject jSONObject) {
            if (jSONObject == null) {
                return;
            }
            this.videoInterval = 1000L * jSONObject.optLong("videointerval");
        }

        boolean load(SharedPreferences sharedPreferences, String string2) {
            boolean bl2 = sharedPreferences.contains("handshake_lastvideo_" + string2);
            boolean bl3 = false;
            if (bl2) {
                this.lastVideo = sharedPreferences.getLong("handshake_lastvideo_" + string2, this.lastVideo);
                bl3 = true;
            }
            if (sharedPreferences.contains("handshake_videointerval_" + string2)) {
                this.videoInterval = sharedPreferences.getLong("handshake_videointerval_" + string2, this.videoInterval);
                bl3 = true;
            }
            return bl3;
        }

        void loadLastVideo(Context context, String string2) {
            SharedPreferences sharedPreferences = context.getSharedPreferences("MillennialMediaSettings", 0);
            if (sharedPreferences != null && sharedPreferences.contains("handshake_lastvideo_" + string2)) {
                this.lastVideo = sharedPreferences.getLong("handshake_lastvideo_" + string2, this.lastVideo);
            }
        }

        void save(Context context, String string2) {
            SharedPreferences.Editor editor = context.getSharedPreferences("MillennialMediaSettings", 0).edit();
            this.save(editor, string2);
            editor.commit();
        }

        void save(SharedPreferences.Editor editor, String string2) {
            editor.putLong("handshake_lastvideo_" + string2, this.lastVideo);
            editor.putLong("handshake_videointerval_" + string2, this.videoInterval);
        }

        void updateLastVideoViewedTime(Context context, String string2) {
            this.lastVideo = System.currentTimeMillis();
            this.save(context, string2);
        }
    }

    static class NuanceCredentials {
        String appID;
        String appKey;
        int port;
        String server;
        String sessionID;

        private NuanceCredentials() {
        }

        public String toString() {
            return "Credentials: appid=" + this.appID + " server=" + this.server + " port=" + this.port + " appKey=" + this.appKey + "sessionID=" + this.sessionID;
        }
    }

    private class Scheme {
        int id;
        String scheme;

        Scheme() {
        }

        Scheme(String string2, int n2) {
            this.scheme = string2;
            this.id = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean checkAvailability(Context context) {
            Intent intent;
            if (this.scheme.contains("://")) {
                intent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.scheme));
                return context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
            }
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)(this.scheme + "://")));
            return context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
        }

        void deserializeFromObj(JSONObject jSONObject) {
            if (jSONObject == null) {
                return;
            }
            this.scheme = jSONObject.optString("scheme", null);
            this.id = jSONObject.optInt("schemeid");
        }
    }
}

