/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.AdProperties;
import com.millennialmedia.android.HttpGetRequest;
import com.millennialmedia.android.InterstitialWebViewClient;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.MMWebView;
import com.millennialmedia.android.MMWebViewClient;
import com.millennialmedia.android.VideoAd;
import com.millennialmedia.android.VideoImage;
import com.millennialmedia.android.VideoPlayerActivity;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

class CachedVideoPlayerActivity
extends VideoPlayerActivity
implements Handler.Callback {
    private static final int STATIC_HUD_ID = 402;
    private static final int STATIC_HUD_SECONDS_ID = 401;
    private RelativeLayout buttonsLayout;
    private boolean hasCountdownHud = true;
    boolean hasLoadedCompletionUrl;
    boolean hasWebOverlay;
    private TextView hudSeconds;
    private TextView hudStaticText;
    private int lastVideoPosition;
    private Handler logTimeAndEventhandler;
    private MMWebView mWebView;
    private VideoAd videoAd;

    CachedVideoPlayerActivity() {
    }

    private String calculateHudSecondsText() {
        if (this.currentVideoPosition != 0) {
            return String.valueOf(this.currentVideoPosition / 1000);
        }
        if (this.videoAd != null) {
            return String.valueOf(this.videoAd.duration / 1000L);
        }
        return "";
    }

    private void dismissAfter(long l2) {
        this.logTimeAndEventhandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CachedVideoPlayerActivity.this.dismiss();
            }
        }, l2);
    }

    private void fadeButton(VideoImage videoImage) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(videoImage.fromAlpha, videoImage.toAlpha);
        alphaAnimation.setDuration(videoImage.fadeDuration);
        alphaAnimation.setFillEnabled(true);
        alphaAnimation.setFillBefore(true);
        alphaAnimation.setFillAfter(true);
        videoImage.button.startAnimation((Animation)alphaAnimation);
    }

    private void fadeButtons() {
        if (this.videoAd != null && this.videoAd.buttons != null) {
            for (int i2 = 0; i2 < this.videoAd.buttons.size(); ++i2) {
                VideoImage videoImage = this.videoAd.buttons.get(i2);
                if (!videoImage.isLeaveBehind) {
                    this.setButtonAlpha(videoImage.button, videoImage.fromAlpha);
                }
                if (videoImage.button.getParent() == null) {
                    this.buttonsLayout.addView((View)videoImage.button, (ViewGroup.LayoutParams)videoImage.layoutParams);
                }
                for (int i3 = 0; i3 < this.videoAd.buttons.size(); ++i3) {
                    this.buttonsLayout.bringChildToFront((View)this.videoAd.buttons.get((int)i3).button);
                }
                Object[] objectArray = new Object[]{i2, Float.valueOf(videoImage.fromAlpha)};
                MMSDK.Log.v("Button: %d alpha: %f", objectArray);
            }
        }
    }

    private void hideHud() {
        if (this.hudStaticText != null) {
            this.hudStaticText.setVisibility(4);
        }
        if (this.hudSeconds != null) {
            this.hudSeconds.setVisibility(4);
        }
    }

    private void initHudSeconds(ViewGroup viewGroup) {
        this.hudSeconds = new TextView((Context)this.activity);
        this.hudSeconds.setText((CharSequence)this.calculateHudSecondsText());
        this.hudSeconds.setTextColor(-1);
        this.hudSeconds.setId(401);
        this.hudSeconds.setShadowLayer(1.0f, 0.0f, 0.0f, -16777216);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        layoutParams.addRule(0, 402);
        viewGroup.addView((View)this.hudSeconds, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initHudStaticText(ViewGroup viewGroup) {
        this.hudStaticText = new TextView((Context)this.activity);
        this.hudStaticText.setText((CharSequence)" seconds remaining ...");
        this.hudStaticText.setTextColor(-1);
        this.hudStaticText.setPadding(0, 0, 5, 0);
        this.hudStaticText.setId(402);
        this.hudStaticText.setShadowLayer(1.0f, 0.0f, 0.0f, -16777216);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        layoutParams.addRule(11);
        viewGroup.addView((View)this.hudStaticText, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initWebOverlay() {
        this.mWebView = new MMWebView((Context)this.activity, this.activity.creatorAdImplInternalId);
        this.mWebView.setId(413);
        CachedVideoWebViewClientListener cachedVideoWebViewClientListener = new CachedVideoWebViewClientListener(this);
        this.mWebView.setWebViewClient(new InterstitialWebViewClient(cachedVideoWebViewClientListener, this.redirectListenerImpl));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mWebView.setBackgroundColor(0);
        this.loadUrlForMraidInjection(this.videoAd.webOverlayURL);
    }

    private void onPageFinished(String string2) {
        if (this.mVideoView != null && this.videoAd != null && !this.mVideoView.isPlaying() && this.videoAd.webOverlayURL != null && string2.equalsIgnoreCase(this.videoAd.webOverlayURL)) {
            this.playVideo(0);
        }
    }

    private void showHud() {
        if (this.videoAd != null) {
            this.hudSeconds.setText((CharSequence)String.valueOf(this.videoAd.duration / 1000L));
        }
        this.hudStaticText.setVisibility(0);
        this.hudSeconds.setVisibility(0);
    }

    @Override
    protected boolean canFadeButtons() {
        return !this.videoAd.stayInPlayer || !super.canFadeButtons();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.videoAd != null) {
            if (this.logTimeAndEventhandler != null) {
                this.logTimeAndEventhandler.removeMessages(1);
            }
            if (!this.hasWebOverlay) {
                for (int i2 = 0; i2 < this.videoAd.buttons.size(); ++i2) {
                    VideoImage videoImage = this.videoAd.buttons.get(i2);
                    this.setButtonAlpha(videoImage.button, videoImage.fromAlpha);
                    if (videoImage.inactivityTimeout > 0L) {
                        Message message = Message.obtain((Handler)this.logTimeAndEventhandler, (int)1, (Object)videoImage);
                        this.logTimeAndEventhandler.sendMessageDelayed(message, videoImage.inactivityTimeout);
                        continue;
                    }
                    if (motionEvent.getAction() == 1) {
                        if (!this.canFadeButtons()) continue;
                        AlphaAnimation alphaAnimation = new AlphaAnimation(videoImage.fromAlpha, videoImage.toAlpha);
                        alphaAnimation.setDuration(videoImage.fadeDuration);
                        alphaAnimation.setFillEnabled(true);
                        alphaAnimation.setFillBefore(true);
                        alphaAnimation.setFillAfter(true);
                        videoImage.button.startAnimation((Animation)alphaAnimation);
                        continue;
                    }
                    if (motionEvent.getAction() != 0) continue;
                    this.setButtonAlpha(videoImage.button, videoImage.fromAlpha);
                }
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void enableButtons() {
        super.enableButtons();
        if (!this.hasWebOverlay && this.videoAd != null && this.videoAd.buttons != null) {
            for (VideoImage videoImage : this.videoAd.buttons) {
                if (videoImage.button == null) continue;
                videoImage.button.setEnabled(true);
            }
        }
    }

    @Override
    protected void errorPlayVideo(String string2) {
        if (this.videoAd != null) {
            HttpGetRequest.log(this.videoAd.videoError);
        }
        if (this.mWebView != null) {
            this.mWebView.loadUrl("javascript:MMJS.cachedVideo.setError(" + string2 + ");");
        }
        super.errorPlayVideo(string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleMessage(Message var1_1) {
        block22: {
            switch (var1_1.what) {
                case 1: {
                    if (this.canFadeButtons() == false) return true;
                    this.fadeButton((VideoImage)var1_1.obj);
                    ** break;
                }
                case 3: {
                    var10_2 = (VideoImage)var1_1.obj;
                    try {
                        if (this.buttonsLayout.indexOfChild((View)var10_2.button) == -1) {
                            this.buttonsLayout.addView((View)var10_2.button, (ViewGroup.LayoutParams)var10_2.layoutParams);
                        }
                    }
                    catch (IllegalStateException var11_4) {
                        var11_4.printStackTrace();
                    }
                    if (this.canFadeButtons() == false) return true;
                    this.fadeButton(var10_2);
                    var12_3 = new Object[]{var10_2.fadeDuration, var10_2.button.getId(), System.currentTimeMillis()};
                    MMSDK.Log.v("Beginning animation to visibility. Fade duration: %d Button: %d Time: %d", var12_3);
                }
lbl18:
                // 3 sources

                default: {
                    return true;
                }
                case 2: 
            }
            try {
                if (this.mVideoView == null || !this.mVideoView.isPlaying()) ** GOTO lbl46
                var4_5 = this.mVideoView.getCurrentPosition();
                if (var4_5 <= this.lastVideoPosition) ** GOTO lbl39
                if (this.videoAd == null) ** GOTO lbl38
                if (this.lastVideoPosition != 0) break block22;
                this.videoAd.logBeginEvent();
                break block22;
lbl29:
                // 1 sources

                while (true) {
                    block23: {
                        if (var7_6 < this.videoAd.activities.size()) {
                            var8_7 = this.videoAd.activities.get(var7_6);
                            if (var8_7 != null && var8_7.position >= (long)this.lastVideoPosition && var8_7.position < (long)var4_5) {
                                for (var9_8 = 0; var9_8 < var8_7.activities.length; ++var9_8) {
                                    MMSDK.Event.logEvent(var8_7.activities[var9_8]);
                                }
                            }
                            ++var7_6;
                            continue;
                        }
lbl38:
                        // 3 sources

                        this.lastVideoPosition = var4_5;
lbl39:
                        // 2 sources

                        if (this.hasWebOverlay && this.mWebView != null) {
                            this.mWebView.loadUrl("javascript:MMJS.cachedVideo.updateVideoSeekTime(" + (float)Math.floor((float)var4_5 / 1000.0f) + ");");
                        }
                        if (!this.hasCountdownHud) break block23;
                        var5_9 = (this.videoAd.duration - (long)var4_5) / 1000L;
                        if (var5_9 <= 0L) break;
                        if (this.hudSeconds != null) {
                            this.hudSeconds.setText((CharSequence)String.valueOf(var5_9));
                        }
                    }
lbl47:
                    // 2 sources

                    while (true) {
                        this.logTimeAndEventhandler.sendMessageDelayed(Message.obtain((Handler)this.logTimeAndEventhandler, (int)2), 500L);
                        return true;
                    }
                    break;
                }
            }
            catch (IllegalStateException var2_10) {
                var2_10.printStackTrace();
                return true;
            }
            {
                this.hideHud();
                ** continue;
            }
        }
        var7_6 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    protected RelativeLayout initLayout() {
        RelativeLayout relativeLayout = super.initLayout();
        this.logTimeAndEventhandler = new Handler((Handler.Callback)this);
        this.setRequestedOrientation(0);
        if (this.hasCountdownHud) {
            this.initHudStaticText((ViewGroup)relativeLayout);
            this.initHudSeconds((ViewGroup)relativeLayout);
            this.showHud();
        }
        if (this.videoAd != null && this.videoAd.webOverlayURL != null) {
            this.initWebOverlay();
            if (this.mWebView == null) return relativeLayout;
            relativeLayout.addView((View)this.mWebView);
            this.hasWebOverlay = true;
            return relativeLayout;
        }
        this.hasWebOverlay = false;
        this.buttonsLayout = new RelativeLayout((Context)this.activity);
        this.buttonsLayout.setId(1000);
        VideoAd videoAd = this.videoAd;
        ArrayList<VideoImage> arrayList = null;
        if (videoAd != null) {
            arrayList = this.videoAd.buttons;
        }
        if (arrayList != null) {
            File file = AdCache.getCacheDirectory((Context)this.activity);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                RelativeLayout.LayoutParams layoutParams;
                ImageButton imageButton;
                VideoImage videoImage;
                block15: {
                    videoImage = (VideoImage)arrayList.get(i2);
                    videoImage.button = imageButton = new ImageButton((Context)this.activity);
                    try {
                        Bitmap bitmap = BitmapFactory.decodeFile((String)(file.getAbsolutePath() + File.separator + this.videoAd.getId() + Uri.parse((String)videoImage.imageUrl).getLastPathSegment().replaceFirst("\\.[^\\.]*$", ".dat")));
                        if (bitmap != null) {
                            imageButton.setImageBitmap(bitmap);
                            break block15;
                        }
                        imageButton.setImageURI(Uri.parse((String)(file.getAbsolutePath() + File.separator + this.videoAd.getId() + Uri.parse((String)videoImage.imageUrl).getLastPathSegment().replaceFirst("\\.[^\\.]*$", ".dat"))));
                    }
                    catch (Exception exception) {
                        MMSDK.Log.e(exception);
                    }
                }
                this.setButtonAlpha(imageButton, videoImage.fromAlpha);
                imageButton.setId(i2 + 1);
                imageButton.setPadding(0, 0, 0, 0);
                if (videoImage.isLeaveBehind) {
                    imageButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    imageButton.setBackgroundColor(-16777216);
                    layoutParams = new RelativeLayout.LayoutParams(-1, -1);
                } else {
                    imageButton.setBackgroundColor(0);
                    layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                    Object[] objectArray = new Object[]{imageButton.getId(), videoImage.anchor, videoImage.position, videoImage.anchor2, videoImage.position2};
                    MMSDK.Log.v("Button: %d Anchor: %d Position: %d Anchor2: %d Position2: %d", objectArray);
                    layoutParams.addRule(videoImage.position, videoImage.anchor);
                    layoutParams.addRule(videoImage.position2, videoImage.anchor2);
                    layoutParams.setMargins(videoImage.paddingLeft, videoImage.paddingTop, videoImage.paddingRight, videoImage.paddingBottom);
                }
                if (!TextUtils.isEmpty((CharSequence)videoImage.linkUrl)) {
                    imageButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (imageButton != null) {
                                imageButton.setEnabled(false);
                            }
                            CachedVideoPlayerActivity.this.redirectListenerImpl.orientation = videoImage.overlayOrientation;
                            CachedVideoPlayerActivity.this.dispatchButtonClick(videoImage.linkUrl);
                            CachedVideoPlayerActivity.this.logButtonEvent(videoImage);
                        }
                    });
                }
                if (videoImage.appearanceDelay > 0L) {
                    videoImage.layoutParams = layoutParams;
                    Message message = Message.obtain((Handler)this.logTimeAndEventhandler, (int)3, (Object)videoImage);
                    this.logTimeAndEventhandler.sendMessageDelayed(message, videoImage.appearanceDelay);
                } else {
                    this.buttonsLayout.addView((View)imageButton, (ViewGroup.LayoutParams)layoutParams);
                }
                if (videoImage.inactivityTimeout <= 0L) continue;
                Message message = Message.obtain((Handler)this.logTimeAndEventhandler, (int)1, (Object)videoImage);
                this.logTimeAndEventhandler.sendMessageDelayed(message, videoImage.inactivityTimeout + videoImage.appearanceDelay + videoImage.fadeDuration);
            }
            relativeLayout.addView((View)this.buttonsLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        }
        if (this.buttonsLayout != null) {
            relativeLayout.bringChildToFront((View)this.buttonsLayout);
        }
        if (this.mWebView == null) return relativeLayout;
        relativeLayout.bringChildToFront((View)this.mWebView);
        return relativeLayout;
    }

    @Override
    protected void initSavedInstance(Bundle bundle) {
        super.initSavedInstance(bundle);
        if (bundle == null) {
            String string2 = this.getIntent().getStringExtra("videoId");
            this.videoAd = (VideoAd)AdCache.load((Context)this.activity, string2);
            if (this.videoAd != null) {
                this.hasBottomBar = this.videoAd.showControls;
                this.hasCountdownHud = this.videoAd.showCountdown;
            }
            return;
        }
        this.videoAd = (VideoAd)bundle.getParcelable("videoAd");
        this.hasBottomBar = bundle.getBoolean("shouldShowBottomBar");
        this.lastVideoPosition = bundle.getInt("lastVideoPosition");
        this.currentVideoPosition = bundle.getInt("currentVideoPosition");
        this.hasCountdownHud = this.videoAd.showCountdown;
    }

    void loadUrlForMraidInjection(String string2) {
        new FetchWebViewContentTask(string2).execute(new Void[0]);
    }

    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        super.onCompletion(mediaPlayer);
        if (this.hasCountdownHud) {
            this.hideHud();
        }
        if (this.videoAd != null) {
            this.videoPlayerOnCompletion(this.videoAd.onCompletionUrl);
        }
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.adProperties = new AdProperties((Context)this.activity);
        MMSDK.Log.v("Is Cached Ad");
    }

    @Override
    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        Object[] objectArray = new Object[]{n2, n3};
        this.errorPlayVideo(String.format("Error while playing, %d - %d", objectArray));
        return super.onError(mediaPlayer, n2, n3);
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        this.videoAd = (VideoAd)bundle.getParcelable("videoAd");
        super.onRestoreInstanceState(bundle);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            this.mWebView.bringToFront();
        }
        if (this.buttonsLayout != null) {
            this.buttonsLayout.bringToFront();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        bundle.putParcelable("videoAd", (Parcelable)this.videoAd);
        super.onSaveInstanceState(bundle);
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!this.hasWebOverlay && this.videoAd != null && this.videoAd.stayInPlayer && this.isVideoCompleted) {
            this.fadeButtons();
        }
    }

    @Override
    protected void pauseVideo() {
        super.pauseVideo();
        this.logTimeAndEventhandler.removeMessages(1);
        this.logTimeAndEventhandler.removeMessages(2);
        this.logTimeAndEventhandler.removeMessages(3);
    }

    @Override
    protected void playVideo(int n2) {
        if (this.videoAd == null) {
            Toast.makeText((Context)this.activity, (CharSequence)"Sorry. There was a problem playing the video", (int)1).show();
            return;
        }
        if (!this.logTimeAndEventhandler.hasMessages(2) && this.videoAd != null) {
            this.logTimeAndEventhandler.sendMessageDelayed(Message.obtain((Handler)this.logTimeAndEventhandler, (int)2), 1000L);
        }
        super.playVideo(n2);
    }

    @Override
    protected void restartVideo() {
        if (this.videoAd != null) {
            if ((this.hasLoadedCompletionUrl || this.videoAd.reloadNonEndOverlayOnRestart) && this.videoAd.webOverlayURL != null && this.mWebView != null) {
                this.loadUrlForMraidInjection(this.videoAd.webOverlayURL);
                this.hasLoadedCompletionUrl = false;
            }
            ArrayList<VideoImage> arrayList = this.videoAd.buttons;
            this.logTimeAndEventhandler.removeMessages(1);
            this.logTimeAndEventhandler.removeMessages(2);
            this.logTimeAndEventhandler.removeMessages(3);
            this.lastVideoPosition = 0;
            if (!this.hasWebOverlay && this.buttonsLayout != null && arrayList != null) {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    VideoImage videoImage = (VideoImage)arrayList.get(i2);
                    if (videoImage == null) continue;
                    if (videoImage.appearanceDelay > 0L) {
                        ImageButton imageButton = videoImage.button;
                        this.buttonsLayout.removeView((View)imageButton);
                        Message message = Message.obtain((Handler)this.logTimeAndEventhandler, (int)3, (Object)videoImage);
                        this.logTimeAndEventhandler.sendMessageDelayed(message, videoImage.appearanceDelay);
                    }
                    if (videoImage.inactivityTimeout <= 0L) continue;
                    Message message = Message.obtain((Handler)this.logTimeAndEventhandler, (int)1, (Object)videoImage);
                    this.logTimeAndEventhandler.sendMessageDelayed(message, videoImage.inactivityTimeout + videoImage.appearanceDelay + videoImage.fadeDuration);
                }
            }
            if (this.logTimeAndEventhandler != null) {
                this.logTimeAndEventhandler.sendMessageDelayed(Message.obtain((Handler)this.logTimeAndEventhandler, (int)2), 1000L);
            }
            if (this.hasCountdownHud) {
                this.showHud();
            }
        }
        super.restartVideo();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void resumeVideo() {
        if (this.videoAd != null) {
            if (!this.logTimeAndEventhandler.hasMessages(2)) {
                this.logTimeAndEventhandler.sendMessageDelayed(Message.obtain((Handler)this.logTimeAndEventhandler, (int)2), 1000L);
            }
            if (!this.hasWebOverlay) {
                if (this.hasCountdownHud) {
                    long l2 = (this.videoAd.duration - (long)this.currentVideoPosition) / 1000L;
                    if (l2 > 0L) {
                        if (this.hudSeconds != null) {
                            this.hudSeconds.setText((CharSequence)String.valueOf(l2));
                        }
                    } else {
                        this.hideHud();
                    }
                }
                if (this.videoAd.buttons != null) {
                    for (int i2 = 0; i2 < this.videoAd.buttons.size(); ++i2) {
                        VideoImage videoImage = this.videoAd.buttons.get(i2);
                        long l3 = 0L;
                        if (videoImage.appearanceDelay > 0L && this.buttonsLayout.indexOfChild((View)videoImage.button) == -1) {
                            Message message = Message.obtain((Handler)this.logTimeAndEventhandler, (int)3, (Object)videoImage);
                            l3 = videoImage.appearanceDelay - (long)this.currentVideoPosition;
                            if (l3 < 0L) {
                                l3 = 500L;
                            }
                            this.logTimeAndEventhandler.sendMessageDelayed(message, l3);
                        }
                        if (videoImage.inactivityTimeout <= 0L) continue;
                        Message message = Message.obtain((Handler)this.logTimeAndEventhandler, (int)1, (Object)videoImage);
                        this.logTimeAndEventhandler.sendMessageDelayed(message, l3 + videoImage.inactivityTimeout + videoImage.fadeDuration);
                    }
                }
            }
        }
        super.resumeVideo();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void videoPlayerOnCompletion(String string2) {
        block11: {
            block10: {
                if (string2 != null) {
                    this.dispatchButtonClick(string2);
                }
                if (this.videoAd == null) break block10;
                this.videoAd.logEndEvent();
                if (this.videoAd.stayInPlayer) break block11;
                this.dismiss();
            }
            return;
        }
        if (!this.hasWebOverlay && this.videoAd.buttons != null) {
            this.fadeButtons();
            if (!this.videoAd.hasEndCard()) {
                this.dismiss();
            }
        }
        if (this.mWebView != null && !TextUtils.isEmpty((CharSequence)this.videoAd.endOverlayURL)) {
            this.loadUrlForMraidInjection(this.videoAd.endOverlayURL);
            this.mWebView.bringToFront();
        } else if (this.hasWebOverlay) {
            this.dismiss();
        }
        if (this.videoAd.closeDelayMillis != 0L) {
            this.dismissAfter(this.videoAd.closeDelayMillis);
        }
        this.logTimeAndEventhandler.removeMessages(1);
        this.logTimeAndEventhandler.removeMessages(2);
        this.logTimeAndEventhandler.removeMessages(3);
    }

    private static class CachedVideoWebViewClientListener
    extends MMWebViewClient.MMWebViewClientListener {
        WeakReference<CachedVideoPlayerActivity> activityRef;

        CachedVideoWebViewClientListener(CachedVideoPlayerActivity cachedVideoPlayerActivity) {
            this.activityRef = new WeakReference<CachedVideoPlayerActivity>(cachedVideoPlayerActivity);
        }

        @Override
        public void onPageFinished(String string2) {
            MMSDK.Log.d("@@ ON PAGE FINISHED" + string2);
            CachedVideoPlayerActivity cachedVideoPlayerActivity = (CachedVideoPlayerActivity)this.activityRef.get();
            if (cachedVideoPlayerActivity != null) {
                cachedVideoPlayerActivity.onPageFinished(string2);
            }
        }
    }

    class FetchWebViewContentTask
    extends AsyncTask<Void, Void, String> {
        private String baseUrl;
        private boolean cancelVideo;

        public FetchWebViewContentTask(String string2) {
            this.baseUrl = string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String doInBackground(Void ... voidArray) {
            try {
                HttpResponse httpResponse = new HttpGetRequest().get(this.baseUrl);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (httpResponse != null && statusLine != null && statusLine.getStatusCode() != 404) {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity == null) return null;
                    return HttpGetRequest.convertStreamToString(httpEntity.getContent());
                }
                this.cancelVideo = true;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(String string2) {
            if (this.cancelVideo) {
                CachedVideoPlayerActivity.this.dismiss();
            }
            if (string2 != null && CachedVideoPlayerActivity.this.mWebView != null) {
                CachedVideoPlayerActivity.this.mWebView.setWebViewContent(string2, this.baseUrl, (Context)CachedVideoPlayerActivity.this.activity);
                CachedVideoPlayerActivity.this.hasLoadedCompletionUrl = true;
            }
        }
    }
}

