/*
 * Decompiled with CFR 0.152.
 */
package com.millennialmedia.android;

import android.content.Context;
import android.os.Parcel;
import com.millennialmedia.android.AdCache;
import com.millennialmedia.android.MMAdImpl;
import com.millennialmedia.android.MMSDK;
import com.millennialmedia.android.VideoAd;
import java.io.Externalizable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

abstract class CachedAd
implements Externalizable {
    static final int INTERSTITIAL = 2;
    static final int NATIVE = 3;
    static final int VIDEO = 1;
    static final long serialVersionUID = 316862728709355974L;
    String acid;
    String contentUrl;
    long deferredViewStart;
    boolean downloadAllOrNothing = false;
    int downloadPriority;
    Date expiration;
    private String id;

    CachedAd() {
        this.deferredViewStart = System.currentTimeMillis();
    }

    protected CachedAd(Parcel parcel) {
        try {
            this.id = parcel.readString();
            this.acid = parcel.readString();
            this.expiration = (Date)parcel.readSerializable();
            this.deferredViewStart = parcel.readLong();
            boolean[] blArray = new boolean[1];
            parcel.readBooleanArray(blArray);
            this.downloadAllOrNothing = blArray[0];
            this.contentUrl = parcel.readString();
            this.downloadPriority = parcel.readInt();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static CachedAd parseJSON(String string2) {
        if (MMSDK.logLevel >= 5) {
            MMSDK.Log.v("Received cached ad.");
            int n2 = string2.length();
            if (n2 > 1000) {
                int n3 = 999;
                int n4 = 0;
                while (n3 < n2) {
                    MMSDK.Log.v(string2.substring(n4, n3));
                    n4 = n3;
                    if ((n3 += 1000) <= n2) continue;
                    n3 = n2 - 1;
                    break;
                }
                MMSDK.Log.v(string2.substring(n4, n3));
            } else {
                MMSDK.Log.v(string2);
            }
        }
        int n5 = string2.length();
        VideoAd videoAd = null;
        if (n5 <= 0) return videoAd;
        return new VideoAd(string2);
    }

    abstract boolean canShow(Context var1, MMAdImpl var2, boolean var3);

    void delete(Context context) {
        File file = AdCache.getCacheDirectory(context);
        if (file != null && file.isDirectory()) {
            int n2;
            File[] fileArray;
            try {
                fileArray = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && file.getName().startsWith(CachedAd.this.id);
                    }
                });
                Object[] objectArray = new Object[]{fileArray.length, this.id};
                MMSDK.Log.v("Deleting %d files for %s.", objectArray);
                n2 = 0;
            }
            catch (Exception exception) {
                MMSDK.Log.v(exception);
            }
            while (true) {
                if (n2 < fileArray.length) {
                    fileArray[n2].delete();
                    ++n2;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deserializeFromObj(JSONObject jSONObject) {
        this.id = jSONObject.optString("id", null);
        this.acid = jSONObject.optString("vid", null);
        this.contentUrl = jSONObject.optString("content-url", null);
        String string2 = jSONObject.optString("expiration", null);
        if (string2 == null) return;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZZ");
        try {
            this.expiration = simpleDateFormat.parse(string2);
            return;
        }
        catch (ParseException parseException) {
            MMSDK.Log.e(parseException);
            return;
        }
    }

    abstract boolean download(Context var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CachedAd)) {
            return false;
        }
        CachedAd cachedAd = (CachedAd)object;
        return this.id.equals(cachedAd.id);
    }

    String getId() {
        return this.id;
    }

    abstract int getType();

    abstract String getTypeString();

    boolean isExpired() {
        return this.expiration != null && this.expiration.getTime() <= System.currentTimeMillis();
    }

    abstract boolean isOnDisk(Context var1);

    boolean isValid() {
        return this.id != null && this.id.length() > 0 && this.contentUrl != null && this.contentUrl.length() > 0;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (String)objectInput.readObject();
        this.acid = (String)objectInput.readObject();
        this.expiration = (Date)objectInput.readObject();
        this.deferredViewStart = objectInput.readLong();
        this.contentUrl = (String)objectInput.readObject();
    }

    abstract boolean saveAssets(Context var1);

    void setId(String string2) {
        this.id = string2;
    }

    abstract void show(Context var1, long var2);

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.acid);
        objectOutput.writeObject(this.expiration);
        objectOutput.writeLong(this.deferredViewStart);
        objectOutput.writeObject(this.contentUrl);
    }

    protected void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.id);
        parcel.writeString(this.acid);
        parcel.writeSerializable((Serializable)this.expiration);
        parcel.writeLong(this.deferredViewStart);
        boolean[] blArray = new boolean[]{this.downloadAllOrNothing};
        parcel.writeBooleanArray(blArray);
        parcel.writeString(this.contentUrl);
        parcel.writeInt(this.downloadPriority);
    }
}

